/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.abr;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.vcloud.abrmodule.DefaultABRModule;
import com.bytedance.vcloud.abrmodule.IABRModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ABRPool {
    private static boolean mEnabled = false;
    private static ABRPool singleton;
    private static final int MAX_COUNT = 8;
    private int mCreated = 0;
    private final Lock mLock = new ReentrantLock();
    private final List<IABRModule> mListCache = new ArrayList<IABRModule>();
    private final List<String> mMapOrder;
    private final Map<String, IABRModule> mMapCache = new HashMap<String, IABRModule>();

    public static void setEnabled(boolean mEnabled) {
        ABRPool.mEnabled = mEnabled;
    }

    private ABRPool() {
        this.mMapOrder = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ABRPool getInstance() {
        if (singleton != null) return singleton;
        Class<ABRPool> clazz = ABRPool.class;
        synchronized (ABRPool.class) {
            if (singleton != null) return singleton;
            singleton = new ABRPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Nullable
    public IABRModule getFromCache() {
        if (!mEnabled) {
            return null;
        }
        IABRModule module = null;
        this.mLock.lock();
        if (this.mListCache.size() > 0) {
            module = this.mListCache.remove(0);
        } else if (this.mCreated < 8) {
            module = new DefaultABRModule();
            ++this.mCreated;
        } else if (this.mMapOrder.size() >= 6) {
            String vid = this.mMapOrder.remove(0);
            module = this.mMapCache.remove(vid);
        }
        this.mLock.unlock();
        return module;
    }

    public void preloadDone(@NonNull String vid, @NonNull IABRModule module) {
        this.mLock.lock();
        module.stop();
        this.mMapCache.put(vid, module);
        this.mMapOrder.remove(vid);
        this.mMapOrder.add(vid);
        this.mLock.unlock();
    }

    @Nullable
    public IABRModule getFromPreloaded(String vid) {
        if (!mEnabled) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)vid)) {
            return null;
        }
        this.mLock.lock();
        IABRModule module = this.mMapCache.remove(vid);
        this.mMapOrder.remove(vid);
        this.mLock.unlock();
        return module;
    }

    public void giveBack(@NonNull IABRModule module) {
        this.mLock.lock();
        module.stop();
        this.mListCache.add(module);
        this.mLock.unlock();
    }

    private void clearPool() {
        ArrayList<IABRModule> modules = new ArrayList<IABRModule>();
        this.mLock.lock();
        modules.addAll(this.mListCache);
        modules.addAll(this.mMapCache.values());
        this.mListCache.clear();
        this.mMapCache.clear();
        this.mMapOrder.clear();
        this.mLock.unlock();
        for (IABRModule module : modules) {
            module.release();
        }
        modules.clear();
    }

    public static void clear() {
        ABRPool pool = ABRPool.getInstance();
        pool.clearPool();
    }
}

