/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.fetcher;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.mediakit.fetcher.AVMDLURLFetcherInterface;
import com.ss.mediakit.fetcher.AVMDLURLFetcherListener;
import com.ss.ttvideoengine.VideoModelCache;
import com.ss.ttvideoengine.fetcher.VideoInfoFetcher;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.TTVideoEngineUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;

public class MDLFetcher
implements AVMDLURLFetcherInterface {
    private static final String TAG = "MDLFetcher";
    private String mFallbackAPI;
    private String mKeyseed;
    private String mVideoID;
    private String mFileHash;
    private String[] mNewUrls = null;
    private VideoInfoFetcher mFetcher;
    private AVMDLURLFetcherListener mListener;
    private Context mContext;
    private String mOldUrl;

    public MDLFetcher(Context context, String fallbackAPI, String keyseed) {
        this.mContext = context;
        this.mFallbackAPI = TTVideoEngineUtils.BuildHttpsApi(fallbackAPI);
        this.mKeyseed = keyseed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int start(String rawKey, String fileKey, String oldUrl, AVMDLURLFetcherListener listener) {
        TTVideoEngineLog.i(TAG, "start rawKey " + rawKey + ", fileKey " + fileKey + ", olderUrl " + oldUrl + ", listener " + listener);
        this.mVideoID = rawKey;
        this.mFileHash = fileKey;
        this.mListener = listener;
        this.mOldUrl = oldUrl;
        VideoModelCache.VideoModelCacheInfo temCache = null;
        Class<MDLFetcher> clazz = MDLFetcher.class;
        // MONITORENTER : com.ss.ttvideoengine.fetcher.MDLFetcher.class
        temCache = VideoModelCache.getInstance().get(this.mVideoID, this.mFallbackAPI);
        // MONITOREXIT : clazz
        if (temCache != null && !temCache.isExpired) {
            TTVideoEngineLog.i(TAG, String.format("get videoModel from cache,key is %s; videoId = %s", this.mFileHash, this.mVideoID));
            String[] temUrls = this._getUrlsFromVideoModelByFileHash(temCache.model, this.mFileHash);
            boolean validModel = true;
            if (!TextUtils.isEmpty((CharSequence)oldUrl) && temUrls != null && temUrls.length > 0) {
                this.mNewUrls = temUrls;
                for (int i = 0; i < temUrls.length; ++i) {
                    String temUrl = temUrls[i];
                    if (!temUrl.equals(oldUrl)) continue;
                    validModel = false;
                    break;
                }
            }
            if (validModel) {
                if (this.mNewUrls != null) {
                    TTVideoEngineLog.i(TAG, "start get urls from cache " + Arrays.toString(this.mNewUrls));
                    return 1;
                }
            } else {
                this.mNewUrls = null;
                Class<MDLFetcher> clazz2 = MDLFetcher.class;
                // MONITORENTER : com.ss.ttvideoengine.fetcher.MDLFetcher.class
                VideoModelCache.getInstance().remove(this.mVideoID, this.mFallbackAPI);
                // MONITOREXIT : clazz2
            }
        }
        this.mFetcher = new VideoInfoFetcher(this.mContext, null);
        if (this.mContext != null) {
            this.mFetcher.setUseVideoModelCache(true);
        }
        this.mFetcher.setVideoID(rawKey);
        this.mFetcher.setListener(new MyFetcherListener(this));
        this.mFetcher.setUseFallbakApi(!TextUtils.isEmpty((CharSequence)this.mFallbackAPI));
        this.mFetcher.fetchInfo(this.mFallbackAPI, null, 0, this.mKeyseed);
        return 0;
    }

    public String[] getURLs() {
        if (this.mNewUrls != null && this.mNewUrls.length > 0) {
            TTVideoEngineLog.d(TAG, "get urls from cache. + urls.length = " + this.mNewUrls.length);
            return this.mNewUrls;
        }
        return null;
    }

    public void close() {
        if (this.mFetcher != null) {
            this.mFetcher.cancel();
            this.mFetcher = null;
        }
        this.mNewUrls = null;
    }

    @Nullable
    private String[] _getUrlsFromVideoModelByFileHash(VideoModel videoModel, String fileHash) {
        if (videoModel == null || TextUtils.isEmpty((CharSequence)fileHash)) {
            TTVideoEngineLog.d(TAG, "_getUrlsFromVideoModel videoModel is null or fileHash is empty " + fileHash);
            return null;
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(15, fileHash);
        VideoInfo info = videoModel.getVideoInfo(map);
        if (info != null) {
            Object[] temUrls = info.getValueStrArr(16);
            TTVideoEngineLog.d(TAG, "_getUrlsFromVideoModel " + Arrays.toString(temUrls));
            if (temUrls != null && temUrls.length > 0) {
                return temUrls;
            }
            return null;
        }
        TTVideoEngineLog.d(TAG, "_getUrlsFromVideoModel videoInfo is null");
        return null;
    }

    private static boolean isNewUrlsValid(String[] newUrls, String oldUrl) {
        if (newUrls == null || newUrls.length <= 0) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)oldUrl)) {
            return true;
        }
        for (String newUrl : newUrls) {
            if (!TextUtils.equals((CharSequence)newUrl, (CharSequence)oldUrl)) continue;
            TTVideoEngineLog.d(TAG, "new urls is invalid");
            return false;
        }
        return true;
    }

    static /* synthetic */ String[] access$302(MDLFetcher x0, String[] x1) {
        x0.mNewUrls = x1;
        return x1;
    }

    private static class MyFetcherListener
    implements VideoInfoFetcher.FetcherListener {
        private final WeakReference<MDLFetcher> mFetcherRef;

        public MyFetcherListener(MDLFetcher fetcher) {
            this.mFetcherRef = new WeakReference<MDLFetcher>(fetcher);
        }

        @Override
        public void onRetry(Error error) {
        }

        @Override
        public void onCompletion(VideoModel model, Error error) {
            TTVideoEngineLog.i(MDLFetcher.TAG, "onCompletion model " + model + ", error " + error);
            MDLFetcher fetcher = (MDLFetcher)this.mFetcherRef.get();
            if (fetcher == null) {
                TTVideoEngineLog.i(MDLFetcher.TAG, "onCompletion but fetcher is null");
                return;
            }
            if (model == null || error != null) {
                int code = -9997;
                if (error != null) {
                    code = error.code;
                }
                fetcher.mListener.onCompletion(code, fetcher.mVideoID, fetcher.mFileHash, null);
                return;
            }
            MDLFetcher.access$302(fetcher, fetcher._getUrlsFromVideoModelByFileHash(model, fetcher.mFileHash));
            TTVideoEngineLog.i(MDLFetcher.TAG, "onCompletion newUrls " + Arrays.toString(fetcher.mNewUrls));
            boolean valid = MDLFetcher.isNewUrlsValid(fetcher.mNewUrls, fetcher.mOldUrl);
            if (valid) {
                TTVideoEngineLog.i(MDLFetcher.TAG, "onCompletion success");
                fetcher.mListener.onCompletion(0, fetcher.mVideoID, fetcher.mFileHash, fetcher.mNewUrls);
            } else {
                TTVideoEngineLog.i(MDLFetcher.TAG, "onCompletion invalid");
                fetcher.mListener.onCompletion(-1, fetcher.mVideoID, fetcher.mFileHash, null);
            }
        }

        @Override
        public void onStatusException(int status, String message) {
            MDLFetcher fetcher = (MDLFetcher)this.mFetcherRef.get();
            if (fetcher == null) {
                TTVideoEngineLog.i(MDLFetcher.TAG, "onStatusException but fetcher is null");
                return;
            }
            fetcher.mListener.onCompletion(status, fetcher.mVideoID, fetcher.mFileHash, null);
        }

        @Override
        public void onLog(String message) {
        }
    }
}

