/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.fetcher;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class SubInfoFetcher {
    private static final String TAG = "SubInfoFetcher";
    private static final int MSG_IS_ERROR = 1;
    private static final int MSG_IS_SUCCESS = 2;
    private Handler mHandler;
    private boolean mCancelled = false;
    private String mSubApiString = "";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_LOGID = "trace_id";
    private FetcherListener mListener;
    private TTVNetClient mNetworkSession;
    private Context mContext;

    public SubInfoFetcher(Context context, TTVNetClient client) {
        this.mContext = context;
        this.mHandler = new MyHandler(this, TTHelper.getLooper());
        this.mNetworkSession = client == null ? new TTHTTPNetwork() : client;
    }

    public void setListener(FetcherListener listener) {
        this.mListener = listener;
    }

    public void fetchInfo(String apiString) {
        this.mSubApiString = apiString;
        this._fetchInfoInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        SubInfoFetcher subInfoFetcher = this;
        synchronized (subInfoFetcher) {
            this.mHandler.removeCallbacksAndMessages(null);
            if (this.mListener == null) {
                return;
            }
            this.mListener.onLog("fetcher cancelled");
            if (this.mCancelled) {
                return;
            }
            this.mCancelled = true;
            this.mNetworkSession.cancel();
        }
    }

    private void _fetchInfoInternal() {
        if (TextUtils.isEmpty((CharSequence)this.mSubApiString)) {
            this._notifyError(new Error("kTTVideoErrorDomainSubFetchingInfo", -9930, "sub ApiString empty"));
            return;
        }
        this._beginToFetch(this.mSubApiString);
    }

    private void _beginToFetch(String url) {
        this.mNetworkSession.startTask(url, new TTVNetClient.CompletionListener(){

            @Override
            public void onCompletion(JSONObject jsonObject, Error error) {
                if (jsonObject != null || error == null) {
                    SubInfoFetcher.this._getInfoSuccess(jsonObject);
                } else {
                    SubInfoFetcher.this._notifyError(error);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _getInfoSuccess(JSONObject jsonObject) {
        SubInfoFetcher subInfoFetcher = this;
        synchronized (subInfoFetcher) {
            if (this.mCancelled || jsonObject == null) {
                return;
            }
            TTVideoEngineLog.d(TAG, "sub jsonObject:" + jsonObject.toString());
            if (jsonObject.has("ResponseMetadata")) {
                JSONObject metadata = jsonObject.optJSONObject("ResponseMetadata");
                if (metadata == null) {
                    TTVideoEngineLog.i(TAG, "_getSubInfoSuccess metadata is null");
                    this._notifyError(new Error("kTTVideoErrorDomainSubFetchingInfo", -9931, "fetched info ResponseMetadata is empty"));
                    return;
                }
                JSONObject errorInfo = metadata.optJSONObject("Error");
                if (errorInfo != null) {
                    String errorDescription = errorInfo.toString() + " RequestId:" + metadata.optString("RequestId");
                    int codeN = errorInfo.optInt("CodeN");
                    Error error = new Error("kTTVideoErrorDomainSubFetchingInfo", -9929, codeN, errorDescription);
                    error.parameters.put("log_id", metadata.optString("RequestId"));
                    this._notifyError(error);
                    return;
                }
                JSONObject resultInfo = jsonObject.optJSONObject("Result");
                if (resultInfo == null) {
                    this._notifyError(new Error("kTTVideoErrorDomainSubFetchingInfo", -9931, "fetched info Result is empty"));
                    return;
                }
                String subList = this._extractFields(resultInfo);
                this._notifySuccess(subList);
            } else {
                this._notifyError(new Error("kTTVideoErrorDomainSubFetchingInfo", -9931, "fetched info ResponseMetadata and Result is empty"));
            }
        }
    }

    public String _extractFields(JSONObject obj) {
        JSONArray subtitleInfoList;
        JSONObject fileSubtitleInfoRef;
        if (obj == null) {
            return "";
        }
        JSONArray subList = new JSONArray();
        JSONObject subData = new JSONObject();
        JSONArray fileSubtitleInfoList = obj.optJSONArray("FileSubtitleInfoList");
        if (fileSubtitleInfoList != null && fileSubtitleInfoList.length() > 0 && (fileSubtitleInfoRef = fileSubtitleInfoList.optJSONObject(0)) != null && (subtitleInfoList = fileSubtitleInfoRef.optJSONArray("SubtitleInfoList")) != null && subtitleInfoList.length() > 0) {
            for (int i = 0; i < subtitleInfoList.length(); ++i) {
                JSONObject subtitleInfoRef = subtitleInfoList.optJSONObject(i);
                if (subtitleInfoRef == null) continue;
                JSONObject object = new JSONObject();
                try {
                    object.put("language", (Object)subtitleInfoRef.optString("Language"));
                    object.put("sub_id", subtitleInfoRef.optInt("SubtitleId"));
                    object.put("language_id", subtitleInfoRef.optInt("LanguageId"));
                    object.put("format", (Object)subtitleInfoRef.optString("Format"));
                    object.put("source", (Object)subtitleInfoRef.optString("Source"));
                    object.put("url", (Object)subtitleInfoRef.optString("SubtitleUrl"));
                    object.put("id", i);
                    subList.put((Object)object);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            subData.put("list", (Object)subList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return subData.toString();
    }

    private void _notifyError(Error error) {
        Message message = this.mHandler.obtainMessage(1, (Object)error);
        this.mHandler.sendMessage(message);
    }

    private void _notifySuccess(String model) {
        Message message = this.mHandler.obtainMessage(2, (Object)model);
        this.mHandler.sendMessage(message);
    }

    public static interface FetcherListener {
        public void onCompletion(String var1, Error var2);

        public void onLog(String var1);
    }

    private static class MyHandler
    extends Handler {
        private final WeakReference<SubInfoFetcher> mFetcherRef;

        public MyHandler(SubInfoFetcher fetcher, Looper looper) {
            super(looper);
            this.mFetcherRef = new WeakReference<SubInfoFetcher>(fetcher);
        }

        public void handleMessage(Message msg) {
            SubInfoFetcher fetcher = (SubInfoFetcher)this.mFetcherRef.get();
            if (fetcher == null) {
                return;
            }
            FetcherListener listener = fetcher.mListener;
            if (listener == null) {
                return;
            }
            if (fetcher.mCancelled) {
                listener.onLog("fetcher is cancelled");
                return;
            }
            switch (msg.what) {
                case 1: {
                    Error error = (Error)msg.obj;
                    listener.onCompletion(null, error);
                    break;
                }
                case 2: {
                    String subList = (String)msg.obj;
                    listener.onCompletion(subList, null);
                    break;
                }
            }
        }
    }
}

