/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.database.ContentObserver;
import android.provider.Settings;
import com.ss.ttvideoengine.utils.ScreenUtils;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class BrightnessMonitor {
    private static final String TAG = "BrightnessMonitor";
    private static final int LIST_SIZE = 100;
    private final Context mContext;
    private final ArrayList<String> mHistoryList = new ArrayList();
    private volatile boolean mIsStart;
    private volatile boolean mIsPlaying;
    private final ContentObserver mBrightnessObserver = new ContentObserver(null){

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            BrightnessMonitor.this.addToHistory();
        }
    };

    public BrightnessMonitor(Context context) {
        this.mContext = context;
    }

    public void start() {
        if (this.mIsStart) {
            return;
        }
        this.mIsStart = true;
        try {
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"screen_brightness"), true, this.mBrightnessObserver);
        }
        catch (Exception e) {
            TTVideoEngineLog.w(TAG, e.getMessage());
        }
        this.addToHistory();
    }

    public void stop() {
        if (!this.mIsStart) {
            return;
        }
        this.mIsStart = false;
        this.mContext.getContentResolver().unregisterContentObserver(this.mBrightnessObserver);
    }

    public void setPlaying(boolean isPlaying) {
        this.mIsPlaying = isPlaying;
    }

    private void addToHistory() {
        if (!this.mIsPlaying || this.mHistoryList.size() > 100) {
            return;
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("b", Float.valueOf(ScreenUtils.getNormalizedBrightness(this.mContext)));
        map.put("t", System.currentTimeMillis());
        this.mHistoryList.add(new JSONObject(map).toString());
    }

    public ArrayList<String> getList() {
        return this.mHistoryList;
    }
}

