/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.LiveVideoInfo;
import com.ss.ttvideoengine.model.LiveVideoRef;
import com.ss.ttvideoengine.model.SubInfo;
import com.ss.ttvideoengine.model.VideoAdRef;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.model.VideoSeekTs;
import com.ss.ttvideoengine.model.VideoStyle;
import com.ss.ttvideoengine.model.VideoThumbInfo;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class VideoModel
implements IVideoModel {
    public static final int IS_LIVE_SOURCE = 0;
    public static final int IS_VOD_SOURCE = 1;
    public static final int VIDEO_MODEL_VER1 = 1;
    public static final int VIDEO_MODEL_VER2 = 2;
    public static final int VIDEO_MODEL_VER3 = 3;
    public static final int VIDEO_MODEL_VER4 = 4;
    @Deprecated
    public VideoRef videoRef = null;
    public List<VideoAdRef> videoAdRefList = null;
    public LiveVideoRef liveVideoRef = null;
    private VideoRef vodVideoRef = null;
    private int mSourceType = 1;
    private int mVersion = 1;
    private HashMap<String, Resolution> mResolutionMap = null;
    private JSONObject mJsonInfo = null;
    private boolean mURLEncrypted = false;
    private String mKeyseed = null;

    @Nullable
    public JSONObject getJsonInfo() {
        return this.mJsonInfo;
    }

    @Override
    public String toMediaInfoJsonString() {
        JSONObject ret = this.getMediaInfo();
        if (ret != null) {
            return ret.toString();
        }
        return null;
    }

    @Override
    public int fromMediaInfoJsonString(String jsonString) {
        return -1;
    }

    @Override
    public int fromMediaInfoJsonObject(JSONObject jsonObject) {
        return -1;
    }

    @Override
    public JSONObject getMediaInfo() {
        String format = this.getVideoRefStr(211);
        String videoId = this.getVideoRefStr(2);
        int duration = this.getVideoRefInt(3);
        List<VideoInfo> videoInfos = this.getVideoInfoList();
        try {
            if (videoInfos != null) {
                HashMap<String, Object> modelMap = new HashMap<String, Object>();
                ArrayList<Map<String, Object>> infoMaps = new ArrayList<Map<String, Object>>();
                for (VideoInfo info : videoInfos) {
                    infoMaps.add(info.toMediaInfo());
                }
                modelMap.put("format", format);
                modelMap.put("vid", videoId);
                modelMap.put("category", this.getVideoRefInt(232));
                modelMap.put("duration", duration);
                modelMap.put("infos", infoMaps);
                return new JSONObject(modelMap);
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        return null;
    }

    public void extractFields(JSONObject obj) throws Throwable {
        JSONArray videoList;
        JSONObject liveVideoInfo;
        JSONArray videoAdList;
        if (obj == null) {
            return;
        }
        try {
            String temJsonStr = obj.toString();
            this.mJsonInfo = new JSONObject(temJsonStr);
        }
        catch (Throwable e) {
            TTVideoEngineLog.e("VideoModel", "generate mJsonInfo error");
        }
        JSONObject videoInfo = obj.optJSONObject("video_info");
        if (videoInfo != null && videoInfo.length() > 0) {
            this.mVersion = 1;
            VideoRef tmpRef = new VideoRef();
            tmpRef.setVersion(this.mVersion);
            JSONObject videoInfoData = videoInfo.optJSONObject("data");
            tmpRef.setValue(219, this.mURLEncrypted);
            tmpRef.setValueStr(218, this.mKeyseed);
            tmpRef.extractFields(videoInfoData);
            this.videoRef = tmpRef;
            this.vodVideoRef = tmpRef;
        }
        if ((videoAdList = obj.optJSONArray("video_ad_list")) != null && videoAdList.length() > 0) {
            this.videoAdRefList = new ArrayList<VideoAdRef>();
            for (int i = 0; i < videoAdList.length(); ++i) {
                try {
                    VideoAdRef videoAdRef = new VideoAdRef();
                    videoAdRef.extractFields(videoAdList.getJSONObject(i));
                    this.videoAdRefList.add(videoAdRef);
                    continue;
                }
                catch (Exception videoAdRef) {
                    // empty catch block
                }
            }
        }
        if ((liveVideoInfo = obj.optJSONObject("live_info")) != null) {
            this.mSourceType = 0;
            this.liveVideoRef = new LiveVideoRef();
            JSONObject liveVideoInfoData = liveVideoInfo.optJSONObject("data");
            this.liveVideoRef.extractFields(liveVideoInfoData);
        }
        if ((videoList = obj.optJSONArray("PlayInfoList")) != null && videoList.length() > 0 || !TextUtils.isEmpty((CharSequence)obj.optString("VideoID")) || !TextUtils.isEmpty((CharSequence)obj.optString("Vid"))) {
            this.mVersion = obj.optInt("Version") == 4 ? 4 : 2;
            this.vodVideoRef = new VideoRef();
            this.vodVideoRef.setVersion(this.mVersion);
            this.vodVideoRef.extractFields(obj);
        }
        this.setUpResolution(this.mResolutionMap);
    }

    @Override
    @Deprecated
    public String[] allVideoURLs(Resolution resolution) {
        return this.allVideoURLs(resolution, null);
    }

    @Override
    public String[] allVideoURLs(Resolution resolution, Map<Integer, String> otherDimensionalityMap) {
        LiveVideoInfo liveVideoInfo;
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.allVideoURLs(resolution, otherDimensionalityMap);
        }
        if (this.liveVideoRef != null && (liveVideoInfo = this.liveVideoRef.getLiveVideoInfo()) != null) {
            return liveVideoInfo.mURLs;
        }
        return new String[0];
    }

    @Override
    public List<VideoInfo> getVideoInfoList() {
        if (this.vodVideoRef == null) {
            return Collections.emptyList();
        }
        return this.vodVideoRef.getVideoInfoList();
    }

    public boolean isMp4Source() {
        return this.vodVideoRef != null && this.vodVideoRef.getValueBool(206) != false;
    }

    public boolean isDashSource() {
        return this.vodVideoRef != null && this.vodVideoRef.getValueBool(205) != false;
    }

    public boolean isHlsSource() {
        return this.vodVideoRef != null && this.vodVideoRef.getValueBool(208) != false;
    }

    public boolean isLiveSource() {
        return this.getSource() == IVideoModel.Source.LIVE;
    }

    @Override
    @Deprecated
    public VideoInfo getVideoInfo(Resolution resolution) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getVideoInfo(resolution, null);
        }
        return null;
    }

    @Override
    public VideoInfo getVideoInfo(Map<Integer, String> otherDimensionalityMap) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getVideoInfo(otherDimensionalityMap);
        }
        return null;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, Map<Integer, String> otherDimensionalityMap) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getVideoInfo(resolution, otherDimensionalityMap);
        }
        return null;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, int type, Map<Integer, String> otherDimensionalityMap) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getVideoInfo(resolution, type, otherDimensionalityMap);
        }
        return null;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, boolean downgrade) {
        if (this.vodVideoRef != null) {
            return this.getVideoInfo(resolution, this.vodVideoRef.getValueInt(7), null, downgrade);
        }
        return null;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, Map<Integer, String> otherDimensionalityMap, boolean downgrade) {
        if (this.vodVideoRef != null) {
            return this.getVideoInfo(resolution, this.vodVideoRef.getValueInt(7), otherDimensionalityMap, downgrade);
        }
        return null;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, int type, boolean downgrade) {
        if (this.vodVideoRef != null) {
            return this.getVideoInfo(resolution, type, null, downgrade);
        }
        return null;
    }

    @Override
    public VideoInfo getVideoInfo(Resolution resolution, int type, Map<Integer, String> otherDimensionalityMap, boolean downgrade) {
        Resolution[] temResolutions;
        int originIndex;
        int i;
        VideoInfo info = this.getVideoInfo(resolution, type, otherDimensionalityMap);
        if (!downgrade) {
            return info;
        }
        String[] temQualityInfos = TTVideoEngine.getAllQualityInfos();
        if (temQualityInfos.length > 0 && otherDimensionalityMap != null && otherDimensionalityMap.containsKey(32)) {
            String value;
            int temIndex = temQualityInfos.length - 1;
            if (info == null && (value = otherDimensionalityMap.get(32)) != null) {
                for (i = 0; i < temQualityInfos.length; ++i) {
                    if (!temQualityInfos[i].equals(value)) continue;
                    temIndex = i;
                    break;
                }
                originIndex = temIndex;
                while (info == null) {
                    String temQualityInfo = temQualityInfos[temIndex];
                    otherDimensionalityMap.put(32, temQualityInfo);
                    info = this.getVideoInfo(resolution, type, otherDimensionalityMap);
                    if (info != null) {
                        return info;
                    }
                    if ((temIndex = (temIndex + temQualityInfos.length - 1) % temQualityInfos.length) != originIndex) continue;
                    break;
                }
            }
        }
        if ((temResolutions = Resolution.getAllResolutions()).length <= 0) {
            return info;
        }
        int index = temResolutions.length - 1;
        if (resolution != null) {
            for (i = 0; i < temResolutions.length; ++i) {
                Resolution tem = temResolutions[i];
                if (tem.getIndex() != resolution.getIndex()) continue;
                index = i;
                break;
            }
        }
        originIndex = index;
        while (info == null) {
            Resolution temResolution = temResolutions[index];
            info = this.getVideoInfo(temResolution, type, null);
            if (info != null) {
                resolution = temResolution;
                break;
            }
            if ((index = (index + temResolutions.length - 1) % temResolutions.length) != originIndex) continue;
            break;
        }
        return info;
    }

    @Override
    public String getSpadea() {
        List<VideoInfo> videoInfoList;
        if (this.vodVideoRef != null && (videoInfoList = this.vodVideoRef.getVideoInfoList()) != null && videoInfoList.size() != 0) {
            for (VideoInfo videoInfo : videoInfoList) {
                String spadea = videoInfo.getValueStr(5);
                if (TextUtils.isEmpty((CharSequence)spadea)) continue;
                return spadea;
            }
        }
        return null;
    }

    @Deprecated
    public String getCodec() {
        if (this.vodVideoRef != null) {
            String codec;
            VideoInfo videoInfo;
            if (this.mVersion == 2) {
                String[] codes = this.vodVideoRef.getCodecs();
                boolean h265 = false;
                for (String codec2 : codes) {
                    if (codec2.equals("h266")) {
                        return "h266";
                    }
                    if (!codec2.equals("h265")) continue;
                    h265 = true;
                }
                if (h265) {
                    return "h265";
                }
                return "h264";
            }
            List<VideoInfo> videoInfoList = this.vodVideoRef.getVideoInfoList();
            if (videoInfoList != null && videoInfoList.size() != 0 && (videoInfo = videoInfoList.get(0)) != null && !TextUtils.isEmpty((CharSequence)(codec = videoInfo.mCodecType))) {
                return codec;
            }
        }
        return "h264";
    }

    @Override
    public String[] getCodecs() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getCodecs();
        }
        return new String[0];
    }

    @Override
    public String getVType() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getValueStr(211);
        }
        return "mp4";
    }

    @Override
    public String getDynamicType() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getValueStr(215);
        }
        return "";
    }

    @Deprecated
    public int getPreloadInterval(Resolution resolution) {
        VideoInfo videoInfo;
        if (this.vodVideoRef != null && (videoInfo = this.vodVideoRef.getVideoInfo(resolution, null)) != null) {
            return videoInfo.getValueInt(13);
        }
        return 0;
    }

    public int getPreloadInterval(Resolution resolution, Map<Integer, String> otherDimensionalityMap) {
        VideoInfo info;
        if (this.vodVideoRef != null && (info = this.vodVideoRef.getVideoInfo(resolution, otherDimensionalityMap)) != null) {
            info.getValueInt(13);
        }
        return 0;
    }

    public int getSourceType() {
        return this.mSourceType;
    }

    @Override
    public IVideoModel.Source getSource() {
        IVideoModel.Source val = IVideoModel.Source.None;
        switch (this.mSourceType) {
            case 1: {
                val = IVideoModel.Source.VOD;
                break;
            }
            case 0: {
                val = IVideoModel.Source.LIVE;
            }
        }
        return val;
    }

    @Override
    @NonNull
    public Set<IVideoModel.Format> getFormats() {
        HashSet<IVideoModel.Format> formats = new HashSet<IVideoModel.Format>();
        if (this.vodVideoRef != null) {
            if (this.vodVideoRef.getValueBool(206).booleanValue()) {
                formats.add(IVideoModel.Format.MP4);
            } else if (this.vodVideoRef.getValueBool(208).booleanValue()) {
                formats.add(IVideoModel.Format.HLS);
            } else if (this.vodVideoRef.getValueBool(205).booleanValue() || this.vodVideoRef.getValueBool(207).booleanValue()) {
                formats.add(IVideoModel.Format.DASH);
            }
        }
        return formats;
    }

    @Override
    public boolean hasFormat(IVideoModel.Format format) {
        if (this.vodVideoRef == null) {
            return false;
        }
        boolean has = false;
        switch (format) {
            case HLS: {
                has = this.vodVideoRef.getValueBool(208);
                break;
            }
            case MP4: {
                has = this.vodVideoRef.getValueBool(206);
                break;
            }
            case DASH: {
                has = this.vodVideoRef.getValueBool(205);
                break;
            }
            case NONE: {
                has = false;
            }
        }
        return has;
    }

    @Override
    public Resolution[] getSupportResolutions() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getSupportResolutions();
        }
        return new Resolution[0];
    }

    @Override
    public String[] getSupportQualityInfos() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getSupportQualityInfos();
        }
        return null;
    }

    @Override
    public int[] getSupportSubtitleLangs() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getSupportSubtitleLangs();
        }
        return null;
    }

    @Override
    public JSONObject getDnsInfo() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getDnsInfo();
        }
        return null;
    }

    public List<VideoThumbInfo> getThumbInfoList() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.mThumbInfoList;
        }
        return null;
    }

    @Override
    public List<SubInfo> getSubInfoList() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.mSubInfoList;
        }
        return null;
    }

    public VideoSeekTs getVideoSeekTS() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.mSeekTs;
        }
        return null;
    }

    @Override
    public boolean hasData() {
        return this.vodVideoRef != null || this.liveVideoRef != null;
    }

    @Deprecated
    public VideoRef getVideoRef() {
        return this.vodVideoRef;
    }

    public void setVideoRef(VideoRef videoRef) {
        this.vodVideoRef = videoRef;
        this.setUpResolution(this.mResolutionMap);
    }

    @Override
    public int getVideoRefInt(int key) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getValueInt(key);
        }
        return -1;
    }

    @Override
    public String getVideoRefStr(int key) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getValueStr(key);
        }
        return "";
    }

    public void setVideoRefStr(int key, String str) {
        if (this.vodVideoRef != null) {
            this.vodVideoRef.setValueStr(key, str);
        }
        if (key == 218) {
            this.mKeyseed = str;
        }
    }

    @Override
    public boolean getVideoRefBool(int key) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getValueBool(key);
        }
        return false;
    }

    public void setVideoRefBool(int key, boolean value) {
        if (key == 219) {
            this.mURLEncrypted = value;
        }
    }

    @Override
    public long getVideoRefLong(int key) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getValueLong(key);
        }
        return 0L;
    }

    @Override
    public float getVideoRefFloat(int key) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.getValueFloat(key);
        }
        return 0.0f;
    }

    @Override
    public void setUpResolution(HashMap<String, Resolution> resolutionMap) {
        this.mResolutionMap = resolutionMap;
        if (this.vodVideoRef != null) {
            this.vodVideoRef.setUpResolution(resolutionMap);
        }
    }

    @Override
    public String resolutionToString(Resolution resolution) {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.resolutionToString(resolution);
        }
        return resolution.toString(VideoRef.TYPE_VIDEO);
    }

    @Override
    public boolean isSupportBash() {
        String dynamicType;
        if (TextUtils.isEmpty((CharSequence)this.getVideoRefStr(8))) {
            return false;
        }
        return this.hasFormat(IVideoModel.Format.DASH) ? !TextUtils.isEmpty((CharSequence)(dynamicType = this.getDynamicType())) && dynamicType.equals("segment_base") : this.hasFormat(IVideoModel.Format.MP4) && this.getVideoRefBool(222) && TextUtils.isEmpty((CharSequence)this.getSpadea());
    }

    @Override
    public boolean isSupportHLSSeamlessSwitch() {
        if (TextUtils.isEmpty((CharSequence)this.getVideoRefStr(8))) {
            return false;
        }
        return this.hasFormat(IVideoModel.Format.HLS) && this.getVideoRefBool(222);
    }

    @Override
    public List<Integer> getSupportInfoId(int mediaType) {
        if (this.vodVideoRef == null) {
            return null;
        }
        List<VideoInfo> videoInfoList = this.vodVideoRef.getVideoInfoList();
        if (videoInfoList == null || videoInfoList.size() == 0) {
            return null;
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (VideoInfo info : videoInfoList) {
            if (info.getMediatype() != mediaType) continue;
            res.add(info.mInfoId);
        }
        return res;
    }

    @Override
    public VideoInfo getVideoInfoByInfoId(int infoId) {
        if (infoId < 0 || this.vodVideoRef == null) {
            return null;
        }
        List<VideoInfo> videoInfoList = this.vodVideoRef.getVideoInfoList();
        if (videoInfoList == null || videoInfoList.size() == 0) {
            return null;
        }
        for (VideoInfo info : videoInfoList) {
            if (info.mInfoId != infoId) continue;
            return info;
        }
        return null;
    }

    @Override
    public List<Integer> getSupportedTTSAudioInfo() {
        if (this.vodVideoRef == null) {
            return null;
        }
        List<VideoInfo> dubbedAudioInfoList = this.vodVideoRef.getValueList(231);
        if (dubbedAudioInfoList == null || dubbedAudioInfoList.size() == 0) {
            return null;
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (VideoInfo info : dubbedAudioInfoList) {
            res.add(info.getValueInt(42));
        }
        return res;
    }

    @Override
    public List<Integer> getOriginalAudioInfo() {
        if (this.vodVideoRef == null) {
            return null;
        }
        List<VideoInfo> originalAudioInfoList = this.vodVideoRef.getValueList(234);
        if (originalAudioInfoList == null || originalAudioInfoList.size() == 0) {
            return null;
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (VideoInfo info : originalAudioInfoList) {
            res.add(info.getValueInt(42));
        }
        return res;
    }

    @Override
    public VideoStyle getVideoStyle() {
        if (this.vodVideoRef != null) {
            return this.vodVideoRef.mVideoStyle;
        }
        return null;
    }
}

