/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.preload;

import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.preload.PreloadMedia;
import com.ss.ttvideoengine.strategrycenter.ISelectBitrateCallback;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class PreloadModelMedia
extends PreloadMedia {
    public IVideoModel mVideoModel = null;
    public Resolution mResolution = Resolution.Undefine;
    public boolean mForbidP2p = false;
    private ISelectBitrateCallback mSelectCallback = null;
    private Map<String, String> mExtraInfo = null;
    private int mPriorityLevel = 0;
    private String mCustomPath = null;
    private String mContext = null;
    private String mFirstSubVid = null;
    private int mSubListIndex = -1;
    private long mCDNUrlExpiredTime = 0L;
    private String mTag = "";
    private String mSubTag = "";
    public boolean isLast = false;

    public PreloadModelMedia(IVideoModel videoModel, Resolution resolution, long preloadSize, boolean forbidP2p) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mForbidP2p = forbidP2p;
    }

    public PreloadModelMedia(IVideoModel videoModel) {
        this.mVideoModel = videoModel;
    }

    public PreloadModelMedia(IVideoModel videoModel, ISelectBitrateCallback callback) {
        this.mVideoModel = videoModel;
        this.mSelectCallback = callback;
    }

    public void setSelectBitrateCallback(ISelectBitrateCallback callback) {
        this.mSelectCallback = callback;
    }

    public void setFirstSubVideoId(String firstSubVideoId) {
        this.mFirstSubVid = firstSubVideoId;
    }

    public void setFirstSubVideoId(String firstSubVideoId, int index) {
        this.mFirstSubVid = firstSubVideoId;
        this.mSubListIndex = index;
    }

    public String getFirstSubVid() {
        return this.mFirstSubVid;
    }

    public int getSubListIndex() {
        return this.mSubListIndex;
    }

    public void setExtraInfo(Map<String, String> extraInfo) {
        this.mExtraInfo = extraInfo;
    }

    public Map<String, String> getExtraInfo() {
        return this.mExtraInfo;
    }

    public void setPriorityLevel(int level) {
        this.mPriorityLevel = level;
    }

    public int getPriorityLevel() {
        return this.mPriorityLevel;
    }

    public void setCustomPath(String path) {
        this.mCustomPath = path;
    }

    public String getCustomPath() {
        return this.mCustomPath;
    }

    public void setContext(String context) {
        this.mContext = context;
    }

    public String getContext() {
        return this.mContext;
    }

    public void setCDNUrlExpiredTime(long CDNUrlExpiredTime) {
        this.mCDNUrlExpiredTime = CDNUrlExpiredTime;
    }

    public long getCDNUrlExpiredTime() {
        return this.mCDNUrlExpiredTime;
    }

    public ISelectBitrateCallback getSelectCallback() {
        return this.mSelectCallback;
    }

    public boolean isNeedConvertStrategyInfo() {
        return this.getExtraInfo() != null || this.getSubListIndex() != -1 || this.getFirstSubVid() != null || this.mCDNUrlExpiredTime != 0L || this.mTag.length() > 0 || this.mSubTag.length() > 0;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setSubTag(String subTag) {
        this.mSubTag = subTag;
    }

    public String getSubTag() {
        return this.mSubTag;
    }

    public String toStrategyInfo() {
        String info = "";
        JSONObject mediaJson = this.mVideoModel.getMediaInfo();
        try {
            mediaJson.put("sc_priority", this.mPriorityLevel);
            if (this.mExtraInfo != null) {
                mediaJson.put("sc_extra", (Object)new JSONObject(this.getExtraInfo()));
            }
            if (this.mCustomPath != null) {
                mediaJson.put("sc_custom_path", (Object)this.mCustomPath);
            }
            if (this.mContext != null) {
                mediaJson.put("sc_context", (Object)this.mContext);
            }
            if (this.mPreloadSize > 0L) {
                mediaJson.put("sc_preload_size", this.mPreloadSize);
            }
            if (this.mFirstSubVid != null) {
                mediaJson.put("sc_frt_sub_vid", (Object)this.mFirstSubVid);
            }
            if (this.mSubListIndex != -1) {
                mediaJson.put("sc_sub_list_index", this.mSubListIndex);
            }
            if (this.mCDNUrlExpiredTime != 0L) {
                mediaJson.put("sc_url_expired_t", this.mCDNUrlExpiredTime);
            }
            if (this.mTag.length() > 0) {
                mediaJson.put("sc_tag", (Object)this.mTag);
            }
            if (this.mSubTag.length() > 0) {
                mediaJson.put("sc_sub_tag", (Object)this.mSubTag);
            }
            info = mediaJson.toString();
        }
        catch (JSONException e) {
            TTVideoEngineLog.d(e);
        }
        return info;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreloadModelMedia)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreloadModelMedia that = (PreloadModelMedia)o;
        return Objects.equals(this.mVideoModel, that.mVideoModel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mVideoModel);
    }
}

