/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.selector;

import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.model.IVideoInfo;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.selector.SelectedInfo;
import com.ss.ttvideoengine.selector.shift.SpeedShiftConfig;
import com.ss.ttvideoengine.selector.shift.SpeedShiftSelector;
import java.util.Map;

public class BestResolution {
    public static Resolution findDefaultResolution(IVideoModel model, Resolution defaultResolution) {
        if (model != null && defaultResolution != null) {
            Resolution bestResolution = defaultResolution;
            int minDis = Resolution.getAllResolutions().length;
            Resolution[] supportResolutions = model.getSupportResolutions();
            if (supportResolutions == null || supportResolutions.length == 0) {
                return bestResolution;
            }
            for (Resolution resolution : supportResolutions) {
                int tmpDis;
                if (resolution == null || (tmpDis = Math.abs(resolution.ordinal() - defaultResolution.ordinal())) >= minDis) continue;
                bestResolution = resolution;
                minDis = tmpDis;
                if (minDis == 0) break;
            }
            return bestResolution;
        }
        return Resolution.Standard;
    }

    public static Resolution findMaxCacheResolution(IVideoModel model, Resolution defaultResolution) {
        if (model != null && defaultResolution != null) {
            Resolution bestResolution = defaultResolution;
            long maxCacheSize = 0L;
            Resolution[] supportResolutions = model.getSupportResolutions();
            if (supportResolutions == null || supportResolutions.length == 0) {
                return bestResolution;
            }
            for (Resolution resolution : supportResolutions) {
                long cacheSize = TTVideoEngine.getCacheFileSize(model, resolution);
                if (cacheSize <= maxCacheSize) continue;
                maxCacheSize = cacheSize;
                bestResolution = resolution;
            }
            return bestResolution;
        }
        return Resolution.Standard;
    }

    public static Resolution findMaxQualityResolution(IVideoModel model, Resolution defaultResolution) {
        if (model != null && defaultResolution != null) {
            Resolution bestResolution = defaultResolution;
            Resolution[] supportResolutions = model.getSupportResolutions();
            if (supportResolutions == null || supportResolutions.length == 0) {
                return bestResolution;
            }
            for (Resolution resolution : supportResolutions) {
                if (TTVideoEngine.getCacheFileSize(model, resolution) <= 0L || resolution.ordinal() <= bestResolution.ordinal()) continue;
                bestResolution = resolution;
            }
            return bestResolution;
        }
        return Resolution.Standard;
    }

    public static Resolution findAwemeShiftResolution(IVideoModel model, Resolution defaultResolution, double speed, SpeedShiftConfig speedShiftConfig) {
        Map<Integer, Object> params;
        SpeedShiftSelector selector;
        SelectedInfo info;
        IVideoInfo videoInfo;
        if (model != null && defaultResolution != null && speedShiftConfig != null && (videoInfo = (info = (selector = new SpeedShiftSelector(speedShiftConfig)).select(model, params = new SpeedShiftSelector.Params().speed(speed).build())).getVideoInfo()) != null) {
            return videoInfo.getResolution();
        }
        return defaultResolution;
    }
}

