/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.selector.gracie;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.vcloud.abrmodule.ABRAudioStream;
import com.bytedance.vcloud.abrmodule.ABRResult;
import com.bytedance.vcloud.abrmodule.ABRResultElement;
import com.bytedance.vcloud.abrmodule.ABRVideoStream;
import com.bytedance.vcloud.abrmodule.DefaultABRModule;
import com.bytedance.vcloud.abrmodule.IABRModule;
import com.bytedance.vcloud.abrmodule.IAudioStream;
import com.bytedance.vcloud.abrmodule.IVideoStream;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTNetWorkListener;
import com.ss.ttvideoengine.abr.ABRPool;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.selector.SelectedInfo;
import com.ss.ttvideoengine.selector.Selector;
import com.ss.ttvideoengine.strategrycenter.StrategyCenter;
import com.ss.ttvideoengine.superresolution.SRStrategy;
import com.ss.ttvideoengine.superresolution.SRStrategyConfig;
import com.ss.ttvideoengine.utils.Error;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GracieSelector
implements Selector {
    public static final int SELECT_SCENE_PRELOAD = 0;
    public static final int SELECT_SCENE_STARTUP = 1;
    private final int mScene;
    private final int mOnceT;
    private static int sSpeedType = 4;
    private static final int DEFAULT_ONCE_TYPE = 8;

    public static void setSpeedType(int speedType) {
        sSpeedType = speedType;
    }

    public GracieSelector(int scene) {
        this(scene, 8);
    }

    public GracieSelector(int scene, int onceType) {
        this.mScene = scene;
        this.mOnceT = onceType;
    }

    private static int getBitrate(int indexKey, int qualityKey, @NonNull Map<Integer, Object> params, @NonNull IVideoModel videoModel) {
        VideoInfo filteredInfo;
        int bitrate = -1;
        int index = -1;
        Object obj = params.get(indexKey);
        if (obj instanceof Integer) {
            index = (Integer)obj;
        }
        obj = params.get(qualityKey);
        if ((index == -1 || index == Resolution.Auto.getIndex()) && obj == null) {
            return -1;
        }
        HashMap<Integer, String> qualityMap = new HashMap<Integer, String>();
        qualityMap.clear();
        if (obj instanceof String) {
            String defaultWifiQuality = (String)obj;
            qualityMap.put(32, defaultWifiQuality);
        }
        if ((filteredInfo = videoModel.getVideoInfo(Resolution.valueOf(index), qualityMap, true)) != null) {
            bitrate = filteredInfo.getValueInt(3);
        }
        return bitrate;
    }

    @Override
    @NonNull
    public SelectedInfo select(@Nullable IVideoModel videoModel, @Nullable Map<Integer, Object> params) {
        if (videoModel == null) {
            Error error = new Error("kTTVideoSelector", -7999, "null video model");
            return new SelectedInfo(error);
        }
        int expectedBitrate = -1;
        int defaultWifiBitrate = -1;
        int startupMaxBitrate = -1;
        int cellularMaxBitrate = -1;
        int downgradeBitrate = -1;
        int screenWidth = -1;
        int screenHeight = -1;
        int displayWidth = -1;
        int displayHeight = -1;
        SRStrategyConfig srStrategyConfig = null;
        SRStrategy srStrategy = null;
        if (params != null) {
            Object obj = params.get(ParamsKey.SCREEN_WIDTH.ordinal());
            if (obj instanceof Integer) {
                screenWidth = (Integer)obj;
            }
            if ((obj = params.get(ParamsKey.SCREEN_HEIGHT.ordinal())) instanceof Integer) {
                screenHeight = (Integer)obj;
            }
            if ((obj = params.get(ParamsKey.DISPLAY_WIDTH.ordinal())) instanceof Integer) {
                displayWidth = (Integer)obj;
            }
            if ((obj = params.get(ParamsKey.DISPLAY_HEIGHT.ordinal())) instanceof Integer) {
                displayHeight = (Integer)obj;
            }
            if ((obj = params.get(ParamsKey.SR_STRATEGY_CONFIG.ordinal())) instanceof SRStrategyConfig) {
                srStrategyConfig = (SRStrategyConfig)obj;
            }
            defaultWifiBitrate = GracieSelector.getBitrate(ParamsKey.WIFI_DEFAULT_RESOLUTION_INDEX.ordinal(), ParamsKey.WIFI_DEFAULT_RESOLUTION_QUALITY.ordinal(), params, videoModel);
            expectedBitrate = GracieSelector.getBitrate(ParamsKey.USER_EXPECTED_RESOLUTION_INDEX.ordinal(), ParamsKey.USER_EXPECTED_RESOLUTION_QUALITY.ordinal(), params, videoModel);
            cellularMaxBitrate = GracieSelector.getBitrate(ParamsKey.CELLULAR_MAX_RESOLUTION_INDEX.ordinal(), ParamsKey.CELLULAR_MAX_RESOLUTION_QUALITY.ordinal(), params, videoModel);
            startupMaxBitrate = GracieSelector.getBitrate(ParamsKey.GRACIE_MAX_RESOLUTION_INDEX.ordinal(), ParamsKey.GRACIE_MAX_RESOLUTION_QUALITY.ordinal(), params, videoModel);
            downgradeBitrate = GracieSelector.getBitrate(ParamsKey.DOWNGRADE_RESOLUTION_INDEX.ordinal(), ParamsKey.DOWNGRADE_RESOLUTION_QUALITY.ordinal(), params, videoModel);
        }
        if (srStrategyConfig != null) {
            srStrategy = new SRStrategy();
            int format = 0;
            if (videoModel.hasFormat(IVideoModel.Format.DASH)) {
                format |= 2;
            }
            if (videoModel.hasFormat(IVideoModel.Format.MP4)) {
                format |= 1;
            }
            srStrategyConfig.setCurrentVideoFormatType(format);
            srStrategyConfig.setCurrentDuration(videoModel.getVideoRefInt(3));
            boolean isHdr = false;
            List<VideoInfo> infos = videoModel.getVideoInfoList();
            if (infos != null && infos.size() > 0) {
                for (VideoInfo info : infos) {
                    String definition = info.getValueStr(7);
                    if (definition == null || !definition.toLowerCase().contains("hdr")) continue;
                    isHdr = true;
                    break;
                }
            }
            srStrategyConfig.setIsHdr(isHdr);
            srStrategy.updateConfig(srStrategyConfig);
        }
        IABRModule abrModule = ABRPool.getInstance().getFromCache();
        boolean fromPool = true;
        if (abrModule == null) {
            fromPool = false;
            abrModule = new DefaultABRModule();
        }
        abrModule.setIntOptionForKey(14, this.mScene);
        abrModule.setIntOptionForKey(6, displayWidth);
        abrModule.setIntOptionForKey(7, displayHeight);
        abrModule.setIntOptionForKey(34, screenWidth);
        abrModule.setIntOptionForKey(35, screenHeight);
        abrModule.setLongOptionForKey(12, defaultWifiBitrate);
        abrModule.setLongOptionForKey(2, cellularMaxBitrate);
        abrModule.setLongOptionForKey(13, startupMaxBitrate);
        abrModule.setLongOptionForKey(22, expectedBitrate);
        abrModule.setLongOptionForKey(33, downgradeBitrate);
        ArrayList<IVideoStream> videoStreams = new ArrayList<IVideoStream>();
        ArrayList<IAudioStream> audioStreams = new ArrayList<IAudioStream>();
        List<VideoInfo> infoList = videoModel.getVideoInfoList();
        if (infoList == null) {
            infoList = Collections.emptyList();
        }
        for (VideoInfo info : infoList) {
            String streamKey;
            if (info == null) continue;
            if (info.getMediatype() == VideoRef.TYPE_VIDEO) {
                String qualityDesc;
                ABRVideoStream videoStream = new ABRVideoStream();
                streamKey = info.getValueStr(15);
                videoStream.setStreamId(streamKey);
                videoStream.setBandWidth(info.getValueInt(3));
                videoStream.setCodec(info.getValueStr(8));
                videoStream.setRealBitrate(info.getValueInt(44));
                int width = info.getValueInt(1);
                int height = info.getValueInt(2);
                videoStream.setWidth(width);
                videoStream.setHeight(height);
                videoStream.setFrameRate(-1);
                videoStream.setSegmentDuration(5000);
                if (!TextUtils.isEmpty((CharSequence)streamKey)) {
                    videoStreams.add(videoStream);
                }
                videoStream.setSupportSR(0);
                if (srStrategy != null) {
                    videoStream.setSupportSR(srStrategy.videoInfoSupportSR(info) != false ? 1 : 0);
                }
                int resolutionindex = -1;
                Resolution resolution = info.getResolution();
                if (resolution != null) {
                    resolutionindex = resolution.getIndex();
                }
                if ((qualityDesc = info.getValueStr(32)) != null) {
                    try {
                        resolutionindex = Integer.parseInt(qualityDesc);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                videoStream.setResolution(resolutionindex);
                continue;
            }
            ABRAudioStream audioStream = new ABRAudioStream();
            streamKey = info.getValueStr(15);
            audioStream.setStreamId(streamKey);
            audioStream.setBandWidth(info.getValueInt(3));
            audioStream.setCodec(info.getValueStr(8));
            audioStream.setRealBitrate(info.getValueInt(44));
            audioStream.setSampleRate(-1);
            audioStream.setSegmentDuration(5000);
            if (TextUtils.isEmpty((CharSequence)streamKey)) continue;
            audioStreams.add(audioStream);
        }
        abrModule.setMediaInfo(videoStreams, audioStreams);
        float avgDownloadSpeed = 0.0f;
        float avgStartupEndNetworkSpeed = 0.0f;
        float downloadSpeed = 0.0f;
        float networkSpeed = 0.0f;
        float networkSpeedConfidence = 0.0f;
        if (StrategyCenter.sNetAbrSpeedPredictor != null) {
            Map<String, String> speedPair = StrategyCenter.sNetAbrSpeedPredictor.getDownloadSpeed(VideoRef.TYPE_VIDEO);
            if (speedPair != null && speedPair.get("download_speed") != null) {
                downloadSpeed = Float.parseFloat(speedPair.get("download_speed"));
            }
            networkSpeed = StrategyCenter.sNetAbrSpeedPredictor.getPredictSpeed(0);
            networkSpeedConfidence = StrategyCenter.sNetAbrSpeedPredictor.getLastPredictConfidence();
            avgDownloadSpeed = StrategyCenter.sNetAbrSpeedPredictor.getAverageDownloadSpeed(VideoRef.TYPE_VIDEO, 3, false);
            avgStartupEndNetworkSpeed = StrategyCenter.sNetAbrSpeedPredictor.getAverageDownloadSpeed(VideoRef.TYPE_VIDEO, sSpeedType, false);
        }
        abrModule.setFloatOptionForKey(25, downloadSpeed);
        abrModule.setFloatOptionForKey(23, networkSpeed);
        abrModule.setFloatOptionForKey(24, networkSpeedConfidence);
        abrModule.setFloatOptionForKey(27, avgDownloadSpeed);
        abrModule.setFloatOptionForKey(28, avgStartupEndNetworkSpeed);
        int networkState = TTNetWorkListener.getInstance().getCurrentAccessType();
        abrModule.setIntOptionForKey(21, networkState);
        if (srStrategy != null) {
            abrModule.setIntOptionForKey(39, srStrategy.isSREnabled() ? 1 : 0);
            abrModule.setIntOptionForKey(40, srStrategy.isSRSatisfied() ? 1 : 0);
            abrModule.setSRBenchmarkMap(srStrategy.getSRBenchmark());
        }
        abrModule.setIntOptionForKey(66, videoModel.getVideoRefInt(3));
        String pallasVidLabels = videoModel.getVideoRefStr(237);
        if (!TextUtils.isEmpty((CharSequence)pallasVidLabels)) {
            abrModule.setStringOptionForKey(69, pallasVidLabels);
        }
        ABRResult result = abrModule.onceSelect(this.mOnceT, this.mScene);
        if (fromPool) {
            String vid = videoModel.getVideoRefStr(2);
            if (TextUtils.isEmpty((CharSequence)vid)) {
                ABRPool.getInstance().giveBack(abrModule);
            } else {
                ABRPool.getInstance().preloadDone(vid, abrModule);
            }
        } else {
            abrModule.release();
        }
        if (result == null) {
            Error error = new Error("kTTVideoSelector", -7997, "null abr result");
            return new SelectedInfo(error);
        }
        long videoBitrate = 0L;
        long videoBitrateUseSR = 0L;
        for (int i = 0; i < result.size(); ++i) {
            ABRResultElement element = result.get(i);
            if (element.getMediaType() != VideoRef.TYPE_VIDEO) continue;
            if (1 == element.getUseSR()) {
                videoBitrateUseSR = element.getBitrate();
                continue;
            }
            videoBitrate = element.getBitrate();
        }
        if (videoBitrateUseSR > 0L) {
            videoBitrate = videoBitrateUseSR;
        }
        long bitRate = videoBitrate;
        SelectedInfo selectedInfo = null;
        if (bitRate > 0L) {
            long diff = -1L;
            VideoInfo bestBitrateInfo = null;
            for (VideoInfo videoInfo : infoList) {
                if (videoInfo == null || videoInfo.getMediatype() == VideoRef.TYPE_AUDIO || videoInfo.getResolution() == null) continue;
                long resolutionBitRate = videoInfo.getValueInt(3);
                if (diff >= 0L && Math.abs(resolutionBitRate - bitRate) >= diff) continue;
                diff = Math.abs(resolutionBitRate - bitRate);
                bestBitrateInfo = videoInfo;
            }
            if (bestBitrateInfo != null) {
                selectedInfo = new SelectedInfo(bestBitrateInfo);
            }
        }
        if (selectedInfo == null) {
            Error error = new Error("kTTVideoSelector", -7999, "null video info fit bitrate");
            selectedInfo = new SelectedInfo(error);
        }
        return selectedInfo;
    }

    public static class Params {
        Map<Integer, Object> mMaps = new HashMap<Integer, Object>();

        public Params wifiDefault(int index, String quality) {
            if (!TextUtils.isEmpty((CharSequence)quality)) {
                this.mMaps.put(ParamsKey.WIFI_DEFAULT_RESOLUTION_QUALITY.ordinal(), quality);
            }
            if (index >= 0) {
                this.mMaps.put(ParamsKey.WIFI_DEFAULT_RESOLUTION_INDEX.ordinal(), index);
            }
            return this;
        }

        public Params cellularMax(int index, String quality) {
            if (!TextUtils.isEmpty((CharSequence)quality)) {
                this.mMaps.put(ParamsKey.CELLULAR_MAX_RESOLUTION_QUALITY.ordinal(), quality);
            }
            if (index >= 0) {
                this.mMaps.put(ParamsKey.CELLULAR_MAX_RESOLUTION_INDEX.ordinal(), index);
            }
            return this;
        }

        public Params userExpected(int index, String quality) {
            if (!TextUtils.isEmpty((CharSequence)quality)) {
                this.mMaps.put(ParamsKey.USER_EXPECTED_RESOLUTION_QUALITY.ordinal(), quality);
            }
            if (index >= 0) {
                this.mMaps.put(ParamsKey.USER_EXPECTED_RESOLUTION_INDEX.ordinal(), index);
            }
            return this;
        }

        public Params abrMax(int index, String quality) {
            if (!TextUtils.isEmpty((CharSequence)quality)) {
                this.mMaps.put(ParamsKey.GRACIE_MAX_RESOLUTION_QUALITY.ordinal(), quality);
            }
            if (index >= 0) {
                this.mMaps.put(ParamsKey.GRACIE_MAX_RESOLUTION_INDEX.ordinal(), index);
            }
            return this;
        }

        public Params downgrade(int index, String quality) {
            if (!TextUtils.isEmpty((CharSequence)quality)) {
                this.mMaps.put(ParamsKey.DOWNGRADE_RESOLUTION_QUALITY.ordinal(), quality);
            }
            if (index >= 0) {
                this.mMaps.put(ParamsKey.DOWNGRADE_RESOLUTION_INDEX.ordinal(), index);
            }
            return this;
        }

        public Params screenSize(int width, int height) {
            this.mMaps.put(ParamsKey.SCREEN_WIDTH.ordinal(), width);
            this.mMaps.put(ParamsKey.SCREEN_HEIGHT.ordinal(), height);
            return this;
        }

        public Params displaySize(int width, int height) {
            this.mMaps.put(ParamsKey.DISPLAY_WIDTH.ordinal(), width);
            this.mMaps.put(ParamsKey.DISPLAY_HEIGHT.ordinal(), height);
            return this;
        }

        public Params srStrategyConfig(SRStrategyConfig config) {
            if (config == null) {
                return this;
            }
            config.setStrategyType(0);
            this.mMaps.put(ParamsKey.SR_STRATEGY_CONFIG.ordinal(), config);
            return this;
        }

        public Map<Integer, Object> build() {
            return this.mMaps;
        }
    }

    private static enum ParamsKey {
        SCREEN_WIDTH,
        SCREEN_HEIGHT,
        DISPLAY_WIDTH,
        DISPLAY_HEIGHT,
        WIFI_DEFAULT_RESOLUTION_INDEX,
        WIFI_DEFAULT_RESOLUTION_QUALITY,
        CELLULAR_MAX_RESOLUTION_INDEX,
        CELLULAR_MAX_RESOLUTION_QUALITY,
        USER_EXPECTED_RESOLUTION_INDEX,
        USER_EXPECTED_RESOLUTION_QUALITY,
        GRACIE_MAX_RESOLUTION_INDEX,
        GRACIE_MAX_RESOLUTION_QUALITY,
        DOWNGRADE_RESOLUTION_INDEX,
        DOWNGRADE_RESOLUTION_QUALITY,
        SR_STRATEGY_CONFIG;

    }
}

