/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.setting;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.vodsetting.ConfigEnv;
import com.bytedance.vodsetting.NetInterface;
import com.bytedance.vodsetting.SettingsListener;
import com.bytedance.vodsetting.SettingsManager;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.strategrycenter.StrategyHelper;
import com.ss.ttvideoengine.utils.DeviceUtil;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SettingsHelper {
    private static String TAG = "VodSettings";
    public static String REGION_CN = ConfigEnv.REGION_CN;
    public static String REGION_US = ConfigEnv.REGION_US;
    public static String REGION_SG = ConfigEnv.REGION_SG;
    public static String MODULE_VOD = "vod";
    public static String MODULE_MDL = "mdl";
    public static int HARDWARE_CONFIG_VIDEO_MODEL = 2;
    public static int HARDWARE_CONFIG_SETTINGS = 3;
    private SettingsManager mSettingsManager = SettingsManager.shareSettings();
    private Context mContext = null;
    private String mPlayerVersion = null;
    private String mMdlVersion = null;
    private boolean mDebug = false;
    private int mEnable = 0;
    private TTVNetClient mNetClient = null;

    public static SettingsHelper helper() {
        return HelperHolder.Instance;
    }

    private SettingsHelper() {
        this.mSettingsManager.addListener(new MyListener(SettingsManager.shareSettings()));
    }

    public SettingsManager settings() {
        return this.mSettingsManager;
    }

    public void addListener(SettingsListener listener) {
        this.mSettingsManager.addListener(listener);
    }

    @Nullable
    public JSONObject getJsonObject(String module) {
        if (this.mEnable == 0) {
            return null;
        }
        return this.mSettingsManager.getJsonObject(module);
    }

    public String getVodString(String key, String dValue) {
        if (this.mEnable == 0) {
            return dValue;
        }
        return this.mSettingsManager.getString("vod", key, dValue);
    }

    public long getVodLong(String key, long dValue) {
        if (this.mEnable == 0) {
            return dValue;
        }
        return this.mSettingsManager.getLong("vod", key, dValue);
    }

    public int getVodInt(String key, int dValue) {
        if (this.mEnable == 0) {
            return dValue;
        }
        return this.mSettingsManager.getInt("vod", key, dValue);
    }

    public JSONObject getVodJsonObject(String key) {
        if (this.mEnable == 0) {
            return null;
        }
        return this.mSettingsManager.getJsonObject("vod", key);
    }

    public JSONArray getVodJsonArray(String key) {
        if (this.mEnable == 0) {
            return null;
        }
        return this.mSettingsManager.getVodJsonArray(key);
    }

    public String getMDLString(String key, String dValue) {
        if (this.mEnable == 0) {
            return dValue;
        }
        return this.mSettingsManager.getString("mdl", key, dValue);
    }

    public long getMDLLong(String key, long dValue) {
        if (this.mEnable == 0) {
            return dValue;
        }
        return this.mSettingsManager.getLong("mdl", key, dValue);
    }

    public int getMDLInt(String key, int dValue) {
        if (this.mEnable == 0) {
            return dValue;
        }
        return this.mSettingsManager.getInt("mdl", key, dValue);
    }

    public JSONObject getMDLJsonObject(String key) {
        if (this.mEnable == 0) {
            return null;
        }
        return this.mSettingsManager.getJsonObject("mdl", key);
    }

    public void setEnable(int enable) {
        this.mEnable = enable;
        if (ConfigEnv.getRegion() != null) {
            this.config().load(MODULE_VOD);
        }
    }

    public SettingsHelper setContext(Context context) {
        this.mContext = context;
        if (this.mSettingsManager != null) {
            this.mSettingsManager.setContext(context);
            this.mSettingsManager.setDebug(this.mDebug);
            this.mSettingsManager.setNet(new NetInterface(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void start(String urlString, Map<String, String> queries, final NetInterface.CompletionListener listener) {
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        if (SettingsHelper.this.mNetClient == null) {
                            if (TTVideoEngineConfig.gNetClient != null) {
                                SettingsHelper.this.mNetClient = TTVideoEngineConfig.gNetClient;
                            } else {
                                SettingsHelper.this.mNetClient = new TTHTTPNetwork();
                            }
                        }
                        urlString = SettingsHelper.this.buildURLString(urlString, queries);
                        TTVideoEngineLog.d(TAG, "setting query " + urlString);
                        SettingsHelper.this.mNetClient.startTask(urlString, null, new TTVNetClient.CompletionListener(){

                            @Override
                            public void onCompletion(JSONObject jsonBody, Error error) {
                                TTVideoEngineLog.d(TAG, "setting result " + jsonBody);
                                if (error != null) {
                                    listener.onCompletion(null, new java.lang.Error(" fail. info: " + error.toString()));
                                } else if (jsonBody != null) {
                                    listener.onCompletion(jsonBody, null);
                                }
                            }
                        });
                    }
                }

                @Override
                public void cancel() {
                    if (SettingsHelper.this.mNetClient != null) {
                        SettingsHelper.this.mNetClient.cancel();
                    }
                }
            });
        }
        return this;
    }

    public SettingsHelper setRegionHost(int key, String value) {
        switch (key) {
            case 116: {
                ConfigEnv.setHostForCN(value);
                break;
            }
            case 117: {
                ConfigEnv.setHostForSG(value);
                break;
            }
            case 118: {
                ConfigEnv.setHostForUS(value);
                break;
            }
        }
        return this;
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    public SettingsHelper config() {
        if (!TextUtils.isEmpty((CharSequence)AppInfo.mRegion)) {
            if (AppInfo.mRegion.equals("china")) {
                ConfigEnv.setRegion(ConfigEnv.REGION_CN);
            } else if (AppInfo.mRegion.equals("singapore")) {
                ConfigEnv.setRegion(ConfigEnv.REGION_SG);
            } else {
                ConfigEnv.setRegion(AppInfo.mRegion);
            }
        }
        HashMap<String, Object> appInfo = new HashMap<String, Object>();
        appInfo.put("aid", AppInfo.mAppID);
        appInfo.put("app_name", AppInfo.mAppName);
        appInfo.put("device_id", AppInfo.mDeviceId == null ? "" : AppInfo.mDeviceId);
        appInfo.put("app_channel", AppInfo.mAppChannel);
        appInfo.put("app_version", AppInfo.mAppVersion);
        this.addSignatureInfo(appInfo);
        this.addDeviceInfo(appInfo);
        ConfigEnv.setAppInfo(appInfo);
        HashMap<String, Object> sdkInfo = new HashMap<String, Object>();
        sdkInfo.put("sdk_version", this._sdkVersion());
        sdkInfo.put("player_version", this._playerVersion());
        sdkInfo.put("mdl_version", this._mdlVersion());
        sdkInfo.put("st_version", this._strategyVersion());
        sdkInfo.put("settings_version", this._settingsVersion());
        ConfigEnv.setSDKInfo(sdkInfo);
        return this;
    }

    private void addDeviceInfo(Map<String, Object> appInfo) {
        appInfo.put("device_id", TTVideoEngine.getDeviceID());
        if (this.mContext != null) {
            appInfo.put("player_unique_id", TTVideoEngine.getEngineUniqueId(this.mContext));
        }
    }

    private void addSignatureInfo(Map<String, Object> appInfo) {
        if (this.mContext == null) {
            return;
        }
        String packageName = this.mContext.getPackageName();
        String bundleId = TTHelper.md5(packageName);
        long timestamp = System.currentTimeMillis() / 1000L;
        String signature = this.getSignature(bundleId, timestamp);
        appInfo.put("bundle_id", bundleId);
        appInfo.put("timestamp", timestamp);
        appInfo.put("signature", signature);
    }

    private String getSignature(String bundleId, long timestamp) {
        String msg = bundleId + "&" + AppInfo.mAppID + "&" + AppInfo.mDeviceId + "&" + DeviceUtil.getDeviceModel().toLowerCase() + "&" + timestamp;
        return TTHelper.hmacSha1(msg);
    }

    public SettingsHelper loadMDLCache() {
        if (this.mContext == null) {
            return this;
        }
        if (this.mSettingsManager != null) {
            this.mSettingsManager.loadLocal(2);
        }
        return this;
    }

    public SettingsHelper load(String module) {
        if (this.mEnable == 0) {
            return this;
        }
        if (this.mContext == null) {
            return this;
        }
        if (this.mSettingsManager != null) {
            this.mSettingsManager.loadLocalAndRefresh(module, true);
        }
        return this;
    }

    private String _sdkVersion() {
        return "1.10.92.2-premium";
    }

    private String _playerVersion() {
        if (this.mPlayerVersion == null) {
            this.mPlayerVersion = TTPlayerConfiger.getValue((int)14, (String)"");
        }
        return this.mPlayerVersion;
    }

    private String _mdlVersion() {
        if (this.mMdlVersion == null) {
            this.mMdlVersion = DataLoaderHelper.getDataLoader().getStringValue(6);
        }
        return this.mMdlVersion;
    }

    private String _strategyVersion() {
        return "3.92.0";
    }

    private String _settingsVersion() {
        return "2.1.0";
    }

    private String buildURLString(String url, Map<String, String> params) {
        if (url == null || params == null || params.isEmpty()) {
            return url;
        }
        Uri.Builder builder = Uri.parse((String)url).buildUpon();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.build().toString();
    }

    private static class MyListener
    implements SettingsListener {
        private WeakReference<SettingsManager> mWeakManager;

        public MyListener(SettingsManager manager) {
            this.mWeakManager = new WeakReference<SettingsManager>(manager);
        }

        @Override
        public void onNotify(String module, int what) {
            JSONObject tem;
            SettingsManager manager = (SettingsManager)this.mWeakManager.get();
            if (manager != null && (tem = HelperHolder.Instance.mSettingsManager.getJsonObject(module)) != null) {
                StrategyHelper.helper().getCenter().setSettingsInfo(module, tem.toString());
            }
        }
    }

    private static class HelperHolder {
        private static final SettingsHelper Instance = new SettingsHelper();

        private HelperHolder() {
        }
    }
}

