/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategrycenter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class StrategyEvent {
    private static final String TAG = "StrategyEvent";
    public static final String LOG_KEY_PLAY_TASK_CONTROL = "st_play_task_op";
    public static final String LOG_KEY_PRELOAD = "st_preload";
    public static final String LOG_KEY_BUFFER_DURATION = "st_buf_dur";
    public static final String LOG_KEY_PRELOAD_PERSONALIZED = "st_preload_personalized";
    public static final String LOG_KEY_ADAPTIVE_RANGE = "st_adaptive_range";
    public static final String LOG_KEY_REMAINING_BUFFER_DURATION = "st_remaining_buf_dur";
    public static final String LOG_KEY_PRELOAD_FINISHED_TIME = "st_preload_finished_time";
    public static final String LOG_KEY_BANDWIDTH_RANGE = "st_band_range";
    public static final String LOG_KEY_COMMON_EVENT_LOG = "st_common";
    private static final String PAUSE = "pause";
    private static final String RESUME = "resume";
    private static final String RANGE = "range";
    private static final String RANGE_DURATION = "range_dur";
    private static final String SEEKLABEL = "seek_label";
    private static final String LOG_KEY_STARTUP_BUFFER_DURATION = "startup_buf_dur";
    private static final String LOG_KEY_RE_BUFFER_DURATION_INITIAL = "rebuf_dur_init";
    private static final String LOG_KEY_PLAY_BUFFER_DIFF_COUNT = "diff_ret_count";
    private static final String LOG_KEY_PRELOAD_PERSONALIZED_OPTION = "preload_personalized_option";
    private static final String LOG_KEY_WATCH_DURATION_LABEL = "watch_duration_label";
    private static final String LOG_KEY_STALL_LABEL = "stall_label";
    private static final String LOG_KEY_FIRST_FRAME_LABEL = "first_frame_label";
    private static final String LOG_KEY_ADAPTIVE_RANGE_ENABLED = "enabled";
    private static final String LOG_KEY_ADAPTIVE_RANGE_BUFFER_LOG = "buffer_log";
    private static final String LOG_KEY_CURRENT_BANDWIDTH = "current_bandwidth";
    private static final String LOG_KEY_BANDWIDTH_BITRATE_RATIO = "band_bitrate_ratio";
    private static final String LOG_KEY_MODULE_ACTIVATED = "module_activated";
    private final Map<String, Object> mPreloadInfo = new ConcurrentHashMap<String, Object>();
    private final Map<String, Map<String, Object>> mPlayTaskInfo = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Integer>> mBufferDurationMap = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Integer>> mPreloadPersonalizedMap = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Object>> mAdaptiveRangeMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Integer> mRemainingBufferDuration = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Long> mPreloadFinishedTime = new ConcurrentHashMap<String, Long>();
    private final Map<String, Map<String, Object>> mBandwidthRangeMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Object> mCommonEventLog = new ConcurrentHashMap<String, Object>();

    @NonNull
    private Map<String, Object> convertCounterMap(@NonNull Map<String, Object> map) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Counter) {
                retMap.put(entry.getKey(), ((Counter)entry.getValue()).getCount());
                continue;
            }
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    @Nullable
    public Map<String, Object> getLogData(String videoId) {
        Map<String, Object> bandwidthRange;
        Long preloadFinishedTime;
        Integer duration;
        Map<String, Object> adaptiveRange;
        Map<String, Integer> preloadPersonalized;
        Map<String, Integer> bufferDuration;
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            return null;
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Map<String, Object> onePlayDict = this.mPlayTaskInfo.get(videoId);
        if (onePlayDict != null) {
            retMap.put(LOG_KEY_PLAY_TASK_CONTROL, this.convertCounterMap(onePlayDict));
        }
        if (!this.mPreloadInfo.isEmpty()) {
            retMap.put(LOG_KEY_PRELOAD, this.mPreloadInfo);
        }
        if ((bufferDuration = this.mBufferDurationMap.get(videoId)) != null) {
            retMap.put(LOG_KEY_BUFFER_DURATION, bufferDuration);
        }
        if ((preloadPersonalized = this.mPreloadPersonalizedMap.get(videoId)) != null) {
            retMap.put(LOG_KEY_PRELOAD_PERSONALIZED, preloadPersonalized);
        }
        if ((adaptiveRange = this.mAdaptiveRangeMap.get(videoId)) != null) {
            retMap.put(LOG_KEY_ADAPTIVE_RANGE, adaptiveRange);
        }
        if ((duration = this.mRemainingBufferDuration.get(videoId)) != null) {
            retMap.put(LOG_KEY_REMAINING_BUFFER_DURATION, duration);
        }
        if ((preloadFinishedTime = this.mPreloadFinishedTime.get(videoId)) != null) {
            retMap.put(LOG_KEY_PRELOAD_FINISHED_TIME, preloadFinishedTime);
        }
        if ((bandwidthRange = this.mBandwidthRangeMap.get(videoId)) != null) {
            retMap.put(LOG_KEY_BANDWIDTH_RANGE, bandwidthRange);
        }
        retMap.put(LOG_KEY_COMMON_EVENT_LOG, this.mCommonEventLog);
        Log.i((String)TAG, (String)("debug info info " + ((Object)retMap).toString()));
        return retMap;
    }

    @Nullable
    public Map<String, Object> getLogData(String videoId, String key) {
        if (TextUtils.isEmpty((CharSequence)videoId) || TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (key.equals(LOG_KEY_PLAY_TASK_CONTROL)) {
            Map<String, Object> retMap = null;
            Map<String, Object> onePlayDict = this.mPlayTaskInfo.get(videoId);
            if (onePlayDict != null) {
                retMap = this.convertCounterMap(onePlayDict);
            }
            return retMap;
        }
        return null;
    }

    public void removeLogData(String videoId) {
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            return;
        }
        this.mPlayTaskInfo.remove(videoId);
        this.mBufferDurationMap.remove(videoId);
        this.mPreloadPersonalizedMap.remove(videoId);
        this.mAdaptiveRangeMap.remove(videoId);
        this.mRemainingBufferDuration.remove(videoId);
        this.mPreloadFinishedTime.remove(videoId);
        this.mBandwidthRangeMap.remove(videoId);
    }

    public void event(String id, int key, int value, @Nullable String logInfo) {
        block4 : switch (key) {
            case 2000: {
                if (!this.mPlayTaskInfo.containsKey(id)) {
                    ConcurrentHashMap<String, Counter> temMap = new ConcurrentHashMap<String, Counter>();
                    temMap.put(PAUSE, new Counter());
                    temMap.put(RESUME, new Counter());
                    temMap.put(RANGE, new Counter());
                    this.mPlayTaskInfo.put(id, temMap);
                }
                Map<String, Object> onePlayDict = this.mPlayTaskInfo.get(id);
                switch (value) {
                    case 1: {
                        ((Counter)onePlayDict.get(PAUSE)).increase();
                        break block4;
                    }
                    case 2: {
                        ((Counter)onePlayDict.get(RESUME)).increase();
                        break block4;
                    }
                    case 4: {
                        ((Counter)onePlayDict.get(RANGE)).increase();
                        break block4;
                    }
                    case 5: {
                        if (logInfo == null) {
                            Log.e((String)TAG, (String)"PLAY_TASK_RANGE_DURATION: logInfo is null");
                            break block4;
                        }
                        try {
                            onePlayDict.put(RANGE_DURATION, new JSONObject(logInfo));
                        }
                        catch (JSONException e) {
                            onePlayDict.put(RANGE_DURATION, logInfo);
                        }
                        break block4;
                    }
                    case 100: {
                        onePlayDict.put(SEEKLABEL, logInfo);
                        break block4;
                    }
                }
                break;
            }
            case 2001: {
                if (TextUtils.isEmpty((CharSequence)logInfo)) break;
                this.mPreloadInfo.put("name", logInfo);
                break;
            }
            case 2002: {
                if (!this.mBufferDurationMap.containsKey(id)) {
                    this.mBufferDurationMap.put(id, new ConcurrentHashMap());
                }
                this.mBufferDurationMap.get(id).put(LOG_KEY_RE_BUFFER_DURATION_INITIAL, value);
                break;
            }
            case 2003: {
                if (!this.mBufferDurationMap.containsKey(id)) {
                    this.mBufferDurationMap.put(id, new ConcurrentHashMap());
                }
                this.mBufferDurationMap.get(id).put(LOG_KEY_STARTUP_BUFFER_DURATION, value);
                break;
            }
            case 2011: {
                if (!this.mBufferDurationMap.containsKey(id)) break;
                Integer ret = 0;
                if (this.mBufferDurationMap.get(id).containsKey(LOG_KEY_PLAY_BUFFER_DIFF_COUNT)) {
                    ret = this.mBufferDurationMap.get(id).get(LOG_KEY_PLAY_BUFFER_DIFF_COUNT);
                }
                ret = ret + value;
                this.mBufferDurationMap.get(id).put(LOG_KEY_PLAY_BUFFER_DIFF_COUNT, ret);
                break;
            }
            case 2004: {
                if (!this.mPreloadPersonalizedMap.containsKey(id)) {
                    this.mPreloadPersonalizedMap.put(id, new ConcurrentHashMap());
                }
                this.mPreloadPersonalizedMap.get(id).put(LOG_KEY_PRELOAD_PERSONALIZED_OPTION, value);
                break;
            }
            case 2005: {
                if (!this.mPreloadPersonalizedMap.containsKey(id)) {
                    this.mPreloadPersonalizedMap.put(id, new ConcurrentHashMap());
                }
                this.mPreloadPersonalizedMap.get(id).put(LOG_KEY_WATCH_DURATION_LABEL, value);
                break;
            }
            case 2006: {
                if (!this.mPreloadPersonalizedMap.containsKey(id)) {
                    this.mPreloadPersonalizedMap.put(id, new ConcurrentHashMap());
                }
                this.mPreloadPersonalizedMap.get(id).put(LOG_KEY_STALL_LABEL, value);
                break;
            }
            case 2007: {
                if (!this.mPreloadPersonalizedMap.containsKey(id)) {
                    this.mPreloadPersonalizedMap.put(id, new ConcurrentHashMap());
                }
                this.mPreloadPersonalizedMap.get(id).put(LOG_KEY_FIRST_FRAME_LABEL, value);
                break;
            }
            case 2008: {
                if (!this.mAdaptiveRangeMap.containsKey(id)) {
                    this.mAdaptiveRangeMap.put(id, new ConcurrentHashMap());
                }
                this.mAdaptiveRangeMap.get(id).put(LOG_KEY_ADAPTIVE_RANGE_ENABLED, value);
                break;
            }
            case 2009: {
                if (logInfo == null) {
                    Log.e((String)TAG, (String)"EVENT_ADAPTIVE_RANGE_BUFFER: logInfo is null");
                    break;
                }
                if (!this.mAdaptiveRangeMap.containsKey(id)) {
                    this.mAdaptiveRangeMap.put(id, new ConcurrentHashMap());
                }
                try {
                    this.mAdaptiveRangeMap.get(id).put(LOG_KEY_ADAPTIVE_RANGE_BUFFER_LOG, new JSONObject(logInfo));
                }
                catch (JSONException e) {
                    this.mAdaptiveRangeMap.get(id).put(LOG_KEY_ADAPTIVE_RANGE_BUFFER_LOG, logInfo);
                }
                break;
            }
            case 2010: {
                this.mRemainingBufferDuration.put(id, value);
                break;
            }
            case 2012: {
                try {
                    this.mPreloadFinishedTime.put(id, Long.parseUnsignedLong(logInfo));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 2013: {
                if (!this.mBandwidthRangeMap.containsKey(id)) {
                    this.mBandwidthRangeMap.put(id, new ConcurrentHashMap());
                }
                this.mBandwidthRangeMap.get(id).put(LOG_KEY_CURRENT_BANDWIDTH, value);
                try {
                    this.mBandwidthRangeMap.get(id).put(LOG_KEY_BANDWIDTH_BITRATE_RATIO, Float.valueOf(Float.parseFloat(logInfo)));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 2014: {
                this.mCommonEventLog.put(LOG_KEY_MODULE_ACTIVATED, value);
            }
        }
    }

    static class Counter {
        private int mCnt = 0;

        Counter() {
        }

        public synchronized void increase() {
            ++this.mCnt;
        }

        public synchronized void decrease() {
            --this.mCnt;
        }

        public synchronized void reset() {
            this.mCnt = 0;
        }

        public synchronized int getCount() {
            return this.mCnt;
        }
    }
}

