/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.mediakit.medialoader.AVMDLDataLoaderConfigure;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.TTVideoEngineInterface;
import com.ss.ttvideoengine.debug.DebugManager;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.strategy.EngineStrategyListener;
import com.ss.ttvideoengine.strategy.StrategySettings;
import com.ss.ttvideoengine.strategy.common.StrategyCommon;
import com.ss.ttvideoengine.strategy.common.StrategyStatic;
import com.ss.ttvideoengine.strategy.preload.StrategyPreload;
import com.ss.ttvideoengine.strategy.prerender.PreRenderListener;
import com.ss.ttvideoengine.strategy.prerender.StrategyPreRender;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import com.ss.ttvideoengine.strategy.utils.BufferCheckListener;
import com.ss.ttvideoengine.strategy.utils.BufferCheckUtil;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class StrategyManager {
    private static final String TAG = "Strategy Manager";
    public static final int STRATEGY_TYPE_COMMON = 0;
    public static final int STRATEGY_TYPE_PRELOAD = 1;
    public static final int STRATEGY_TYPE_PRE_RENDER = 2;
    public static final int STRATEGY_SCENE_SMALL_VIDEO = 0;
    public static final int STRATEGY_SCENE_SHORT_VIDEO = 1;
    private final StrategyCommon mStrategyCommon = new StrategyCommon();
    private StrategyPreload mStrategyPreload;
    private StrategyPreRender mStrategyPreRender;
    private StrategyStatic mStrategyStatic;
    private WeakReference<TTVideoEngine> mPlayEngine;
    private EngineStrategyListener mListener;
    private ScheduledExecutorService mExecutor;
    private final List<StrategySource> mStrategySources = new ArrayList<StrategySource>();
    private int mPlayIndex = -1;

    public static StrategyManager instance() {
        return Holder.instance;
    }

    private StrategyManager() {
    }

    public void setStrategySources(List<StrategySource> strategySources) {
        this.runOnWorkThread(() -> {
            TTVideoEngineLog.d(TAG, "setStrategySources");
            if (strategySources == null) {
                return;
            }
            this.mStrategySources.clear();
            this.mStrategySources.addAll(strategySources);
            this.updateEngineIndex();
            if (this.mStrategyPreload != null) {
                this.mStrategyPreload.updateSource();
            }
            if (this.mStrategyPreRender != null) {
                this.mStrategyPreRender.updateSource();
            }
        });
    }

    public void addStrategySources(List<StrategySource> strategySources) {
        this.runOnWorkThread(() -> {
            TTVideoEngineLog.d(TAG, "addStrategySources");
            if (strategySources == null) {
                return;
            }
            this.mStrategySources.addAll(strategySources);
            if (this.mStrategyPreload != null) {
                this.mStrategyPreload.updateSource();
            }
            if (this.mStrategyPreRender != null) {
                this.mStrategyPreRender.updateSource();
            }
        });
    }

    public void enable(int type, int scene) {
        this.runOnWorkThread(() -> {
            TTVideoEngineLog.d(TAG, "enable type:" + type + ", scene:" + scene);
            if (this.mStrategyStatic == null) {
                this.mStrategyStatic = new StrategyStatic(scene);
            }
            switch (type) {
                case 1: {
                    if (this.mStrategyPreload != null) break;
                    this.mStrategyPreload = new StrategyPreload(scene, (result, vid) -> {
                        if (result == 2 && this.mStrategyPreRender != null) {
                            this.mStrategyPreRender.onPreloadSuccess(vid);
                        }
                    });
                    this.mStrategyPreload.start();
                    this.startBufferCheck();
                    break;
                }
                case 2: {
                    if (this.mStrategyPreRender != null) break;
                    this.mStrategyPreRender = new StrategyPreRender(scene, new PreRenderListener(){

                        @Override
                        public TTVideoEngine createPreRenderEngine(StrategySource source) {
                            if (StrategyManager.this.mListener == null) {
                                return null;
                            }
                            return StrategyManager.this.mListener.createPreRenderEngine(source);
                        }

                        @Override
                        public void onPreRenderEngineCreated(TTVideoEngine engine, StrategySource source) {
                            if (StrategyManager.this.mListener != null) {
                                StrategyManager.this.mListener.onPreRenderEngineCreated(engine, source);
                            }
                        }
                    });
                    this.mStrategyPreRender.start();
                    this.startBufferCheck();
                    break;
                }
            }
        });
    }

    @Nullable
    public TTVideoEngine getPreRenderEngine(StrategySource source) {
        if (this.mStrategyPreRender == null || source == null) {
            return null;
        }
        return this.mStrategyPreRender.getPreRenderEngine(source.vid());
    }

    @Nullable
    public TTVideoEngine getPreRenderEngine(String videoId) {
        if (this.mStrategyPreRender == null || TextUtils.isEmpty((CharSequence)videoId)) {
            return null;
        }
        return this.mStrategyPreRender.getPreRenderEngine(videoId);
    }

    public void clearAll() {
        this.runOnWorkThread(() -> {
            TTVideoEngineLog.d(TAG, "clearAll");
            if (this.mStrategyPreload != null) {
                this.mStrategyPreload.stop();
                this.mStrategyPreload = null;
            }
            if (this.mStrategyPreRender != null) {
                this.mStrategyPreRender.stop();
                this.mStrategyPreRender = null;
            }
            this.mStrategyStatic = null;
            this.stopBufferCheck();
            this.mStrategySources.clear();
        });
    }

    public void enginePlay(TTVideoEngine engine) {
        DebugManager.enginePlay(engine);
        this.runOnWorkThread(() -> {
            if (this.mStrategyPreload == null && this.mStrategyPreRender == null) {
                return;
            }
            TTVideoEngineLog.d(TAG, "enginePlay " + engine);
            if (this.getPlayEngine() == engine) {
                return;
            }
            this.mPlayEngine = new WeakReference<TTVideoEngine>(engine);
            this.updateEngineIndex();
            if (this.mStrategyPreload != null) {
                this.mStrategyPreload.updateEngine();
            }
            if (this.mStrategyPreRender != null) {
                this.mStrategyPreRender.updateEngine();
            }
            this.startBufferCheck();
        });
    }

    public TTVideoEngine getPlayEngine() {
        if (this.mPlayEngine == null) {
            return null;
        }
        return (TTVideoEngine)this.mPlayEngine.get();
    }

    public int getPlayIndex() {
        return this.mPlayIndex;
    }

    public List<StrategySource> getSource() {
        return this.mStrategySources;
    }

    public void bufferStart(TTVideoEngine engine) {
        this.runOnWorkThread(() -> {
            if (this.mStrategyPreload != null) {
                this.mStrategyPreload.onBufferStart(engine);
            }
        });
    }

    public void onPrepared(TTVideoEngineInterface engine) {
        this.runOnWorkThread(() -> {
            if (this.mStrategyStatic != null) {
                this.mStrategyStatic.onPrepared(engine);
            }
        });
    }

    public void setListener(EngineStrategyListener listener) {
        this.mListener = listener;
    }

    public void engineCreate(TTVideoEngineInterface engine) {
        StrategyStatic strategyStatic;
        StrategyCommon strategyCommon = this.mStrategyCommon;
        if (strategyCommon != null) {
            strategyCommon.engineCreate(engine);
        }
        if ((strategyStatic = this.mStrategyStatic) != null) {
            strategyStatic.engineCreate(engine);
        }
    }

    public void mdlStart(AVMDLDataLoaderConfigure configure) {
        StrategyCommon strategyCommon = this.mStrategyCommon;
        if (strategyCommon != null) {
            strategyCommon.mdlStart(configure);
        }
    }

    public void codecType(TTVideoEngineInterface engine, String codecID) {
        StrategyCommon strategyCommon = this.mStrategyCommon;
        if (strategyCommon != null) {
            strategyCommon.setCodecType(engine, codecID);
        }
    }

    public void setVideoInfo(TTVideoEngineInterface engine, VideoInfo videoInfo) {
        this.mStrategyCommon.setVideoInfo(engine, videoInfo);
    }

    public void updateSettings() {
        StrategySettings.getInstance().update();
        this.runOnWorkThread(() -> {
            this.mStrategyCommon.updateConfig();
            if (this.mStrategyPreload != null) {
                this.mStrategyPreload.updateConfig();
            }
            if (this.mStrategyPreRender != null) {
                this.mStrategyPreRender.updateConfig();
            }
            if (this.mStrategyStatic != null) {
                this.mStrategyStatic.updateConfig();
            }
        });
    }

    public boolean isAllowPreRender(String videoID) {
        if (this.mStrategyPreload == null) {
            return true;
        }
        return this.mStrategyPreload.isPreloaded(videoID);
    }

    public boolean enableEngineLooper() {
        return this.mStrategyCommon.enableEngineLooper();
    }

    private void startBufferCheck() {
        if (this.mStrategyPreload == null && this.mStrategyPreRender == null) {
            return;
        }
        BufferCheckUtil.instance().start(this.getPlayEngine(), new BufferCheckListener(){

            @Override
            public void onCacheEnd(TTVideoEngine playEngine) {
                StrategyManager.this.runOnWorkThread(() -> {
                    if (StrategyManager.this.mStrategyPreload != null) {
                        StrategyManager.this.mStrategyPreload.onCacheEnd(playEngine);
                    }
                    if (StrategyManager.this.mStrategyPreRender != null) {
                        StrategyManager.this.mStrategyPreRender.onCacheEnd(playEngine);
                    }
                });
            }

            @Override
            public void onCacheSize(TTVideoEngine playEngine, long cacheSizeInMS) {
                StrategyManager.this.runOnWorkThread(() -> {
                    if (StrategyManager.this.mStrategyPreload != null) {
                        StrategyManager.this.mStrategyPreload.onCacheSize(playEngine, cacheSizeInMS);
                    }
                    if (StrategyManager.this.mStrategyPreRender != null) {
                        StrategyManager.this.mStrategyPreRender.onCacheSize(playEngine, cacheSizeInMS);
                    }
                });
            }
        });
    }

    private void stopBufferCheck() {
        BufferCheckUtil.instance().stop();
    }

    public synchronized void runOnWorkThread(Runnable task) {
        if (this.mExecutor == null) {
            this.mExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        this.mExecutor.execute(task);
    }

    private void updateEngineIndex() {
        TTVideoEngine playEngine = this.getPlayEngine();
        if (playEngine == null) {
            this.mPlayIndex = -1;
            return;
        }
        String playVideoID = playEngine.getVideoID();
        this.mPlayIndex = -1;
        for (StrategySource strategySource : this.mStrategySources) {
            String vid = strategySource.vid();
            if (!TextUtils.equals((CharSequence)playVideoID, (CharSequence)vid)) continue;
            this.mPlayIndex = this.mStrategySources.indexOf(strategySource);
            return;
        }
    }

    private static class Holder {
        private static final StrategyManager instance = new StrategyManager();

        private Holder() {
        }
    }
}

