/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy;

import com.ss.ttvideoengine.setting.SettingsHelper;
import org.json.JSONObject;

public class StrategySettings {
    public static final String STRATEGY = "strategy_center_v1";
    public static final String COMMON = "recomm_default";
    public static final String SMALL_VIDEO = "scene_small_video";
    public static final String SHORT_VIDEO = "scene_short_video";
    public static final String PRELOAD = "strategy_preload";
    public static final String PRE_RENDER = "strategy_prerender";
    public static final String STATIC = "strategy_static";
    private JSONObject mCommon;
    private JSONObject mSmallVideoPreload;
    private JSONObject mSmallVideoPreRender;
    private JSONObject mSmallStatic;
    private JSONObject mShortVideoPreload;

    public static StrategySettings getInstance() {
        return Holder.instance;
    }

    private StrategySettings() {
        this.update();
    }

    public void update() {
        JSONObject shortVideo;
        this.reset();
        JSONObject strategyCenter = SettingsHelper.helper().getVodJsonObject(STRATEGY);
        if (strategyCenter == null) {
            return;
        }
        this.mCommon = strategyCenter.optJSONObject(COMMON);
        JSONObject smallVideo = strategyCenter.optJSONObject(SMALL_VIDEO);
        if (smallVideo != null) {
            this.mSmallVideoPreload = smallVideo.optJSONObject(PRELOAD);
            this.mSmallVideoPreRender = smallVideo.optJSONObject(PRE_RENDER);
            this.mSmallStatic = smallVideo.optJSONObject(STATIC);
        }
        if ((shortVideo = strategyCenter.optJSONObject(SHORT_VIDEO)) != null) {
            this.mShortVideoPreload = shortVideo.optJSONObject(PRELOAD);
        }
    }

    public JSONObject getPreload(int scene) {
        switch (scene) {
            case 1: {
                return this.mShortVideoPreload;
            }
        }
        return this.mSmallVideoPreload;
    }

    public JSONObject getPreRender(int scene) {
        return this.mSmallVideoPreRender;
    }

    public JSONObject getStatic(int scene) {
        if (scene == 0) {
            return this.mSmallStatic;
        }
        return null;
    }

    public JSONObject getCommon() {
        return this.mCommon;
    }

    private void reset() {
        this.mCommon = null;
        this.mSmallVideoPreload = null;
        this.mSmallVideoPreRender = null;
        this.mSmallStatic = null;
        this.mShortVideoPreload = null;
    }

    private static class Holder {
        private static final StrategySettings instance = new StrategySettings();

        private Holder() {
        }
    }
}

