/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy.common;

import android.text.TextUtils;
import com.ss.mediakit.medialoader.AVMDLDataLoaderConfigure;
import com.ss.ttvideoengine.InfoWrapper;
import com.ss.ttvideoengine.TTVideoEngineInterface;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.strategy.StrategySettings;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import org.json.JSONObject;

public class StrategyCommon {
    private static final String TAG = "Strategy Common";
    private static final String ORIGINAL_QUALITY = "original";
    private static final String SKIP_FIND_STREAM_INFO = "skip_find_stream_info";
    private static final String ENGINE_LOOPER = "engine_looper";
    private static final String CLEAR_MDL_CACHE = "clear_mdl_cache";
    private static final String OUTLET_DROP_LIMIT = "outlet_drop_limit";
    private static final String CPP_h265CODEC_OPT = "cpp_h265codec_opt";
    private static final String DEMUX_NONBLOCK_READ = "demux_nonblock_read";
    private static final String MDL_PRECONNECT = "mdl_preconnect";
    private static final String SOCKET_TRAIN_CENTER = "socket_train_center";
    private static final String LOAD_MONITOR_TIME_INTERNAL = "load_monitor_time_internal";
    private int mSkipFindStreamInfo = -100;
    private int mEngineLooper = -100;
    private int mClearMdlCache = -100;
    private int mOutletDropLimit = -100;
    private int mCpph265codecOpt = -100;
    private int mDemuxNonblockRead = -100;
    private int mMdlPreconnect = -100;
    private String mSocketTrainCenter;
    private int mLoadMonitorTimeInternal = -100;

    public StrategyCommon() {
        this.updateConfig();
    }

    public void start() {
    }

    public void stop() {
    }

    public void updateConfig() {
        JSONObject config = StrategySettings.getInstance().getCommon();
        TTVideoEngineLog.d(TAG, "updateConfig " + config);
        if (config == null) {
            return;
        }
        this.mSkipFindStreamInfo = config.optInt(SKIP_FIND_STREAM_INFO, -100);
        this.mEngineLooper = config.optInt(ENGINE_LOOPER, -100);
        this.mMdlPreconnect = config.optInt(MDL_PRECONNECT, -100);
        this.mClearMdlCache = config.optInt(CLEAR_MDL_CACHE, -100);
        this.mOutletDropLimit = config.optInt(OUTLET_DROP_LIMIT, -100);
        this.mCpph265codecOpt = config.optInt(CPP_h265CODEC_OPT, -100);
        this.mDemuxNonblockRead = config.optInt(DEMUX_NONBLOCK_READ, -100);
        this.mSocketTrainCenter = config.optString(SOCKET_TRAIN_CENTER, "");
        this.mLoadMonitorTimeInternal = config.optInt(LOAD_MONITOR_TIME_INTERNAL, -100);
    }

    public void engineCreate(TTVideoEngineInterface engine) {
        if (engine == null) {
            return;
        }
        if (this.mClearMdlCache != -100) {
            engine.setIntOption(603, this.mClearMdlCache);
        }
        if (this.mOutletDropLimit != -100) {
            engine.setIntOption(673, this.mOutletDropLimit);
        }
        if (this.mCpph265codecOpt != -100) {
            engine.setIntOption(581, this.mCpph265codecOpt);
        }
        if (this.mDemuxNonblockRead != -100) {
            engine.setIntOption(561, this.mDemuxNonblockRead);
        }
    }

    public void mdlStart(AVMDLDataLoaderConfigure configure) {
        TTVideoEngineLog.d(TAG, "set common option mdl prconnect:" + this.mMdlPreconnect + ", loadMonitorTimeInternal:" + this.mLoadMonitorTimeInternal + ", mSocketTrainCenter:" + this.mSocketTrainCenter);
        configure.mEnableExternDNS = 1;
        configure.mEnableSocketReuse = 1;
        if (this.mMdlPreconnect != -100) {
            configure.mEnablePreconnect = this.mMdlPreconnect;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSocketTrainCenter)) {
            configure.mSocketTraingCenterConfigStr = this.mSocketTrainCenter;
        }
        if (this.mLoadMonitorTimeInternal != -100) {
            configure.mMonitorTimeInternal = this.mLoadMonitorTimeInternal;
        }
    }

    public void setCodecType(TTVideoEngineInterface engine, String codec) {
        if (engine != null) {
            TTVideoEngineLog.d(TAG, "set codec:" + codec + ", engine:" + engine);
            if (TextUtils.equals((CharSequence)codec, (CharSequence)"h265")) {
                engine.setIntOption(7, InfoWrapper.geth265HardwareEnable());
                engine.setAsyncInit(true, 1);
            } else if (TextUtils.equals((CharSequence)codec, (CharSequence)"h264")) {
                engine.setIntOption(7, InfoWrapper.getH264HardwareEnable());
                engine.setAsyncInit(true, 0);
            }
        }
    }

    public boolean enableEngineLooper() {
        return this.mEngineLooper > 0;
    }

    public void setVideoInfo(TTVideoEngineInterface engine, VideoInfo videoInfo) {
        if (engine == null || videoInfo == null) {
            return;
        }
        String quality = videoInfo.getValueStr(18);
        if (TextUtils.equals((CharSequence)quality, (CharSequence)ORIGINAL_QUALITY)) {
            return;
        }
        String format = videoInfo.getValueStr(6);
        if (TextUtils.equals((CharSequence)format, (CharSequence)"mp4") || TextUtils.equals((CharSequence)format, (CharSequence)"dash")) {
            engine.setIntOption(204, this.mSkipFindStreamInfo);
        }
    }
}

