/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy.prerender;

import android.content.Context;
import android.support.annotation.Nullable;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.strategy.StrategyManager;
import com.ss.ttvideoengine.strategy.StrategySettings;
import com.ss.ttvideoengine.strategy.prerender.PreRenderListener;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class StrategyPreRender {
    private static final String TAG = "Strategy PreRender";
    private static final String COUNT = "count";
    private static final String START_BUFFER_LIMIT = "start_buffer_limit";
    private static final String STOP_BUFFER_LIMIT = "stop_buffer_limit";
    private int mCount = 1;
    private int mStartBufferLimitInS = 14;
    private int mStopBufferLimitInS = 5;
    private final ConcurrentHashMap<String, TTVideoEngine> mPreRenderEngines;
    private final PreRenderListener mPreRenderListener;
    private final int mScene;
    private boolean mEnable;
    private final List<String> mWaitPreloads = new ArrayList<String>();
    private TTVideoEngine mCacheReadyEngine;

    public StrategyPreRender(int scene, PreRenderListener listener) {
        this.mScene = scene;
        this.mPreRenderListener = listener;
        this.mPreRenderEngines = new ConcurrentHashMap();
        this.updateConfig();
    }

    public void start() {
        TTVideoEngineLog.d(TAG, "start");
        this.mEnable = true;
        this.startPreRender(StrategyManager.instance().getPlayEngine());
    }

    public void stop() {
        TTVideoEngineLog.d(TAG, "stop");
        this.mEnable = false;
        this.clearAllEngine(null);
    }

    public void updateSource() {
        this.clearAllEngine(StrategyManager.instance().getPlayEngine());
        this.startPreRender(StrategyManager.instance().getPlayEngine());
    }

    public void updateConfig() {
        JSONObject preloadConfig = StrategySettings.getInstance().getPreRender(this.mScene);
        TTVideoEngineLog.d(TAG, "updateConfig " + preloadConfig);
        if (preloadConfig == null) {
            return;
        }
        this.mCount = preloadConfig.optInt(COUNT, 1);
        this.mStartBufferLimitInS = preloadConfig.optInt(START_BUFFER_LIMIT, 14);
        this.mStopBufferLimitInS = preloadConfig.optInt(STOP_BUFFER_LIMIT, 5);
    }

    public void updateEngine() {
        this.clearAllEngine(StrategyManager.instance().getPlayEngine());
    }

    public void onCacheEnd(TTVideoEngine engine) {
        if (engine != StrategyManager.instance().getPlayEngine()) {
            return;
        }
        this.startPreRender(engine);
    }

    public void onCacheSize(TTVideoEngine engine, long cacheSizeInMS) {
        if (engine != StrategyManager.instance().getPlayEngine()) {
            return;
        }
        if (cacheSizeInMS > (long)this.mStartBufferLimitInS * 1000L && this.mCacheReadyEngine != engine) {
            this.mCacheReadyEngine = engine;
            this.startPreRender(engine);
        }
    }

    @Nullable
    public TTVideoEngine getPreRenderEngine(String videoID) {
        TTVideoEngine engine = this.mPreRenderEngines.get(videoID);
        TTVideoEngineLog.d(TAG, "getPreRenderEngine " + engine);
        if (engine == null) {
            return null;
        }
        if (engine.isPrepared()) {
            return engine;
        }
        TTVideoEngineLog.d(TAG, "preRender engine is not prepared");
        engine.releaseAsync();
        this.mPreRenderEngines.remove(videoID);
        return null;
    }

    public void onPreloadSuccess(String VideoID) {
        if (this.mWaitPreloads.contains(VideoID)) {
            TTVideoEngineLog.d(TAG, "onPreloadSuccess " + VideoID);
            this.startPreRender(StrategyManager.instance().getPlayEngine());
        }
    }

    private void startPreRender(TTVideoEngine engine) {
        if (!this.mEnable) {
            return;
        }
        if (engine == null || engine != StrategyManager.instance().getPlayEngine()) {
            return;
        }
        Context context = engine.getContext();
        if (context == null) {
            TTVideoEngineLog.d(TAG, "startPreRender context is null");
            return;
        }
        context.getApplicationContext();
        int playIndex = StrategyManager.instance().getPlayIndex();
        TTVideoEngineLog.d(TAG, "startPreRender play index " + playIndex);
        List<StrategySource> needPreRenderList = this.getNeedPreRenderList(playIndex);
        for (StrategySource source : needPreRenderList) {
            String preRenderVid = source.vid();
            if (this.mPreRenderEngines.containsKey(preRenderVid)) {
                TTVideoEngineLog.d(TAG, "startPreRender already exist " + preRenderVid);
                continue;
            }
            if (!StrategyManager.instance().isAllowPreRender(preRenderVid)) {
                TTVideoEngineLog.d(TAG, "startPreRender preload no ready");
                this.mWaitPreloads.add(preRenderVid);
                continue;
            }
            this.mWaitPreloads.remove(preRenderVid);
            TTVideoEngine preRenderEngine = this.mPreRenderListener.createPreRenderEngine(source);
            if (preRenderEngine == null) {
                preRenderEngine = new TTVideoEngine(context, 0);
                preRenderEngine.setStrategySource(source);
                this.mPreRenderListener.onPreRenderEngineCreated(preRenderEngine, source);
            }
            preRenderEngine.setIntOption(100, 0);
            preRenderEngine.setAutoRangeRead(2, 512000);
            preRenderEngine.prepare();
            this.mPreRenderEngines.put(preRenderVid, preRenderEngine);
            TTVideoEngineLog.d(TAG, "startPreRender success engine:" + preRenderEngine + " " + preRenderVid);
        }
    }

    private List<StrategySource> getNeedPreRenderList(int playIndex) {
        List<StrategySource> strategySources = StrategyManager.instance().getSource();
        ArrayList<StrategySource> sources = new ArrayList<StrategySource>();
        if (playIndex < 0 || playIndex >= strategySources.size() - 1) {
            return sources;
        }
        StrategySource strategySource = strategySources.get(playIndex + 1);
        if (strategySource != null) {
            sources.add(strategySource);
        }
        return sources;
    }

    private void clearAllEngine(TTVideoEngine currentEngine) {
        this.mCacheReadyEngine = null;
        this.mWaitPreloads.clear();
        TTVideoEngine needRestoreEngine = null;
        for (TTVideoEngine engine : this.mPreRenderEngines.values()) {
            if (engine == null) continue;
            if (engine == currentEngine) {
                needRestoreEngine = engine;
                continue;
            }
            engine.releaseAsync();
        }
        this.mPreRenderEngines.clear();
        if (needRestoreEngine != null) {
            this.mPreRenderEngines.put(needRestoreEngine.getVideoID(), needRestoreEngine);
        }
    }
}

