/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.superresolution;

import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.superresolution.ISRStatusListener;
import com.ss.ttvideoengine.superresolution.ISRStrategyListener;
import com.ss.ttvideoengine.superresolution.SRStrategyConfig;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SRStrategy {
    private static final String TAG = "TTVideoEngine.SRStrategy";
    public static final int SR_STRATEGY_MODE_AUTO = 0;
    public static final int SR_STRATEGY_MODE_USER = 1;
    public static final int SR_STATUS_NONE = -1;
    public static final int SR_STATUS_CLOSE = 0;
    public static final int SR_STATUS_OPEN_SUCCESS = 1;
    public static final int SR_STATUS_OPEN_FAIL = 2;
    public static final int VIDEO_FORMAT_TYPE_MP4 = 1;
    public static final int VIDEO_FORMAT_TYPE_DASH = 2;
    public static final int SCENE_NONE = 0;
    public static final int SCENE_LIST = 1;
    public static final int SCENE_DETAIL = 2;
    public static final int SCENE_FULLSCREEN = 4;
    public static final int SR_CHECK_TYPE_PRELOAD = 0;
    public static final int SR_CHECK_TYPE_PLAY = 1;
    public static final String KEY_ENABLE_SR_STRATEGY = "ess";
    public static final String KEY_ENABLE_ABR_SR = "eas";
    public static final String KEY_SR_STRATEGY_CONFIG = "sc";
    public static final String KEY_SR_STRATEGY_MODE = "sm";
    public static final String KEY_BITRATE_BEFORE_DOWNGRADE = "bbd";
    public static final String KEY_BITRATE_AFTER_DOWNGRADE = "bad";
    public static final String KEY_SR_STATUS = "ss";
    public static final String KEY_SR_FAIL_REASON = "sfr";
    private SRStrategyConfig mSRConfig = new SRStrategyConfig();
    private ISRStrategyListener mSRStrategyListener = null;
    private int mSRStrategyMode = 1;
    private boolean mSRSatisfied = false;
    private boolean mShouldUseSRTexture = false;
    private int mSRNotUseReason = 0;
    private int mSRStatus = -1;
    private Map<Integer, List<Integer>> mSRBenchmark = new HashMap<Integer, List<Integer>>();

    public SRStrategy() {
        this.resetAll();
        this.mSRBenchmark.put(Resolution.Standard.getIndex(), new ArrayList<Integer>(Arrays.asList(Resolution.High.getIndex())));
        this.mSRBenchmark.put(Resolution.High.getIndex(), new ArrayList<Integer>(Arrays.asList(Resolution.H_High.getIndex())));
        this.mSRBenchmark.put(Resolution.H_High.getIndex(), new ArrayList<Integer>(Arrays.asList(Resolution.SuperHigh.getIndex())));
        this.mSRBenchmark.put(Resolution.SuperHigh.getIndex(), new ArrayList<Integer>(Arrays.asList(Resolution.ExtremelyHigh.getIndex())));
    }

    public void resetStream() {
        this.mSRConfig.resetStream();
        this.mSRSatisfied = false;
        this.mShouldUseSRTexture = false;
        this.mSRNotUseReason = 0;
        this.mSRStatus = -1;
    }

    public void resetAll() {
        this.mSRConfig.resetAll();
        this.mSRConfig.enableSR(false);
        this.mSRConfig.setEnableHdr(false);
        this.mSRConfig.setIsSpeed(false);
        this.mSRStrategyListener = null;
        this.mSRStrategyMode = 1;
        this.mSRSatisfied = false;
        this.mShouldUseSRTexture = false;
        this.mSRNotUseReason = 0;
        this.mSRStatus = -1;
    }

    private void checkSatisfied() {
        Float curFps;
        Boolean isSpeed;
        Boolean enableSpeed;
        Integer curScene;
        Boolean isHdr;
        Integer curFormat;
        Integer curDuration;
        Integer curWidth;
        this.mSRSatisfied = false;
        this.mShouldUseSRTexture = false;
        this.mSRNotUseReason = 0;
        if (2 == this.mSRStatus) {
            return;
        }
        Boolean enableSr = this.mSRConfig.getEnableSR();
        if (enableSr != null && !enableSr.booleanValue()) {
            this.mSRNotUseReason = -7888;
            return;
        }
        Boolean resolutionChanged = this.mSRConfig.getResolutionChanged();
        if (resolutionChanged != null && resolutionChanged.booleanValue()) {
            this.mSRNotUseReason = -7879;
            return;
        }
        if (this.mSRBenchmark.size() <= 0) {
            this.mSRNotUseReason = -7878;
            return;
        }
        Integer screenWidth = this.mSRConfig.getScreenWidth();
        if (screenWidth != null && (curWidth = this.mSRConfig.getCurrentWidth()) != null && curWidth <= screenWidth) {
            this.mSRNotUseReason = -7891;
            return;
        }
        Long minDuration = this.mSRConfig.getMinDuration();
        Long maxDuration = this.mSRConfig.getMaxDuration();
        if (minDuration != null && maxDuration != null && ((curDuration = this.mSRConfig.getCurrentDuration()) == null || (long)curDuration.intValue() < minDuration || (long)curDuration.intValue() > maxDuration)) {
            this.mSRNotUseReason = -7885;
            return;
        }
        Integer format = this.mSRConfig.getVideoFormatType();
        if (format != null && ((curFormat = this.mSRConfig.getCurrentVideoFormatType()) == null || curFormat.compareTo(curFormat & format) != 0)) {
            this.mSRNotUseReason = -7887;
            return;
        }
        Boolean enableHdr = this.mSRConfig.getEnableHdr();
        if (enableHdr != null && ((isHdr = this.mSRConfig.getIsHdr()) == null || !enableHdr.booleanValue() && isHdr.booleanValue())) {
            this.mSRNotUseReason = -7883;
            return;
        }
        Integer supportScene = this.mSRConfig.getSupportScene();
        if (supportScene != null && ((curScene = this.mSRConfig.getCurrentScene()) == null || curScene.compareTo(curScene & supportScene) != 0)) {
            this.mSRNotUseReason = -7884;
            return;
        }
        this.mShouldUseSRTexture = true;
        Integer strategyType = this.mSRConfig.getStrategyType();
        if (strategyType != null && 1 == strategyType && (enableSpeed = this.mSRConfig.getEnableSpeed()) != null && ((isSpeed = this.mSRConfig.getIsSpeed()) == null || !enableSpeed.booleanValue() && isSpeed.booleanValue())) {
            this.mSRNotUseReason = -7882;
            return;
        }
        Float maxFps = this.mSRConfig.getMaxFps();
        if (maxFps != null && ((curFps = this.mSRConfig.getCurrentFps()) == null || curFps.floatValue() > maxFps.floatValue())) {
            this.mSRNotUseReason = -7892;
            return;
        }
        this.mSRSatisfied = true;
    }

    public void updateConfig(SRStrategyConfig cfg) {
        TTVideoEngineLog.i(TAG, "[SRLog]updateConfig cfg=" + cfg);
        if (cfg == null) {
            return;
        }
        this.mSRConfig.updateFrom(cfg);
        String extraConfig = cfg.getExtraConfig();
        if (extraConfig != null && !extraConfig.isEmpty()) {
            extraConfig = extraConfig.toLowerCase();
            HashMap<Integer, List<Integer>> benchmarkMap = new HashMap<Integer, List<Integer>>();
            try {
                JSONObject jRoot = new JSONObject(extraConfig);
                JSONObject jSR = jRoot.getJSONObject("sr");
                JSONObject jSRBenchmark = jSR.getJSONObject("benchmark");
                Iterator iterator = jSRBenchmark.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    int iKey = Integer.parseInt(key);
                    JSONArray jValues = jSRBenchmark.getJSONArray(key);
                    ArrayList<Integer> valList = new ArrayList<Integer>();
                    for (int i = 0; i < jValues.length(); ++i) {
                        int iVal = jValues.getInt(i);
                        valList.add(iVal);
                    }
                    benchmarkMap.put(iKey, valList);
                }
                this.mSRBenchmark = benchmarkMap;
                TTVideoEngineLog.i(TAG, "[SRLog]updateConfig mSRBenchmark=" + this.mSRBenchmark);
            }
            catch (Exception e) {
                TTVideoEngineLog.i(TAG, "[SRLog]updateConfig exception=" + e);
                e.printStackTrace();
            }
        }
        this.checkSatisfied();
    }

    public int getSRStrategyMode() {
        return this.mSRStrategyMode;
    }

    public void setSRStrategyMode(int mode) {
        this.mSRStrategyMode = mode;
    }

    public boolean isSREnabled() {
        Boolean enable = this.mSRConfig.getEnableSR();
        if (enable != null) {
            return enable;
        }
        return false;
    }

    public boolean isSRSatisfied() {
        return this.mSRSatisfied;
    }

    public boolean shouldUseSRTexture() {
        return this.mShouldUseSRTexture;
    }

    public void onSRStatus(int status, int reason) {
        ISRStatusListener listener;
        if (status == this.mSRStatus) {
            return;
        }
        if (0 == status && 2 == this.mSRStatus) {
            return;
        }
        this.mSRStatus = status;
        TTVideoEngineLog.d(TAG, "[SRLog]onSRStatus status=" + status + " reason=" + reason);
        if (2 == this.mSRStatus) {
            this.mSRNotUseReason = reason;
        }
        if ((listener = this.mSRConfig.getListener()) != null) {
            listener.onSRStatus(status);
        }
    }

    public int getSRStatus() {
        return this.mSRStatus;
    }

    public void setSRStrategyListener(ISRStrategyListener listener) {
        this.mSRStrategyListener = listener;
    }

    public int getSRNotUseReason() {
        return this.mSRNotUseReason;
    }

    public Integer getMaxWidth() {
        return this.mSRConfig.getMaxWidth();
    }

    public Integer getMaxHeight() {
        return this.mSRConfig.getMaxHeight();
    }

    public Map<Integer, List<Integer>> getSRBenchmark() {
        return this.mSRBenchmark;
    }

    public Boolean videoInfoSupportSR(VideoInfo info) {
        int width = info.getValueInt(1);
        Integer screenWidth = this.mSRConfig.getScreenWidth();
        if (screenWidth != null && width <= screenWidth) {
            return false;
        }
        return true;
    }

    public String configString() {
        return this.mSRConfig.toString();
    }
}

