/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.superresolution;

import com.ss.ttvideoengine.superresolution.ISRStatusListener;
import com.ss.ttvideoengine.superresolution.ISRStrategyListener;

public class SRStrategyConfig {
    private Boolean mEnableSR;
    private Integer mVideoFormatType;
    private Long mMinDuration;
    private Long mMaxDuration;
    private Integer mMinPower;
    private Integer mSupportScene;
    private Boolean mEnableSpeed;
    private Integer mSRPercent;
    private Integer mMaxWidth;
    private Integer mMaxHeight;
    private Float mMaxFps;
    private Boolean mEnableHdr;
    private Integer mCurrentVideoFormatType;
    private Integer mCurrentDuration;
    private Integer mCurrentPower;
    private Boolean mIsCharging;
    private Integer mCurrentScene;
    private Boolean mIsSpeed;
    private Integer mCurrentWidth;
    private Integer mCurrentHeight;
    private Float mCurrentFps;
    private Boolean mIsHdr;
    private String mExtraConfig;
    ISRStatusListener mStatusListener;
    ISRStrategyListener mStrategyListener;
    private Boolean mResolutionChanged;
    private Integer mStrategyType;
    private Integer mScreenWidth;

    public SRStrategyConfig() {
        this.resetAll();
    }

    public static SRStrategyConfig newConfig() {
        return new SRStrategyConfig();
    }

    public void resetStream() {
        this.mMaxFps = null;
        this.mCurrentVideoFormatType = null;
        this.mCurrentDuration = null;
        this.mCurrentWidth = null;
        this.mCurrentHeight = null;
        this.mCurrentFps = null;
        this.mIsHdr = null;
        this.mResolutionChanged = null;
        this.mIsSpeed = null;
        this.mStrategyType = null;
    }

    public void resetAll() {
        this.mEnableSR = null;
        this.mVideoFormatType = null;
        this.mMinDuration = null;
        this.mMaxDuration = null;
        this.mMinPower = null;
        this.mSupportScene = null;
        this.mEnableSpeed = null;
        this.mSRPercent = null;
        this.mMaxWidth = null;
        this.mMaxHeight = null;
        this.mMaxFps = null;
        this.mEnableHdr = null;
        this.mCurrentVideoFormatType = null;
        this.mCurrentDuration = null;
        this.mCurrentPower = null;
        this.mIsCharging = null;
        this.mCurrentScene = null;
        this.mIsSpeed = null;
        this.mCurrentWidth = null;
        this.mCurrentHeight = null;
        this.mCurrentFps = null;
        this.mIsHdr = null;
        this.mExtraConfig = null;
        this.mStatusListener = null;
        this.mResolutionChanged = null;
        this.mStrategyType = null;
        this.mScreenWidth = null;
        this.mStrategyListener = null;
    }

    public void updateFrom(SRStrategyConfig config) {
        Integer screenWidth;
        Integer strategyType;
        ISRStrategyListener strategyListener;
        ISRStatusListener statusListener;
        Boolean isHdr;
        Float curFps;
        Integer curHeight;
        Integer curWidth;
        Boolean isSpeed;
        Integer curScene;
        Boolean isCharging;
        Integer curPower;
        Integer curDuration;
        Integer curFormat;
        Boolean enableHdr;
        Float maxFps;
        Integer maxHeight;
        Integer maxWidth;
        Integer percent;
        Boolean enableSpeed;
        Integer supportScene;
        Integer minPower;
        Long maxDuration;
        Long minDuration;
        Integer format;
        Boolean enableSr;
        if (config == null) {
            return;
        }
        Boolean resolutionChanged = config.getResolutionChanged();
        if (resolutionChanged != null) {
            this.mResolutionChanged = resolutionChanged;
        }
        if ((enableSr = config.getEnableSR()) != null) {
            this.mEnableSR = enableSr;
        }
        if ((format = config.getVideoFormatType()) != null) {
            this.mVideoFormatType = format;
        }
        if ((minDuration = config.getMinDuration()) != null) {
            this.mMinDuration = minDuration;
        }
        if ((maxDuration = config.getMaxDuration()) != null) {
            this.mMaxDuration = maxDuration;
        }
        if ((minPower = config.getMinPower()) != null) {
            this.mMinPower = minPower;
        }
        if ((supportScene = config.getSupportScene()) != null) {
            this.mSupportScene = supportScene;
        }
        if ((enableSpeed = config.getEnableSpeed()) != null) {
            this.mEnableSpeed = enableSpeed;
        }
        if ((percent = config.getSRPercent()) != null) {
            this.mSRPercent = percent;
        }
        if ((maxWidth = config.getMaxWidth()) != null) {
            this.mMaxWidth = maxWidth;
        }
        if ((maxHeight = config.getMaxHeight()) != null) {
            this.mMaxHeight = maxHeight;
        }
        if ((maxFps = config.getMaxFps()) != null) {
            this.mMaxFps = maxFps;
        }
        if ((enableHdr = config.getEnableHdr()) != null) {
            this.mEnableHdr = enableHdr;
        }
        if ((curFormat = config.getCurrentVideoFormatType()) != null) {
            this.mCurrentVideoFormatType = curFormat;
        }
        if ((curDuration = config.getCurrentDuration()) != null) {
            this.mCurrentDuration = curDuration;
        }
        if ((curPower = config.getCurrentPower()) != null) {
            this.mCurrentPower = curPower;
        }
        if ((isCharging = config.getIsCharging()) != null) {
            this.mIsCharging = isCharging;
        }
        if ((curScene = config.getCurrentScene()) != null) {
            this.mCurrentScene = curScene;
        }
        if ((isSpeed = config.getIsSpeed()) != null) {
            this.mIsSpeed = isSpeed;
        }
        if ((curWidth = config.getCurrentWidth()) != null) {
            this.mCurrentWidth = curWidth;
        }
        if ((curHeight = config.getCurrentHeight()) != null) {
            this.mCurrentHeight = curHeight;
        }
        if ((curFps = config.getCurrentFps()) != null) {
            this.mCurrentFps = curFps;
        }
        if ((isHdr = config.getIsHdr()) != null) {
            this.mIsHdr = isHdr;
        }
        if ((statusListener = config.getListener()) != null) {
            this.mStatusListener = statusListener;
        }
        if ((strategyListener = config.getStrategyListener()) != null) {
            this.mStrategyListener = strategyListener;
        }
        if ((strategyType = config.getStrategyType()) != null) {
            this.mStrategyType = strategyType;
        }
        if ((screenWidth = config.getScreenWidth()) != null) {
            this.mScreenWidth = screenWidth;
        }
    }

    public Boolean getResolutionChanged() {
        return this.mResolutionChanged;
    }

    public SRStrategyConfig resolutionChanged(boolean changed) {
        this.mResolutionChanged = changed;
        return this;
    }

    public Boolean getEnableSR() {
        return this.mEnableSR;
    }

    public SRStrategyConfig enableSR(boolean enable) {
        this.mEnableSR = enable;
        return this;
    }

    public Integer getVideoFormatType() {
        return this.mVideoFormatType;
    }

    public SRStrategyConfig setVideoFormatType(int format) {
        this.mVideoFormatType = format;
        return this;
    }

    public Long getMinDuration() {
        return this.mMinDuration;
    }

    public Long getMaxDuration() {
        return this.mMaxDuration;
    }

    public SRStrategyConfig setDurationRangeSecond(long min, long max) {
        this.mMinDuration = min;
        this.mMaxDuration = max;
        return this;
    }

    public Integer getMinPower() {
        return this.mMinPower;
    }

    public SRStrategyConfig setMinPower(int min) {
        this.mMinPower = min;
        return this;
    }

    public Integer getSupportScene() {
        return this.mSupportScene;
    }

    public SRStrategyConfig setSupportScene(int scene) {
        this.mSupportScene = scene;
        return this;
    }

    public Boolean getEnableSpeed() {
        return this.mEnableSpeed;
    }

    public SRStrategyConfig enableSpeed(boolean enable) {
        this.mEnableSpeed = enable;
        return this;
    }

    public Integer getSRPercent() {
        return this.mSRPercent;
    }

    public SRStrategyConfig setSRPercent(int percent) {
        this.mSRPercent = percent;
        return this;
    }

    public Integer getMaxWidth() {
        return this.mMaxWidth;
    }

    public SRStrategyConfig setMaxWidth(int width) {
        this.mMaxWidth = width;
        return this;
    }

    public Integer getMaxHeight() {
        return this.mMaxHeight;
    }

    public SRStrategyConfig setMaxHeight(int height) {
        this.mMaxHeight = height;
        return this;
    }

    public Boolean getEnableHdr() {
        return this.mEnableHdr;
    }

    public SRStrategyConfig setEnableHdr(boolean enable) {
        this.mEnableHdr = enable;
        return this;
    }

    public Boolean getIsHdr() {
        return this.mIsHdr;
    }

    public SRStrategyConfig setIsHdr(boolean isHdr) {
        this.mIsHdr = isHdr;
        return this;
    }

    public String getExtraConfig() {
        return this.mExtraConfig;
    }

    public SRStrategyConfig setExtraConfig(String extraConfig) {
        this.mExtraConfig = extraConfig;
        return this;
    }

    public Float getMaxFps() {
        return this.mMaxFps;
    }

    public SRStrategyConfig setMaxFps(float max) {
        this.mMaxFps = Float.valueOf(max);
        return this;
    }

    public Integer getCurrentVideoFormatType() {
        return this.mCurrentVideoFormatType;
    }

    public void setCurrentVideoFormatType(int format) {
        this.mCurrentVideoFormatType = format;
    }

    public Integer getCurrentDuration() {
        return this.mCurrentDuration;
    }

    public void setCurrentDuration(int duration) {
        this.mCurrentDuration = duration;
    }

    public Integer getCurrentPower() {
        return this.mCurrentPower;
    }

    public SRStrategyConfig setCurrentPower(int power) {
        this.mCurrentPower = power;
        return this;
    }

    public Boolean getIsCharging() {
        return this.mIsCharging;
    }

    public SRStrategyConfig setIsCharging(boolean charging) {
        this.mIsCharging = charging;
        return this;
    }

    public Integer getCurrentScene() {
        return this.mCurrentScene;
    }

    public SRStrategyConfig setCurrentScene(int scene) {
        this.mCurrentScene = scene;
        return this;
    }

    public Boolean getIsSpeed() {
        return this.mIsSpeed;
    }

    public SRStrategyConfig setIsSpeed(boolean speed) {
        this.mIsSpeed = speed;
        return this;
    }

    public Float getCurrentFps() {
        return this.mCurrentFps;
    }

    public SRStrategyConfig setCurrentFps(float fps) {
        this.mCurrentFps = Float.valueOf(fps);
        return this;
    }

    public ISRStatusListener getListener() {
        return this.mStatusListener;
    }

    public SRStrategyConfig setListener(ISRStatusListener listener) {
        this.mStatusListener = listener;
        return this;
    }

    public ISRStrategyListener getStrategyListener() {
        return this.mStrategyListener;
    }

    public SRStrategyConfig setStrategyListener(ISRStrategyListener listener) {
        this.mStrategyListener = listener;
        return this;
    }

    public Integer getCurrentWidth() {
        return this.mCurrentWidth;
    }

    public SRStrategyConfig setCurrentWidth(int width) {
        this.mCurrentWidth = width;
        return this;
    }

    public Integer getCurrentHeight() {
        return this.mCurrentHeight;
    }

    public SRStrategyConfig setCurrentHeight(int height) {
        this.mCurrentHeight = height;
        return this;
    }

    public Integer getStrategyType() {
        return this.mStrategyType;
    }

    public SRStrategyConfig setStrategyType(int type) {
        this.mStrategyType = type;
        return this;
    }

    public Integer getScreenWidth() {
        return this.mScreenWidth;
    }

    public SRStrategyConfig setScreenWidth(int width) {
        this.mScreenWidth = width;
        return this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[");
        if (this.mEnableSR != null) {
            str.append(" e=").append(this.mEnableSR);
        }
        if (this.mStrategyType != null) {
            str.append(" st=").append(this.mStrategyType);
        }
        if (this.mScreenWidth != null) {
            str.append(" sw=").append(this.mScreenWidth);
        }
        if (this.mCurrentWidth != null) {
            str.append(" cw=").append(this.mCurrentWidth);
        }
        if (this.mVideoFormatType != null) {
            str.append(" ft=").append(this.mVideoFormatType);
        }
        if (this.mCurrentVideoFormatType != null) {
            str.append(" cft=").append(this.mCurrentVideoFormatType);
        }
        if (this.mMinDuration != null && this.mMaxDuration != null) {
            str.append(" d=(").append(this.mMinDuration).append(",").append(this.mMaxDuration).append(")");
        }
        if (this.mCurrentDuration != null) {
            str.append(" cd=").append(this.mCurrentDuration);
        }
        if (this.mSupportScene != null) {
            str.append(" ss=").append(this.mSupportScene);
        }
        if (this.mCurrentScene != null) {
            str.append(" cs=").append(this.mCurrentScene);
        }
        if (this.mEnableSpeed != null) {
            str.append(" es=").append(this.mEnableSpeed);
        }
        if (this.mIsSpeed != null) {
            str.append(" is=").append(this.mIsSpeed);
        }
        if (this.mMaxFps != null) {
            str.append(" mf=").append(this.mMaxFps);
        }
        if (this.mCurrentFps != null) {
            str.append(" cf=").append(this.mCurrentFps);
        }
        if (this.mEnableHdr != null) {
            str.append(" eh=").append(this.mEnableHdr);
        }
        if (this.mIsHdr != null) {
            str.append(" ih=").append(this.mIsHdr);
        }
        str.append("]");
        return str.toString();
    }
}

