/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import com.bytedance.vcloud.cacheModule.CacheModule;
import com.ss.mediakit.medialoader.AVMDLDataLoader;

public class CacheFileManager {
    private static final String TAG = CacheFileManager.class.getSimpleName();

    public static void removeFileCache(String fileKey) {
        TsCacheNodeInfo[] tsNodeList = (TsCacheNodeInfo[])CacheFileManager.getTsCacheInfos(fileKey);
        CacheFileManager._removeHlsCacheWithoutTs(fileKey);
        if (tsNodeList != null) {
            for (TsCacheNodeInfo info : tsNodeList) {
                AVMDLDataLoader.getInstance().removeFileCache(info.fileKey);
            }
        }
    }

    public static long getCacheSize(String fileKey) {
        TsCacheNodeInfo[] tsNodeList;
        long cacheSize = -1L;
        long playlistCacheSize = CacheFileManager.getHlsCacheSizeWithoutTs(fileKey);
        if (playlistCacheSize > 0L) {
            cacheSize = playlistCacheSize;
        }
        if ((tsNodeList = (TsCacheNodeInfo[])CacheFileManager.getTsCacheInfos(fileKey)) != null) {
            for (TsCacheNodeInfo info : tsNodeList) {
                long tsCacheSize = AVMDLDataLoader.getInstance().getCacheSize(info.fileKey);
                if (tsCacheSize <= 0L) continue;
                cacheSize += tsCacheSize;
            }
        }
        return cacheSize;
    }

    public static long getHlsCacheSizeWithoutTs(String fileKey) {
        if (CacheModule.inited) {
            return CacheFileManager._getHlsCacheSizeWithoutTs(fileKey);
        }
        return 0L;
    }

    public static long getAllPlaylistCacheSize() {
        if (CacheModule.inited) {
            return CacheFileManager._getAllHlsCacheSizeWithoutTs();
        }
        return 0L;
    }

    public static void clearAllPlaylistCache() {
        if (CacheModule.inited) {
            CacheFileManager._removeAllHlsCacheWithoutTs();
        }
    }

    private static Object[] getTsCacheInfos(String fileKey) {
        if (CacheModule.inited) {
            return CacheFileManager._getTsCacheInfos(fileKey);
        }
        return null;
    }

    private static native void _removeHlsCacheWithoutTs(String var0);

    private static native long _getHlsCacheSizeWithoutTs(String var0);

    private static native Object[] _getTsCacheInfos(String var0);

    private static native long _getAllHlsCacheSizeWithoutTs();

    private static native void _removeAllHlsCacheWithoutTs();

    static {
        CacheModule.loadLibrary();
    }

    public static class TsCacheNodeInfo {
        public int version = 1;
        public String fileKey = null;
    }

    public static class HlsCacheNodeInfo {
        public int version = 1;
        public String fileKey = null;
    }
}

