/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import com.bytedance.vcloud.cacheModule.CacheModule;
import com.bytedance.vcloud.cacheModule.CalledByNative;
import java.util.HashMap;
import java.util.Map;

public class CacheSettings {
    private final Map<OptionKey, String> mStrOptionMap = new HashMap<OptionKey, String>();
    private IGenerateFileKeyCallback mGenerateFileKeyCallback = null;

    private CacheSettings() {
        CacheModule.loadLibrary();
    }

    public static CacheSettings getInstance() {
        return CacheSettingsHandler.sInstance;
    }

    public void setStringOption(OptionKey key, String value) {
        this.mStrOptionMap.put(key, value);
        if (CacheModule.inited) {
            this._setStringOption(key.value(), value);
        }
    }

    public String getStringOption(OptionKey key) {
        return this.mStrOptionMap.get(key);
    }

    public void setGenerateFileKeyCallback(IGenerateFileKeyCallback cb) {
        this.mGenerateFileKeyCallback = cb;
        if (CacheModule.inited) {
            this._setGenerateFileKeyCb(this.mGenerateFileKeyCallback != null);
        }
    }

    @CalledByNative
    public static String generateFileKeyCB(String url, String hlsFileKey, Object extraInfo) {
        CacheSettings cacheSettings = CacheSettings.getInstance();
        if (cacheSettings.mGenerateFileKeyCallback == null) {
            return null;
        }
        return cacheSettings.mGenerateFileKeyCallback.generateFileKey(url, hlsFileKey, (Map)extraInfo);
    }

    private native void _setStringOption(int var1, String var2);

    private native void _setGenerateFileKeyCb(boolean var1);

    public static interface IGenerateFileKeyCallback {
        public String generateFileKey(String var1, String var2, Map<String, String> var3);
    }

    private static class CacheSettingsHandler {
        public static CacheSettings sInstance = new CacheSettings();

        private CacheSettingsHandler() {
        }
    }

    public static class OptionKey {
        public static final OptionKey CACHE_DIR = new OptionKey(0);
        private int mName = -1;

        private OptionKey(int name) {
            this.mName = name;
        }

        public int value() {
            return this.mName;
        }
    }
}

