/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.bytedance.vcloud.cacheModule.CacheFileManager;
import com.bytedance.vcloud.cacheModule.CacheModule;
import com.bytedance.vcloud.cacheModule.CacheSettings;
import com.bytedance.vcloud.cacheModule.PlaylistLoaderItem;
import com.bytedance.vcloud.cacheModule.utils.CmLog;
import com.bytedance.vcloud.cacheModule.utils.UriUtils;
import com.ss.mediakit.medialoader.AVMDLDataLoader;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlaylistLoader {
    private static final String TAG;
    private String mUrl = null;
    private String mUrlFileKey = null;
    private int mSize = 0;
    private int mTotalCacheSize = 0;
    private String mCacheDir = null;
    private LoadStatus mLoadStatus = LoadStatus.Unknown;
    private static final int WHAT_PRELOAD_CMD_START = 10000;
    private static final int WHAT_PRELOAD_CMD_NEXT = 10001;
    private static final int WHAT_PRELOAD_STATUS_START = 11000;
    private static final int WHAT_PRELOAD_STATUS_CANCEL = 11001;
    private static final int WHAT_PRELOAD_STATUS_COMPLETED = 11002;
    private static final int WHAT_PRELOAD_STATUS_ERROR = 11003;
    private static final int ErrorCodeIsCreateTask = -1000;
    private static final int ErrorCodeIsTheSameKeyTask = -1001;
    private static final int ErrorCodeIsTooManyTask = -1002;
    private static final int ErrorCodeIsAllURLInvalid = -1003;
    private static final int ErrorCodeIsInvalidContentLenth = -2000;
    private static final int ErrorCodeIsStatusCodeMoreThan400 = -3000;
    private static final int ErrorCodeIsStatusCodeMoreThan500 = -3001;
    private static final int ErrorCodeIsInvalidRequestInfo = -4000;
    private static final int ErrorCodeIsInvalidFileWrite = -5000;
    private static final int HTTP_ERROR_HTTP_BAD_REQUEST;
    private static final int HTTP_ERROR_HTTP_UNAUTHORIZED;
    private static final int HTTP_ERROR_HTTP_FORBIDDEN;
    private static final int HTTP_ERROR_HTTP_NOT_FOUND;
    private static final int HTTP_ERROR_HTTP_TIMEOUT;
    private static final int HTTP_ERROR_HTTP_OTHER_4XX;
    private static final int HTTP_ERROR_HTTP_SERVER_ERROR;
    private static final int FILE_ERROR;
    private HandlerThread mPreloadThread = null;
    private Handler mPreloadHandler = null;
    private Handler mListenerHandler = null;
    private volatile boolean mCanceled = false;
    private PlaylistLoaderItem mCurrentItem = null;
    private final List<String> mSubProxyUrls = new ArrayList<String>();
    private String mCurrentLoadRawKey = null;
    private String mCurrentFileKey = null;
    private long mCurrentPreLoadSize = 0L;
    private ILoaderListener mListener = null;

    public PlaylistLoader(String url, int size) {
        this.getCacheDir();
        this.mUrl = url;
        this.mSize = size;
        Map<String, String> params = UriUtils.parseURLParam(this.mUrl);
        if (params.containsKey("k")) {
            this.mUrlFileKey = params.get("k");
        }
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
        this.mListenerHandler = new Handler(Looper.myLooper()){

            public void handleMessage(Message msg) {
                CmLog.d(TAG, "msg.what = " + msg.what);
                if (PlaylistLoader.this.mListener != null) {
                    int what = msg.what;
                    switch (what) {
                        case 11000: {
                            PlaylistLoader.this.mLoadStatus = LoadStatus.Start;
                            PlaylistLoader.this.mListener.onStart(PlaylistLoader.this.mUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                            break;
                        }
                        case 11001: {
                            PlaylistLoader.this.mLoadStatus = LoadStatus.Cancel;
                            PlaylistLoader.this.mListener.onCancel(PlaylistLoader.this.mUrlFileKey, PlaylistLoader.this.mUrl);
                            break;
                        }
                        case 11002: {
                            PlaylistLoader.this.mLoadStatus = LoadStatus.Completed;
                            AVMDLDataLoaderNotifyInfo completedInfo = new AVMDLDataLoaderNotifyInfo();
                            completedInfo.what = 4;
                            completedInfo.parameter = 2L;
                            completedInfo.logInfo = String.format("%d,%d,%s,%s", CacheFileManager.getCacheSize(PlaylistLoader.this.mUrlFileKey), -1, PlaylistLoader.this.mUrlFileKey, PlaylistLoader.this.getCacheDir() + "/" + PlaylistLoader.this.mUrlFileKey + ".plc");
                            PlaylistLoader.this.mListener.onCompleted(PlaylistLoader.this.mUrl, completedInfo);
                            break;
                        }
                        case 11003: {
                            PlaylistLoader.this.mLoadStatus = LoadStatus.Error;
                            AVMDLDataLoaderNotifyInfo completedInfo = null;
                            if (msg.obj == null) {
                                completedInfo = new AVMDLDataLoaderNotifyInfo();
                                completedInfo.what = 8;
                                completedInfo.code = msg.arg1;
                            } else {
                                completedInfo = (AVMDLDataLoaderNotifyInfo)msg.obj;
                            }
                            completedInfo.parameter = 2L;
                            completedInfo.logInfo = TextUtils.isEmpty((CharSequence)PlaylistLoader.this.mUrlFileKey) ? PlaylistLoader.this.mUrl : PlaylistLoader.this.mUrlFileKey;
                            PlaylistLoader.this.mListener.onError(PlaylistLoader.this.mUrl, completedInfo);
                        }
                    }
                }
                super.handleMessage(msg);
            }
        };
    }

    private String getCacheDir() {
        if (TextUtils.isEmpty((CharSequence)this.mCacheDir)) {
            this.mCacheDir = CacheSettings.getInstance().getStringOption(CacheSettings.OptionKey.CACHE_DIR);
        }
        return this.mCacheDir;
    }

    private static int mkTag(int a, int b, int c, int d) {
        return -(a | b << 8 | c << 16 | d << 24);
    }

    public int preload() {
        if (this.mPreloadThread != null) {
            return 0;
        }
        if (this.mCanceled) {
            return 0;
        }
        this.mPreloadThread = new HandlerThread("playlistPreloader");
        this.mPreloadThread.start();
        this.mPreloadHandler = new Handler(this.mPreloadThread.getLooper()){

            public void handleMessage(Message msg) {
                if (msg.what == 10000) {
                    String url = (String)msg.obj;
                    int preloadSize = msg.arg1;
                    PlaylistLoader.this.preloadInner(url, preloadSize);
                } else if (msg.what == 10001) {
                    int preloadSize = msg.arg1;
                    PlaylistLoader.this.preLoadNextUrl(preloadSize);
                }
                super.handleMessage(msg);
            }
        };
        Message msg = this.mPreloadHandler.obtainMessage(10000);
        msg.arg1 = this.mSize;
        msg.obj = this.mUrl;
        this.mPreloadHandler.sendMessage(msg);
        return 0;
    }

    private void preloadInner(String url, int preloadSize) {
        CmLog.d(TAG, " preloadInner : " + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            CmLog.e(TAG, " main url is empty. ");
            Message message = this.mListenerHandler.obtainMessage(11003);
            message.arg1 = -4000;
            this.mListenerHandler.sendMessage(message);
            return;
        }
        if (preloadSize < 0) {
            preloadSize = 0;
        }
        if (this.mCurrentItem != null) {
            this.mCurrentItem.release();
        }
        this.mCurrentItem = new PlaylistLoaderItem(url);
        int preloadRet = this.mCurrentItem.preload();
        CmLog.d(TAG, " preloadRet : " + preloadRet);
        if (preloadRet < 0) {
            CmLog.e(TAG, "open main url fail : " + preloadRet);
            if (!this.mCanceled) {
                Message message = this.mListenerHandler.obtainMessage(11003);
                message.arg1 = PlaylistLoader.getErrorCode(preloadRet);
                this.mListenerHandler.sendMessage(message);
            }
            return;
        }
        PlaylistLoaderItem.PlayListType type = this.mCurrentItem.getType();
        if (type == PlaylistLoaderItem.PlayListType.MasterPlaylist) {
            CmLog.i(TAG, " main url is MasterPlaylist ");
            return;
        }
        CacheFileManager.HlsCacheNodeInfo hlsCacheNodeInfo = new CacheFileManager.HlsCacheNodeInfo();
        hlsCacheNodeInfo.version = 1;
        hlsCacheNodeInfo.fileKey = this.mUrlFileKey;
        this.mCurrentItem.writeHlsNodeInfo(hlsCacheNodeInfo);
        List<String> allSubProxyUrls = this.mCurrentItem.getSubUrls();
        this.mSubProxyUrls.clear();
        if (allSubProxyUrls != null && !allSubProxyUrls.isEmpty()) {
            this.mSubProxyUrls.addAll(allSubProxyUrls);
        }
        CmLog.d(TAG, " preload suburls : " + this.mSubProxyUrls.size());
        int preloadedSize = (int)CacheFileManager.getHlsCacheSizeWithoutTs(this.mUrlFileKey);
        this.preLoadNextUrl(preloadSize - preloadedSize);
    }

    private static int getErrorCode(int preloadRet) {
        if (preloadRet == HTTP_ERROR_HTTP_BAD_REQUEST || preloadRet == HTTP_ERROR_HTTP_UNAUTHORIZED || preloadRet == HTTP_ERROR_HTTP_FORBIDDEN || preloadRet == HTTP_ERROR_HTTP_NOT_FOUND || preloadRet == HTTP_ERROR_HTTP_TIMEOUT || preloadRet == HTTP_ERROR_HTTP_OTHER_4XX) {
            return -3000;
        }
        if (preloadRet == HTTP_ERROR_HTTP_SERVER_ERROR) {
            return -3001;
        }
        if (preloadRet == FILE_ERROR) {
            return -5000;
        }
        return preloadRet;
    }

    private void preLoadNextUrl(int preloadSize) {
        CmLog.d(TAG, " preLoadNextUrl preloadSize = " + preloadSize);
        if (this.mSubProxyUrls.isEmpty()) {
            this.mCurrentLoadRawKey = null;
            this.mCurrentFileKey = null;
            Message msg = this.mListenerHandler.obtainMessage(11002);
            this.mListenerHandler.sendMessage(msg);
            CmLog.i(TAG, "no more url, preLoadNextUrl completed..");
            return;
        }
        String proxyUrl = this.mSubProxyUrls.get(0);
        this.mSubProxyUrls.remove(0);
        if (TextUtils.isEmpty((CharSequence)proxyUrl)) {
            Message message = this.mListenerHandler.obtainMessage(11003);
            message.arg1 = -4000;
            this.mListenerHandler.sendMessage(message);
            return;
        }
        if (this.mCanceled) {
            return;
        }
        Map<String, String> params = UriUtils.parseURLParam(proxyUrl);
        if (params.containsKey("rk")) {
            this.mCurrentLoadRawKey = params.get("rk");
        }
        if (params.containsKey("k")) {
            this.mCurrentFileKey = params.get("k");
        }
        this.mCurrentPreLoadSize = preloadSize;
        CacheFileManager.TsCacheNodeInfo tsCacheNodeInfo = new CacheFileManager.TsCacheNodeInfo();
        tsCacheNodeInfo.version = 1;
        tsCacheNodeInfo.fileKey = this.mCurrentFileKey;
        this.mCurrentItem.writeTsNodeInfo(tsCacheNodeInfo);
        CmLog.i(TAG, "proxyUrl = " + proxyUrl + ", RawKey=" + this.mCurrentLoadRawKey + ", filekey = " + this.mCurrentFileKey);
        AVMDLDataLoader.getInstance().preloadResource(proxyUrl, preloadSize);
    }

    public KeyType getKeyType(String fileKey) {
        if (this.mUrlFileKey != null && this.mUrlFileKey.equals(fileKey)) {
            return KeyType.HlsFileKey;
        }
        if (this.mCurrentFileKey != null && this.mCurrentFileKey.equals(fileKey)) {
            return KeyType.TsFileKey;
        }
        return KeyType.Unknown;
    }

    public boolean processHlsPreloadStatus(LoadStatus status, AVMDLDataLoaderNotifyInfo info) {
        if (status == this.mLoadStatus) {
            return true;
        }
        return status != LoadStatus.Error;
    }

    public boolean processTsPreloadStatus(String fileKey, LoadStatus status, AVMDLDataLoaderNotifyInfo info) {
        CmLog.i(TAG, "processSubPreloadStatus = " + fileKey + ", mCurrentFileKey = " + this.mCurrentFileKey + ", mUrlFileKey = " + this.mUrlFileKey + ", status = " + status.name());
        if (status == LoadStatus.Completed) {
            if (this.mCanceled) {
                return false;
            }
            long cacheSize = AVMDLDataLoader.getInstance().getCacheSize(this.mCurrentLoadRawKey);
            this.mTotalCacheSize = (int)((long)this.mTotalCacheSize + cacheSize);
            int preloadSize = (int)(this.mCurrentPreLoadSize - cacheSize);
            CmLog.i(TAG, "sub preload completd size = " + cacheSize + " , key = " + this.mCurrentFileKey + ", cacheSize = " + cacheSize + " , mTotalCacheSize = " + this.mTotalCacheSize + " , left preloadSize = " + preloadSize);
            this.mCurrentLoadRawKey = null;
            this.mCurrentFileKey = null;
            if (preloadSize > 0) {
                CmLog.d(TAG, "preloadNext...");
                Message msg = this.mPreloadHandler.obtainMessage(10001);
                msg.arg1 = preloadSize;
                this.mPreloadHandler.sendMessage(msg);
            } else {
                CmLog.d(TAG, "all preloadSize used, completed...");
                Message msg = this.mListenerHandler.obtainMessage(11002);
                this.mListenerHandler.sendMessage(msg);
            }
        } else if (status == LoadStatus.Cancel) {
            CmLog.d(TAG, "canceled... " + this.mCurrentFileKey);
        } else if (status == LoadStatus.Error) {
            CmLog.d(TAG, "Error ...");
            Message message = this.mListenerHandler.obtainMessage(11003);
            message.obj = info;
            this.mListenerHandler.sendMessage(message);
        }
        return false;
    }

    public void cancel() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        if (this.mCurrentItem != null) {
            this.mCurrentItem.cancel();
        }
        CmLog.d(TAG, "cancel ts.. mCurrentFileKey:" + this.mCurrentFileKey + ", mCurrentLoadRawKey:" + this.mCurrentLoadRawKey);
        if (this.mCurrentLoadRawKey != null) {
            AVMDLDataLoader.getInstance().cancel(this.mCurrentLoadRawKey);
        }
        Message message = this.mListenerHandler.obtainMessage(11001);
        this.mListenerHandler.sendMessage(message);
    }

    public void release() {
        if (this.mCurrentItem != null) {
            this.mCurrentItem.release();
        }
        this.mPreloadThread.quit();
    }

    public void setLoaderListener(ILoaderListener listener) {
        this.mListener = listener;
    }

    static {
        CacheModule.loadLibrary();
        TAG = PlaylistLoader.class.getSimpleName();
        HTTP_ERROR_HTTP_BAD_REQUEST = PlaylistLoader.mkTag(248, 52, 48, 48);
        HTTP_ERROR_HTTP_UNAUTHORIZED = PlaylistLoader.mkTag(248, 52, 48, 49);
        HTTP_ERROR_HTTP_FORBIDDEN = PlaylistLoader.mkTag(248, 52, 48, 51);
        HTTP_ERROR_HTTP_NOT_FOUND = PlaylistLoader.mkTag(248, 52, 48, 52);
        HTTP_ERROR_HTTP_TIMEOUT = PlaylistLoader.mkTag(248, 52, 48, 56);
        HTTP_ERROR_HTTP_OTHER_4XX = PlaylistLoader.mkTag(248, 52, 88, 88);
        HTTP_ERROR_HTTP_SERVER_ERROR = PlaylistLoader.mkTag(248, 53, 88, 88);
        FILE_ERROR = PlaylistLoader.mkTag(73, 78, 70, 87);
    }

    public static interface ILoaderListener {
        public void onStart(String var1, AVMDLDataLoaderNotifyInfo var2);

        public void onCancel(String var1, String var2);

        public void onCompleted(String var1, AVMDLDataLoaderNotifyInfo var2);

        public void onError(String var1, AVMDLDataLoaderNotifyInfo var2);
    }

    public static enum KeyType {
        Unknown,
        HlsFileKey,
        TsFileKey;

    }

    public static enum LoadStatus {
        Unknown,
        Start,
        Cancel,
        Completed,
        Error;

    }
}

