/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.strategy;

import android.content.Context;
import android.util.Log;
import com.bytedance.vcloud.strategy.IAppService;
import com.bytedance.vcloud.strategy.ILogCallback;
import com.bytedance.vcloud.strategy.IPreloadTaskCallbackListener;
import com.bytedance.vcloud.strategy.ISelectBitrateListener;
import com.bytedance.vcloud.strategy.IStrategyEventListener;
import com.bytedance.vcloud.strategy.IStrategyStateSupplier;
import com.bytedance.vcloud.strategy.StrategyCenterJniLoader;

public class StrategyCenter {
    private static final String TAG = "VCStrategy";
    public static final int LOG_LEVEL = 10000;
    public static final int PLAY_INTERACTION_BLOCK_DURATION_PRELOADED = 801;
    public static final int PLAY_INTERACTION_BLOCK_DURATION_NON_PRELOADED = 802;
    public static final int APP_STATE = 1001;
    public static final int BANDWIDTH_QUEUE_SIZE = 1002;
    public static final int PORTRAIT_CHANGED = 1003;
    public static final int NET_STATE_CHANGED = 1202;
    public static final int ALGO_CONFIG_STRING_COMMON = 31001;
    public static final int ALGO_CONFIG_STRING_SMART_PRELOAD = 31002;
    public static final int ALGO_CONFIG_STRING_PRELOAD_TIMELINESS = 31003;
    public static final int ALGO_CONFIG_STRING_PLAY_LOAD = 31004;
    public static final int ALGO_CONFIG_STRING_PLAY_RANGE = 31005;
    public static final int ALGO_CONFIG_STRING_SELECT_BITRATE = 31006;
    public static final int ALGO_CONFIG_STRING_BANDWIDTH = 31007;
    public static final int ALGO_CONFIG_STRING_MODULE_CONFIG = 31008;
    public static final int ALGO_CONFIG_STRING_SMART_RANGE_REQUEST = 31009;
    public static final int ALGO_CONFIG_STRING_PRELOAD = 31010;
    public static final int ALGO_CONFIG_STRING_DYNAMIC = 31011;
    public static final int ALGO_CONFIG_STRING_OPTION = 31012;
    public static final int PRELOAD_SMART_RET_LABEL = 31201;
    public static final int PRELOAD_TIMELINESS_RET_LABEL = 31202;
    public static final int PRELOAD_SMART_CONFIG_JSON_UPDATE = 31203;
    public static final int SMART_RANGE_REQUEST_LABEL = 31204;
    public static final int APP_PRELOAD_CANCEL_ALL_EVENT = 31205;
    public static final int CONFIG_PEAK_SETTING = 31206;
    public static final int APP_UPDATE_TRACE_HOST = 31207;
    public static final int APP_CONFIG_CACHE_DIR = 31209;
    public static final int GLOBAL_OPTION_START = 50000;
    public static final int OPTION_STOP_BACKGROUND = 50001;
    public static final int OPTION_STOP_TASK_END_PLAY = 50002;
    public static final int OPTION_CACHE_TIMESTAMP = 50003;
    public static final int OPTION_CHECK_EXITED_LC = 50004;
    public static final int OPTION_CHECK_ORIGIN_LC = 50005;
    public static final int OPTION_SELECT_BITRATE_MODE = 50006;
    public static final int OPTION_ALL_PRELOAD_FINISH_MESSAGE = 50007;
    public static final int OPTION_ENABLE_IO_DECISION = 50008;
    public static final int OPTION_AUTO_RESUME_TASK_WHEN_PLAY = 50009;
    public static final int OPTION_PAUSE_IO_WHEN_REQ_END = 50010;
    public static final int GLOBAL_OPTION_END = 60000;
    public static final int MODULE_SWITCH_BANDWIDTH = 803;
    public static final int MODULE_SWITCH_PRELOAD = 805;
    public static final int MODULE_SWITCH_SELECT_BITRATE = 804;
    public static final int MODULE_SWITCH_PLAY_LOAD = 806;
    public static final int MODULE_SWITCH_ABR = 807;
    public static final int GET_NETWORK_SPEED = 20401;
    public static final int GET_PRELOAD_STRATEGY_LOG_INFO = 31301;
    public static final int SELECT_BITRATE_TYPE_PLAY = 1;
    public static final int SELECT_BITRATE_TYPE_PRELOAD = 2;
    public static final int EVENT_PLAY_TASK_OPERATE = 2000;
    public static final int EVENT_PRELOAD_SWITCH = 2001;
    public static final int EVENT_RE_BUFFER_DURATION_INITIAL = 2002;
    public static final int EVENT_STARTUP_DURATION = 2003;
    public static final int EVENT_PRELOAD_PERSONALIZED_OPTION = 2004;
    public static final int EVENT_WATCH_DURATION_LABEL = 2005;
    public static final int EVENT_STALL_LABEL = 2006;
    public static final int EVENT_FIRST_FRAME_LABEL = 2007;
    public static final int EVENT_ADAPTIVE_RANGE_ENABLED = 2008;
    public static final int EVENT_ADAPTIVE_RANGE_BUFFER = 2009;
    public static final int EVENT_REMAINING_BUFFER_DURATION_AT_STOP = 2010;
    public static final int EVENT_PLAY_BUFFER_DIFF_RESULT = 2011;
    public static final int EVENT_PLAY_RELATED_PRELOAD_FINISHED = 2012;
    public static final int EVENT_PLAYER_RANGE_DETERMINED = 2013;
    public static final int EVENT_MODULE_ACTIVATED = 2014;
    public static final int EVENT_PRELOAD_DECISION_INFO = 2015;
    public static final int EVENT_LOAD_CONTROL_VERSION = 2016;
    public static final int EVENT_LOAD_CONTROL_SLIDING_WINDOW = 2017;
    public static final int EVENT_SCENE_SWITCH = 2018;
    public static final int PLAY_TASK_PAUSE = 1;
    public static final int PLAY_TASK_RESUME = 2;
    public static final int PLAY_TASK_STOP = 3;
    public static final int PLAY_TASK_RANGE = 4;
    public static final int PLAY_TASK_RANGE_DURATION = 5;
    public static final int PLAY_TASK_SEEK_LABEL = 100;
    public static final int PLAY_TASK_FIRST_BLOCK_DECISION_TIME = 101;
    public static final int PLAY_TASK_FIRST_BLOCK_EXEC_TIME = 102;
    public static final int PLAY_TASK_EST_PLAYTIME = 103;
    public static final int PLAY_TASK_SMART_LEVEL = 104;
    public static final int NetStateUnknown = -1;
    public static final int NetStateUnReachable = 0;
    public static final int NetStateWWAN = 10;
    public static final int NetStateWifi = 20;
    public static final int LOG_VERBOSE = 0;
    public static final int LOG_DEBUG = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_WARN = 3;
    public static final int LOG_ERROR = 4;
    public static final int LOG_FATAL = 5;
    public static final int APP_STATE_FOREGROUND = 1;
    public static final int APP_STATE_BACKGROUND = 2;
    private long mHandle = 0L;
    private boolean mDidStart = false;
    private int mLogLevel = 3;
    private IStrategyEventListener mListener = null;

    public StrategyCenter(IStrategyEventListener listener) {
        this.mListener = listener;
    }

    public boolean isLoadLibrarySucceed() {
        return this.mHandle != 0L;
    }

    public void create(Context context, boolean needLoadLibrary) {
        if (!this.isLoadLibrarySucceed()) {
            if (needLoadLibrary) {
                StrategyCenterJniLoader.loadLibrary(context);
                if (!StrategyCenterJniLoader.isLibraryLoaded) {
                    Log.i((String)TAG, (String)"load library fail.");
                    return;
                }
            }
            this.mHandle = this._create(this.mListener);
        }
    }

    public void start(Context context, boolean needLoadLibrary) {
        if (this.mDidStart) {
            return;
        }
        this.create(context, needLoadLibrary);
        if (this.mHandle == 0L) {
            return;
        }
        this.setIntValue(10000, this.mLogLevel);
        this._start(this.mHandle);
        this.mDidStart = true;
    }

    public boolean isRunning() {
        return this.mDidStart;
    }

    public void stop() {
        if (!this.mDidStart) {
            return;
        }
        if (this.mHandle == 0L) {
            return;
        }
        this._stop(this.mHandle);
        this.mDidStart = false;
    }

    public void setEventListener(IStrategyEventListener listener) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setEventListener(this.mHandle, listener);
    }

    public void setIntValue(int key, int value) {
        if (key == 10000) {
            this.mLogLevel = value;
        }
        if (this.mHandle == 0L) {
            return;
        }
        this._setIntValue(this.mHandle, key, value);
    }

    public int getIntValue(int key, int dVal) {
        if (this.mHandle == 0L) {
            return dVal;
        }
        try {
            return this._getIntValue(this.mHandle, key, dVal);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
            return dVal;
        }
    }

    public float getFloatValue(int key, float dVal) {
        if (this.mHandle == 0L) {
            return dVal;
        }
        try {
            return this._getFloatValue(this.mHandle, key, dVal);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
            return dVal;
        }
    }

    public void setLongValue(int key, long value) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._setLongValue(this.mHandle, key, value);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public long getLongValue(int key, long dVal) {
        if (this.mHandle == 0L) {
            return dVal;
        }
        try {
            return this._getLongValue(this.mHandle, key, dVal);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
            return dVal;
        }
    }

    public long getLongValue(int key, String strKey, long dVal) {
        if (this.mHandle == 0L) {
            return dVal;
        }
        try {
            return this._getLongValue(this.mHandle, key, strKey, dVal);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
            return dVal;
        }
    }

    public void setStringValue(int key, String val) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._setStrValue(this.mHandle, key, val);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public String getStringValue(int key, String dVal) {
        if (this.mHandle == 0L) {
            return dVal;
        }
        try {
            return this._getStrValue(this.mHandle, key, dVal);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
            return dVal;
        }
    }

    public void setFloatValue(int key, float value) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setFloatValue(this.mHandle, key, value);
    }

    public void setStateSupplier(IStrategyStateSupplier listener) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setStateSupplier(this.mHandle, listener);
    }

    public void addMedia(String mediaInfo, ISelectBitrateListener listener, String sceneId, boolean isLast) {
        if (this.mHandle == 0L) {
            return;
        }
        this._addMedia(this.mHandle, mediaInfo, listener, sceneId, isLast);
    }

    public void addMedia(String mediaInfo, ISelectBitrateListener listener, String sceneId, boolean isLast, boolean needRemove) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._addInterimMedia(this.mHandle, mediaInfo, listener, sceneId, isLast, needRemove);
        }
        catch (Throwable e) {
            Log.i((String)TAG, (String)e.toString());
        }
    }

    public void addPriorityTask(String mediaInfo, ISelectBitrateListener listener, IPreloadTaskCallbackListener callBackListener) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._addPriorityTask(this.mHandle, mediaInfo, listener, callBackListener);
        }
        catch (Throwable e) {
            Log.i((String)TAG, (String)e.toString());
        }
    }

    public void removePriorityTask(String key) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._removePriorityTask(this.mHandle, key);
        }
        catch (Throwable e) {
            Log.i((String)TAG, (String)e.toString());
        }
    }

    public void removeMedia(String mediaId, String sceneId) {
        if (this.mHandle == 0L) {
            return;
        }
        this._removeMedia(this.mHandle, mediaId, sceneId);
    }

    public void removeAllMedia(String sceneId, int stopTask) {
        if (this.mHandle == 0L) {
            return;
        }
        this._removeAllMedia(this.mHandle, sceneId, stopTask);
    }

    public void focusMedia(String mediaId, int forceType) {
        if (this.mHandle == 0L) {
            return;
        }
        this._focusMedia(this.mHandle, mediaId, forceType);
    }

    public void updateMedia(String mediaId, String sceneId, String mediaInfo) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._updateMedia(this.mHandle, mediaId, sceneId, mediaInfo);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public void createScene(String configJson) {
        if (this.mHandle == 0L || configJson == null) {
            return;
        }
        this._createScene(this.mHandle, configJson);
    }

    public void destroyScene(String sceneId) {
        if (this.mHandle == 0L) {
            return;
        }
        this._destroyScene(this.mHandle, sceneId);
    }

    public void switchToScene(String sceneId) {
        if (this.mHandle == 0L) {
            return;
        }
        this._moveToScene(this.mHandle, sceneId);
    }

    public void createPlayer(long player, String mediaId, String traceId) {
        if (this.mHandle == 0L) {
            return;
        }
        this._createPlayer(this.mHandle, player, mediaId, traceId);
    }

    public void createPlayer(long player, String mediaId, String traceId, String tag) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._createPlayerWithTag(this.mHandle, player, mediaId, traceId, tag);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
            this._createPlayer(this.mHandle, player, mediaId, traceId);
        }
    }

    public void releasePlayer(String mediaId, String traceId) {
        if (this.mHandle == 0L) {
            return;
        }
        this._releasePlayer(this.mHandle, mediaId, traceId);
    }

    public void makeCurrentPlayer(String mediaId) {
        if (this.mHandle == 0L) {
            return;
        }
        this._makeCurrentPlayer(this.mHandle, mediaId);
    }

    public void playSelection(String mediaId, int videoBitrate, int audioBitrate) {
        if (this.mHandle == 0L) {
            return;
        }
        this._playSelection(this.mHandle, mediaId, videoBitrate, audioBitrate);
    }

    public void setIOManager(long ioManager, long ioManagerVersion) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setIOManager(this.mHandle, ioManager, ioManagerVersion);
    }

    public boolean isIOManagerVersionMatch() {
        if (this.mHandle == 0L) {
            return false;
        }
        return this._isIOManagerVersionMatch(this.mHandle);
    }

    public void setAppInfo(String appInfo) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setAppInfo(this.mHandle, appInfo);
    }

    public void setAlgorithmJson(int key, String json) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setAlgorithmJson(this.mHandle, key, json);
    }

    public void setSettingsInfo(String module, String info) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setSettingsInfo(this.mHandle, module, info);
    }

    public void setLogCallback(ILogCallback callback) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setLogCallback(this.mHandle, callback);
    }

    public void businessEvent(int key, int value) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._businessEvent(this.mHandle, key, value);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public void businessEvent(int key, String value) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._businessEvent(this.mHandle, key, value);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public void businessEvent(int appId, int key, int value) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._businessEvent(this.mHandle, appId, key, value);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public void businessEvent(int appId, int key, String value) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._businessEvent(this.mHandle, appId, key, value);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public String selectBitrate(String mediaInfo, int type, String param, Object context) {
        if (this.mHandle == 0L) {
            return null;
        }
        try {
            return this._selectBitrate(this.mHandle, mediaInfo, type, param, context);
        }
        catch (Throwable e) {
            Log.i((String)TAG, (String)e.toString());
            return null;
        }
    }

    public int iPlayerVersion() {
        if (this.mHandle == 0L) {
            return -1;
        }
        return this._iPlayerVersion(this.mHandle);
    }

    public void setAppServer(IAppService service) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._setAppServer(this.mHandle, service);
        }
        catch (Throwable e) {
            Log.i((String)TAG, (String)e.toString());
        }
    }

    private native long _create(IStrategyEventListener var1);

    private native void _release(long var1);

    private native void _start(long var1);

    private native void _stop(long var1);

    private native void _createPlayer(long var1, long var3, String var5, String var6);

    private native void _createPlayerWithTag(long var1, long var3, String var5, String var6, String var7);

    private native void _releasePlayer(long var1, String var3, String var4);

    private native void _makeCurrentPlayer(long var1, String var3);

    private native void _playSelection(long var1, String var3, int var4, int var5);

    private native void _setIOManager(long var1, long var3, long var5);

    private native boolean _isIOManagerVersionMatch(long var1);

    private native void _setAppInfo(long var1, String var3);

    private native void _setEventListener(long var1, IStrategyEventListener var3);

    private native void _setIntValue(long var1, int var3, int var4);

    private native void _setFloatValue(long var1, int var3, float var4);

    private native void _setProbeType(long var1, int var3);

    private native void _setPlayTaskProgress(long var1, float var3);

    private native void _setIntervalMS(long var1, int var3);

    private native void _setStateSupplier(long var1, IStrategyStateSupplier var3);

    private native void _addMedia(long var1, String var3, ISelectBitrateListener var4, String var5, boolean var6);

    private native void _addPriorityTask(long var1, String var3, ISelectBitrateListener var4, IPreloadTaskCallbackListener var5);

    private native void _addInterimMedia(long var1, String var3, ISelectBitrateListener var4, String var5, boolean var6, boolean var7);

    private native void _removeMedia(long var1, String var3, String var4);

    private native void _removeAllMedia(long var1, String var3, int var4);

    private native void _focusMedia(long var1, String var3, int var4);

    private native void _updateMedia(long var1, String var3, String var4, String var5);

    private native void _createScene(long var1, String var3);

    private native void _destroyScene(long var1, String var3);

    private native void _moveToScene(long var1, String var3);

    private native void _setAlgorithmJson(long var1, int var3, String var4);

    private native void _setLogCallback(long var1, ILogCallback var3);

    private native void _setSettingsInfo(long var1, String var3, String var4);

    private native void _businessEvent(long var1, int var3, int var4);

    private native void _businessEvent(long var1, int var3, String var4);

    private native void _businessEvent(long var1, int var3, int var4, int var5);

    private native void _businessEvent(long var1, int var3, int var4, String var5);

    private native int _iPlayerVersion(long var1);

    private native String _selectBitrate(long var1, String var3, int var4, String var5, Object var6);

    private native int _getIntValue(long var1, int var3, int var4);

    private native float _getFloatValue(long var1, int var3, float var4);

    private native long _getLongValue(long var1, int var3, long var4);

    private native long _getLongValue(long var1, int var3, String var4, long var5);

    private native void _setStrValue(long var1, int var3, String var4);

    private native String _getStrValue(long var1, int var3, String var4);

    private native void _setLongValue(long var1, int var3, long var4);

    private native void _removePriorityTask(long var1, String var3);

    private native void _setAppServer(long var1, IAppService var3);
}

