/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.networkspeed;

import android.os.SystemClock;
import android.util.Log;
import com.ss.android.ugc.networkspeed.DefaultSpeedAlgorithm;
import com.ss.android.ugc.networkspeed.SpeedRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NetworkSpeedManager {
    public static final String TAG = "NetworkSpeedManager";
    public static final double INVALID_SPEED = -1.0;
    public static final double VALID_SPEED_MIN = 0.001;
    private double mAverageSpeed = -1.0;
    private double mDefaultInitialSpeed = -1.0;
    private Queue<SpeedRecord> mSpeedRecordQueue = new ArrayBlockingQueue<SpeedRecord>(DEFAULT_QUEUE_CAPACITY);
    private SpeedRecord[] mSortBuffer = new SpeedRecord[DEFAULT_QUEUE_CAPACITY];
    public SpeedRecord mRecycledSpeedRecord;
    public static final int DEAFULT_SPEED_RECORD_VALID_THRESHOLD = 1;
    public static int DEFAULT_QUEUE_CAPACITY = 10;
    private static final Lock sLock = new ReentrantLock();
    private final List<OnSpeedChangeListener> listeners = new ArrayList<OnSpeedChangeListener>();
    private static volatile NetworkSpeedManager insts;
    private SpeedAlgorithm speedAlgorithm = this.defaultAlgorithm = new DefaultSpeedAlgorithm();
    private SpeedAlgorithm defaultAlgorithm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkSpeedManager getInstance() {
        if (insts != null) return insts;
        Class<NetworkSpeedManager> clazz = NetworkSpeedManager.class;
        synchronized (NetworkSpeedManager.class) {
            if (insts != null) return insts;
            insts = new NetworkSpeedManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return insts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorVideoSpeed(double speed, double weight, long cost) {
        sLock.lock();
        try {
            SpeedRecord speedRecord;
            if (this.mRecycledSpeedRecord != null) {
                speedRecord = this.mRecycledSpeedRecord;
                speedRecord.setSpeed(speed);
                speedRecord.setWeight(weight);
                speedRecord.setCostTime(cost);
                speedRecord.setCurrentTime(SystemClock.elapsedRealtime());
            } else {
                speedRecord = new SpeedRecord(speed, weight, cost, SystemClock.elapsedRealtime());
            }
            if (!this.mSpeedRecordQueue.offer(speedRecord)) {
                this.mRecycledSpeedRecord = this.mSpeedRecordQueue.poll();
                this.mSpeedRecordQueue.offer(speedRecord);
            }
        }
        finally {
            this.notifySpeedChange();
            sLock.unlock();
        }
    }

    public void setDefaultInitialSpeed(double defaultInitialSpeed) {
        this.mDefaultInitialSpeed = defaultInitialSpeed;
    }

    public double getSpeed() {
        double result = this.mAverageSpeed;
        if (this.mAverageSpeed == -1.0) {
            sLock.lock();
            try {
                if (this.mAverageSpeed == -1.0) {
                    result = this.speedAlgorithm.getSpeed(this.mSpeedRecordQueue, this.mSortBuffer);
                    if (result == -1.0 && this.defaultAlgorithm != this.speedAlgorithm) {
                        result = this.defaultAlgorithm.getSpeed(this.mSpeedRecordQueue, this.mSortBuffer);
                    }
                    this.mAverageSpeed = result;
                } else {
                    result = this.mAverageSpeed;
                }
            }
            finally {
                sLock.unlock();
            }
        }
        if (result <= 0.001 && this.mDefaultInitialSpeed > 0.001) {
            result = this.mDefaultInitialSpeed;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double calculateSpeed() {
        sLock.lock();
        double speed = -1.0;
        try {
            try {
                speed = this.speedAlgorithm.calculate(this.mSpeedRecordQueue, this.mSortBuffer);
            }
            catch (Throwable throwable) {
                Log.e((String)"calculateSpeed", (String)"error.", (Throwable)throwable);
            }
            if (-1.0 == speed && this.defaultAlgorithm != this.speedAlgorithm) {
                speed = this.defaultAlgorithm.calculate(this.mSpeedRecordQueue, this.mSortBuffer);
            }
        }
        catch (Throwable throwable) {
            Log.d((String)"calculateSpeed", (String)"error.", (Throwable)throwable);
        }
        finally {
            sLock.unlock();
        }
        return speed;
    }

    public void setSpeedQueueSize(int size) {
        if (size < 1) {
            return;
        }
        if (size != this.mSpeedRecordQueue.size()) {
            sLock.lock();
            try {
                ArrayBlockingQueue<SpeedRecord> newQueue = new ArrayBlockingQueue<SpeedRecord>(size);
                newQueue.addAll(this.mSpeedRecordQueue);
                this.mSortBuffer = new SpeedRecord[size];
                this.mSpeedRecordQueue = newQueue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpeedRecord[] getSpeedRecordQueue() {
        sLock.lock();
        try {
            if (this.mSpeedRecordQueue != null) {
                SpeedRecord[] speedRecordArray = new SpeedRecord[this.mSpeedRecordQueue.size()];
                int index = 0;
                for (SpeedRecord speedRecord : this.mSpeedRecordQueue) {
                    speedRecordArray[index++] = new SpeedRecord(speedRecord.mSpeed, speedRecord.mWeight, speedRecord.mCostTime, speedRecord.mCurrentTime);
                }
                SpeedRecord[] speedRecordArray2 = speedRecordArray;
                return speedRecordArray2;
            }
            SpeedRecord[] speedRecordArray = null;
            return speedRecordArray;
        }
        finally {
            sLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySpeedChange() {
        this.mAverageSpeed = -1.0;
        List<OnSpeedChangeListener> list = this.listeners;
        synchronized (list) {
            for (OnSpeedChangeListener listener : this.listeners) {
                listener.onChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpeedChangeListener(OnSpeedChangeListener listener) {
        if (listener == null) {
            return;
        }
        List<OnSpeedChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpeedChangeListener(OnSpeedChangeListener listener) {
        if (listener == null) {
            return;
        }
        List<OnSpeedChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void setSpeedAlgorithm(SpeedAlgorithm speedAlgorithm) {
        this.speedAlgorithm = speedAlgorithm;
    }

    public static int getAverageSpeedInKBps() {
        double doubleAverageSpeed = NetworkSpeedManager.getInstance().getSpeed();
        int intAverageSpeed = doubleAverageSpeed == -1.0 ? -1 : (int)(doubleAverageSpeed / 8.0 / 1000.0);
        return intAverageSpeed;
    }

    public static interface SpeedAlgorithm {
        public double calculate(Queue<SpeedRecord> var1, SpeedRecord[] var2) throws Exception;

        public double getSpeed(Queue<SpeedRecord> var1, SpeedRecord[] var2);
    }

    public static interface OnSpeedChangeListener {
        public void onChange();
    }
}

