/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.text.TextUtils;
import com.ss.ttvideoengine.TTNetWorkListener;
import com.ss.ttvideoengine.TTNetworkStateCallback;
import com.ss.ttvideoengine.log.DeviceMonitorUtils;
import com.ss.ttvideoengine.log.EventLoggerSource;
import com.ss.ttvideoengine.log.VideoEventOneStorage;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.utils.SessionIDGenerator;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoEventBase {
    public EventLoggerSource mDataSource;
    private static final String TAG = "VideoEventBase";
    public static volatile String gNetworkType = "unknown";
    public static volatile String gSigStrength = "unknown";
    private static TTNetWorkListener mTTNetWorkListener = null;
    private TTNetworkStateCallback mNetWorkChangeCb = null;
    private WeakReference<TTNetworkStateCallback> mNetWorkChangeCbr = null;
    public static String appSessionId = SessionIDGenerator.generateSessionID(null);
    public String mDeviceId;
    public String pv = "";
    public String pc = "";
    public String sv = "";
    public String sdk_version = "";
    public String ffmpeg_version = "";
    public String libvcn_version = "";
    public String texturender_version = "";
    public String preload_version = "";
    public String abr_version = "";
    public String predict_version = "";
    public String mSessionID;
    public String mInitialURL;
    public String mInitialHost;
    public String mInitialIP;
    public String mCurURL;
    public String mCurHost;
    public String mCurIP;
    public String mDNSType = "";
    @Deprecated
    public String mCurResolution;
    public String mCurQuality;
    public int mPlayType = 0;
    public String mVid = "";
    public String mMediaID = "";
    public String mSourceTypeStr = "";
    public int mVideoHW = 0;
    public int mVideoHWUser = 0;
    public int mAudioHwUser = 0;
    public int vd = Integer.MIN_VALUE;
    public long vs = Integer.MIN_VALUE;
    public String codec_type = "";
    public String a_codec_type = "";
    public int audioCodecNameId = Integer.MIN_VALUE;
    public int videoCodecNameId = Integer.MIN_VALUE;
    public int formatType = Integer.MIN_VALUE;
    public String vtype = "";
    public String dynamic_type = "";
    public String mLastResolution = "";
    public String mCurrentResolution = "";
    public int mCurrentConfigBitrate = Integer.MIN_VALUE;
    public int mP2PCDNType = Integer.MIN_VALUE;
    public String mTag = "default";
    public String mSubTag = "default";
    public int mReuseSocket = 0;
    public int mDrmType = 0;
    public String mDrmTokenUrl = "";
    public float mPlaySpeed = 1.0f;
    public String mTraceID = "";
    private Map mVideoInfo;
    public String mNetworkType = "";
    public Context mContext;
    public String mMdlVersion = "";
    public String mInitialQualityDesc = "";
    public String mCurrentQualityDesc = "";
    public boolean mEnablePlayerDegrade = false;
    public String mOriginVid = null;
    public boolean mEnableTmpLog = false;
    public boolean mEnablePowerReport = false;
    public MDLTrackInfo mdlVideoInfo = new MDLTrackInfo();
    public MDLTrackInfo mdlAudioInfo = new MDLTrackInfo();
    public int mdl_cur_task_num = Integer.MIN_VALUE;
    public Map abrInfo = null;
    public int speed_predict_type;
    public int is_enable_abr = 0;
    public int is_multi_dimensions;
    public int is_multi_dimensionsInput;
    public Map<String, Object> abrGeneralInfo = null;
    public int mEnableMDL = -1;
    public boolean isUploadLogEnabled;
    public Map mdlFeatures = null;
    public int mdlP2pLoader = -1;

    VideoEventBase(EventLoggerSource datasource, boolean uploadLogEnabled, Context context) {
        this.mDataSource = datasource;
        this.mSessionID = SessionIDGenerator.generateSessionID(null);
        this.isUploadLogEnabled = uploadLogEnabled;
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerNetwork() {
        if (this.mContext == null) return;
        String string = TAG;
        synchronized (TAG) {
            if (mTTNetWorkListener == null) {
                mTTNetWorkListener = TTNetWorkListener.getInstance();
            }
            this.mNetWorkChangeCb = new TTNetworkStateCallback(){

                @Override
                public void onAccessChanged(int what, int from, int to) {
                    switch (what) {
                        case 0: {
                            VideoEventBase.this._changeNetworkType(from, to);
                            break;
                        }
                        case 1: {
                            VideoEventBase.this._changeSignalStrength(from, to);
                        }
                    }
                }
            };
            this.mNetWorkChangeCbr = new WeakReference<TTNetworkStateCallback>(this.mNetWorkChangeCb);
            mTTNetWorkListener.startListen(this.mNetWorkChangeCbr);
            gNetworkType = VideoEventBase._switchNetworkType(mTTNetWorkListener.getCurrentAccessType());
            gSigStrength = VideoEventBase._switchNetworkStrength(mTTNetWorkListener.getCurrentAccessStrength());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void unregisterNetwork() {
        if (mTTNetWorkListener != null) {
            mTTNetWorkListener.stopListen(this.mNetWorkChangeCbr);
        }
    }

    public void reset() {
        this.mSessionID = SessionIDGenerator.generateSessionID(this.mDeviceId);
    }

    public void setSourceType(int sourceType, String vid) {
        switch (sourceType) {
            case 0: {
                this.mSourceTypeStr = "local_url";
                break;
            }
            case 1: {
                this.mSourceTypeStr = "dir_url";
                break;
            }
            case 2: {
                this.mSourceTypeStr = "playitem";
                break;
            }
            case 3: {
                this.mSourceTypeStr = "preload";
                break;
            }
            case 4: {
                this.mSourceTypeStr = "feed";
                break;
            }
            case 5: {
                this.mSourceTypeStr = "vid";
                break;
            }
            case 6: {
                this.mSourceTypeStr = "fd";
                break;
            }
            case 7: {
                this.mSourceTypeStr = "mds";
                break;
            }
        }
        this.mVid = vid;
    }

    public void beginToPlay(String vid, String device_id) {
        this.mVid = vid;
        this.mDeviceId = device_id;
        String preloadTraceId = null;
        if (this.mDataSource != null) {
            preloadTraceId = this.mDataSource.getLogValueStr(139);
        }
        this.mSessionID = TextUtils.isEmpty(preloadTraceId) ? SessionIDGenerator.generateTrackID(this.mDeviceId) : preloadTraceId;
        this.mTraceID = this.mSessionID;
    }

    public void showedOneFrame() {
        if (this.mDataSource != null) {
            this.codec_type = this.mDataSource.getLogValueStr(0);
            this.a_codec_type = this.mDataSource.getLogValueStr(146);
        }
        if (this.mVideoInfo != null) {
            Object vtypeObj;
            Map sizeMap = (Map)this.mVideoInfo.get("size");
            Object sizeObject = sizeMap.get(this.mCurrentResolution);
            int size = -1;
            if (sizeObject != null) {
                size = ((Long)sizeObject).intValue();
            }
            this.vs = size;
            Map vtypeMap = (Map)this.mVideoInfo.get("vtype");
            if (vtypeMap != null && (vtypeObj = vtypeMap.get(this.mCurrentResolution)) != null) {
                this.vtype = (String)vtypeObj;
                TTVideoEngineLog.i(TAG, "showedOneFrame vtype:" + this.vtype + ", currentResolution:" + this.mCurrentResolution);
            }
        }
    }

    public void setVideoInfo(IVideoModel model) {
        Object curBitrateObj;
        List<VideoInfo> infoList;
        if (model == null) {
            return;
        }
        HashMap<String, Long> sizeMap = new HashMap<String, Long>();
        HashMap<String, String> codecMap = new HashMap<String, String>();
        HashMap<String, Integer> bitrateMap = new HashMap<String, Integer>();
        HashMap<Integer, String> fileKeyMap = new HashMap<Integer, String>();
        HashMap<Integer, Integer> bitrateMapTable = new HashMap<Integer, Integer>();
        HashMap<String, String> vtypeMap = new HashMap<String, String>();
        ArrayList<Integer> audioBitrate = new ArrayList<Integer>();
        ArrayList<Integer> videoBitrare = new ArrayList<Integer>();
        if (model.hasData() && (infoList = model.getVideoInfoList()) != null && infoList.size() > 0) {
            int i = 0;
            for (VideoInfo info : infoList) {
                int mediaType = info.getMediatype();
                long size = info.getValueLong(12);
                String codec_type = info.getValueStr(8);
                int bitrate = info.getValueInt(3);
                String resolution = info.getResolution().toString(mediaType);
                String vtype = info.getValueStr(6);
                sizeMap.put(resolution, size);
                codecMap.put(resolution, codec_type);
                bitrateMap.put(resolution, bitrate);
                fileKeyMap.put(info.getValueInt(3), info.getValueStr(15));
                bitrateMapTable.put(info.getValueInt(3), i);
                vtypeMap.put(resolution, vtype);
                if (mediaType == 1) {
                    audioBitrate.add(info.getValueInt(3));
                } else {
                    videoBitrare.add(info.getValueInt(3));
                }
                if (this.mEnableTmpLog) {
                    TTVideoEngineLog.i(TAG, "setVideoInfo i:" + i + ", resolution:" + resolution + ", size:" + size + ",codec_type:" + codec_type + ", bitrate:" + bitrate);
                }
                ++i;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String dt = model.getDynamicType();
        map.put("duration", model.getVideoRefInt(3));
        map.put("size", sizeMap);
        map.put("codec", codecMap);
        map.put("vtype", vtypeMap);
        map.put("dynamic_type", dt);
        map.put("bitrate", bitrateMap);
        map.put("fileKey", fileKeyMap);
        map.put("bitrateMapTable", bitrateMapTable);
        map.put("audio_bitrate", audioBitrate);
        map.put("video_bitrate", videoBitrare);
        this.mVideoInfo = map;
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentResolution) && (curBitrateObj = bitrateMap.get(this.mCurrentResolution)) != null) {
            this.mCurrentConfigBitrate = (Integer)curBitrateObj;
        }
        this.dynamic_type = dt;
    }

    public Map getVideoInfo() {
        return this.mVideoInfo;
    }

    public String getCodecType() {
        String codec = "";
        if (this.mVideoInfo != null) {
            Map codecMap = (Map)this.mVideoInfo.get("codec");
            String string = codec = codecMap.get(this.mCurrentResolution) != null ? codecMap.get(this.mCurrentResolution) : "";
        }
        if (this.mDataSource != null && TextUtils.isEmpty((CharSequence)codec)) {
            codec = this.mDataSource.getLogValueStr(0);
        }
        return codec;
    }

    public void updateVideoInfo(VideoModel model) {
        if (model != null) {
            this.setVideoInfo(model);
        }
        if (this.mVideoInfo != null) {
            if (this.vd <= 0) {
                int duration = (Integer)this.mVideoInfo.get("duration");
                this.vd = duration * 1000;
            }
            if (this.vs <= 0L) {
                Map sizeMap = (Map)this.mVideoInfo.get("size");
                Object sizeObject = sizeMap.get(this.mCurrentResolution);
                long size = -1L;
                if (sizeObject != null) {
                    size = ((Number)sizeObject).longValue();
                }
                this.vs = size;
            }
            if (TextUtils.isEmpty((CharSequence)this.codec_type)) {
                Map codecMap = (Map)this.mVideoInfo.get("codec");
                this.codec_type = codecMap.get(this.mCurrentResolution) != null ? codecMap.get(this.mCurrentResolution) : "";
                TTVideoEngineLog.i(TAG, "brian codec_type:" + this.codec_type + ", for resolution:" + this.mCurrentResolution + ", quality desc:" + this.mCurrentQualityDesc);
            }
        }
        if (this.mDataSource != null) {
            String mdlVersion;
            Map<String, String> versionInfo;
            if ((this.pv == null || this.pv.isEmpty()) && (versionInfo = this.mDataSource.versionInfo()) != null) {
                this.pv = versionInfo.get("pv");
                this.pc = versionInfo.get("pc");
                this.sv = versionInfo.get("sv");
                this.sdk_version = versionInfo.get("sdk_version");
                this.ffmpeg_version = versionInfo.get("ffv");
                this.libvcn_version = versionInfo.get("vcnv");
                this.texturender_version = versionInfo.get("trv");
                this.abr_version = versionInfo.get("abrv");
                this.predict_version = versionInfo.get("prdtv");
                this.preload_version = versionInfo.get("prldv");
            }
            if (TextUtils.isEmpty((CharSequence)this.codec_type)) {
                this.codec_type = this.mDataSource.getLogValueStr(0);
            }
            if (TextUtils.isEmpty((CharSequence)this.a_codec_type)) {
                this.a_codec_type = this.mDataSource.getLogValueStr(146);
            }
            if (!TextUtils.isEmpty((CharSequence)(mdlVersion = this.mDataSource.getLogValueStr(37)))) {
                this.mMdlVersion = mdlVersion;
            }
            TTVideoEngineLog.i(TAG, "video_type:" + this.vtype);
            if (TextUtils.isEmpty((CharSequence)this.vtype)) {
                String fileFmt = this.mDataSource.getLogValueStr(65);
                TTVideoEngineLog.i(TAG, "get video_type from player:" + fileFmt);
                if (!TextUtils.isEmpty((CharSequence)fileFmt)) {
                    int end;
                    this.vtype = fileFmt.indexOf("mp4") > 0 ? "mp4" : ((end = fileFmt.indexOf(",")) < 0 ? fileFmt : fileFmt.substring(0, end));
                }
            }
            TTVideoEngineLog.i(TAG, "video_size :" + this.vs);
            if (this.vs <= 0L) {
                this.vs = this.mDataSource.getLogValueLong(66);
                TTVideoEngineLog.i(TAG, "get video_size from player:" + this.vs);
            }
            this.videoCodecNameId = this.mDataSource.getLogValueInt(24);
            this.audioCodecNameId = this.mDataSource.getLogValueInt(25);
            switch (this.videoCodecNameId) {
                case 2: {
                    this.mVideoHW = 1;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.mVideoHW = 0;
                    break;
                }
            }
            this.formatType = this.mDataSource.getLogValueInt(49);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getMDLInfo() {
        JSONObject info = null;
        if (this.mDataSource != null) {
            String strMDLInfo = null;
            VideoEventBase videoEventBase = this;
            synchronized (videoEventBase) {
                strMDLInfo = this.mDataSource.getMediaLoaderInfo();
            }
            TTVideoEngineLog.d(TAG, "update mdl info: " + strMDLInfo);
            if (!TextUtils.isEmpty((CharSequence)strMDLInfo)) {
                try {
                    info = new JSONObject(strMDLInfo);
                }
                catch (JSONException e) {
                    TTVideoEngineLog.e(TAG, e.toString());
                    info = null;
                }
            }
        }
        return info;
    }

    public void updateMDLInfo() {
        JSONObject info = this.getMDLInfo();
        if (info != null) {
            try {
                boolean trackInfo = false;
                if (!info.isNull("audio")) {
                    trackInfo = true;
                    this.mdlAudioInfo.update(info.getJSONObject("audio"));
                }
                if (!info.isNull("video")) {
                    trackInfo = true;
                    TTVideoEngineLog.d(TAG, "found video: " + info.getJSONObject("video").toString());
                    this.mdlVideoInfo.update(info.getJSONObject("video"));
                }
                if (!trackInfo) {
                    this.mdlVideoInfo.update(info);
                }
                if (!info.isNull("cur_task_num")) {
                    this.mdl_cur_task_num = (Integer)info.get("cur_task_num");
                }
                int type = -1;
                if (!info.isNull("dns_type")) {
                    type = (Integer)info.get("dns_type");
                }
                switch (type) {
                    case 0: {
                        this.mDNSType = "localDNS";
                        break;
                    }
                    case 2: {
                        this.mDNSType = "httpDNS_own";
                        break;
                    }
                    case 3: {
                        this.mDNSType = "httpDNS_google";
                        break;
                    }
                    case 4: {
                        if (this.mDataSource != null && this.mDataSource.getLogValueInt(85) == 1) {
                            this.mDNSType = "customDNSInnerByteDanceHTTPDNS";
                            break;
                        }
                        this.mDNSType = "customDNS";
                        break;
                    }
                }
                if (!info.isNull("mdl_features")) {
                    this.updateMdlFeatures(info.getJSONObject("mdl_features"));
                }
            }
            catch (Exception e) {
                TTVideoEngineLog.d(e);
            }
        }
    }

    private void updateMdlFeatures(JSONObject json) {
        HashMap<String, Integer> features = new HashMap<String, Integer>();
        try {
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                int value = json.getInt(key);
                features.put(key, value);
                if (this.mdlP2pLoader != -1 || !key.equals("mdl_p2p_loader")) continue;
                this.mdlP2pLoader = value;
            }
        }
        catch (JSONException e) {
            TTVideoEngineLog.d(e);
        }
        if (!features.isEmpty()) {
            this.mdlFeatures = features;
        }
    }

    public MDLTrackInfo getMdlTrackInfo(JSONObject json) throws Exception {
        MDLTrackInfo trackInfo = new MDLTrackInfo();
        trackInfo.update(json);
        return trackInfo;
    }

    public void configResolution(String toResolution, String lastResolution) {
        Map bitrateMap;
        Object curBitrateObj;
        this.mLastResolution = lastResolution;
        this.mCurrentResolution = toResolution;
        if (this.mVideoInfo != null && (curBitrateObj = (bitrateMap = (Map)this.mVideoInfo.get("bitrate")).get(this.mCurrentResolution)) != null) {
            this.mCurrentConfigBitrate = (Integer)curBitrateObj;
        }
    }

    public void setCurrentQualityDesc(String qualityDesc) {
        if (TextUtils.isEmpty((CharSequence)this.mInitialQualityDesc)) {
            this.mInitialQualityDesc = qualityDesc;
        }
        this.mCurrentQualityDesc = qualityDesc;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public void setP2PCDNType(int type) {
        this.mP2PCDNType = type;
    }

    public void movieFinish() {
        this.updateVideoInfo(null);
    }

    public void useVideoHW(int isHW) {
        this.mVideoHW = isHW;
        this.mVideoHWUser = isHW;
    }

    public void setCurURL(String url) {
        this.mCurURL = url;
    }

    public String getCurURL() {
        return this.mCurURL;
    }

    public void setCurHost(String host) {
        this.mCurHost = host;
    }

    public String getCurHost() {
        return this.mCurHost;
    }

    public void setCurIP(String ip) {
        this.mCurIP = ip;
    }

    public String getCurIP() {
        return this.mCurIP;
    }

    public void setCurResolution(String res) {
        this.mCurResolution = res;
    }

    public String getCurResolution() {
        return this.mCurResolution;
    }

    public void setCurQuality(String qualit) {
        this.mCurQuality = qualit;
    }

    public String getCurQuality() {
        return this.mCurQuality;
    }

    private void _changeNetworkType(int from, int to) {
        String fromStr = VideoEventBase._switchNetworkType(from);
        String toStr = VideoEventBase._switchNetworkType(to);
        TTVideoEngineLog.d(TAG, String.format("receive network type changed, from:%s to:%s", fromStr, toStr));
        gNetworkType = toStr;
    }

    private void _changeSignalStrength(int from, int to) {
        String fromStr = VideoEventBase._switchNetworkStrength(from);
        String toStr = VideoEventBase._switchNetworkStrength(to);
        TTVideoEngineLog.d(TAG, String.format("receive signal strength changed, from:%s to:%s", fromStr, toStr));
        gSigStrength = toStr;
    }

    private static String _switchNetworkType(int i) {
        switch (i) {
            case 0: {
                return "WIFI";
            }
            case 2: {
                return "2G";
            }
            case 3: {
                return "3G";
            }
            case 1: {
                return "4G";
            }
            case 4: {
                return "5G";
            }
        }
        return "unknown";
    }

    private static String _switchNetworkStrength(int i) {
        switch (i) {
            case 1: {
                return "weak";
            }
            case 2: {
                return "medium";
            }
            case 3: {
                return "good";
            }
            case 4: {
                return "excellent";
            }
        }
        return "unknown";
    }

    public static String getSignalStrength() {
        if (gNetworkType.equals("unknown")) {
            return "unknown";
        }
        if (gSigStrength.equals("unknown") && mTTNetWorkListener != null) {
            gSigStrength = VideoEventBase._switchNetworkStrength(mTTNetWorkListener.getCurrentAccessStrength());
        }
        return gSigStrength;
    }

    public static String getNetType() {
        if (gNetworkType.equals("unknown") && mTTNetWorkListener != null) {
            gNetworkType = VideoEventBase._switchNetworkType(mTTNetWorkListener.getCurrentAccessType());
        }
        return gNetworkType;
    }

    public void degradeModeChangeSession() {
        if (!this.mEnablePlayerDegrade) {
            return;
        }
        String sessionId = VideoEventOneStorage.getInstance().getSessionId(this.mOriginVid);
        TTVideoEngineLog.d(TAG, "degradeModeChangeSession, stored sessionid:" + sessionId + ", current sessionid:" + this.mSessionID);
        if (sessionId != null && !sessionId.equals(this.mSessionID)) {
            TTVideoEngineLog.i(TAG, String.format("degrade mode, change sessionId, before:%s, after:%s", this.mSessionID, sessionId));
            this.mSessionID = sessionId;
            this.mTraceID = sessionId;
        }
    }

    public DeviceMonitorUtils.CPUInfo getCurrentCPUInfo() {
        if (!this.mEnablePowerReport) {
            return null;
        }
        return DeviceMonitorUtils.getCurrentCPUInfo();
    }

    public double getCPUSpeed() {
        if (!this.mEnablePowerReport) {
            return -1.0;
        }
        return DeviceMonitorUtils.getCPUSpeed();
    }

    public double getCPURate() {
        if (!this.mEnablePowerReport) {
            return -1.0;
        }
        return DeviceMonitorUtils.getCPURate();
    }

    public float getBatteryCurrent() {
        if (!this.mEnablePowerReport) {
            return -1.0f;
        }
        return DeviceMonitorUtils.getGalvanicNow(this.mContext);
    }

    public HashMap<String, Object> getChargingState() {
        if (!this.mEnablePowerReport) {
            return null;
        }
        return DeviceMonitorUtils.getChargingState(this.mContext);
    }

    public class MDLTrackInfo {
        public long mdl_cur_req_pos = Integer.MIN_VALUE;
        public long mdl_cur_end_pos = Integer.MIN_VALUE;
        public long mdl_cur_cache_pos = Integer.MIN_VALUE;
        public int mdl_cache_type = 0;
        public String mdl_cur_ip = "";
        public String mdl_cur_host = "";
        public String mdl_cur_url = "";
        public long mdl_reply_size = Integer.MIN_VALUE;
        public long mdl_down_pos = Integer.MIN_VALUE;
        public long mdl_player_wait_time = Integer.MIN_VALUE;
        public int mdl_player_wait_num = Integer.MIN_VALUE;
        public int mdl_stage = Integer.MIN_VALUE;
        public int mdl_error_code = 0;
        public int mdl_speed = Integer.MIN_VALUE;
        public String mdl_file_key = "";
        public int mdl_is_socrf = -1;
        public int mdl_url_index = -1;
        public String mdl_re_url = "";
        public int mdl_cur_soure = -1;
        public String mdl_extra_info = "";
        public int mdl_http_code = -1;
        public long mdl_req_t = Integer.MIN_VALUE;
        public long mdl_end_t = Integer.MIN_VALUE;
        public long mdl_dns_t = Integer.MIN_VALUE;
        public long mdl_tcp_start_t = Integer.MIN_VALUE;
        public long mdl_tcp_end_t = Integer.MIN_VALUE;
        public long mdl_ttfp = Integer.MIN_VALUE;
        public long mdl_httpfb = Integer.MIN_VALUE;
        public long mdl_http_open_end_t = Integer.MIN_VALUE;
        public long mdl_fs = Integer.MIN_VALUE;
        public int mdl_pcdn_full_speed = Integer.MIN_VALUE;
        public long mdl_tbs = Integer.MIN_VALUE;
        public long mdl_lbs = Integer.MIN_VALUE;
        public int mdl_res_err = -1;
        public int mdl_read_src = -1;
        public int mdl_seek_num = -1;
        public String mdl_last_msg = "";
        public String mdl_server_timing = "";
        public int mdl_v_lt = -1;
        public int mdl_v_p2p_ier = 1;
        public String mdl_ip_list = "";
        public String mdl_blocked_ips = "";
        public int mdl_req_num = Integer.MIN_VALUE;
        public String mdl_cdn_cache = "";
        public String mdl_client_info = "";
        public int mdl_disable_seek = -1;

        public void update(JSONObject info) throws Exception {
            if (info != null) {
                if (!info.isNull("cur_req_pos")) {
                    this.mdl_cur_req_pos = ((Number)info.get("cur_req_pos")).longValue();
                }
                if (!info.isNull("cur_end_pos")) {
                    this.mdl_cur_end_pos = ((Number)info.get("cur_end_pos")).longValue();
                }
                if (!info.isNull("cur_cache_pos")) {
                    this.mdl_cur_cache_pos = ((Number)info.get("cur_cache_pos")).longValue();
                }
                if (!info.isNull("cache_type")) {
                    this.mdl_cache_type = ((Number)info.get("cache_type")).intValue();
                }
                if (!info.isNull("down_pos")) {
                    this.mdl_down_pos = ((Number)info.get("down_pos")).longValue();
                }
                if (!info.isNull("err_code")) {
                    this.mdl_error_code = ((Number)info.get("err_code")).intValue();
                }
                if (!info.isNull("player_wait_num")) {
                    this.mdl_player_wait_num = ((Number)info.get("player_wait_num")).intValue();
                }
                if (!info.isNull("player_wait_time")) {
                    this.mdl_player_wait_time = ((Number)info.get("player_wait_time")).longValue();
                }
                if (!info.isNull("reply_size")) {
                    this.mdl_reply_size = ((Number)info.get("reply_size")).longValue();
                }
                if (!info.isNull("stage")) {
                    this.mdl_stage = ((Number)info.get("stage")).intValue();
                }
                if (!info.isNull("cur_host")) {
                    this.mdl_cur_host = info.get("cur_host").toString();
                }
                if (!info.isNull("cur_ip")) {
                    this.mdl_cur_ip = info.get("cur_ip").toString();
                }
                if (!info.isNull("speed")) {
                    this.mdl_speed = ((Number)info.get("speed")).intValue();
                }
                if (!info.isNull("url")) {
                    this.mdl_cur_url = info.get("url").toString();
                }
                if (!info.isNull("file_key")) {
                    this.mdl_file_key = info.get("file_key").toString();
                }
                if (!info.isNull("is_socrf")) {
                    this.mdl_is_socrf = ((Number)info.get("is_socrf")).intValue();
                }
                if (!info.isNull("url_index")) {
                    this.mdl_url_index = ((Number)info.get("url_index")).intValue();
                }
                if (!info.isNull("re_url")) {
                    this.mdl_re_url = info.get("re_url").toString();
                }
                if (!info.isNull("cur_source")) {
                    this.mdl_cur_soure = ((Number)info.get("cur_source")).intValue();
                }
                if (!info.isNull("extra_info")) {
                    this.mdl_extra_info = info.get("extra_info").toString();
                }
                if (!info.isNull("status_code")) {
                    this.mdl_http_code = ((Number)info.get("status_code")).intValue();
                }
                if (!info.isNull("req_t")) {
                    this.mdl_req_t = ((Number)info.get("req_t")).longValue();
                }
                if (!info.isNull("end_t")) {
                    this.mdl_end_t = ((Number)info.get("end_t")).longValue();
                }
                if (!info.isNull("dns_t")) {
                    this.mdl_dns_t = ((Number)info.get("dns_t")).longValue();
                }
                if (!info.isNull("tcp_con_start_t")) {
                    this.mdl_tcp_start_t = ((Number)info.get("tcp_con_start_t")).longValue();
                }
                if (!info.isNull("tcp_con_t")) {
                    this.mdl_tcp_end_t = ((Number)info.get("tcp_con_t")).longValue();
                }
                if (!info.isNull("tcp_first_pack_t")) {
                    this.mdl_ttfp = ((Number)info.get("tcp_first_pack_t")).longValue();
                }
                if (!info.isNull("http_first_body_t")) {
                    this.mdl_httpfb = ((Number)info.get("http_first_body_t")).longValue();
                }
                if (!info.isNull("http_open_end_t")) {
                    this.mdl_http_open_end_t = ((Number)info.get("http_open_end_t")).longValue();
                }
                if (!info.isNull("fs")) {
                    this.mdl_fs = ((Number)info.get("fs")).longValue();
                }
                if (!info.isNull("full_speed")) {
                    this.mdl_pcdn_full_speed = ((Number)info.get("full_speed")).intValue();
                }
                if (!info.isNull("tbs")) {
                    this.mdl_tbs = ((Number)info.get("tbs")).longValue();
                }
                if (!info.isNull("lbs")) {
                    this.mdl_lbs = ((Number)info.get("lbs")).longValue();
                }
                if (!info.isNull("req_err")) {
                    this.mdl_res_err = ((Number)info.get("req_err")).intValue();
                }
                if (!info.isNull("read_src")) {
                    this.mdl_read_src = ((Number)info.get("read_src")).intValue();
                }
                if (!info.isNull("seek_times")) {
                    this.mdl_seek_num = ((Number)info.get("seek_times")).intValue();
                }
                if (!info.isNull("last_msg")) {
                    this.mdl_last_msg = info.get("last_msg").toString();
                }
                if (!info.isNull("server_timing")) {
                    this.mdl_server_timing = info.get("server_timing").toString();
                }
                if (!info.isNull("v_lt")) {
                    this.mdl_v_lt = ((Number)info.get("v_lt")).intValue();
                }
                if (!info.isNull("v_p2p_ier")) {
                    this.mdl_v_p2p_ier = ((Number)info.get("v_p2p_ier")).intValue();
                }
                if (!info.isNull("req_num")) {
                    this.mdl_req_num = ((Number)info.get("req_num")).intValue();
                }
                if (!info.isNull("ip_list")) {
                    this.mdl_ip_list = info.get("ip_list").toString();
                }
                if (!info.isNull("blocked_ip")) {
                    this.mdl_blocked_ips = info.get("blocked_ip").toString();
                }
                if (!info.isNull("cdn_cache")) {
                    this.mdl_cdn_cache = info.get("cdn_cache").toString();
                }
                if (!info.isNull("client_info")) {
                    this.mdl_client_info = info.get("client_info").toString();
                }
                if (!info.isNull("disable_seek")) {
                    this.mdl_disable_seek = ((Number)info.get("disable_seek")).intValue();
                }
            }
        }
    }
}

