/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.metrics;

import android.os.Bundle;
import com.ss.ttvideoengine.log.VideoEventOnePlay;
import com.ss.ttvideoengine.metrics.IMediaMetrics;

class FirstFrameMetrics
implements IMediaMetrics {
    private Bundle mMetrics = new Bundle();
    private int mType;
    private int mFreeLastDuration;
    private long mReadHeaderDuration;
    private long mReadFirstVideoPktDuration;
    private long mFirstFrameDecodedDuration;
    private long mFirstFrameRenderDuration;
    private long mPlaybackBufferEndDuration;
    private long mPlayerFirstFrameRenderDuration;

    public FirstFrameMetrics(int type) {
        this.mType = type;
    }

    @Override
    public void logMetric(String key, int value) {
        this.mMetrics.putInt(key, value);
    }

    @Override
    public void logMetric(String key, float value) {
        this.mMetrics.putFloat(key, value);
    }

    @Override
    public void logMetric(String key, String value) {
        this.mMetrics.putString(key, value);
    }

    @Override
    public void logMetric(String key, boolean value) {
        this.mMetrics.putBoolean(key, value);
    }

    @Override
    public void logMetric(VideoEventOnePlay event) {
        if (event == null) {
            return;
        }
        this.mReadHeaderDuration = event.tranFirstPacketT > 0L ? event.tranFirstPacketT - event.prepare_start_time : 0L;
        this.mReadFirstVideoPktDuration = event.receiveFirstVideoFrameT - event.prepare_start_time;
        this.mFirstFrameDecodedDuration = event.decodeFirstVideoFrameT - event.prepare_start_time;
        this.mFirstFrameRenderDuration = event.vt - event.prepare_start_time;
        this.mPlayerFirstFrameRenderDuration = event.playerFirstFrameT - event.prepare_start_time;
        this.mPlaybackBufferEndDuration = event.playbackBufferEndT > 0L ? event.playbackBufferEndT - event.prepare_start_time : 0L;
        this.mMetrics.putLong("ffr_read_head_duration", this.mReadHeaderDuration);
        this.mMetrics.putLong("ffr_read_first_data_duration", this.mReadFirstVideoPktDuration);
        this.mMetrics.putLong("ffr_decode_duration", this.mFirstFrameDecodedDuration);
        this.mMetrics.putLong("ffr_render_duration", this.mFirstFrameRenderDuration);
        this.mMetrics.putLong("ffr_playback_buffering_duration", this.mPlaybackBufferEndDuration);
        this.mMetrics.putLong("ffr_prender_duration", this.mPlayerFirstFrameRenderDuration);
    }

    @Override
    public long popMetricLong(String key) {
        return this.mMetrics.getLong(key);
    }

    @Override
    public int popMetricInt(String key) {
        return this.mMetrics.getInt(key);
    }

    @Override
    public float popMetricFloat(String key) {
        return this.mMetrics.getFloat(key);
    }

    @Override
    public boolean popMetricBoolean(String key) {
        return this.mMetrics.getBoolean(key);
    }

    @Override
    public int getType() {
        return this.mType;
    }

    @Override
    public String printf() {
        return this.mMetrics.toString();
    }

    @Override
    public Bundle popMetrics() {
        return this.mMetrics;
    }
}

