/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.net.NetUtils;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelSelect {
    private static final String TAG = "ChannelSelect";
    private static final String SP_NAME = "engine_channel_select_v2";
    private static final String KEY_CHANNEL_ARRAY = "channel_array";
    private static final String KEY_NET_TYPE = "netType";
    private static final int COST_ERROR_VALUE_MS = 30000;
    private static final int REUSE_HOST_COST_WEIGHT_MILLIS = 80;
    private static final long REUSE_HOST_LIFE_TIME_MILLIS = 300000L;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ChannelSelect sInstance;
    private Context mContext;
    private final Map<String, Channel> mChannelMap = new HashMap<String, Channel>();
    private Channel mChannelSelected;
    private SharedPreferences mSP;
    private int mNetType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelSelect getInstance() {
        if (sInstance != null) return sInstance;
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ChannelSelect();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private ChannelSelect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context) {
        if (context == null) {
            return;
        }
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (this.mContext != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.mContext = context.getApplicationContext();
            this.mSP = context.getSharedPreferences(SP_NAME, 0);
            this.mNetType = NetUtils.getNetType(context);
            this._loadFromSPLocked(this.mSP);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void _loadFromSPLocked(SharedPreferences sp) {
        if (sp == null) {
            return;
        }
        int netType = sp.getInt(KEY_NET_TYPE, -1);
        if (netType != -1 && this.mNetType != -1 && netType != this.mNetType) {
            this.resetHostChannelMapLocked();
            return;
        }
        String channelsStr = sp.getString(ChannelSelect.channelKey(), null);
        if (TextUtils.isEmpty((CharSequence)channelsStr)) {
            return;
        }
        JSONArray jsonChannels = null;
        try {
            jsonChannels = new JSONArray(channelsStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (TTHelper.isEmpty(jsonChannels)) {
            return;
        }
        for (int i = 0; i < jsonChannels.length(); ++i) {
            Channel channel;
            JSONObject jsonChannel = jsonChannels.optJSONObject(i);
            if (jsonChannel == null || (channel = Channel.parse(jsonChannel)) == null) continue;
            this.mChannelMap.put(channel.mHost, channel);
        }
    }

    private static String channelKey() {
        if (TextUtils.isEmpty((CharSequence)AppInfo.mRegion)) {
            return KEY_CHANNEL_ARRAY;
        }
        return "channel_array_" + AppInfo.mRegion;
    }

    private void resetHostChannelMapLocked() {
        if (TTHelper.isEmpty(this.mChannelMap)) {
            return;
        }
        for (Map.Entry<String, Channel> entry : this.mChannelMap.entrySet()) {
            entry.getValue().reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostList(int apiVersion, JSONArray hostArray) {
        if (TTHelper.isEmpty(hostArray)) {
            return;
        }
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            for (int i = 0; i < hostArray.length(); ++i) {
                String hostStr = hostArray.optString(i);
                Channel channel = this.mChannelMap.get(hostStr);
                if (channel != null) continue;
                this.mChannelMap.put(hostStr, new Channel(apiVersion, hostStr));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostCost(int apiVersion, String host, long costInMS, boolean isError) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            return;
        }
        TTVideoEngineLog.d(TAG, String.format("setHostCost host:%s cost:%dms isError:%b", host, costInMS, isError));
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (this.mContext == null) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return;
            }
            Channel channel = this.mChannelMap.get(host);
            if (channel == null) {
                channel = new Channel(apiVersion, host);
            }
            long curTime = System.currentTimeMillis();
            if (isError) {
                if (!NetUtils.isNetAvailable(this.mContext)) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return;
                }
                channel.setHostCost(30000L, curTime);
            } else {
                channel.setHostCost(costInMS, curTime);
            }
            this.mChannelMap.put(host, channel);
            this._saveToSPLocked(this.mSP);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String select(int apiVersion) {
        Class<ChannelSelect> clazz = ChannelSelect.class;
        synchronized (ChannelSelect.class) {
            if (this.mContext == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if (!NetUtils.isNetAvailable(this.mContext)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            int net = NetUtils.getNetType(this.mContext);
            if (net != this.mNetType) {
                TTVideoEngineLog.d(TAG, "network type change:" + net);
                this.resetHostChannelMapLocked();
                this.mNetType = net;
            }
            long minCost = -1L;
            Channel minChannel = null;
            long curTime = System.currentTimeMillis();
            List<Channel> channels = this.groupByApiVersionLocked(apiVersion);
            for (Channel channel : channels) {
                long cost = channel.mNetCost;
                TTVideoEngineLog.d(TAG, String.format("host:%s cost:%dms", channel.mHost, cost));
                if (this.mChannelSelected != null && this.mChannelSelected.mNetCost < 30000L && this.mChannelSelected.mHost.equals(channel.mHost) && curTime - this.mChannelSelected.mLastUpdateTime < 300000L) {
                    cost = channel.mNetCost - 80L;
                    long l = cost = cost < 0L ? 0L : cost;
                }
                if (minCost == -1L) {
                    minCost = cost;
                    minChannel = channel;
                    continue;
                }
                if (cost >= minCost) continue;
                minCost = cost;
                minChannel = channel;
            }
            if (minCost == 30000L) {
                this.resetHostChannelMapLocked();
            }
            if (minChannel != null) {
                this.mChannelSelected = minChannel;
                TTVideoEngineLog.d(TAG, String.format("select host:%s cost:%dms", minChannel.mHost, minChannel.mNetCost));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return minChannel.mHost;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private List<Channel> groupByApiVersionLocked(int apiVersion) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (Map.Entry<String, Channel> entry : this.mChannelMap.entrySet()) {
            Channel channel = entry.getValue();
            if (channel == null || channel.mApiVersion != apiVersion) continue;
            channels.add(entry.getValue());
        }
        return channels;
    }

    private void _saveToSPLocked(SharedPreferences sp) {
        if (sp == null) {
            return;
        }
        SharedPreferences.Editor editor = sp.edit();
        if (editor == null) {
            return;
        }
        editor.putInt(KEY_NET_TYPE, this.mNetType);
        JSONArray jsonChannels = new JSONArray();
        for (Map.Entry<String, Channel> entry : this.mChannelMap.entrySet()) {
            Channel channel = entry.getValue();
            JSONObject jsonChannel = Channel.toJson(channel);
            if (jsonChannel == null) continue;
            jsonChannels.put((Object)jsonChannel);
        }
        editor.putString(ChannelSelect.channelKey(), jsonChannels.toString());
        editor.apply();
    }

    private static class Channel {
        private final int mApiVersion;
        private final String mHost;
        private long mNetCost;
        private long mLastUpdateTime;

        Channel(int apiVersion, String hostStr) {
            this.mApiVersion = apiVersion;
            this.mHost = hostStr;
            this.mNetCost = 0L;
            this.mLastUpdateTime = 0L;
        }

        @Nullable
        static Channel parse(@Nullable JSONObject object) {
            if (object == null) {
                return null;
            }
            int apiVersion = object.optInt("apiVersion");
            String host = object.optString("host");
            if (apiVersion >= 0 && !TextUtils.isEmpty((CharSequence)host)) {
                Channel channel = new Channel(apiVersion, host);
                channel.mNetCost = object.optLong("netCost", 0L);
                return channel;
            }
            return null;
        }

        @Nullable
        static JSONObject toJson(@Nullable Channel channel) {
            if (channel == null) {
                return null;
            }
            if (TextUtils.isEmpty((CharSequence)channel.mHost)) {
                return null;
            }
            JSONObject object = new JSONObject();
            try {
                object.put("host", (Object)channel.mHost);
                object.put("apiVersion", channel.mApiVersion);
                object.put("netCost", channel.mNetCost);
                return object;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        void setHostCost(long costInMS, long updateTime) {
            if (costInMS <= 0L) {
                return;
            }
            this.mNetCost = costInMS;
            this.mLastUpdateTime = updateTime;
        }

        void reset() {
            this.mNetCost = 0L;
            this.mLastUpdateTime = 0L;
        }
    }
}

