/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.preload;

import android.text.TextUtils;
import com.ss.ttvideoengine.preload.PreloadTaskConfig;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PreloadScene {
    public String mSceneId = null;
    public int mAutoPlay = 0;
    public int mMute = 0;
    public int mMaxVisibleCardCnt = 1;
    private String mConfigString = null;
    private String mAlgorithmName = null;
    private List<PreloadTaskConfig> configs = null;

    public PreloadScene(String sceneId) {
        this.mSceneId = sceneId;
    }

    public void setConfigs(List<PreloadTaskConfig> configs) {
        this.configs = configs;
    }

    public void setConfigJsonString(String jsonString) {
        this.mConfigString = jsonString;
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(jsonString);
            this.mAlgorithmName = obj.getJSONObject("preload_strategy").getString("name");
        }
        catch (JSONException e) {
            TTVideoEngineLog.i("Scene", e.toString());
        }
    }

    public void setAlgorithmName(String algorithmName) {
        this.mAlgorithmName = algorithmName;
    }

    public String toJsonString() {
        HashMap<String, Object> temMap = new HashMap<String, Object>();
        temMap.put("scene_id", this.mSceneId);
        temMap.put("auto_play", this.mAutoPlay);
        temMap.put("mute", this.mMute);
        temMap.put("card_cnt", this.mMaxVisibleCardCnt);
        temMap.put("json", this.mConfigString);
        return new JSONObject(temMap).toString();
    }
}

