/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategrycenter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.strategrycenter.StrategyHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class StrategyEvent {
    private static final String TAG = "StrategyEvent";
    public static final String LOG_KEY_THROWS = "st_throws";
    public static final String LOG_KEY_PLAY_TASK_CONTROL = "st_play_task_op";
    public static final String LOG_KEY_PRELOAD = "st_preload";
    public static final String LOG_KEY_BUFFER_DURATION = "st_buf_dur";
    public static final String LOG_KEY_PRELOAD_PERSONALIZED = "st_preload_personalized";
    public static final String LOG_KEY_ADAPTIVE_RANGE = "st_adaptive_range";
    public static final String LOG_KEY_REMAINING_BUFFER_DURATION = "st_remaining_buf_dur";
    public static final String LOG_KEY_PRELOAD_FINISHED_TIME = "st_preload_finished_time";
    public static final String LOG_KEY_BANDWIDTH_RANGE = "st_band_range";
    public static final String LOG_KEY_COMMON_EVENT_LOG = "st_common";
    public static final String LOG_KEY_PRELOAD_DECISION_INFO = "st_preload_decision";
    public static final String LOG_KEY_PRELOAD_STRATEGY = "st_preload_sc_info";
    private static final String PAUSE = "pause";
    private static final String RESUME = "resume";
    private static final String RANGE = "range";
    private static final String RANGE_DURATION = "range_dur";
    private static final String SEEKLABEL = "seek_label";
    private static final String FIRST_BLOCK_DECISION_TIME = "first_block_decision_time";
    private static final String FIRST_BLOCK_EXEC_TIME = "first_block_exec_time";
    private static final String EST_PLAYTIME = "est_play";
    private static final String SMART_LEVEL = "smart_level";
    private static final String LOG_KEY_STARTUP_BUFFER_DURATION = "startup_buf_dur";
    private static final String LOG_KEY_RE_BUFFER_DURATION_INITIAL = "rebuf_dur_init";
    private static final String LOG_KEY_PLAY_BUFFER_DIFF_COUNT = "diff_ret_count";
    private static final String LOG_KEY_STARTUP_CACHE_SIZE = "startup_cache";
    private static final String LOG_KEY_LOAD_CONTROL_VERSION = "lc_version";
    private static final String LOG_KEY_LOAD_CONTROL_SLIDING_WINDOW = "sliding_window";
    private static final String LOG_KEY_PRELOAD_PERSONALIZED_OPTION = "preload_personalized_option";
    private static final String LOG_KEY_WATCH_DURATION_LABEL = "watch_duration_label";
    private static final String LOG_KEY_STALL_LABEL = "stall_label";
    private static final String LOG_KEY_FIRST_FRAME_LABEL = "first_frame_label";
    private static final String LOG_KEY_ADAPTIVE_RANGE_ENABLED = "enabled";
    private static final String LOG_KEY_ADAPTIVE_RANGE_BUFFER_LOG = "buffer_log";
    private static final String LOG_KEY_CURRENT_BANDWIDTH = "current_bandwidth";
    private static final String LOG_KEY_BANDWIDTH_BITRATE_RATIO = "band_bitrate_ratio";
    private static final String LOG_KEY_MODULE_ACTIVATED = "module_activated";
    private final ConcurrentMap<String, ConcurrentMap<String, Object>> mVidMap = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();
    private final ConcurrentMap<String, Object> mNoVidMap = new ConcurrentHashMap<String, Object>();
    private final Queue<Map<String, Object>> mUnexpectedThrowables = new ConcurrentLinkedQueue<Map<String, Object>>();

    @NonNull
    private static Map<String, Object> convertCounterMap(@NonNull Map<String, Object> map) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                retMap.put(entry.getKey(), StrategyEvent.convertCounterMap((Map)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof AtomicInteger) {
                retMap.put(entry.getKey(), ((AtomicInteger)entry.getValue()).get());
                continue;
            }
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    @NonNull
    private static ConcurrentMap<String, Object> putIfAbsentAndGetMap(@NonNull ConcurrentMap<String, Object> map, String key) {
        map.putIfAbsent(key, new ConcurrentHashMap());
        return (ConcurrentMap)map.get(key);
    }

    @Nullable
    public Map<String, Object> getLogData(String videoId) {
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            return null;
        }
        Map<String, Object> retMap = (Map<String, Object>)this.mVidMap.get(videoId);
        retMap = retMap != null ? StrategyEvent.convertCounterMap(retMap) : new HashMap<String, Object>();
        retMap.putAll(this.mNoVidMap);
        String preloadStrategyInfo = StrategyHelper.helper().getCenter().getStringValue(31301, videoId);
        if (!TextUtils.isEmpty((CharSequence)preloadStrategyInfo)) {
            retMap.put(LOG_KEY_PRELOAD_STRATEGY, preloadStrategyInfo);
        }
        if (!this.mUnexpectedThrowables.isEmpty()) {
            retMap.put(LOG_KEY_THROWS, this.mUnexpectedThrowables);
            this.mUnexpectedThrowables.clear();
        }
        TTVideoEngineLog.i(TAG, "vid: " + videoId + ", gotten log data: " + retMap);
        return retMap;
    }

    @Nullable
    public Map<String, Object> getLogData(String videoId, String key) {
        if (TextUtils.isEmpty((CharSequence)videoId) || TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (key.equals(LOG_KEY_PLAY_TASK_CONTROL)) {
            Map<String, Object> retMap = null;
            Map onePlayDict = (Map)((ConcurrentMap)this.mVidMap.get(videoId)).get(key);
            if (onePlayDict != null) {
                retMap = StrategyEvent.convertCounterMap(onePlayDict);
            }
            return retMap;
        }
        return null;
    }

    public void removeLogData(String videoId) {
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            return;
        }
        this.mVidMap.remove(videoId);
    }

    public void event(final @Nullable String id, final int key, final int value, final @Nullable String logInfo) {
        try {
            this.eventImpl(id, key, value, logInfo);
        }
        catch (Throwable e) {
            this.mUnexpectedThrowables.add((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("id", id);
                    this.put("key", key);
                    this.put("value", value);
                    this.put("logInfo", logInfo);
                    this.put("throwable", e.toString());
                }
            });
        }
    }

    private void eventImpl(@Nullable String id, int key, int value, @Nullable String logInfo) {
        ConcurrentMap map;
        if (!TextUtils.isEmpty((CharSequence)id) && !"unknown".equalsIgnoreCase(id)) {
            this.mVidMap.putIfAbsent(id, new ConcurrentHashMap());
            map = (ConcurrentMap)this.mVidMap.get(id);
        } else {
            map = this.mNoVidMap;
        }
        block9 : switch (key) {
            case 2000: {
                map.putIfAbsent((String)LOG_KEY_PLAY_TASK_CONTROL, new ConcurrentHashMap());
                ConcurrentMap onePlayDict = (ConcurrentMap)map.get(LOG_KEY_PLAY_TASK_CONTROL);
                switch (value) {
                    case 1: {
                        onePlayDict.putIfAbsent(PAUSE, new AtomicInteger());
                        ((AtomicInteger)onePlayDict.get(PAUSE)).incrementAndGet();
                        break block9;
                    }
                    case 2: {
                        onePlayDict.putIfAbsent(RESUME, new AtomicInteger());
                        ((AtomicInteger)onePlayDict.get(RESUME)).incrementAndGet();
                        break block9;
                    }
                    case 4: {
                        onePlayDict.putIfAbsent(RANGE, new AtomicInteger());
                        ((AtomicInteger)onePlayDict.get(RANGE)).incrementAndGet();
                        break block9;
                    }
                    case 5: {
                        if (logInfo == null) {
                            TTVideoEngineLog.e(TAG, "PLAY_TASK_RANGE_DURATION: logInfo is null");
                            break block9;
                        }
                        try {
                            onePlayDict.put(RANGE_DURATION, new JSONObject(logInfo));
                        }
                        catch (JSONException e) {
                            TTVideoEngineLog.w(TAG, "PLAY_TASK_RANGE_DURATION:\n" + (Object)((Object)e));
                            onePlayDict.put(RANGE_DURATION, logInfo);
                        }
                        break block9;
                    }
                    case 100: {
                        onePlayDict.put(SEEKLABEL, logInfo);
                        break block9;
                    }
                    case 101: {
                        try {
                            onePlayDict.put(FIRST_BLOCK_DECISION_TIME, Long.parseLong(logInfo));
                        }
                        catch (NumberFormatException e) {
                            TTVideoEngineLog.e(TAG, "PLAY_TASK_FIRST_BLOCK_DECISION_TIME:\n" + e);
                            onePlayDict.put(FIRST_BLOCK_DECISION_TIME, logInfo);
                        }
                        break block9;
                    }
                    case 102: {
                        try {
                            onePlayDict.put(FIRST_BLOCK_EXEC_TIME, Long.parseLong(logInfo));
                        }
                        catch (NumberFormatException e) {
                            TTVideoEngineLog.e(TAG, "PLAY_TASK_FIRST_BLOCK_EXEC_TIME:\n" + e);
                            onePlayDict.put(FIRST_BLOCK_EXEC_TIME, logInfo);
                        }
                        break block9;
                    }
                    case 103: {
                        try {
                            onePlayDict.put(EST_PLAYTIME, Long.parseLong(logInfo));
                        }
                        catch (NumberFormatException e) {
                            TTVideoEngineLog.e(TAG, "EST_PLAYTIME:\n" + e);
                            onePlayDict.put(EST_PLAYTIME, logInfo);
                        }
                        break block9;
                    }
                    case 104: {
                        onePlayDict.put(SMART_LEVEL, logInfo);
                        break block9;
                    }
                }
                break;
            }
            case 2001: {
                if (TextUtils.isEmpty((CharSequence)logInfo)) break;
                StrategyEvent.putIfAbsentAndGetMap(this.mNoVidMap, LOG_KEY_PRELOAD).put("name", logInfo);
                break;
            }
            case 2018: {
                if (TextUtils.isEmpty((CharSequence)logInfo)) break;
                StrategyEvent.putIfAbsentAndGetMap(this.mNoVidMap, LOG_KEY_PRELOAD).put("scene", logInfo);
                break;
            }
            case 2002: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_BUFFER_DURATION).put(LOG_KEY_RE_BUFFER_DURATION_INITIAL, value);
                break;
            }
            case 2003: {
                ConcurrentMap<String, Object> bufferDurationMap = StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_BUFFER_DURATION);
                bufferDurationMap.put(LOG_KEY_STARTUP_BUFFER_DURATION, value);
                if (logInfo == null) break;
                try {
                    bufferDurationMap.put(LOG_KEY_STARTUP_CACHE_SIZE, new JSONObject(logInfo));
                }
                catch (JSONException e) {
                    TTVideoEngineLog.w(TAG, "LOG_KEY_STARTUP_CACHE_SIZE:\n" + (Object)((Object)e));
                    bufferDurationMap.put(LOG_KEY_STARTUP_CACHE_SIZE, logInfo);
                }
                break;
            }
            case 2011: {
                Map bufferDurationMap = (Map)map.get(LOG_KEY_BUFFER_DURATION);
                if (bufferDurationMap == null) break;
                Integer cnt = (Integer)bufferDurationMap.get(LOG_KEY_PLAY_BUFFER_DIFF_COUNT);
                if (cnt == null) {
                    cnt = 0;
                }
                cnt = cnt + value;
                bufferDurationMap.put(LOG_KEY_PLAY_BUFFER_DIFF_COUNT, cnt);
                break;
            }
            case 2016: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_BUFFER_DURATION).put(LOG_KEY_LOAD_CONTROL_VERSION, value);
                break;
            }
            case 2017: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_BUFFER_DURATION).put(LOG_KEY_LOAD_CONTROL_SLIDING_WINDOW, value);
                break;
            }
            case 2004: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_PRELOAD_PERSONALIZED).put(LOG_KEY_PRELOAD_PERSONALIZED_OPTION, value);
                break;
            }
            case 2005: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_PRELOAD_PERSONALIZED).put(LOG_KEY_WATCH_DURATION_LABEL, value);
                break;
            }
            case 2006: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_PRELOAD_PERSONALIZED).put(LOG_KEY_STALL_LABEL, value);
                break;
            }
            case 2007: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_PRELOAD_PERSONALIZED).put(LOG_KEY_FIRST_FRAME_LABEL, value);
                break;
            }
            case 2008: {
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_ADAPTIVE_RANGE).put(LOG_KEY_ADAPTIVE_RANGE_ENABLED, value);
                break;
            }
            case 2009: {
                Object info;
                if (logInfo == null) {
                    TTVideoEngineLog.e(TAG, "EVENT_ADAPTIVE_RANGE_BUFFER: logInfo is null");
                    break;
                }
                try {
                    info = new JSONObject(logInfo);
                }
                catch (JSONException e) {
                    TTVideoEngineLog.w(TAG, "EVENT_ADAPTIVE_RANGE_BUFFER:\n" + (Object)((Object)e));
                    info = logInfo;
                }
                StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_ADAPTIVE_RANGE).put(LOG_KEY_ADAPTIVE_RANGE_BUFFER_LOG, info);
                break;
            }
            case 2010: {
                map.put((String)LOG_KEY_REMAINING_BUFFER_DURATION, value);
                break;
            }
            case 2012: {
                try {
                    map.put((String)LOG_KEY_PRELOAD_FINISHED_TIME, Long.parseLong(logInfo));
                }
                catch (NumberFormatException e) {
                    TTVideoEngineLog.e(TAG, "EVENT_PLAY_RELATED_PRELOAD_FINISHED:\n" + e);
                    map.put(LOG_KEY_PRELOAD_FINISHED_TIME, logInfo);
                }
                break;
            }
            case 2013: {
                ConcurrentMap<String, Object> bandwidthRangeMap = StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_BANDWIDTH_RANGE);
                bandwidthRangeMap.put(LOG_KEY_CURRENT_BANDWIDTH, value);
                try {
                    bandwidthRangeMap.put(LOG_KEY_BANDWIDTH_BITRATE_RATIO, Float.valueOf(Float.parseFloat(logInfo)));
                }
                catch (NumberFormatException e) {
                    TTVideoEngineLog.e(TAG, "LOG_KEY_BANDWIDTH_BITRATE_RATIO:\n" + e);
                    bandwidthRangeMap.put(LOG_KEY_BANDWIDTH_BITRATE_RATIO, logInfo);
                }
                break;
            }
            case 2014: {
                this.mNoVidMap.put(LOG_KEY_COMMON_EVENT_LOG, Collections.singletonMap(LOG_KEY_MODULE_ACTIVATED, value));
                break;
            }
            case 2015: {
                if (logInfo == null) break;
                try {
                    StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_PRELOAD_DECISION_INFO).put("info", new JSONObject(logInfo));
                    break;
                }
                catch (JSONException e) {
                    TTVideoEngineLog.w(TAG, "LOG_KEY_PRELOAD_DECISION_INFO:\n" + (Object)((Object)e));
                    StrategyEvent.putIfAbsentAndGetMap(map, LOG_KEY_PRELOAD_DECISION_INFO).put("info", logInfo);
                }
            }
        }
    }
}

