/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule.utils;

import android.util.Log;
import com.bytedance.vcloud.cacheModule.CacheModule;
import java.util.HashMap;
import java.util.Map;

public class CmLog {
    private static final String TAG = "PlaylistCacheModule";
    private static final String FORMAT = "<%s>%s";
    private static final Map<LogLevel, Boolean> sLogLevelMap = new HashMap<LogLevel, Boolean>();

    public static void turnLogLevel(LogLevel level, boolean on) {
        sLogLevelMap.put(level, on);
        if (CacheModule.loadLibrary()) {
            CmLog._turnLogLevel(level.ordinal(), on);
        }
    }

    public static void v(String tag, String msg) {
        if (sLogLevelMap.get((Object)LogLevel.V) == Boolean.TRUE) {
            Log.v((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void d(String tag, String msg) {
        if (sLogLevelMap.get((Object)LogLevel.D) == Boolean.TRUE) {
            Log.d((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void i(String tag, String msg) {
        if (sLogLevelMap.get((Object)LogLevel.I) == Boolean.TRUE) {
            Log.i((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void w(String tag, String msg) {
        if (sLogLevelMap.get((Object)LogLevel.W) == Boolean.TRUE) {
            Log.w((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void e(String tag, String msg) {
        if (sLogLevelMap.get((Object)LogLevel.E) == Boolean.TRUE) {
            Log.e((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    private static native void _turnLogLevel(int var0, boolean var1);

    static {
        sLogLevelMap.put(LogLevel.E, true);
        sLogLevelMap.put(LogLevel.W, true);
        sLogLevelMap.put(LogLevel.I, false);
        sLogLevelMap.put(LogLevel.D, false);
        sLogLevelMap.put(LogLevel.V, false);
    }

    public static enum LogLevel {
        V,
        D,
        I,
        W,
        E;

    }
}

