/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import com.bytedance.vcloud.cacheModule.CacheModule;
import com.bytedance.vcloud.cacheModule.CacheSettings;
import com.bytedance.vcloud.cacheModule.PlayTaskKeyManager;
import com.bytedance.vcloud.cacheModule.PlaylistLoader;
import com.bytedance.vcloud.cacheModule.PlaylistLoaderManager;
import com.ss.mediakit.medialoader.AVMDLDataLoader;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class DataLoaderHelperAdapter {
    private static final String TAG = "DataLoaderHelperAdapter";
    private PlaylistLoaderManager mPlaylistLoaderManager = null;

    public void onMDLStartComplete() {
        long urlGeneratorMethod = AVMDLDataLoader.getInstance().getLongValue(7425);
        TTVideoEngineLog.i(TAG, "MediaDataLoader start complete , urlGeneratorMethod = " + urlGeneratorMethod);
        if (urlGeneratorMethod == -1L || urlGeneratorMethod == 0L) {
            return;
        }
        CacheModule.setProxyUrlGenerator(urlGeneratorMethod);
    }

    public void setHLSCacheDir(String cacheDir) {
        CacheSettings.getInstance().setStringOption(CacheSettings.OptionKey.CACHE_DIR, cacheDir);
    }

    public void initHLSCacheModule() {
        this.mPlaylistLoaderManager = PlaylistLoaderManager.getInstance();
        this.mPlaylistLoaderManager.addLoaderListener(new PlaylistLoader.ILoaderListener(){

            @Override
            public void onStart(String url, AVMDLDataLoaderNotifyInfo info) {
                DataLoaderHelper.getDataLoader().onNotify(info);
            }

            @Override
            public void onCancel(String fileKey, String url) {
            }

            @Override
            public void onCompleted(String url, AVMDLDataLoaderNotifyInfo info) {
                DataLoaderHelper.getDataLoader().onNotify(info);
            }

            @Override
            public void onError(String url, AVMDLDataLoaderNotifyInfo info) {
                DataLoaderHelper.getDataLoader().onNotify(info);
            }
        });
    }

    public void convertHLSProxyUrl(StringBuffer proxyUrlBuffer) {
        if (this.mPlaylistLoaderManager != null) {
            proxyUrlBuffer.append("hlsproxy://");
        }
    }

    public boolean preloadHLSSource(String url, int size) {
        if (this.mPlaylistLoaderManager != null) {
            this.mPlaylistLoaderManager.preloadSource(url, size);
            return true;
        }
        return false;
    }

    public boolean cancelPreload(String key) {
        if (this.mPlaylistLoaderManager != null && this.mPlaylistLoaderManager.hasKey(key)) {
            this.mPlaylistLoaderManager.cancel(key);
            return true;
        }
        return false;
    }

    public boolean removeCacheFile(String key) {
        if (this.mPlaylistLoaderManager != null && !this.mPlaylistLoaderManager.hasKey(key)) {
            this.mPlaylistLoaderManager.removeFileCache(key);
            return true;
        }
        return false;
    }

    public long getAllCacheSize() {
        if (this.mPlaylistLoaderManager != null) {
            return this.mPlaylistLoaderManager.getAllCacheSize();
        }
        return 0L;
    }

    public long getCacheSize(String key) {
        if (this.mPlaylistLoaderManager != null) {
            return this.mPlaylistLoaderManager.getCacheSize(key);
        }
        return 0L;
    }

    public void cancelAll() {
        if (this.mPlaylistLoaderManager != null) {
            this.mPlaylistLoaderManager.cancelAll();
        }
    }

    public boolean onLoaderFail(AVMDLDataLoaderNotifyInfo info) {
        if (info.parameter == 2L && this.mPlaylistLoaderManager != null) {
            String[] temArray = info.logInfo.split(",");
            String fileKey = temArray[0];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(fileKey, PlaylistLoader.LoadStatus.Error, info);
        }
        return false;
    }

    public boolean onLoaderOpen(AVMDLDataLoaderNotifyInfo info) {
        if (info.parameter == 2L && this.mPlaylistLoaderManager != null) {
            String[] logInfos = info.logInfo.split(",");
            String fileKey = logInfos[0];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(fileKey, PlaylistLoader.LoadStatus.Start, info);
        }
        if (info.parameter == 1L) {
            String[] logInfos = info.logInfo.split(",");
            String fileKey = logInfos[0];
            PlayTaskKeyManager.getInstance().onPlayTaskOpen(fileKey);
        }
        return false;
    }

    public boolean onLoaderCancel(AVMDLDataLoaderNotifyInfo info) {
        if (this.mPlaylistLoaderManager != null) {
            String[] logInfos = info.logInfo.split(",");
            String fileKey = logInfos[0];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(fileKey, PlaylistLoader.LoadStatus.Cancel, info);
        }
        return false;
    }

    public boolean onLoaderEnd(AVMDLDataLoaderNotifyInfo info) {
        if (info.parameter == 2L && info.what == 4 && this.mPlaylistLoaderManager != null) {
            String[] temArray = info.logInfo.split(",");
            String key = temArray[2];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(key, PlaylistLoader.LoadStatus.Completed, info);
        }
        return false;
    }

    public boolean removeCache(String key) {
        if (this.mPlaylistLoaderManager != null) {
            return this.mPlaylistLoaderManager.removeFileCache(key);
        }
        return false;
    }

    public void removeAllHLSCache() {
        if (this.mPlaylistLoaderManager != null) {
            this.mPlaylistLoaderManager.clearAllPlaylistCache();
        }
    }
}

