/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorListener;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorMLConfig;
import com.ss.mediakit.fetcher.AVMDLNewFetcherMakerInterface;
import com.ss.mediakit.fetcher.AVMDLURLFetcherBridge;
import com.ss.mediakit.medialoader.AVMDLDataLoader;
import com.ss.mediakit.medialoader.LoaderListener;
import com.ss.texturerender.TextureRenderManager;
import com.ss.texturerender.VideoSurface;
import com.ss.ttm.player.AVThreadPool;
import com.ss.ttm.player.AudioProcessor;
import com.ss.ttm.player.ILibraryLoader;
import com.ss.ttm.player.IMediaDataSource;
import com.ss.ttm.player.LoadControl;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.PlaybackParams;
import com.ss.ttvideoengine.ABRListener;
import com.ss.ttvideoengine.AIBarrageSimpleCallback;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.CacheFilePathListener;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.DataLoaderListener;
import com.ss.ttvideoengine.DataLoaderListener2ForStrategyCenter;
import com.ss.ttvideoengine.DataLoaderResourceProvider;
import com.ss.ttvideoengine.DataSource;
import com.ss.ttvideoengine.DirectUrlItem;
import com.ss.ttvideoengine.EngineAdapter;
import com.ss.ttvideoengine.EngineGlobalConfig;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.InfoWrapper;
import com.ss.ttvideoengine.JniUtils;
import com.ss.ttvideoengine.MaskInfoListener;
import com.ss.ttvideoengine.MediaPlayerWrapper;
import com.ss.ttvideoengine.MediaTrackInfoModel;
import com.ss.ttvideoengine.PlayerEventSimpleListener;
import com.ss.ttvideoengine.PreloaderURLItem;
import com.ss.ttvideoengine.PreloaderVidItem;
import com.ss.ttvideoengine.PreloaderVideoModelItem;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.SARChangeListener;
import com.ss.ttvideoengine.SeekCompletionListener;
import com.ss.ttvideoengine.SnapshotListener;
import com.ss.ttvideoengine.StreamInfoListener;
import com.ss.ttvideoengine.SubDesInfoModelProvider;
import com.ss.ttvideoengine.SubInfoListener;
import com.ss.ttvideoengine.SubInfoSimpleCallBack;
import com.ss.ttvideoengine.SubModelProvider;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.TTVideoEngineFFmpegProtocol;
import com.ss.ttvideoengine.TTVideoEngineImpl;
import com.ss.ttvideoengine.TTVideoEngineInterface;
import com.ss.ttvideoengine.TTVideoEnginePlayItem;
import com.ss.ttvideoengine.TestNetSpeedListener;
import com.ss.ttvideoengine.VideoBufferDetailListener;
import com.ss.ttvideoengine.VideoBufferListener;
import com.ss.ttvideoengine.VideoEngineCallback;
import com.ss.ttvideoengine.VideoEngineGetInfoListener;
import com.ss.ttvideoengine.VideoEngineInfoListener;
import com.ss.ttvideoengine.VideoEngineListener;
import com.ss.ttvideoengine.VideoEngineSimpleCallback;
import com.ss.ttvideoengine.VideoFormatInfo;
import com.ss.ttvideoengine.VideoInfoListener;
import com.ss.ttvideoengine.VideoURLRouteListener;
import com.ss.ttvideoengine.cache.CopyCacheItem;
import com.ss.ttvideoengine.drm.DrmUtils;
import com.ss.ttvideoengine.fetcher.mdlfethcer.FetcherMakerNew;
import com.ss.ttvideoengine.httpdns.ByteDanceHttpDnsDepend;
import com.ss.ttvideoengine.httpdns.BytedanceHTTPDNSParser;
import com.ss.ttvideoengine.info.DeviceInfoVE;
import com.ss.ttvideoengine.info.HARInfo;
import com.ss.ttvideoengine.info.networkRTTLevelListener;
import com.ss.ttvideoengine.log.AppLogEngineUploader;
import com.ss.ttvideoengine.log.AppLogTOBVer2;
import com.ss.ttvideoengine.log.EventLoggerSource;
import com.ss.ttvideoengine.log.ExternVideoLoggerListener;
import com.ss.ttvideoengine.log.IVideoEventLogger;
import com.ss.ttvideoengine.log.IVideoEventUploader;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.metrics.IMediaMetrics;
import com.ss.ttvideoengine.model.DubbedInfo;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.SubInfo;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.net.HTTPDNS;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.preload.PreloadMedia;
import com.ss.ttvideoengine.preload.PreloadModelMedia;
import com.ss.ttvideoengine.preload.PreloadTaskConfig;
import com.ss.ttvideoengine.preload.PreloadURLMedia;
import com.ss.ttvideoengine.preloader.TTAVPreloaderItem;
import com.ss.ttvideoengine.selector.BestResolution;
import com.ss.ttvideoengine.selector.shift.SpeedShiftConfig;
import com.ss.ttvideoengine.selector.strategy.GearStrategyConfig;
import com.ss.ttvideoengine.selector.strategy.IGearStrategyListener;
import com.ss.ttvideoengine.setting.SettingsHelper;
import com.ss.ttvideoengine.strategrycenter.IPortraitService;
import com.ss.ttvideoengine.strategrycenter.IStrategyEventListener;
import com.ss.ttvideoengine.strategrycenter.IStrategyStateSupplier;
import com.ss.ttvideoengine.strategrycenter.StrategyCenter;
import com.ss.ttvideoengine.strategrycenter.StrategyHelper;
import com.ss.ttvideoengine.strategrycenter.StrategyKeys;
import com.ss.ttvideoengine.strategy.EngineStrategyListener;
import com.ss.ttvideoengine.strategy.StrategyManager;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import com.ss.ttvideoengine.superresolution.SRStrategyConfig;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.FormatProvider;
import com.ss.ttvideoengine.utils.Inspector;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.TTVideoEngineUtils;
import java.io.FileDescriptor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import okhttp3.OkHttpClient;
import org.json.JSONObject;

public class TTVideoEngine
implements TTVideoEngineInterface {
    private final TTVideoEngineInterface mVideoEngine;
    private static boolean HTTP_DNS_FIRST = false;
    private static int[] sDNSType;
    private static final String TAG = "TTVideoEngine";
    private static final String SDK_VERSION = "1.10.98.304-premium";
    private static final String OWN_PLAYER_LOADER_CLASS = "com.ss.ttm.player.TTPlayerLibLoader";
    private static boolean mForceUseLitePlayer;
    private static boolean mForceUsePluginPlayer;
    private static boolean mFallbackUseExoPlayer;
    private static GearStrategyConfig mGearStrategyConfig;
    private static HARInfo mHARInfo;
    private static int sRefactorFlag;
    static int sTestSpeedInterval;
    static int sTestSpeedSampleInterval;
    static int sIsReportTestSpeedInfo;
    static int sReportSpeedInfoMaxWindowSize;
    static int sNetSpeedAbrPredictType;
    static int sABRAlgorithmType;
    static int sABRSpeedPredictInputType;
    private static String[] mQualityInfos;
    private static FetcherMakerNew sFetcherMakerNew;
    static int sEnableGloablMuteFeature;
    static int sGlobalMute;

    public TTVideoEngine(Context context, int type) {
        TTVideoEngineLog.i(TAG, "init, type:" + type + ", this:" + this + ", version:" + SDK_VERSION);
        this.mVideoEngine = TTVideoEngine.createEngine(context, type, null, this);
    }

    public TTVideoEngine(Context context, int type, Map params) {
        TTVideoEngineLog.i(TAG, "init2, type:" + type + ", this:" + this + ", version:" + SDK_VERSION);
        this.mVideoEngine = TTVideoEngine.createEngine(context, type, params, this);
    }

    private static TTVideoEngineInterface createEngine(Context context, int type, Map params, TTVideoEngine engine) {
        return new TTVideoEngineImpl(context, type, params, engine);
    }

    public static synchronized void releaseTextureRender() {
        try {
            TextureRenderManager.getManager().release();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void setRadioMode(boolean on) {
        this.mVideoEngine.setRadioMode(on);
    }

    @Override
    public void setDisplayMode(View disPlayView, int disPlayMode) {
        this.mVideoEngine.setDisplayMode(disPlayView, disPlayMode);
    }

    @Override
    public Bitmap saveFrame() {
        return this.mVideoEngine.saveFrame();
    }

    @Override
    public void snapshot(SnapshotListener snapshotListener) {
        this.mVideoEngine.snapshot(snapshotListener);
    }

    @Override
    public boolean clearSurface(Surface surface, boolean async) {
        return this.mVideoEngine.clearSurface(surface, async);
    }

    @Override
    public void openTextureSR(boolean useSRTexture, boolean open) {
        this.mVideoEngine.openTextureSR(useSRTexture, open);
    }

    @Override
    public void setBarrageMaskUrl(String barrageMaskUrl) {
        this.mVideoEngine.setBarrageMaskUrl(barrageMaskUrl);
    }

    @Override
    public void setBarrageMaskUrlUseDataLoader(String barrageMaskUrl, String key) {
        this.mVideoEngine.setBarrageMaskUrlUseDataLoader(barrageMaskUrl, key);
    }

    @Override
    public void setAIBarrageUrl(String aiBarrageUrl) {
        this.mVideoEngine.setAIBarrageUrl(aiBarrageUrl);
    }

    @Override
    @Deprecated
    public void setSrMaxTexureSize(int maxTextureWidth, int maxTextureHeight) {
        this.mVideoEngine.setSrMaxTextureSize(maxTextureWidth, maxTextureHeight);
    }

    @Override
    public void setSrMaxTextureSize(int maxTextureWidth, int maxTextureHeight) {
        this.mVideoEngine.setSrMaxTextureSize(maxTextureWidth, maxTextureHeight);
    }

    @Override
    public void asyncInitSR(boolean asyncInit) {
        this.mVideoEngine.asyncInitSR(asyncInit);
    }

    @Override
    public void dynamicControlSR(boolean dynamicControl) {
        this.mVideoEngine.dynamicControlSR(dynamicControl);
    }

    @Override
    public void setSRInitConfig(int algType, String strKernelBinPath, String strOclModuleName, String strDspModuleName, int backend, int scaleType, int poolSize) {
        this.mVideoEngine.setSRInitConfig(algType, strKernelBinPath, strOclModuleName, strDspModuleName, backend, scaleType, poolSize);
    }

    @Override
    public void setSRInitConfig(int algType, String strKernelBinPath, String strOclModuleName, String strDspModuleName) {
        this.mVideoEngine.setSRInitConfig(algType, strKernelBinPath, strOclModuleName, strDspModuleName);
    }

    @Override
    public void setLensParams(Bundle bundle) {
        this.mVideoEngine.setLensParams(bundle);
    }

    @Override
    public void initSRStrategyConfig(SRStrategyConfig config) {
        this.mVideoEngine.initSRStrategyConfig(config);
    }

    @Override
    public void updateSRStrategyConfig(SRStrategyConfig config) {
        this.mVideoEngine.updateSRStrategyConfig(config);
    }

    @Override
    public boolean isplaybackUsedSR() {
        return this.mVideoEngine.isplaybackUsedSR();
    }

    @Override
    public void ignoreSRResolutionLimit(boolean ignore) {
        this.mVideoEngine.ignoreSRResolutionLimit(ignore);
    }

    @Override
    public void setEffect(Bundle bundle) {
        this.mVideoEngine.setEffect(bundle);
    }

    @Override
    public void setAutoRangeRead(int mdlReadMode, int autoRangeOffset) {
        this.mVideoEngine.setAutoRangeRead(mdlReadMode, autoRangeOffset);
    }

    @Override
    public void setBufferThresholdControl(int dangerThreshold, int secureThreshold) {
        this.mVideoEngine.setBufferThresholdControl(dangerThreshold, secureThreshold);
    }

    @Override
    public IMediaMetrics getMetrics(int metricsType) {
        return this.mVideoEngine.getMetrics(metricsType);
    }

    public static String getEngineVersion() {
        return SDK_VERSION;
    }

    public static void setForceUseLitePlayer(boolean force) {
        mForceUseLitePlayer = force;
    }

    public static boolean isForceUseLitePlayer() {
        return mForceUseLitePlayer;
    }

    public static void setForceUsePluginPlayer(boolean force) {
        mForceUsePluginPlayer = force;
    }

    public static boolean isForceUsePluginPlayer() {
        return mForceUsePluginPlayer;
    }

    public static void setFallbackUseExoPlayer(boolean useExoPlayer) {
        mFallbackUseExoPlayer = useExoPlayer;
    }

    public static boolean isFallbackUseExoPlayer() {
        return mFallbackUseExoPlayer;
    }

    public static void setVideoEventUploader(IVideoEventUploader uploader) {
        AppInfo.mUploader = uploader;
        DataLoaderHelper.getDataLoader().setUploader(uploader);
        VideoEventManager.instance.setUploader(uploader);
    }

    @Override
    public String getDubbedMemUrl(List<DubbedInfo> infos) {
        return this.mVideoEngine.getDubbedMemUrl(infos);
    }

    public static synchronized void setPlayerLibraryLoader(ILibraryLoader loader) {
        try {
            Class<?> clsz = TTHelper.getClzUsingPluginLoader(200, OWN_PLAYER_LOADER_CLASS);
            Method method = clsz.getDeclaredMethod("setLibraryLoader", ILibraryLoader.class);
            method.setAccessible(true);
            method.invoke(clsz, loader);
        }
        catch (Throwable e) {
            TTVideoEngineLog.e(TAG, "setPlayerLibraryLoader failed = " + e);
        }
    }

    @Override
    public void setLoadControl(LoadControl loadControl) {
        this.mVideoEngine.setLoadControl(loadControl);
    }

    @Override
    public void setMaskInfoListener(MaskInfoListener listener) {
        this.mVideoEngine.setMaskInfoListener(listener);
    }

    @Override
    public void setAIBarrageInfoListener(AIBarrageSimpleCallback listener) {
        this.mVideoEngine.setAIBarrageInfoListener(listener);
    }

    @Override
    @Nullable
    public String getSubtitleContentInfo(int queryTime) {
        return this.mVideoEngine.getSubtitleContentInfo(queryTime);
    }

    @Override
    public void setSubInfoListener(SubInfoListener listener) {
        this.mVideoEngine.setSubInfoListener(listener);
    }

    @Override
    public void setSubInfoCallBack(SubInfoSimpleCallBack callback) {
        this.mVideoEngine.setSubInfoCallBack(callback);
    }

    @Override
    public void setSubDesInfoModel(SubDesInfoModelProvider subDesInfoModel) {
        this.mVideoEngine.setSubDesInfoModel(subDesInfoModel);
    }

    @Override
    public void setAdditionSubModel(SubModelProvider subModel) {
        this.mVideoEngine.setAdditionSubModel(subModel);
    }

    public static void setAppInfo(Context context, Map infoMap) {
        if (infoMap != null && infoMap.size() > 0) {
            try {
                TTVideoEngineLog.d(TAG, "setAppInfo:" + infoMap.toString());
                AppInfo.mContext = context;
                AppInfo.mAppID = TTHelper.parseInt(infoMap.get("appid"));
                AppInfo.mAppName = (String)infoMap.get("appname");
                AppInfo.mAppChannel = (String)infoMap.get("appchannel");
                AppInfo.mAppVersion = (String)infoMap.get("appversion");
                if (infoMap.containsKey("screen_height")) {
                    AppInfo.mScreenHeight = (Integer)infoMap.get("screen_height");
                }
                if (infoMap.containsKey("screen_width")) {
                    AppInfo.mScreenWidth = (Integer)infoMap.get("screen_width");
                }
                JniUtils.loadLibrary();
                AppInfo.mRegion = (String)infoMap.get("region");
                AppInfo.mDeviceId = AppLogTOBVer2.getDeviceID();
                EngineAdapter.initDefaultEventUploader();
                StrategyHelper.helper().configAppInfo(AppInfo.toJsonString(), infoMap);
                EngineAdapter.initSettings(context);
                TTVideoEngine.setIntValue(1127, 1);
            }
            catch (Exception e) {
                TTVideoEngineLog.d(TAG, e.toString());
            }
        }
    }

    @Override
    public boolean isSupportHDR() {
        return this.mVideoEngine.isSupportHDR();
    }

    @Override
    public boolean isSupportSR() {
        return this.mVideoEngine.isSupportSR();
    }

    public static void initAppLog() {
    }

    @Override
    public String getPlayerSessionId() {
        return this.mVideoEngine.getPlayerSessionId();
    }

    @NonNull
    public static String getEngineUniqueId(Context context) {
        return DrmUtils.getEngineUniqueId(context);
    }

    public static String getDeviceID() {
        return InfoWrapper.getDeviceID();
    }

    @Override
    public void setReportLogEnable(boolean reportLogEnable) {
        this.mVideoEngine.setReportLogEnable(reportLogEnable);
    }

    @Override
    public boolean isReportLogEnable() {
        return this.mVideoEngine.isReportLogEnable();
    }

    public static void setReportLogByEngine(boolean reportLogByEngine, Context context) {
        TTVideoEngineLog.i(TAG, "setReportLogByEngine " + reportLogByEngine);
        if (context == null) {
            TTVideoEngineLog.e(TAG, "setReportLogByEngine context is null");
            return;
        }
        AppLogEngineUploader.getInstance().setReportLogByEngine(reportLogByEngine, context.getApplicationContext());
    }

    @Deprecated
    public static void onResume() {
        TTVideoEngineLog.d(TAG, "onResume");
    }

    @Deprecated
    public static void onPause() {
        TTVideoEngineLog.d(TAG, "onPause");
    }

    public static void setDNSType(int mainDNS, int backupDNS) {
        sDNSType = new int[]{mainDNS, backupDNS};
        TTVideoEngineLog.i(TAG, "setDNSType main:" + mainDNS + " backup:" + backupDNS);
    }

    public static void setTTDNSServerHost(String host) {
        HTTPDNS.setTTDNSServerHost(host);
    }

    public static void enableTLSv1_2(boolean enable) {
        TTHTTPNetwork.enableTLSv1_2(enable);
    }

    public static int[] getDNSType() {
        return sDNSType;
    }

    public static void setHTTPDNSFirst(boolean isHTTPDNSFirst) {
        HTTP_DNS_FIRST = isHTTPDNSFirst;
    }

    public static boolean isHttpDnsFirst() {
        return HTTP_DNS_FIRST;
    }

    public static void onlyUseMediaLoader(boolean only) {
        EngineGlobalConfig.getInstance().onlyUseMediaLoader(only);
    }

    @Deprecated
    public static void setUsingTTNETHttpDns(boolean isUsingTTNETHttpDns) {
    }

    @Deprecated
    public static boolean isUsingTTNETHttpDns() {
        return false;
    }

    @Deprecated
    public static void setExpiredIpEnable(boolean isExpiredIPEnable) {
    }

    @Deprecated
    public static boolean isExpiredIpEnable() {
        return false;
    }

    @Deprecated
    public static void setSettingConfig(Context context, Map<String, Object> configParameter) {
    }

    public static String computeMD5(String origin) {
        String result = "";
        try {
            result = origin;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(origin.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception exception) {
            return result;
        }
    }

    public static void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        TTVideoEngineLog.i(TAG, "set threadpool");
        EngineThreadPool.setExecutorInstance(executor);
    }

    public static void setPlayerThreadPoolExecutor(ExecutorService executor) {
        TTVideoEngineLog.i(TAG, "set player threadpool");
        AVThreadPool.setExecutorInstance((ExecutorService)executor);
    }

    @Override
    public EventLoggerSource getVideoEngineDataSource() {
        return this.mVideoEngine.getVideoEngineDataSource();
    }

    @Override
    public void setPlayInfo(int key, long value) {
        this.mVideoEngine.setPlayInfo(key, value);
    }

    @Override
    public void setFileCacheDir(String dir) {
    }

    @Override
    public void setDefaultFileCacheDir(String dir) {
    }

    @Override
    public void setSurface(Surface surface) {
        this.mVideoEngine.setSurface(surface);
    }

    @Override
    public void setExtraSurface(Surface surface, int operate) {
        this.mVideoEngine.setExtraSurface(surface, operate);
    }

    @Override
    public Surface getSurface() {
        return this.mVideoEngine.getSurface();
    }

    @Override
    public VideoSurface getTextureSurface() {
        return this.mVideoEngine.getTextureSurface();
    }

    @Override
    public void setRotation(int rotation) {
        this.mVideoEngine.setRotation(rotation);
    }

    @Override
    public int getRotation() {
        return this.mVideoEngine.getRotation();
    }

    @Override
    public void setMirrorHorizontal(boolean isMirror) {
        this.mVideoEngine.setMirrorHorizontal(isMirror);
    }

    @Override
    public boolean getMirrorHorizontal() {
        return this.mVideoEngine.getMirrorHorizontal();
    }

    @Override
    public void setMirrorVertical(boolean isMirror) {
        this.mVideoEngine.setMirrorVertical(isMirror);
    }

    @Override
    public boolean getMirrorVertical() {
        return this.mVideoEngine.getMirrorVertical();
    }

    @Override
    public void setSurfaceSync(Surface surface) {
        this.mVideoEngine.setSurfaceSync(surface);
    }

    @Override
    public void setSurfaceSync(Surface surface, long timeout) {
        this.mVideoEngine.setSurfaceSync(surface, timeout);
    }

    @Override
    public void setPlayerSurface(Surface surface, int forceUse, int isSyncMode) {
        this.mVideoEngine.setPlayerSurface(surface, forceUse, isSyncMode);
    }

    @Override
    public void setSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.mVideoEngine.setSurfaceHolder(surfaceHolder);
    }

    @Override
    public void setSurfaceHolder(SurfaceHolder surfaceHolder, boolean stop) {
        this.mVideoEngine.setSurfaceHolder(surfaceHolder, stop);
    }

    @Override
    public void setSurfaceHolderSync(SurfaceHolder surfaceHolder) {
        this.mVideoEngine.setSurfaceHolderSync(surfaceHolder);
    }

    @Override
    public void setCustomHeader(String key, String value) {
        this.mVideoEngine.setCustomHeader(key, value);
    }

    @Override
    public void setCacheControlEnabled(boolean enabled) {
        this.mVideoEngine.setCacheControlEnabled(enabled);
    }

    @Override
    public boolean getCacheControlEnabled() {
        return this.mVideoEngine.getCacheControlEnabled();
    }

    @Override
    public void setVolume(float left, float right) {
        this.mVideoEngine.setVolume(left, right);
    }

    @Override
    public float getMaxVolume() {
        return this.mVideoEngine.getMaxVolume();
    }

    @Override
    public float getVolume() {
        return this.mVideoEngine.getVolume();
    }

    @Override
    public void setIsMute(boolean isMute) {
        this.mVideoEngine.setIsMute(isMute);
    }

    @Override
    public boolean isMute() {
        return this.mVideoEngine.isMute();
    }

    @Override
    @Deprecated
    public int getAudioLatencytime() {
        return this.mVideoEngine.getAudioLatencyTime();
    }

    @Override
    public int getAudioLatencyTime() {
        return this.mVideoEngine.getAudioLatencyTime();
    }

    @Override
    @Deprecated
    public VideoModel getVideoModel() {
        return this.mVideoEngine.getVideoModel();
    }

    @Override
    public IVideoModel getIVideoModel() {
        return this.mVideoEngine.getIVideoModel();
    }

    @Override
    public void setStartTime(int msec) {
        this.mVideoEngine.setStartTime(msec);
    }

    @Override
    @Deprecated
    public void setListener(VideoEngineListener listener) {
        this.mVideoEngine.setListener(listener);
    }

    @Override
    @Deprecated
    public void setVideoEngineSimpleCallback(VideoEngineSimpleCallback simpleCallback) {
        this.mVideoEngine.setVideoEngineSimpleCallback(simpleCallback);
    }

    @Override
    public void setVideoEngineCallback(VideoEngineCallback videoEngineCallback) {
        this.mVideoEngine.setVideoEngineCallback(videoEngineCallback);
    }

    @Override
    public void setVideoInfoListener(VideoInfoListener listener) {
        this.mVideoEngine.setVideoInfoListener(listener);
    }

    @Override
    public void setVideoEngineInfoListener(VideoEngineInfoListener listener) {
        this.mVideoEngine.setVideoEngineInfoListener(listener);
    }

    @Override
    public void setVideoEngineGetInfoListener(VideoEngineGetInfoListener listener) {
        this.mVideoEngine.setVideoEngineGetInfoListener(listener);
    }

    @Override
    @Deprecated
    public void setVideoURLRouteListener(VideoURLRouteListener listener) {
        this.mVideoEngine.setVideoURLRouteListener(listener);
    }

    @Override
    public void setCacheFilePathListener(CacheFilePathListener listener) {
        this.mVideoEngine.setCacheFilePathListener(listener);
    }

    @Override
    @Deprecated
    public void setStreamInfoListener(StreamInfoListener listener) {
        this.mVideoEngine.setStreamInfoListener(listener);
    }

    @Override
    public void setExternLogListener(ExternVideoLoggerListener listener, String key) {
        this.mVideoEngine.setExternLogListener(listener, key);
    }

    @Override
    @Deprecated
    public void setVideoBufferListener(VideoBufferListener listener) {
        this.mVideoEngine.setVideoBufferListener(listener);
    }

    @Override
    @Deprecated
    public void setVideoBufferDetailListener(VideoBufferDetailListener listener) {
        this.mVideoEngine.setVideoBufferDetailListener(listener);
    }

    @Override
    @Deprecated
    public void setABRListener(ABRListener listener) {
        this.mVideoEngine.setABRListener(listener);
    }

    @Override
    @Deprecated
    public void setSARChangeListener(SARChangeListener listener) {
        this.mVideoEngine.setSARChangeListener(listener);
    }

    @Override
    public void setNetworkClient(TTVNetClient client) {
        this.mVideoEngine.setNetworkClient(client);
    }

    public static void setGlobalNetworkClient(TTVNetClient client) {
        TTVideoEngineConfig.gNetClient = client;
    }

    @Override
    public TTVNetClient getNetClientSetByUser() {
        return this.mVideoEngine.getNetClientSetByUser();
    }

    @Override
    public void setAudioProcessor(AudioProcessor processor) {
        this.mVideoEngine.setAudioProcessor(processor);
    }

    @Override
    public void setDecryptionKey(String decryptionKey) {
        this.mVideoEngine.setDecryptionKey(decryptionKey);
    }

    @Override
    public void setEncodedKey(String key) {
        this.mVideoEngine.setEncodedKey(key);
    }

    @Override
    public void setTokenUrlTemplate(String tokenUrlTemplate) {
        this.mVideoEngine.setTokenUrlTemplate(tokenUrlTemplate);
    }

    @Override
    public void setTTHlsDrmToken(String ttHlsDrmToken) {
        this.mVideoEngine.setTTHlsDrmToken(ttHlsDrmToken);
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.mVideoEngine.setDataSource(dataSource);
    }

    @Override
    public void setDataSource(FileDescriptor fd, long startOffset, long length) {
        this.mVideoEngine.setDataSource(fd, startOffset, length);
    }

    @Override
    public void setDataSource(IMediaDataSource datasource) {
        this.mVideoEngine.setDataSource(datasource);
    }

    @Override
    public List<String> getCacheKeys() {
        return this.mVideoEngine.getCacheKeys();
    }

    @Override
    public void forceDraw() {
        this.mVideoEngine.forceDraw();
    }

    @Override
    public String getVideoID() {
        return this.mVideoEngine.getVideoID();
    }

    @Override
    public boolean isPrepared() {
        return this.mVideoEngine.isPrepared();
    }

    @Override
    public boolean isReleased() {
        return this.mVideoEngine.isReleased();
    }

    @Override
    public StrategySource getStrategySource() {
        return this.mVideoEngine.getStrategySource();
    }

    @Override
    public void setStrategySource(StrategySource strategySource) {
        this.mVideoEngine.setStrategySource(strategySource);
    }

    public static void setStrategySources(List<StrategySource> strategySources) {
        StrategyManager.instance().setStrategySources(strategySources);
    }

    public static void addStrategySources(List<StrategySource> strategySources) {
        StrategyManager.instance().addStrategySources(strategySources);
    }

    public static void enableEngineStrategy(int type, int scene) {
        StrategyManager.instance().enable(type, scene);
    }

    public static void setEngineStrategyListener(EngineStrategyListener listener) {
        StrategyManager.instance().setListener(listener);
    }

    @Nullable
    public static TTVideoEngine getPreRenderEngine(StrategySource source) {
        return StrategyManager.instance().getPreRenderEngine(source);
    }

    @Nullable
    public static TTVideoEngine getPreRenderEngine(String vid) {
        return StrategyManager.instance().getPreRenderEngine(vid);
    }

    public static void clearAllStrategy() {
        StrategyManager.instance().clearAll();
    }

    public static void setFormatProvider(FormatProvider provider) {
        FormatProvider.FormatProviderHolder.set(provider);
    }

    @Override
    public void setVideoID(String videoID) {
        this.mVideoEngine.setVideoID(videoID);
    }

    @Override
    public void setLiveID(String liveID) {
        this.mVideoEngine.setVideoID(liveID);
    }

    @Override
    public void setPreloaderItem(TTAVPreloaderItem item) {
        this.mVideoEngine.setPreloaderItem(item);
    }

    @Override
    @Deprecated
    public void setVideoModel(VideoModel videoModel) {
        this.mVideoEngine.setVideoModel(videoModel);
    }

    @Override
    public void setVideoModel(IVideoModel videoModel) {
        this.mVideoEngine.setVideoModel(videoModel);
    }

    @Override
    public void setPlayItem(TTVideoEnginePlayItem playItem) {
        this.mVideoEngine.setPlayItem(playItem);
    }

    @Override
    public void setLocalURL(String url) {
        this.mVideoEngine.setLocalURL(url);
    }

    @Override
    public void setGroupID(String groupID) {
        this.mVideoEngine.setGroupID(groupID);
    }

    @Override
    public void initEngine(Context context, int type) {
    }

    @Override
    public void resetEngine() {
    }

    @Override
    public void refreshEnginePara(Context context, int type, Map params) {
        this.mVideoEngine.refreshEnginePara(context, type, params);
    }

    @Override
    public void resetByPool() {
        this.mVideoEngine.resetByPool();
    }

    @Override
    public void resetByPoolSyncPart() {
        this.mVideoEngine.resetByPoolSyncPart();
    }

    @Override
    public void setTag(String tag) {
        this.mVideoEngine.setTag(tag);
    }

    @Override
    public void setSubTag(String subTag) {
        this.mVideoEngine.setSubTag(subTag);
    }

    @Override
    public void setDirectURL(String url) {
        this.mVideoEngine.setDirectURL(url);
    }

    @Override
    public void setDirectURL(String url, String cachePath) {
        this.mVideoEngine.setDirectURL(url, cachePath);
    }

    @Override
    public void setDirectUrlUseDataLoader(String url, String key) {
        this.mVideoEngine.setDirectUrlUseDataLoader(url, key);
    }

    @Override
    public void setDirectUrlUseDataLoader(String url, String key, @Nullable String videoId) {
        this.mVideoEngine.setDirectUrlUseDataLoader(url, key, videoId);
    }

    @Override
    public void setDirectUrlUseDataLoader(String[] urls, String key) {
        this.mVideoEngine.setDirectUrlUseDataLoader(urls, key);
    }

    @Override
    public void setDirectUrlUseDataLoader(String[] urls, String key, @Nullable String videoId) {
        this.mVideoEngine.setDirectUrlUseDataLoader(urls, key, videoId);
    }

    @Override
    public void setDirectUrlUseDataLoaderByFilePath(String url, String filePath) {
        this.mVideoEngine.setDirectUrlUseDataLoaderByFilePath(url, filePath);
    }

    @Override
    public void setDirectUrlUseDataLoaderByFilePath(String[] urls, String filePath) {
        this.mVideoEngine.setDirectUrlUseDataLoaderByFilePath(urls, filePath);
    }

    @Override
    public void setDirectUrlUseDataLoaderByFilePath(String[] urls, String fileKey, String customDir) {
        this.mVideoEngine.setDirectUrlUseDataLoaderByFilePath(urls, fileKey, customDir);
    }

    @Override
    public void setDirectUrlUseDataLoader(DirectUrlItem urlItem) {
        this.mVideoEngine.setDirectUrlUseDataLoader(urlItem);
    }

    @Deprecated
    public static void setDataLoaderNetworkClient(TTVNetClient client) {
        DataLoaderHelper.getDataLoader().setNetworkClient(client);
    }

    public static void setDataLoaderListener(DataLoaderListener listener) {
        DataLoaderHelper.getDataLoader().setListener(listener);
    }

    public static void setLoaderEventListener(LoaderListener listener) {
        DataLoaderHelper.getDataLoader().setLoaderEventListener(listener);
    }

    public static void setApplicationContext(Context context) {
        DataLoaderHelper.getDataLoader().setContext(context);
    }

    public static void setClassLoader(ClassLoader classLoader) {
        DataLoaderHelper.getDataLoader().setClassLoader(classLoader);
    }

    public static void startDataLoader(Context context) throws Exception {
        DataLoaderHelper.getDataLoader().setContext(context);
        try {
            DataLoaderHelper.getDataLoader().start();
            TTVideoEngineLog.d(TAG, "DataLoader Start");
        }
        catch (Exception e) {
            TTVideoEngineLog.d(TAG, "DataLoader Start Fail");
            throw e;
        }
    }

    public static void setDefaultABRAlgorithm(int type) {
        sABRAlgorithmType = type;
    }

    public static void startIESSpeedPredictor(int type) {
        if (!FeatureManager.hasPermission("net_speed")) {
            return;
        }
        if (0 != StrategyHelper.helper().moduleSwitch(803)) {
            TTVideoEngineLog.i(TAG, "startIESSpeedPredictor, vod strategy speed predictor");
            return;
        }
        if (StrategyCenter.sNetSpeedPredictor != null) {
            return;
        }
        StrategyCenter.createSpeedPredictor(type);
        TTVideoEngine.setPredictorDataLoaderListener();
    }

    public static void startStartAndSelectGearSpeedPredictor(int type) {
        if (0 != StrategyHelper.helper().moduleSwitch(803)) {
            TTVideoEngineLog.i(TAG, "startStartAndSelectGearSpeedPredictor ,vod strategy speed predictor");
            return;
        }
        if (StrategyCenter.sNetSpeedPredictor != null) {
            return;
        }
        StrategyCenter.createNewStartAndSelectGearSpeedPredictor(type);
        TTVideoEngine.setPredictorDataLoaderListener();
    }

    public static void releaseStartAndSelectGearSpeedPredictor() {
        if (0 != StrategyHelper.helper().moduleSwitch(803)) {
            TTVideoEngineLog.i(TAG, "releaseStartAndSelectGearSpeedPredictor, vod strategy speed predictor");
            return;
        }
        StrategyCenter.closeNewStartAndSelectGearSpeedPredictor();
    }

    public static void setPredictorDataLoaderListener() {
        if (0 != StrategyHelper.helper().moduleSwitch(803)) {
            TTVideoEngineLog.i(TAG, "setPredictorDataLoaderListener, vod strategy speed predictor");
            return;
        }
        DataLoaderHelper.getDataLoader().addListener(DataLoaderListener2ForStrategyCenter.sInstance);
    }

    public static float getNetworkSpeedFromPredictor() {
        if (0 != StrategyHelper.helper().moduleSwitch(803)) {
            float speed = StrategyHelper.helper().getCenter().getFloatValue(20401, -1.0f);
            TTVideoEngineLog.i(TAG, " get network speed from vod strategy. info = " + speed);
            return speed;
        }
        if (StrategyCenter.sNetSpeedPredictor != null) {
            float speed = StrategyCenter.sNetSpeedPredictor.getPredictSpeed();
            DecimalFormat speedFormat = new DecimalFormat("#.000000000");
            String speedStr = speedFormat.format(speed);
            TTVideoEngineLog.d(TAG, "[IESSpeedPredictor] get network speed:" + speedStr);
            return speed;
        }
        return -1.0f;
    }

    public static void setSpeedPredictorMlConfig(ISpeedPredictorMLConfig mlConfig) {
        StrategyCenter.setSpeedPredictorMlConfig(mlConfig);
    }

    public static void setSpeedPredictorListener(ISpeedPredictorListener predictorListener) {
        StrategyCenter.setSpeedPredictorListener(predictorListener);
    }

    public static void setupNewSpeedPredictorConfigInfo(Map configInfo) {
        StrategyCenter.setConfigInfo(configInfo);
    }

    public static void startSpeedPredictor(int type, int intervalMs) {
        TTVideoEngine.startSpeedPredictor(type, intervalMs, 0, 0);
    }

    public static void startSpeedPredictor(int type, int intervalMs, int isReportTestSpeedInfo, int reportSpeedInfoMaxWindowSize) {
        if (!FeatureManager.hasPermission("net_speed")) {
            return;
        }
        if (StrategyCenter.sNetAbrSpeedPredictor != null) {
            return;
        }
        sNetSpeedAbrPredictType = type;
        sIsReportTestSpeedInfo = isReportTestSpeedInfo;
        sReportSpeedInfoMaxWindowSize = reportSpeedInfoMaxWindowSize;
        if (sABRSpeedPredictInputType == 0) {
            sABRSpeedPredictInputType = 1;
        }
        if (intervalMs > 0) {
            sTestSpeedInterval = intervalMs;
            sTestSpeedSampleInterval = intervalMs;
        }
        TTVideoEngineLog.d(TAG, "[ABR] abrSpeedPredictUpdateIntervalMs:" + intervalMs);
        StrategyCenter.createAbrSpeedPredictor(type, intervalMs);
    }

    public static void setupSpeedPredictorInputType(int type) {
        sABRSpeedPredictInputType = type;
        if (type == 2) {
            DataLoaderHelper.getDataLoader().setIntValue(112, 500);
        } else {
            DataLoaderHelper.getDataLoader().setIntValue(112, 0);
        }
    }

    public static int getSpeedPredictorInputType() {
        return sABRSpeedPredictInputType;
    }

    public static boolean dataLoaderIsRunning() {
        return DataLoaderHelper.getDataLoader().isRunning();
    }

    public static void copyDataLoaderCache(CopyCacheItem parameters) {
        DataLoaderHelper.getDataLoader().copyCache(parameters);
    }

    public static void closeDataLoader() {
        DataLoaderHelper.getDataLoader().close();
    }

    public static String proxyUrl(String key, String rawKey, String[] urls, Resolution resolution, String decryptionKey) {
        return DataLoaderHelper.getDataLoader().proxyUrl(key, rawKey, urls, resolution, decryptionKey);
    }

    public static void addTask(String key, PreloaderVidItem vidItem) {
        DataLoaderHelper.getDataLoader().addTask(key, vidItem);
    }

    public static void addTask(PreloaderVidItem vidItem) {
        DataLoaderHelper.getDataLoader().addTask(vidItem);
    }

    public static void addTask(PreloaderURLItem urlItem) {
        DataLoaderHelper.getDataLoader().addTask(urlItem);
    }

    public static void addTask(String key, String videoId, String url, long preloadSize) {
        DataLoaderHelper.getDataLoader().addTask(key, videoId, url, preloadSize);
    }

    public static void addTask(String url, String videoId, long preloadSize, String filePath) {
        DataLoaderHelper.getDataLoader().addTask(url, videoId, preloadSize, filePath);
    }

    public static void addTask(String key, String videoId, long preloadSize, DataLoaderResourceProvider provider) {
        DataLoaderHelper.getDataLoader().addTask(key, videoId, preloadSize, provider, null);
    }

    public static void addTask(String key, String videoId, long preloadSize, DataLoaderResourceProvider provider, String cacheDir) {
        DataLoaderHelper.getDataLoader().addTask(key, videoId, preloadSize, provider, cacheDir);
    }

    public static void addTask(String key, String videoId, String[] urls, long preloadSize) {
        DataLoaderHelper.getDataLoader().addTask(key, videoId, urls, preloadSize);
    }

    public static void addTask(String key, String videoId, String[] urls, long preloadSize, String cacheDir) {
        DataLoaderHelper.getDataLoader().addTask(key, videoId, urls, preloadSize, cacheDir);
    }

    public static void addTask(String[] urls, String videoId, long preloadSize, String filePath) {
        DataLoaderHelper.getDataLoader().addTask(urls, videoId, preloadSize, filePath);
    }

    @Deprecated
    public static void addTask(String key, String videoId, VideoModel videoModel, Resolution resolution, long preloadSize) {
        DataLoaderHelper.getDataLoader().addTask(key, videoId, videoModel, resolution, preloadSize);
    }

    public static void addTask(VideoModel videoModel, Resolution resolution, long preloadSize) {
        DataLoaderHelper.getDataLoader().addTask(videoModel, resolution, preloadSize);
    }

    public static void addTask(IVideoModel videoModel, Resolution resolution, long preloadSize) {
        DataLoaderHelper.getDataLoader().addTask(videoModel, resolution, preloadSize);
    }

    public static void addTask(PreloaderVideoModelItem item) {
        DataLoaderHelper.getDataLoader().addTask(item);
    }

    public static void addTask(VideoModel videoModel, Resolution resolution, Map<Integer, String> params, long preloadSize) {
        DataLoaderHelper.getDataLoader().addTask(videoModel, resolution, params, preloadSize);
    }

    public static void cancelPreloadTask(String key) {
        DataLoaderHelper.getDataLoader().cancelTask(key);
    }

    public static void cancelPreloadTaskByFilePath(String filePath) {
        DataLoaderHelper.getDataLoader().cancelTaskByFilePath(filePath);
    }

    public static void cancelPreloadTaskByVideoId(String vid) {
        DataLoaderHelper.getDataLoader().cancelTaskByVideoId(vid);
    }

    public static void cancelAllPreloadTasks() {
        TTVideoEngineLog.d(TAG, "<preload> cancel all preload task outside");
        DataLoaderHelper.getDataLoader().cancelAllTasks();
    }

    public static void cancelAllWaitReqs() {
        DataLoaderHelper.getDataLoader().cancelAllWaitReqs();
    }

    public static void removeCacheFile(String key) {
        DataLoaderHelper.getDataLoader().removeCacheFile(key);
    }

    public static void forceRemoveCacheFile(String key) {
        DataLoaderHelper.getDataLoader().forceRemoveCacheFile(key);
    }

    public static void enableAutoTrim(String key) {
        DataLoaderHelper.getDataLoader().enableAutoTrim(key);
    }

    public static void disableAutoTrim(String key) {
        DataLoaderHelper.getDataLoader().disableAutoTrim(key);
    }

    public static void setLongValue(int key, long value) {
        if (key == 217) {
            EngineGlobalConfig.getInstance().setALogWriteAddr(value);
        } else {
            DataLoaderHelper.getDataLoader().setLongValue(key, value);
        }
    }

    public static int writeDataToFile(String fileKey, long fileSize, long off, int length, byte[] buffer) {
        return DataLoaderHelper.getDataLoader().writeDataToFile(fileKey, fileSize, off, length, buffer);
    }

    public static void setIntValue(int key, int value) {
        TTVideoEngineLog.i(TAG, "TTVideoEngine.setIntValue key=" + key + " value=" + value);
        if (key == 672) {
            TTVideoEngineLog.i(TAG, "do set static render type, value = " + value);
            EngineGlobalConfig.getInstance().setRenderType(value);
        } else if (key == 674) {
            TTVideoEngineLog.i(TAG, "enable https for fetch");
            TTVideoEngineUtils.sEnableHTTPSForFetch = value;
        } else if (key == 112) {
            if (value > 0) {
                sABRSpeedPredictInputType = 2;
                DataLoaderHelper.getDataLoader().setIntValue(112, value);
            } else {
                sABRSpeedPredictInputType = 1;
                DataLoaderHelper.getDataLoader().setIntValue(112, 0);
            }
        } else if (key == 676) {
            StrategyCenter.setSpeedQueueSize(value);
        } else if (key == 702) {
            EngineGlobalConfig.getInstance().setOutputLogLevel(value);
            TTVideoEngineLog.d(TAG, "set log level" + value);
        } else if (key == 684) {
            sRefactorFlag = value;
        } else if (key == 960) {
            sEnableGloablMuteFeature = value;
            MediaPlayerWrapper.setGlobalIntOptionForKey(1015, value);
        } else if (key == 961) {
            sGlobalMute = value;
            MediaPlayerWrapper.setGlobalIntOptionForKey(1016, value);
        } else if (key == 689) {
            TTVideoEngineLog.i(TAG, "do set static enable cpp opt bvc1, value = " + value);
            EngineGlobalConfig.getInstance().setEnableCPPh265CodecOpt(value);
        } else if (key == 719) {
            EngineGlobalConfig.getInstance().setEnableBmf(value);
            TTVideoEngineLog.d(TAG, "enable bmf" + value);
        } else if (key == 720) {
            EngineGlobalConfig.getInstance().setEnableUseRealBitrate(value);
            TTVideoEngineLog.d(TAG, "set use realbitrate:" + value);
        } else {
            DataLoaderHelper.getDataLoader().setIntValue(key, value);
            StrategyKeys.setIntValue(key, value);
            StrategyHelper.helper().setIntValue(key, value);
        }
    }

    @Override
    public void setCacheInfoLists(String[] dirs, long[] maxCaches) {
        this.mVideoEngine.setCacheInfoLists(dirs, maxCaches);
    }

    public static void businessEvent(int key, int value) {
        StrategyHelper.helper().getCenter().businessEvent(key, value);
    }

    public static void businessEvent(int key, String value) {
        StrategyHelper.helper().getCenter().businessEvent(key, value);
    }

    public static void businessEvent(int appId, int key, int value) {
        StrategyHelper.helper().getCenter().businessEvent(appId, key, value);
    }

    public static void businessEvent(int appId, int key, String value) {
        StrategyHelper.helper().getCenter().businessEvent(appId, key, value);
    }

    public static void setStringValue(int key, String value) {
        SettingsHelper.helper().setRegionHost(key, value);
        DataLoaderHelper.getDataLoader().setStringValue(key, value);
        if (key == 122) {
            Inspector.share().setHost(value);
        }
    }

    public static String getStringValue(int key) {
        return DataLoaderHelper.getDataLoader().getStringValue(key);
    }

    public static DataLoaderHelper.DataLoaderCacheInfo getCacheInfo(String key) {
        return DataLoaderHelper.getDataLoader().getCacheInfo(key);
    }

    public static DataLoaderHelper.DataLoaderCacheInfo getCacheInfoByFilePath(String filePath) {
        return DataLoaderHelper.getDataLoader().getCacheInfoByFilePath(filePath);
    }

    public static long getCacheFileSize(String key) {
        return DataLoaderHelper.getDataLoader().getCacheSize(key);
    }

    public static long quickGetCacheFileSize(String key) {
        long size = DataLoaderHelper.getDataLoader().tryQuickGetCacheFileSize(key);
        if (size == 0L) {
            size = DataLoaderHelper.getDataLoader().getCacheSize(key);
        }
        return size;
    }

    public static long getCacheFileSizeByFilePath(String filePath) {
        return DataLoaderHelper.getDataLoader().getCacheSizeByFilePath(filePath);
    }

    public static void clearAllCaches() {
        DataLoaderHelper.getDataLoader().clearAllCaches();
    }

    public static void clearAllCaches(boolean force) {
        DataLoaderHelper.getDataLoader().clearAllCaches(force);
    }

    public static void openBytedanceHTTPDNS(ByteDanceHttpDnsDepend byteDanceHttpDnsDepend) {
        BytedanceHTTPDNSParser parser = new BytedanceHTTPDNSParser(byteDanceHttpDnsDepend);
        EngineGlobalConfig.getInstance().setDnsCustomType(parser.start());
    }

    public static void setIntValueSync(int key, int value) {
        DataLoaderHelper.getDataLoader().setIntValueSync(key, value);
    }

    public static void setStringValueSync(int key, String value) {
        DataLoaderHelper.getDataLoader().setStringValueSync(key, value);
    }

    @Override
    public void setPlayAuthToken(String authToken) {
        this.mVideoEngine.setPlayAuthToken(authToken);
    }

    @Override
    public void setSubAuthToken(String authToken) {
        this.mVideoEngine.setSubAuthToken(authToken);
    }

    @Override
    @Deprecated
    public void setPlayAuthToken(String authToken, int apiVersion) {
        this.mVideoEngine.setPlayAuthToken(authToken, apiVersion);
    }

    public static void preConnect(String url) {
        DataLoaderHelper.getDataLoader().preConnect(url);
    }

    public static void switchToCellularNetwork() {
        DataLoaderHelper.getDataLoader().switchToCellularNetwork();
    }

    public static void switchToDefaultNetwork() {
        DataLoaderHelper.getDataLoader().switchToDefaultNetwork();
    }

    public static void setProbeType(int probeType) {
        DataLoaderHelper.getDataLoader().setProbeType(probeType);
    }

    public static int getProbeType() {
        return DataLoaderHelper.getDataLoader().getProbeType();
    }

    public static void setProbeIntervalMS(int intervalMS) {
        DataLoaderHelper.getDataLoader().setProbeIntervalMS(intervalMS);
    }

    public static int getProbeIntervalMS() {
        return DataLoaderHelper.getDataLoader().getProbeIntervalMS();
    }

    public static void setPlayTaskProgress(float progress) {
        DataLoaderHelper.getDataLoader().setPlayTaskProgress(progress);
    }

    public static float playTaskProgress() {
        return DataLoaderHelper.getDataLoader().playTaskProgress();
    }

    public static void addPreloadURLMedia(PreloadURLMedia urlMedia) {
        DataLoaderHelper.getDataLoader().addPreloadUrlMedia(urlMedia);
    }

    public static void addPreloadModelMedia(PreloadModelMedia modelMedia) {
        DataLoaderHelper.getDataLoader().addPreloadModelMedia(modelMedia);
    }

    public static void addPriorityPreloadTask(PreloadModelMedia modelMedia) {
        DataLoaderHelper.getDataLoader().addPriorityPreloadTask(modelMedia);
    }

    public static void removePriorityPreloadTask(String key) {
        DataLoaderHelper.getDataLoader().removePriorityPreloadTask(key);
    }

    public static void addPreloadMedias(List<PreloadMedia> mediaList, String sceneId) {
        DataLoaderHelper.getDataLoader().addPreloadMedias(mediaList, sceneId);
    }

    public static void addPreloadModelMedia(PreloadModelMedia media, String sceneId) {
        media.mSceneId = sceneId;
        DataLoaderHelper.getDataLoader().addPreloadModelMedia(media);
    }

    public static void addPreloadMedias(List<PreloadMedia> mediaList) {
        DataLoaderHelper.getDataLoader().addPreloadMedias(mediaList, null);
    }

    public static void removePreloadMedia(PreloadMedia media, String sceneId) {
        DataLoaderHelper.getDataLoader().removePreloadMedia(media, sceneId);
    }

    public static void focusMedia(String videoId, int forceType) {
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            TTVideoEngineLog.i(TAG, "[strategy] focus media . videoId is null");
            return;
        }
        DataLoaderHelper.getDataLoader().focusMedia(videoId, forceType);
    }

    public static void removeAllPreloadMedia(String sceneId, int moveFlag) {
        DataLoaderHelper.getDataLoader().removeAllPreloadMedia(sceneId, moveFlag);
    }

    public static void removeAllPreloadMedia() {
        TTVideoEngine.removeAllPreloadMedia(null, 1);
    }

    public static void removeMedia(String mediaId, String sceneId) {
        DataLoaderHelper.getDataLoader().removeMedia(mediaId, sceneId);
    }

    public static void removeMedia(String mediaId) {
        DataLoaderHelper.getDataLoader().removeMedia(mediaId, "");
    }

    public static void setPreloadTaskConfigs(List<PreloadTaskConfig> taskConfigs) {
        DataLoaderHelper.getDataLoader().setTaskConfigs(taskConfigs);
    }

    public static void setStrategyStateSupplier(IStrategyStateSupplier supplier) {
        StrategyHelper.helper().setSupplier(supplier);
    }

    public static void setStrategyEventListener(IStrategyEventListener listener) {
        StrategyHelper.helper().setEventListener(listener);
    }

    public static void setPortraitService(IPortraitService service) {
        StrategyHelper.helper().setPortraitService(service);
    }

    public static boolean isStrategyCenterRunning() {
        return StrategyHelper.helper().isRunning();
    }

    public static void focusEngine(TTVideoEngine engine) {
        if (engine == null) {
            return;
        }
        TTVideoEngineLog.i(TAG, "[strategy] focus engine" + engine.getVideoID());
        TTVideoEngine.focusMedia(engine.getVideoID(), 1);
    }

    public static void setAlgorithmJson(int key, String jsonString) {
        StrategyHelper.helper().setAlgorithmJson(key, jsonString);
    }

    @Override
    @Nullable
    public Map<String, Object> getStrategyLogData(String key) {
        return this.mVideoEngine.getStrategyLogData(key);
    }

    @Nullable
    public static JSONObject getVodPreloadLabel(String key) {
        return SettingsHelper.helper().getVodJsonObject(key);
    }

    public static void configBoeSuffix(String boeSuffix) {
        TTHelper.configBoeSuffix(boeSuffix);
    }

    public static void setOkhttpCliet(OkHttpClient customClient) {
        AVMDLDataLoader.setOkhttpClient((OkHttpClient)customClient);
    }

    @Override
    public void setPlayAPIVersion(int apiVersion, String authorization) {
        this.mVideoEngine.setPlayAPIVersion(apiVersion, authorization);
    }

    @Override
    public void setPlaybackParams(PlaybackParams params) {
        this.mVideoEngine.setPlaybackParams(params);
    }

    @Override
    public void setAsyncInit(boolean enable, int codecid) {
        this.mVideoEngine.setAsyncInit(enable, codecid);
    }

    @Override
    public void setQcomVpp(boolean enable, int level) {
        this.mVideoEngine.setQcomVpp(enable, level);
    }

    @Override
    public void setCustomStr(String customStr) {
        this.mVideoEngine.setCustomStr(customStr);
    }

    @Override
    public void setCustomInfo(IVideoEventLogger.VideoEventCustomInfo key, Object value) {
        this.mVideoEngine.setCustomInfo(key, value);
    }

    @Override
    public void setStringOption(int key, String value) {
        this.mVideoEngine.setStringOption(key, value);
    }

    @Override
    public void setIntOption(int key, int value) {
        this.mVideoEngine.setIntOption(key, value);
    }

    @Override
    public void setFloatOption(int key, float value) {
        this.mVideoEngine.setFloatOption(key, value);
    }

    @Override
    public void setLongOption(int key, long value) {
        this.mVideoEngine.setLongOption(key, value);
    }

    @Override
    public int getIntOption(int key) {
        return this.mVideoEngine.getIntOption(key);
    }

    @Override
    public long getLongOption(int key) {
        return this.mVideoEngine.getLongOption(key);
    }

    @Override
    public float getFloatOption(int key) {
        return this.mVideoEngine.getFloatOption(key);
    }

    @Override
    public String getStringOption(int key) {
        return this.mVideoEngine.getStringOption(key);
    }

    @Override
    @Deprecated
    public int[] supportedSubtitleLangs() {
        return this.mVideoEngine.supportedSubtitleLangs();
    }

    @Override
    public List<SubInfo> supportedSubInfoList() {
        return this.mVideoEngine.supportedSubInfoList();
    }

    @Override
    public Resolution[] supportedResolutionTypes() {
        return this.mVideoEngine.supportedResolutionTypes();
    }

    @Override
    public String[] supportedQualityInfos() {
        return this.mVideoEngine.supportedQualityInfos();
    }

    public static void setAllQualityInfos(String[] qualityInfos) {
        mQualityInfos = qualityInfos;
    }

    public static String[] getAllQualityInfos() {
        return mQualityInfos;
    }

    @Override
    public void setExpectedParams(@NonNull Resolution resolution, @Nullable Map<Integer, String> params) {
        this.mVideoEngine.setExpectedParams(resolution, params);
    }

    @Override
    public void configParams(Resolution resolution, Map<Integer, String> params) {
        this.mVideoEngine.configParams(resolution, params);
    }

    @Override
    public void configResolution(Resolution resolution) {
        this.mVideoEngine.configResolution(resolution);
    }

    @Override
    public void setSpeedShiftConfig(SpeedShiftConfig speedShiftConfig) {
        this.mVideoEngine.setSpeedShiftConfig(speedShiftConfig);
    }

    public static void setHARInfo(HARInfo harInfo) {
        if (harInfo == null) {
            TTVideoEngineLog.i(TAG, "setHARInfo harInfo is null");
            return;
        }
        TTVideoEngineLog.i(TAG, String.format("setHARInfo status=%d score=%d", harInfo.getHARStatus(), harInfo.getHARScore()));
        mHARInfo = harInfo;
    }

    public static HARInfo getHARInfo() {
        return mHARInfo;
    }

    public static void setGearStrategyConfig(GearStrategyConfig config) {
        TTVideoEngineLog.i(TAG, "[GearStrategy]setGearStrategyConfig config=" + config);
        mGearStrategyConfig = config;
    }

    public static GearStrategyConfig getGearStrategyConfig() {
        return mGearStrategyConfig;
    }

    @Override
    public void setGearStrategyListener(IGearStrategyListener listener, Object userData) {
        this.mVideoEngine.setGearStrategyListener(listener, userData);
    }

    @Override
    public void setLoggerLongOption(int key, long value) {
        this.mVideoEngine.setLoggerLongOption(key, value);
    }

    @Override
    public void setLoggerIntOption(int key, int value) {
        this.mVideoEngine.setLoggerIntOption(key, value);
    }

    @Override
    public MediaTrackInfoModel[] getMediaTrackInfos() {
        return this.mVideoEngine.getMediaTrackInfos();
    }

    @Override
    public Resolution getCurrentResolution() {
        return this.mVideoEngine.getCurrentResolution();
    }

    @Override
    public String getCurrentQualityDesc() {
        return this.mVideoEngine.getCurrentQualityDesc();
    }

    @Override
    public Resolution getResolutionBeforeDowngrade() {
        return this.mVideoEngine.getResolutionBeforeDowngrade();
    }

    @Override
    public String getQualityDescBeforeDowngrade() {
        return this.mVideoEngine.getQualityDescBeforeDowngrade();
    }

    public static List<Resolution> findCachedResolutionList(VideoModel model, @Nullable Map<Integer, String> params) {
        ArrayList<Resolution> ret = new ArrayList<Resolution>();
        if (model == null) {
            return ret;
        }
        Resolution[] resolutions = model.getSupportResolutions();
        if (resolutions == null || resolutions.length < 1) {
            return ret;
        }
        VideoInfo info = null;
        long cacheSize = 0L;
        String mediaTypeStr = model.getVideoRefStr(7);
        int mediaType = TextUtils.isEmpty((CharSequence)mediaTypeStr) && mediaTypeStr.equals("audio") ? VideoRef.TYPE_AUDIO : VideoRef.TYPE_VIDEO;
        Resolution resolution = resolutions[0];
        Resolution[] resolutionArray = resolutions;
        int n = resolutionArray.length;
        for (int i = 0; i < n; ++i) {
            Resolution value;
            resolution = value = resolutionArray[i];
            info = model.getVideoInfo(resolution, mediaType, params, false);
            cacheSize = 0L;
            if (info == null || (cacheSize = DataLoaderHelper.getDataLoader().getCacheFileSize(info.getValueStr(15))) <= 0L || info.getResolution() == null) continue;
            ret.add(info.getResolution());
        }
        return ret;
    }

    public static long getCacheFileSize(VideoModel model, Resolution resolution) {
        return TTVideoEngine.getCacheFileSize((IVideoModel)model, resolution);
    }

    public static long getCacheFileSize(IVideoModel model, Resolution resolution) {
        return TTVideoEngine.getCacheFileSize(model, resolution, null);
    }

    public static long getCacheFileSize(VideoModel model, Resolution resolution, Map<Integer, String> params) {
        return TTVideoEngine.getCacheFileSize((IVideoModel)model, resolution, params);
    }

    public static long getCacheFileSize(IVideoModel model, Resolution resolution, Map<Integer, String> params) {
        long cacheFileSize = 0L;
        if (model != null && resolution != null) {
            VideoInfo info = null;
            info = model.getVideoInfo(resolution, VideoRef.TYPE_VIDEO, params, false);
            if (info != null) {
                cacheFileSize += DataLoaderHelper.getDataLoader().getCacheFileSize(info.getValueStr(15));
            }
            if ((info = model.getVideoInfo(resolution, VideoRef.TYPE_AUDIO, params, true)) != null) {
                cacheFileSize += DataLoaderHelper.getDataLoader().getCacheFileSize(info.getValueStr(15));
            }
        }
        return cacheFileSize;
    }

    public static Resolution findMaxQualityResolution(VideoModel model, Resolution defaultResolution) {
        return BestResolution.findMaxQualityResolution(model, defaultResolution);
    }

    public static Resolution findMaxCacheResolution(VideoModel model, Resolution defaultResolution) {
        return BestResolution.findMaxCacheResolution(model, defaultResolution);
    }

    public static Resolution findDefaultResolution(VideoModel model, Resolution defaultResolution) {
        return BestResolution.findDefaultResolution(model, defaultResolution);
    }

    public static Resolution findBestResolution(VideoModel model, int bestResolutionType) {
        return TTVideoEngine.findBestResolution(model, Resolution.Standard, bestResolutionType, null);
    }

    public static Resolution findBestResolution(VideoModel model, Resolution defaultResolution, int bestResolutionType) {
        return TTVideoEngine.findBestResolution(model, defaultResolution, bestResolutionType, null);
    }

    protected static Resolution findBestResolution(IVideoModel model, Resolution defaultResolution, int bestResolutionType, SpeedShiftConfig speedShiftConfig) {
        Resolution bestResolution = defaultResolution = BestResolution.findDefaultResolution(model, defaultResolution);
        switch (bestResolutionType) {
            case 1: {
                bestResolution = BestResolution.findMaxCacheResolution(model, defaultResolution);
                break;
            }
            case 2: {
                bestResolution = BestResolution.findMaxQualityResolution(model, defaultResolution);
                break;
            }
            case 3: {
                double speed = -1.0;
                if (StrategyCenter.sNetSpeedPredictor != null) {
                    speed = StrategyCenter.sNetSpeedPredictor.getPredictSpeed() / 8.0f / 1024.0f;
                }
                bestResolution = BestResolution.findAwemeShiftResolution(model, defaultResolution, speed, speedShiftConfig);
            }
        }
        return bestResolution;
    }

    public static void removeCacheFile(IVideoModel model) {
        List<VideoInfo> videoInfoList;
        if (model != null && model.hasData() && (videoInfoList = model.getVideoInfoList()) != null && videoInfoList.size() > 0) {
            for (VideoInfo info : videoInfoList) {
                DataLoaderHelper.getDataLoader().forceRemoveCacheFile(info.getValueStr(15));
            }
        }
    }

    @Override
    public void setResolutionMap(HashMap<String, Resolution> resolutionMap) {
        this.mVideoEngine.setResolutionMap(resolutionMap);
    }

    @Override
    public void prepare() {
        this.mVideoEngine.prepare();
    }

    @Override
    public void start() {
        this.mVideoEngine.start();
    }

    @Override
    public void play() {
        this.mVideoEngine.play();
    }

    @Override
    public void pause() {
        this.mVideoEngine.pause();
    }

    @Override
    public void pauseByInterruption() {
        this.mVideoEngine.pauseByInterruption();
    }

    @Override
    public void stop() {
        this.mVideoEngine.stop();
    }

    @Override
    public synchronized void release() {
        this.mVideoEngine.release();
    }

    @Override
    public synchronized void releaseAsync() {
        this.mVideoEngine.releaseAsync();
    }

    @Override
    public void setLooping(boolean looping) {
        this.mVideoEngine.setLooping(looping);
    }

    @Override
    @Deprecated
    public boolean getLooping(boolean looping) {
        return this.mVideoEngine.getLooping(looping);
    }

    @Override
    public boolean isLooping() {
        return this.mVideoEngine.isLooping();
    }

    @Override
    @Deprecated
    public boolean isSystemPlayer() {
        return this.mVideoEngine.isSystemPlayer();
    }

    @Override
    public boolean isOSPlayer() {
        return this.mVideoEngine.isOSPlayer();
    }

    @Override
    public boolean isPlayerType(int type) {
        return this.mVideoEngine.isPlayerType(type);
    }

    @Override
    public boolean isInHousePlayer() {
        return this.mVideoEngine.isInHousePlayer();
    }

    @Override
    public String getCurrentPlayPath() {
        return this.mVideoEngine.getCurrentPlayPath();
    }

    @Override
    public int getDuration() {
        return this.mVideoEngine.getDuration();
    }

    @Override
    public int getLoadedProgress() {
        return this.mVideoEngine.getLoadedProgress();
    }

    @Override
    public int getPlaybackState() {
        return this.mVideoEngine.getPlaybackState();
    }

    @Override
    public int getLoadState() {
        return this.mVideoEngine.getLoadState();
    }

    @Override
    public boolean isStarted() {
        return this.mVideoEngine.isStarted();
    }

    @Override
    public boolean isShouldPlay() {
        return this.mVideoEngine.isShouldPlay();
    }

    @Override
    public int getCurrentPlaybackTime() {
        return this.mVideoEngine.getCurrentPlaybackTime();
    }

    @Override
    public int getCurrentPlaybackTimeAsync() {
        return this.mVideoEngine.getCurrentPlaybackTimeAsync();
    }

    @Override
    public boolean isDashSource() {
        return this.mVideoEngine.isDashSource();
    }

    @Override
    public int getVideoWidth() {
        return this.mVideoEngine.getVideoWidth();
    }

    @Override
    public int getVideoHeight() {
        return this.mVideoEngine.getVideoHeight();
    }

    @Override
    public int getWatchedDuration() {
        return this.mVideoEngine.getWatchedDuration();
    }

    @Override
    public JSONObject getPlayErrorInfo() {
        return this.mVideoEngine.getPlayErrorInfo();
    }

    @Override
    public int getBufferingType() {
        return this.mVideoEngine.getBufferingType();
    }

    @Override
    public void setUnSupportSampleRates(int[] sampleRates) {
        this.mVideoEngine.setUnSupportSampleRates(sampleRates);
    }

    @Override
    public void setTestSpeedEnable(int testNetSpeed, TestNetSpeedListener speedListener) {
        this.mVideoEngine.setTestSpeedEnable(testNetSpeed, speedListener);
    }

    @Override
    public IVideoEventLogger getLogger() {
        return this.mVideoEngine.getLogger();
    }

    @Override
    public void seekTo(int msec, SeekCompletionListener listener) {
        this.mVideoEngine.seekTo(msec, listener);
    }

    @Override
    public synchronized void createPlayer() {
        this.mVideoEngine.createPlayer();
    }

    @Override
    public boolean supporth265Playback() {
        return this.mVideoEngine.supporth265Playback();
    }

    @Override
    public boolean supporth266Playback() {
        return this.mVideoEngine.supporth266Playback();
    }

    @Override
    public VideoFormatInfo getVideoFormatInfo() {
        return this.mVideoEngine.getVideoFormatInfo();
    }

    @Override
    public void setPlayerEventListener(PlayerEventSimpleListener listener) {
        this.mVideoEngine.setPlayerEventListener(listener);
    }

    public static void setDeviceInfo(DeviceInfoVE deviceInfoVE) {
        if (deviceInfoVE == null) {
            return;
        }
        TTVideoEngineLog.d(TAG, "DeviceInfoVE.overAllScore: " + DeviceInfoVE.overAllScore);
    }

    public static void setNetworkRTTLevelListener(networkRTTLevelListener networkRTTLevelListener2) {
        PortraitNetworkScore.getInstance().setNetworkRTTLevelListener(networkRTTLevelListener2);
    }

    @Override
    public void setFFmpegProtocolObject(TTVideoEngineFFmpegProtocol obj) {
        if (this.mVideoEngine != null) {
            this.mVideoEngine.setFFmpegProtocolObject(obj);
        }
    }

    @Override
    public Context getContext() {
        return this.mVideoEngine.getContext();
    }

    @Override
    public String getDirectUrl() {
        return this.mVideoEngine.getDirectUrl();
    }

    @Override
    public MediaPlayer getMediaPlayer() {
        return this.mVideoEngine.getMediaPlayer();
    }

    public static void enableNewMDLFetcher(boolean enable) {
        try {
            if (enable) {
                if (sFetcherMakerNew == null) {
                    sFetcherMakerNew = new FetcherMakerNew();
                }
                AVMDLURLFetcherBridge.setNewFetcherMaker((AVMDLNewFetcherMakerInterface)sFetcherMakerNew);
            } else {
                AVMDLURLFetcherBridge.setNewFetcherMaker(null);
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.i(TAG, "setFetcherMakerNew exception " + e);
        }
    }

    public static String encryptTimestamp(Context context, long timestamp) {
        String engineUniqueId = TTVideoEngine.getEngineUniqueId(context);
        return JniUtils.encryptTimestamp(String.valueOf(timestamp), engineUniqueId);
    }

    @Override
    public void clearTextureRef() {
        this.mVideoEngine.clearTextureRef();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void notifyCacheEnd() {
        this.mVideoEngine.notifyCacheEnd();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getHash() {
        return this.mVideoEngine.getHash();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String getAPIString() {
        return this.mVideoEngine.getAPIString();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getPlayAPIVersion() {
        return this.mVideoEngine.getPlayAPIVersion();
    }

    static {
        mForceUseLitePlayer = false;
        mForceUsePluginPlayer = false;
        mGearStrategyConfig = null;
        mHARInfo = null;
        sTestSpeedInterval = 0;
        sTestSpeedSampleInterval = 500;
        sIsReportTestSpeedInfo = 0;
        sReportSpeedInfoMaxWindowSize = 100;
        sNetSpeedAbrPredictType = 0;
        sABRAlgorithmType = 0;
        sABRSpeedPredictInputType = 0;
        mQualityInfos = new String[0];
        sEnableGloablMuteFeature = 0;
        sGlobalMute = 0;
    }
}

