/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.PlaybackParams;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttvideoengine.BaseAppInfo;
import com.ss.ttvideoengine.ITTVideoEngineEventSource;
import com.ss.ttvideoengine.ITTVideoEngineInternal;
import com.ss.ttvideoengine.SeekCompletionListener;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.IPlayDurationManager;
import com.ss.ttvideoengine.utils.TTVideoEngineInternalHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineInternalLog;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public abstract class TTVideoEngineInternal
implements ITTVideoEngineInternal,
ITTVideoEngineEventSource {
    private static final String TAG = "TTVideoEngine";
    protected static final int MAX_ERROR_COUNT = 3;
    private static int sIsColdStart = 1;
    protected String mTag = "";
    protected String mSubTag = "";
    protected Context mContext;
    protected MediaPlayer mMediaPlayer;
    protected MyMediaPlayerListener mMediaPlayerListener;
    protected int mPlayerType;
    protected HashMap<Integer, Integer> mConfigParams = null;
    protected Surface mSurface;
    protected SurfaceHolder mSurfaceHolder;
    protected int mSurfaceHolderByKernel = 0;
    protected int mState = 0;
    protected int mPlaybackState = 0;
    protected int mLoadState = 0;
    protected PlaybackParams mPlaybackParams;
    protected int mEnablePlaySpeedExtend;
    protected int mBufferingType = -1;
    private String mSourceTypeStr = "";
    protected String mInitialURL;
    protected boolean mIsDirectURL = false;
    protected String mDirectURL = "";
    protected String mDirectUrlSrc = "";
    protected boolean mIsLocal = false;
    protected String mLocalURL = "";
    protected int mConfigParamsOption = 1;
    protected int mForbidOSPlayer = 0;
    protected Boolean mFallbackExoFirst;
    protected int mPlayerDegradeMode = 0;
    protected int mIsColdStart = 0;
    protected boolean mShouldPlay = false;
    protected boolean mShouldStop = false;
    protected boolean mUserStopped = false;
    protected boolean mPausedBeforePrepared = false;
    protected boolean mStarted = false;
    protected boolean mPrepared = false;
    protected boolean mReleased = false;
    protected boolean mHasComplete = false;
    protected boolean mErrorEnd = false;
    protected long mPlayTime = 0L;
    protected boolean mRetrying = false;
    protected boolean mRetryingNotHandleError = false;
    protected int mAccumulatedErrorCount = 0;
    protected boolean mIsPlayComplete = false;
    protected boolean mHasFirstFrameShown = false;
    protected boolean mTexNotifyFirstFrame = false;
    protected boolean mFirstGetWidthHeight = true;
    protected boolean mSeeking = false;
    protected long mSeekingStartTime = 0L;
    protected SeekCompletionListener mSeekCompletionListener;
    protected int mLastPlaybackTime = 0;
    protected boolean mLooping;
    protected float mLeftVolume = -1.0f;
    protected float mRightVolume = -1.0f;
    protected boolean mIsMute;
    protected int mDuration = 0;
    protected int mCurPlayBackTime = 0;
    protected int mLoadedProgress = 0;
    protected int mWidth = 0;
    protected int mHeight = 0;
    protected IPlayDurationManager mPlayDuration;
    protected int mCodecId = 0;
    protected int mAsyncInitEnable = 0;
    protected int mSetTrackVolume = 0;
    protected boolean mIsStartPlayAutomatically = true;
    protected int mCleanWhenStop = 0;
    protected int mMaxAccumulatedCountSetByUser = 30;
    protected int mRadioModeEnable = 0;
    protected long mLastSwitchRadioModeTime = 0L;
    protected int mHardwareDecodeEnablePlayer2 = 0;
    protected int mDisableResetSystemVolume = 0;
    protected int mVideoCodecType = -1;
    protected int mAudioCodecType = -1;
    protected int mVideoCodecID = -1;
    protected int mAudioCodecID = -1;
    protected String mExoLoadControlParameters = null;
    protected int mExoRenderReadyMs = -1;
    protected int mExoConsecutiveFailNum = -1;
    protected int mExoCodecReusable = 0;
    protected int mExoCodecAsyncInitEnable = 0;
    protected int mExoAllowMediaCodecHelper = 0;
    protected int mErrorCount = 0;
    protected Error mError = null;

    @Override
    public void initEngine(Context context, int type) {
        this.mContext = context;
        this.mPlayerType = type;
        this.mConfigParams = new HashMap();
        this.mIsMute = false;
        this.mIsColdStart = sIsColdStart;
        sIsColdStart = 0;
        TTPlayerConfiger.setValue((int)6, (boolean)false);
        TTPlayerConfiger.setValue((int)1, (int)(type != 2 && type != 5 ? 1 : 0));
        TTPlayerConfiger.setValue((int)2, (type == 1 ? 1 : 0) != 0);
        TTPlayerConfiger.setValue((int)26, (type == 5 ? 1 : 0) != 0);
        TTPlayerConfiger.setValue((int)11, (boolean)false);
        TTPlayerConfiger.setValue((int)4, (boolean)false);
    }

    abstract MediaPlayer createMediaPlayer();

    protected void refreshEnginePara(Context context, int type, Map params) {
        this.mIsColdStart = sIsColdStart;
    }

    protected void resetAllOptions() {
        this.mTag = "";
        this.mSubTag = "";
        this.mContext = null;
        this.mMediaPlayerListener = null;
        this.mPlayerType = 0;
        this.mConfigParams = new HashMap();
        this.mSurface = null;
        this.mSurfaceHolder = null;
        this.mSurfaceHolderByKernel = 0;
        this.mState = 0;
        this.mPlaybackState = 0;
        this.mLoadState = 0;
        this.mPlaybackParams = null;
        this.mEnablePlaySpeedExtend = 0;
        this.mBufferingType = -1;
        this.mSourceTypeStr = "";
        this.mInitialURL = null;
        this.mIsDirectURL = false;
        this.mDirectURL = "";
        this.mDirectUrlSrc = "";
        this.mIsLocal = false;
        this.mLocalURL = "";
        this.mConfigParamsOption = 1;
        this.mForbidOSPlayer = 0;
        this.mFallbackExoFirst = null;
        this.mPlayerDegradeMode = 0;
        this.mIsColdStart = 0;
        this.mShouldPlay = false;
        this.mUserStopped = false;
        this.mPausedBeforePrepared = false;
        this.mStarted = false;
        this.mPrepared = false;
        this.mHasComplete = false;
        this.mErrorEnd = false;
        this.mPlayTime = 0L;
        this.mRetrying = false;
        this.mRetryingNotHandleError = false;
        this.mAccumulatedErrorCount = 0;
        this.mIsPlayComplete = false;
        this.mHasFirstFrameShown = false;
        this.mTexNotifyFirstFrame = false;
        this.mFirstGetWidthHeight = true;
        this.mSeeking = false;
        this.mSeekingStartTime = 0L;
        this.mSeekCompletionListener = null;
        this.mLastPlaybackTime = 0;
        this.mLooping = false;
        this.mLeftVolume = -1.0f;
        this.mRightVolume = -1.0f;
        this.mIsMute = false;
        this.mDuration = 0;
        this.mCurPlayBackTime = 0;
        this.mLoadedProgress = 0;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mCodecId = 0;
        this.mAsyncInitEnable = 0;
        this.mSetTrackVolume = 0;
        this.mIsStartPlayAutomatically = true;
        this.mCleanWhenStop = 0;
        this.mMaxAccumulatedCountSetByUser = 30;
        this.mRadioModeEnable = 0;
        this.mLastSwitchRadioModeTime = 0L;
        this.mHardwareDecodeEnablePlayer2 = 0;
        this.mDisableResetSystemVolume = 0;
        this.mVideoCodecType = -1;
        this.mAudioCodecType = -1;
        this.mVideoCodecID = -1;
        this.mAudioCodecID = -1;
        this.mExoLoadControlParameters = null;
        this.mExoRenderReadyMs = -1;
        this.mExoConsecutiveFailNum = -1;
        this.mExoCodecReusable = 0;
        this.mExoCodecAsyncInitEnable = 0;
        this.mExoAllowMediaCodecHelper = 0;
        this.mErrorCount = 0;
        this.mError = null;
    }

    @Override
    public void resetEngine() {
    }

    @Override
    public void setTag(String tag) {
        this.mTag = tag;
    }

    @Override
    public void setSubTag(String subTag) {
        this.mSubTag = subTag;
    }

    protected void updatePlaybackState(int playbackState) {
    }

    protected void updateLoadState(int loadState, int bufferingType) {
    }

    @Override
    public Surface getSurface() {
        return this.mSurface;
    }

    @Override
    public void setVolume(float left, float right) {
        TTVideoEngineInternalLog.i(TAG, "setVolume left:" + left + " right:" + right);
        this.mLeftVolume = left;
        this.mRightVolume = right;
        this.setPlayerVolume(left, right);
    }

    protected void setPlayerVolume(float left, float right) {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer == null) {
            return;
        }
        float playerLeft = left;
        float playerRight = right;
        if (this.mSetTrackVolume == 0 && !this.isInHousePlayer()) {
            AudioManager audioManager;
            if (left != 0.0f) {
                playerLeft = 1.0f;
                playerRight = 1.0f;
            }
            if ((audioManager = (AudioManager)this.mContext.getSystemService("audio")) != null) {
                audioManager.setStreamVolume(3, (int)left, 0);
            }
        }
        mediaPlayer.setVolume(playerLeft, playerRight);
    }

    @Override
    public float getVolume() {
        return TTVideoEngineInternalHelper.getVolume(this.mContext);
    }

    @Override
    public void setIsMute(boolean isMute) {
        TTVideoEngineInternalLog.i(TAG, String.format("setIsMute:%s", isMute));
        this.mIsMute = isMute;
        this.setPlayerMute(isMute);
    }

    protected void setPlayerMute(boolean isMute) {
        MediaPlayer player = this.mMediaPlayer;
        if (player != null) {
            if (player.isOSPlayer()) {
                float volume = isMute ? 0.0f : 1.0f;
                try {
                    player.setVolume(volume, volume);
                }
                catch (Exception e) {
                    TTVideoEngineInternalLog.d(e);
                }
            } else {
                player.setIsMute(isMute);
            }
        }
    }

    @Override
    public boolean isMute() {
        if (this.mState != 3 || !this.mShouldPlay && this.mPlaybackState != 2) {
            return this.mIsMute;
        }
        boolean ret = this.mIsMute;
        if (this.mMediaPlayer != null) {
            ret = this.mMediaPlayer.isMute();
        }
        return ret;
    }

    @Override
    public void setPlaybackParams(PlaybackParams params) {
        this.mPlaybackParams = params;
        if (this.mMediaPlayer != null) {
            try {
                if (this.isOSPlayer() && (Build.VERSION.SDK_INT < 23 || !this.mPrepared)) {
                    return;
                }
                this.mMediaPlayer.setPlaybackParams(params);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected boolean shouldPrepare() {
        if (!(this.mPlaybackState != 0 && this.mPlaybackState != 3 || this.mPrepared)) {
            return true;
        }
        return this.mMediaPlayer != null && this.mMediaPlayer.getPlayerType() == 0 && !this.mPrepared;
    }

    @Override
    public void setLooping(boolean looping) {
        TTVideoEngineInternalLog.i(TAG, "setLooping:" + looping);
        this.mLooping = looping;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setLooping(this.mLooping);
        }
    }

    @Override
    public boolean isLooping() {
        return this.mLooping;
    }

    @Override
    public int getDuration() {
        return this.mDuration;
    }

    @Override
    public int getLoadedProgress() {
        return this.mLoadedProgress;
    }

    @Override
    public int getPlaybackState() {
        return this.mPlaybackState;
    }

    @Override
    public int getLoadState() {
        return this.mLoadState;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public boolean isShouldPlay() {
        return this.mShouldPlay;
    }

    @Override
    public int getCurrentPlaybackTimeAsync() {
        return this.getCurrentPlaybackTime();
    }

    @Override
    public int getVideoWidth() {
        int ret = 0;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            ret = mediaPlayer.getVideoWidth();
        }
        return ret;
    }

    @Override
    public int getVideoHeight() {
        int ret = 0;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            ret = mediaPlayer.getVideoHeight();
        }
        return ret;
    }

    @Override
    public int getWatchedDuration() {
        if (this.mPlayDuration != null) {
            return this.mPlayDuration.getPlayedDuration();
        }
        return 0;
    }

    @Override
    public int getBufferingType() {
        return this.mBufferingType;
    }

    @Override
    public boolean isOSPlayer() {
        return this.isPlayerType(2);
    }

    @Override
    public boolean isPlayerType(int type) {
        MediaPlayer player = this.mMediaPlayer;
        int currentType = -1;
        currentType = player != null ? TTVideoEngineInternal.transMediaPlayerType(player.getPlayerType()) : this.mPlayerType;
        return currentType == type;
    }

    public boolean isInHousePlayer() {
        return this.isPlayerType(0) || this.isPlayerType(1) || this.isPlayerType(3) || this.isPlayerType(4);
    }

    protected void updateConfigParams(Map<Integer, Integer> params) {
        if (params == null) {
            return;
        }
        params.put(2, this.mPlayerType == 1 ? 1 : 0);
        params.put(1, this.mPlayerType != 2 && this.mPlayerType != 5 ? 1 : 0);
        this.mConfigParams.put(26, this.mPlayerType == 5 ? 1 : 0);
        params.put(11, this.mForbidOSPlayer);
        params.put(100, this.mConfigParamsOption);
        if (this.mFallbackExoFirst != null) {
            params.put(27, this.mFallbackExoFirst != false ? 1 : 0);
        }
    }

    protected static int transMediaPlayerType(MediaPlayer mediaPlayer) {
        if (mediaPlayer == null) {
            return 0;
        }
        switch (mediaPlayer.getPlayerType()) {
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 0: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    protected static int transMediaPlayerType(int internalType) {
        int engineType = -1;
        switch (internalType) {
            case 0: {
                engineType = 2;
                break;
            }
            case 1: {
                engineType = 0;
                break;
            }
            case 2: {
                engineType = 1;
                break;
            }
            case 3: {
                engineType = 3;
                break;
            }
            case 4: {
                engineType = 4;
                break;
            }
            case 5: {
                engineType = 5;
                break;
            }
            default: {
                throw new RuntimeException("unknown internal player type: " + internalType);
            }
        }
        return engineType;
    }

    protected boolean needReleaseMediaPlayer() {
        return this.mMediaPlayer.getPlayerType() == 0 || this.mMediaPlayer.getPlayerType() == 5 || this.mMediaPlayer.getPlayerType() == 3 || this.mMediaPlayer.getPlayerType() == 4;
    }

    protected void setMediaPlayerOptions() {
        this.mMediaPlayer.setIntOption(94, this.mSetTrackVolume);
        this.mMediaPlayer.setIntOption(98, this.mDisableResetSystemVolume);
        this.mMediaPlayer.setIntOption(261, this.mRadioModeEnable);
        this.setPlayerMute(this.mIsMute);
        if (this.mLeftVolume >= 0.0f && this.mRightVolume >= 0.0f) {
            this.setPlayerVolume(this.mLeftVolume, this.mRightVolume);
        }
        if (this.mHardwareDecodeEnablePlayer2 == 1) {
            this.mMediaPlayer.setIntOption(182, this.mCodecId);
            this.mMediaPlayer.setIntOption(181, this.mAsyncInitEnable);
        }
        if (this.mPlayerType == 5) {
            if (this.mExoLoadControlParameters != null) {
                this.mMediaPlayer.setStringOption(5000, this.mExoLoadControlParameters);
            }
            if (this.mExoRenderReadyMs >= 0) {
                this.mMediaPlayer.setIntOption(5001, this.mExoRenderReadyMs);
            }
            if (this.mExoConsecutiveFailNum >= 0) {
                this.mMediaPlayer.setIntOption(5002, this.mExoConsecutiveFailNum);
            }
            if (this.mExoCodecReusable >= 0) {
                this.mMediaPlayer.setIntOption(5003, this.mExoCodecReusable);
            }
            if (this.mExoCodecAsyncInitEnable >= 0) {
                this.mMediaPlayer.setIntOption(5004, this.mExoCodecAsyncInitEnable);
            }
            if (this.mExoAllowMediaCodecHelper >= 0) {
                this.mMediaPlayer.setIntOption(5005, this.mExoAllowMediaCodecHelper);
            }
        }
    }

    protected void resetMediaPlayerOptions() {
        this.mMediaPlayer.setIntOption(59, this.mHardwareDecodeEnablePlayer2);
    }

    protected void registerListenerMediaPlayer() {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayerListener = new MyMediaPlayerListener(this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this.mMediaPlayerListener);
        this.mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this.mMediaPlayerListener);
        this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.mMediaPlayerListener);
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this.mMediaPlayerListener);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this.mMediaPlayerListener);
        this.mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this.mMediaPlayerListener);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this.mMediaPlayerListener);
        this.mMediaPlayer.setOnSARChangedListener((MediaPlayer.onSARChangedListener)this.mMediaPlayerListener);
    }

    protected void releaseMediaPlayer() {
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.mTexNotifyFirstFrame = false;
    }

    protected void receivedError(Error error) {
    }

    protected void notifyLoadStateChanged(int loadState) {
    }

    protected void notifyPlaybackStateChanged(int playbackState) {
    }

    protected void notifyInfoIdChanged(int infoId) {
    }

    protected void notifyReadyForDisplay() {
    }

    protected void notifyStreamChanged(int type) {
    }

    protected void notifyBufferStart(int reason, int afterFirstFrame, int action) {
    }

    protected void notifyBufferEnd(int reason) {
    }

    protected void notifyRenderStart() {
    }

    protected void notifyPrepare() {
    }

    protected void notifyPrepared() {
    }

    protected void notifyBufferingUpdate(int percent) {
    }

    protected void notifyCompletion() {
    }

    protected void notifyError(Error error) {
    }

    protected void notifySeekCompletion(boolean success) {
    }

    protected void notifySARChanged(int num, int den) {
    }

    protected void notifyVideoSizeChanged(int width, int height) {
    }

    protected void onMediaPlayerPrepared(MediaPlayer mediaPlayer) {
    }

    protected boolean onMediaPlayerInfo(MediaPlayer mediaPlayer, int what, int extra) {
        return false;
    }

    protected void onMediaPlayerBufferingUpdate(MediaPlayer mediaPlayer, int percent) {
    }

    protected void onMediaPlayerCompletion(MediaPlayer mediaPlayer) {
    }

    protected boolean onMediaPlayerError(MediaPlayer mediaPlayer, int what, int extra) {
        return false;
    }

    protected void onMediaPlayerSeekComplete(MediaPlayer mediaPlayer, boolean success) {
    }

    protected void onMediaPlayerVideoSizeChanged(MediaPlayer mediaPlayer, int width, int height) {
    }

    protected void onMediaPlayerSARChanged(MediaPlayer mediaPlayer, int num, int den) {
    }

    @Override
    public void setStringOption(int key, String value) {
        switch (key) {
            case 5000: {
                if (this.mMediaPlayer != null && this.mMediaPlayer.getPlayerType() == 5) {
                    this.mMediaPlayer.setStringOption(5000, value);
                }
                this.mExoLoadControlParameters = value;
                break;
            }
        }
    }

    @Override
    public void setIntOption(int key, int value) {
        switch (key) {
            case 3: {
                this.mForbidOSPlayer = value;
                TTPlayerConfiger.setValue((int)11, (int)value);
                break;
            }
            case 117: {
                TTPlayerConfiger.setValue((int)4, (int)value);
                break;
            }
            case 100: {
                boolean bl = this.mIsStartPlayAutomatically = value != 0;
                if (this.mMediaPlayer == null) break;
                this.mMediaPlayer.setIntOption(196, this.mIsStartPlayAutomatically ? 0 : 1);
                break;
            }
            case 27: {
                this.mCleanWhenStop = value;
                break;
            }
            case 28: {
                this.mMaxAccumulatedCountSetByUser = value;
                break;
            }
            case 206: {
                break;
            }
            case 480: {
                this.mRadioModeEnable = value;
                this.mLastSwitchRadioModeTime = System.currentTimeMillis();
                if (this.mMediaPlayer == null) break;
                this.mMediaPlayer.setIntOption(261, value);
                break;
            }
            case 415: {
                this.mSetTrackVolume = value;
                if (this.mMediaPlayer == null) break;
                this.mMediaPlayer.setIntOption(94, value);
                break;
            }
            case 340: {
                this.mDisableResetSystemVolume = value;
                if (this.mMediaPlayer == null) break;
                this.mMediaPlayer.setIntOption(98, value);
                break;
            }
            case 85: {
                this.mFallbackExoFirst = value != 0;
                break;
            }
            case 7: {
                this.mHardwareDecodeEnablePlayer2 = value;
                TTVideoEngineInternalLog.i(TAG, "hardware enable = " + this.mHardwareDecodeEnablePlayer2);
                if (this.mMediaPlayer == null) break;
                this.mMediaPlayer.setIntOption(59, value);
                break;
            }
            case 5003: {
                this.mExoCodecReusable = value;
                if (this.mMediaPlayer == null || this.mMediaPlayer.getPlayerType() != 5) break;
                this.mMediaPlayer.setIntOption(5003, value);
                break;
            }
            case 5001: {
                this.mExoRenderReadyMs = value;
                if (this.mMediaPlayer == null || this.mMediaPlayer.getPlayerType() != 5) break;
                this.mMediaPlayer.setIntOption(5001, value);
                break;
            }
            case 5002: {
                this.mExoConsecutiveFailNum = value;
                if (this.mMediaPlayer == null || this.mMediaPlayer.getPlayerType() != 5) break;
                this.mMediaPlayer.setIntOption(5002, value);
                break;
            }
            case 5004: {
                this.mExoCodecAsyncInitEnable = value;
                if (this.mMediaPlayer == null || this.mMediaPlayer.getPlayerType() != 5) break;
                this.mMediaPlayer.setIntOption(5004, value);
                break;
            }
            case 5005: {
                this.mExoAllowMediaCodecHelper = value;
                if (this.mMediaPlayer == null || this.mMediaPlayer.getPlayerType() != 5) break;
                this.mMediaPlayer.setIntOption(5005, value);
                break;
            }
        }
    }

    @Override
    public void setFloatOption(int key, float value) {
    }

    @Override
    public void setLongOption(int key, long value) {
    }

    @Override
    public int getIntOption(int key) {
        int ret = -1;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        try {
            switch (key) {
                case 47: {
                    ret = this.mPlayerType;
                    break;
                }
                case 49: {
                    if (this.mContext == null) break;
                    AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
                    if (audioManager != null) {
                        ret = audioManager.getStreamVolume(3);
                    }
                    if (ret < 0) {
                        ret = 0;
                    }
                    break;
                }
                case 48: {
                    if (this.mContext == null) break;
                    AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
                    if (audioManager != null) {
                        ret = audioManager.getStreamMaxVolume(3);
                    }
                    if (ret < 0) {
                        ret = 0;
                    }
                    break;
                }
                case 50: {
                    ret = this.mDuration;
                    break;
                }
                case 51: {
                    ret = this.mLoadedProgress;
                    break;
                }
                case 52: {
                    ret = mediaPlayer == null ? 0 : mediaPlayer.getCurrentPosition();
                    break;
                }
                case 53: {
                    if (this.mPlayDuration == null) break;
                    ret = this.mPlayDuration.getPlayedDuration();
                    break;
                }
                case 54: {
                    ret = this.mBufferingType;
                    break;
                }
                case 55: {
                    ret = this.mPlaybackState;
                    break;
                }
                case 56: {
                    ret = this.mLoadState;
                    break;
                }
                case 57: {
                    ret = this.mState;
                    break;
                }
                case 480: {
                    ret = this.mRadioModeEnable;
                    break;
                }
                case 43: {
                    if (this.mVideoCodecType < 0 && mediaPlayer != null) {
                        this.mVideoCodecType = mediaPlayer.getIntOption(157, -1);
                    }
                    ret = this.mVideoCodecType;
                    break;
                }
                case 44: {
                    if (this.mAudioCodecType < 0 && mediaPlayer != null) {
                        this.mAudioCodecType = mediaPlayer.getIntOption(158, -1);
                    }
                    ret = this.mAudioCodecType;
                    break;
                }
                case 45: {
                    if (this.mVideoCodecID < 0 && mediaPlayer != null) {
                        this.mVideoCodecID = mediaPlayer.getIntOption(141, -1);
                    }
                    ret = this.mVideoCodecID;
                    break;
                }
                case 46: {
                    if (this.mAudioCodecID < 0 && mediaPlayer != null) {
                        this.mAudioCodecID = mediaPlayer.getIntOption(140, -1);
                    }
                    ret = this.mAudioCodecID;
                    break;
                }
            }
        }
        catch (Throwable e) {
            TTVideoEngineInternalLog.d(e);
        }
        return ret;
    }

    @Override
    public long getLongOption(int key) {
        long ret = -1L;
        return ret;
    }

    @Override
    public float getFloatOption(int key) {
        float ret = 0.0f;
        return ret;
    }

    @Override
    public String getStringOption(int key) {
        String ret = "";
        return ret;
    }

    @Override
    public Object get(String key) {
        switch (key) {
            case "tag": {
                return this.mTag;
            }
            case "subtag": {
                return this.mSubTag;
            }
            case "device_id": {
                return BaseAppInfo.mDeviceId;
            }
            case "chipboard": {
                try {
                    return Build.BOARD;
                }
                catch (Exception e) {
                    TTVideoEngineInternalLog.d(e);
                    return "";
                }
            }
            case "chiphardware": {
                try {
                    return Build.HARDWARE;
                }
                catch (Exception e) {
                    TTVideoEngineInternalLog.d(e);
                    return "";
                }
            }
            case "engine_state": {
                return this.mState;
            }
            case "cold_start": {
                return this.mIsColdStart;
            }
            case "hw_user": {
                return this.mHardwareDecodeEnablePlayer2;
            }
            case "radio_mode": {
                return this.mRadioModeEnable;
            }
            case "cp": {
                return this.mExoAllowMediaCodecHelper;
            }
            case "format_type": {
                if (this.mMediaPlayer != null) {
                    return this.mMediaPlayer.getStringOption(516);
                }
                return "";
            }
            case "mute": {
                if (this.mMediaPlayer != null) {
                    if (this.mMediaPlayer.isMute()) {
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            case "volume": {
                return Float.valueOf(this.getVolume());
            }
            case "initial_url": {
                return this.mInitialURL;
            }
            case "source_type": {
                return this.mSourceTypeStr;
            }
            case "vd": {
                return this.mDuration;
            }
            case "cur_play_pos": {
                return this.mCurPlayBackTime;
            }
            case "codec": {
                if (this.mMediaPlayer == null) break;
                if (this.mVideoCodecID < 0) {
                    this.mVideoCodecID = this.mMediaPlayer.getIntOption(141, -1);
                }
                if (this.mVideoCodecID == 0) {
                    return "h264";
                }
                if (this.mVideoCodecID == 1) {
                    return "h265";
                }
                if (this.mVideoCodecID != 33) break;
                return this.mVideoCodecID;
            }
            case "audio_codec_nameid": {
                if (this.mMediaPlayer == null) {
                    return 0;
                }
                if (this.mAudioCodecType < 0) {
                    this.mAudioCodecType = this.mMediaPlayer.getIntOption(158, -1);
                }
                return this.mAudioCodecType;
            }
            case "video_codec_nameid": {
                if (this.mMediaPlayer == null) {
                    return 0;
                }
                if (this.mVideoCodecType < 0) {
                    this.mVideoCodecType = this.mMediaPlayer.getIntOption(157, -1);
                }
                return this.mVideoCodecType;
            }
            case "hw": {
                if (this.mMediaPlayer == null) {
                    return 0;
                }
                if (this.mVideoCodecType < 0) {
                    this.mVideoCodecType = this.mMediaPlayer.getIntOption(157, -1);
                }
                switch (this.mVideoCodecType) {
                    case 2: {
                        return 1;
                    }
                }
                return 0;
            }
            case "render_type": {
                if (this.mMediaPlayer == null) break;
                int renderType = this.mMediaPlayer.getIntOption(139, -1);
                switch (renderType) {
                    case 0: {
                        return "opengl";
                    }
                    case 1: {
                        return "nativewindow";
                    }
                }
                break;
            }
            case "width": {
                return this.mWidth;
            }
            case "height": {
                return this.mHeight;
            }
            case "async_init": {
                return this.mAsyncInitEnable;
            }
            case "async_codec_id": {
                return this.mCodecId;
            }
        }
        return null;
    }

    public void setSourceType(int sourceType) {
        switch (sourceType) {
            case 0: {
                this.mSourceTypeStr = "local_url";
                break;
            }
            case 1: {
                this.mSourceTypeStr = "dir_url";
                break;
            }
            case 2: {
                this.mSourceTypeStr = "playitem";
                break;
            }
            case 3: {
                this.mSourceTypeStr = "preload";
                break;
            }
            case 4: {
                this.mSourceTypeStr = "feed";
                break;
            }
            case 5: {
                this.mSourceTypeStr = "vid";
                break;
            }
            case 6: {
                this.mSourceTypeStr = "fd";
                break;
            }
            case 7: {
                this.mSourceTypeStr = "mds";
                break;
            }
        }
    }

    private static class MyMediaPlayerListener
    implements MediaPlayer.OnPreparedListener,
    MediaPlayer.OnInfoListener,
    MediaPlayer.OnBufferingUpdateListener,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnSeekCompleteListener,
    MediaPlayer.OnVideoSizeChangedListener,
    MediaPlayer.onSARChangedListener {
        private final WeakReference<TTVideoEngineInternal> mVideoEngineInternalRef;

        public MyMediaPlayerListener(TTVideoEngineInternal videoEngineInternal) {
            this.mVideoEngineInternalRef = new WeakReference<TTVideoEngineInternal>(videoEngineInternal);
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return;
            }
            videoEngineInternal.onMediaPlayerPrepared(mediaPlayer);
        }

        public boolean onInfo(MediaPlayer mediaPlayer, int what, int extra) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return false;
            }
            return videoEngineInternal.onMediaPlayerInfo(mediaPlayer, what, extra);
        }

        public void onBufferingUpdate(MediaPlayer mediaPlayer, int percent) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return;
            }
            videoEngineInternal.onMediaPlayerBufferingUpdate(mediaPlayer, percent);
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return;
            }
            videoEngineInternal.onMediaPlayerCompletion(mediaPlayer);
        }

        public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return false;
            }
            return videoEngineInternal.onMediaPlayerError(mediaPlayer, what, extra);
        }

        public void onSeekComplete(MediaPlayer mediaPlayer) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return;
            }
            videoEngineInternal.onMediaPlayerSeekComplete(mediaPlayer, true);
        }

        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int width, int height) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return;
            }
            videoEngineInternal.onMediaPlayerVideoSizeChanged(mediaPlayer, width, height);
        }

        public void onSARChanged(MediaPlayer mediaPlayer, int num, int den) {
            TTVideoEngineInternal videoEngineInternal = (TTVideoEngineInternal)this.mVideoEngineInternalRef.get();
            if (videoEngineInternal == null) {
                return;
            }
            videoEngineInternal.onMediaPlayerSARChanged(mediaPlayer, num, den);
        }
    }
}

