/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class VideoInfoCollector {
    private HashMap<Long, TTVideoEngine> mActiveEngines = new HashMap();
    private long mWastedDataSize = 0L;
    private long mPlayConsumedSize = 0L;
    private static final String TAG = "VideoInfoCollecor";
    private static final VideoInfoCollector ourInstance = new VideoInfoCollector();

    public synchronized void registEngine(long serial, TTVideoEngine engine) {
        if (this.mActiveEngines.containsKey(serial)) {
            return;
        }
        this.mActiveEngines.put(serial, engine);
        TTVideoEngineLog.d(TAG, "new engine: " + serial);
    }

    public synchronized void unregistEngine(long serial) {
        try {
            if (this.mActiveEngines.containsKey(serial)) {
                TTVideoEngine engine = this.mActiveEngines.get(serial);
                long wasteData = engine.getLongOption(81);
                if (wasteData > 0L) {
                    this.mWastedDataSize += wasteData;
                }
                this.mActiveEngines.remove(serial);
                TTVideoEngineLog.d(TAG, "delete engine: " + serial + ", waste data: " + wasteData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized long getPlayWastDataSize() {
        long ret = this.mWastedDataSize;
        this.mWastedDataSize = 0L;
        try {
            for (TTVideoEngine value : this.mActiveEngines.values()) {
                long wasteData = value.getLongOption(81);
                if (wasteData <= 0L) continue;
                ret += wasteData;
            }
        }
        catch (Exception e) {
            return ret;
        }
        TTVideoEngineLog.d(TAG, "get play waste data size: " + ret);
        return ret;
    }

    public synchronized long getPlayConsumedSize() {
        long ret = this.mPlayConsumedSize;
        this.mPlayConsumedSize = 0L;
        return ret;
    }

    public synchronized void addPlayConsumedSize(long size) {
        if (size > 0L) {
            this.mPlayConsumedSize += size;
        }
    }

    public static VideoInfoCollector getInstance() {
        return ourInstance;
    }

    private VideoInfoCollector() {
    }

    public static class myVideoCollectorAddConsumeSize
    implements Runnable {
        long mConsumeSize;

        public myVideoCollectorAddConsumeSize(long size) {
            this.mConsumeSize = size;
        }

        @Override
        public void run() {
            VideoInfoCollector collector = VideoInfoCollector.getInstance();
            if (collector != null) {
                collector.addPlayConsumedSize(this.mConsumeSize);
            }
        }
    }

    static class myVideoCollectorUnregister
    implements Runnable {
        long mSerial;

        public myVideoCollectorUnregister(long serial) {
            this.mSerial = serial;
        }

        @Override
        public void run() {
            VideoInfoCollector collector = VideoInfoCollector.getInstance();
            if (collector != null) {
                collector.unregistEngine(this.mSerial);
            }
        }
    }

    static class myVideoCollectorRegister
    implements Runnable {
        private final WeakReference<TTVideoEngine> mVideoEngineRef;
        long mSerial;

        public myVideoCollectorRegister(TTVideoEngine engine, long serial) {
            this.mVideoEngineRef = new WeakReference<TTVideoEngine>(engine);
            this.mSerial = serial;
        }

        @Override
        public void run() {
            VideoInfoCollector collector;
            TTVideoEngine engine = (TTVideoEngine)this.mVideoEngineRef.get();
            if (engine != null && (collector = VideoInfoCollector.getInstance()) != null) {
                collector.registEngine(this.mSerial, engine);
            }
        }
    }
}

