/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LoggerUtils {
    public static final int PLAYER_BUFFER_STATE_SIZE = 6;
    public static final String KEY_FORMAT_VIDEO_LENGTH = "fvl";
    public static final String KEY_FORMAT_AUDIO_LENGTH = "fal";
    public static final String KEY_DECODER_VIDEO_LENGTH = "dvl";
    public static final String KEY_DECODER_AUDIO_LENGTH = "dal";
    public static final String KEY_BASE_VIDEO_LENGTH = "bvl";
    public static final String KEY_BASE_AUDIO_LENGTH = "bal";

    static void putToMap(Map map, String key, String value) {
        if (map == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)value)) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, int value) {
        if (map == null) {
            return;
        }
        if (value != Integer.MIN_VALUE) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, long value) {
        if (map == null) {
            return;
        }
        if (value != Integer.MIN_VALUE) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, Map value) {
        if (map == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, ArrayList value) {
        if (map == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, float value) {
        if (map == null) {
            return;
        }
        if (value != Float.MIN_VALUE && value != Float.NaN) {
            map.put(key, Float.valueOf(value));
        }
    }

    static Map<String, Long> parsePlayerBufferString(String text) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return result;
        }
        String[] strArray = text.split(";|:");
        if (strArray == null || strArray.length == 0) {
            return result;
        }
        for (int i = 0; i < strArray.length - 1; i += 2) {
            try {
                result.put(strArray[i], Long.parseLong(strArray[i + 1]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

