/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResult;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResultCollection;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResultItem;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public class VideoEventSampleRecord {
    private static final String TAG = "VideoEventSampleRecord";
    public static final String monitorName = "videoplayer_sample";
    public static final boolean enableBitrateMap = true;
    public int mMaxWindowSize = 200;
    public float mSampingRate = 0.0f;
    public boolean mIsStarted = false;
    public int mSampleInterval = Integer.MIN_VALUE;
    private long mLastVideoDownBytes = 0L;
    private long mLastAudioDownBytes = 0L;
    private long mLastVideoTotalCachedLen = 0L;
    private long mLastAudioTotalCachedLen = 0L;
    private EventContext mEventContext = null;
    public VideoEventBase mEventBase = null;
    private final ReentrantLock mLock = new ReentrantLock();

    VideoEventSampleRecord(VideoEventBase eventBase) {
        this.mEventContext = new EventContext();
        this.mEventBase = eventBase;
    }

    public void startRecord() {
        double random = Math.random();
        this.mIsStarted = !(random > (double)this.mSampingRate);
    }

    public void stopRecord() {
        this.mLock.lock();
        try {
            if (this.mIsStarted) {
                this.mIsStarted = false;
                this._sendEvent(1);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setInterval(int interval) {
        if (interval > 0) {
            this.mSampleInterval = interval;
        }
    }

    public void setMaxWindowSize(int size) {
        if (size > 0) {
            this.mMaxWindowSize = size;
        }
    }

    public void setSamplingRate(float samplingRate) {
        this.mSampingRate = samplingRate;
    }

    private void _updateEventBaseInfo() {
        if (this.mEventBase != null) {
            if (this.mEventBase.mDataSource != null) {
                this.mEventContext.play_pos_set.add(this.mEventBase.mDataSource.getLogValueInt(67));
                this.mEventContext.buffer_len_set.add(this.mEventBase.mDataSource.getLogValueLong(68));
                Map videoInfo = this.mEventBase.getVideoInfo();
                if (videoInfo != null) {
                    ArrayList audioBitrate;
                    Map bitrateMap = (Map)videoInfo.get("bitrate");
                    if (bitrateMap != null) {
                        Integer videoBitrate = (Integer)bitrateMap.get(this.mEventBase.mCurrentResolution);
                        if (videoBitrate == null) {
                            this.mEventContext.video_play_bitrate_set.add(-1);
                        } else if (videoBitrate == 0) {
                            this.mEventContext.video_play_bitrate_set.add(-1);
                        } else {
                            this.mEventContext.video_play_bitrate_set.add(this._doBitrateMap(videoBitrate));
                        }
                    }
                    if ((audioBitrate = (ArrayList)videoInfo.get("audio_bitrate")) != null && !audioBitrate.isEmpty()) {
                        if (audioBitrate.get(0) == null) {
                            this.mEventContext.audio_play_bitrate_set.add(-1);
                        } else if ((Integer)audioBitrate.get(0) == 0) {
                            this.mEventContext.audio_play_bitrate_set.add(-1);
                        } else {
                            this.mEventContext.audio_play_bitrate_set.add(this._doBitrateMap((Integer)audioBitrate.get(0)));
                        }
                    }
                }
            }
            this.mEventContext.play_speed_set.add(Float.valueOf(this.mEventBase.mPlaySpeed));
        }
    }

    public void updateNetworkSpeed(String downloadVideoStreamId, String downloadAudioStreamId, float downVideoSpeed, float downAudioSpeed, float predictVideoSpeed, float predictAudioSpeed, long timeInterval, Map<String, String> extraVideoInfo, Map<String, String> extraAudioInfo) {
        Map videoInfo;
        if (!this.mIsStarted || this.mEventBase == null) {
            return;
        }
        this._updateEventBaseInfo();
        String algoType = String.valueOf(this.mEventBase.speed_predict_type);
        if (!(this.mEventBase == null || TextUtils.isEmpty((CharSequence)downloadVideoStreamId) || TextUtils.isEmpty((CharSequence)downloadAudioStreamId) || (videoInfo = this.mEventBase.getVideoInfo()) == null || downloadVideoStreamId.equals("-1") || downloadAudioStreamId.equals("-1"))) {
            Map currentPlackBackFileHashMap = (Map)videoInfo.get("fileKey");
            for (Map.Entry entry : currentPlackBackFileHashMap.entrySet()) {
                if (((String)entry.getValue()).equals(downloadVideoStreamId)) {
                    if (entry.getKey() == null) {
                        this.mEventContext.video_download_bitrate_set.add(-1);
                    } else if ((Integer)entry.getKey() == 0) {
                        this.mEventContext.video_download_bitrate_set.add(-1);
                    } else {
                        this.mEventContext.video_download_bitrate_set.add(this._doBitrateMap((Integer)entry.getKey()));
                    }
                    this.mEventContext.video_sample_interval.add((int)timeInterval);
                    this.mEventContext.video_speed_set.add(Float.valueOf(downVideoSpeed));
                    this.mEventContext.video_predict_speed_set.add(Float.valueOf(predictVideoSpeed));
                    this.mEventContext.video_predict_speed_load_type_set.add(algoType);
                    this.addExtraMapInfoForTrackType(extraVideoInfo, 0);
                }
                if (!((String)entry.getValue()).equals(downloadAudioStreamId)) continue;
                if (entry.getKey() == null) {
                    this.mEventContext.audio_download_bitrate_set.add(-1);
                } else if ((Integer)entry.getKey() == 0) {
                    this.mEventContext.audio_download_bitrate_set.add(-1);
                } else {
                    this.mEventContext.audio_download_bitrate_set.add(this._doBitrateMap((Integer)entry.getKey()));
                }
                this.mEventContext.audio_sample_interval.add((int)timeInterval);
                this.mEventContext.audio_speed_set.add(Float.valueOf(downAudioSpeed));
                this.mEventContext.audio_predict_speed_set.add(Float.valueOf(predictAudioSpeed));
                this.mEventContext.audio_predict_speed_load_type_set.add(algoType);
                this.addExtraMapInfoForTrackType(extraAudioInfo, 1);
            }
        }
        ++this.mEventContext.video_sample_count;
        ++this.mEventContext.audio_sample_count;
        TTVideoEngineLog.d(TAG, "brian video count:" + this.mEventContext.video_sample_count + ",audio count:" + this.mEventContext.audio_sample_count);
        if (this.mEventContext.video_sample_count >= this.mMaxWindowSize || this.mEventContext.audio_sample_count >= this.mMaxWindowSize) {
            if (this.mEventContext.index == 0) {
                this._sendEvent(0);
            } else {
                this._popHead();
            }
        }
    }

    void addExtraMapInfoForTrackType(Map<String, String> extraInfo, int trackType) {
        if (extraInfo == null || extraInfo.size() <= 0 || trackType > 1) {
            return;
        }
        if (trackType == 0) {
            String downLoadSize = extraInfo.get("download_size");
            String downLoadCostTime = extraInfo.get("download_time");
            String tcpInfoRtt = extraInfo.get("rtt");
            String tcpInfoLastRecvDate = extraInfo.get("last_data_recv");
            String protocol = extraInfo.get("mdl_loader_type");
            if (downLoadSize != null) {
                this.mEventContext.video_download_size_set.add(Float.valueOf(Float.parseFloat(downLoadSize)));
            }
            if (downLoadCostTime != null) {
                this.mEventContext.video_downLoad_cost_time_set.add(Long.parseLong(downLoadCostTime));
            }
            if (tcpInfoRtt != null) {
                this.mEventContext.video_tcpinfo_rtt_set.add(Long.parseLong(tcpInfoRtt));
            }
            if (tcpInfoLastRecvDate != null) {
                this.mEventContext.video_tcpinfo_lastRevDate.add(Long.parseLong(tcpInfoLastRecvDate));
            }
            if (protocol != null) {
                this.mEventContext.video_protocol_set.add(protocol);
            }
        } else if (trackType == 1) {
            String downLoadSize = extraInfo.get("download_size");
            String downLoadCostTime = extraInfo.get("download_time");
            String tcpInfoRtt = extraInfo.get("rtt");
            String tcpInfoLastRecvDate = extraInfo.get("last_data_recv");
            String protocol = extraInfo.get("mdl_loader_type");
            if (downLoadSize != null) {
                this.mEventContext.audio_download_size_set.add(Float.valueOf(Float.parseFloat(downLoadSize)));
            }
            if (downLoadCostTime != null) {
                this.mEventContext.audio_downLoad_cost_time_set.add(Long.parseLong(downLoadCostTime));
            }
            if (tcpInfoRtt != null) {
                this.mEventContext.audio_tcpinfo_rtt_set.add(Long.parseLong(tcpInfoRtt));
            }
            if (tcpInfoLastRecvDate != null) {
                this.mEventContext.audio_tcpinfo_lastRevDate.add(Long.parseLong(tcpInfoLastRecvDate));
            }
            if (protocol != null) {
                this.mEventContext.audio_protocol_set.add(protocol);
            }
        }
    }

    private Integer _doBitrateMap(Integer bitrate) {
        if (this.mEventBase == null) {
            return bitrate;
        }
        Map videoInfo = this.mEventBase.getVideoInfo();
        if (videoInfo == null) {
            return bitrate;
        }
        Map bitrateMapTable = (Map)videoInfo.get("bitrateMapTable");
        if (bitrateMapTable != null) {
            Integer index = (Integer)bitrateMapTable.get(bitrate);
            if (index == null) {
                return -1;
            }
            return (Integer)bitrateMapTable.get(bitrate);
        }
        return bitrate;
    }

    public void updateNetworkMutiSpeed(SpeedPredictorResultCollection mutiDownSpeed, SpeedPredictorResultCollection mutiPredictSpeed, long timeInterval) {
        if (!this.mIsStarted || this.mEventBase == null || mutiDownSpeed == null || mutiPredictSpeed == null) {
            return;
        }
        this._updateEventBaseInfo();
        Map videoInfo = this.mEventBase.getVideoInfo();
        if (videoInfo == null) {
            return;
        }
        Map currentPlackBackFileHashMap = (Map)videoInfo.get("fileKey");
        if (currentPlackBackFileHashMap == null || currentPlackBackFileHashMap.isEmpty()) {
            return;
        }
        Boolean[] isVideoMark = new Boolean[]{false};
        Boolean[] isAudioVideoMark = new Boolean[]{false};
        for (Map.Entry entry : currentPlackBackFileHashMap.entrySet()) {
            String currentPlackBackFileId = (String)entry.getValue();
            for (SpeedPredictorResult it : mutiDownSpeed.getResultCollection()) {
                if (!it.getFileId().equals(currentPlackBackFileId) || it == null) continue;
                if (!it.getResultItems().isEmpty()) {
                    int mediaType = it.getResultItems().get(0).getTrackType();
                    if (mediaType == 0) {
                        if (entry.getKey() == null) {
                            this.mEventContext.video_download_bitrate_set.add(-1);
                        } else if ((Integer)entry.getKey() == 0) {
                            this.mEventContext.video_download_bitrate_set.add(-1);
                        } else {
                            this.mEventContext.video_download_bitrate_set.add(this._doBitrateMap((Integer)entry.getKey()));
                        }
                    } else if (entry.getKey() == null) {
                        this.mEventContext.audio_download_bitrate_set.add(-1);
                    } else if ((Integer)entry.getKey() == 0) {
                        this.mEventContext.audio_download_bitrate_set.add(-1);
                    } else {
                        this.mEventContext.audio_download_bitrate_set.add(this._doBitrateMap((Integer)entry.getKey()));
                    }
                }
                this._addResultItemToSampleSet(it, (Integer)entry.getKey(), timeInterval, isVideoMark, isAudioVideoMark);
            }
            for (SpeedPredictorResult it : mutiPredictSpeed.getResultCollection()) {
                if (!it.getFileId().equals(currentPlackBackFileId) || it == null) continue;
                this._addResultItemToPredictorSet(it, (Integer)entry.getKey());
            }
        }
        ++this.mEventContext.video_sample_count;
        ++this.mEventContext.audio_sample_count;
        if (this.mEventContext.video_sample_count >= this.mMaxWindowSize || this.mEventContext.audio_sample_count >= this.mMaxWindowSize) {
            if (this.mEventContext.index == 0) {
                this._sendEvent(0);
            } else {
                this._popHead();
            }
        }
    }

    private void _addResultItemToSampleSet(SpeedPredictorResult result, Integer bitrate, long timeInterval, Boolean[] isVideoMark, Boolean[] isAudioMark) {
        if (result == null) {
            return;
        }
        for (SpeedPredictorResultItem it : result.getResultItems()) {
            String loadType = String.format("%s|%s|%s", it.getLoadType(), it.getHost(), String.valueOf(bitrate));
            if (it.getTrackType() == 0) {
                this.mEventContext.video_speed_set.add(Float.valueOf(it.getBandwidth()));
                this.mEventContext.video_speed_load_type_set.add(loadType);
                if (!isVideoMark[0].booleanValue()) {
                    this.mEventContext.video_sample_interval.add((int)timeInterval);
                    isVideoMark[0] = true;
                    continue;
                }
                this.mEventContext.video_sample_interval.add(0);
                continue;
            }
            if (it.getTrackType() != 1) continue;
            this.mEventContext.audio_speed_set.add(Float.valueOf(it.getBandwidth()));
            this.mEventContext.audio_speed_load_type_set.add(loadType);
            if (!isAudioMark[0].booleanValue()) {
                this.mEventContext.audio_sample_interval.add((int)timeInterval);
                isAudioMark[0] = true;
                continue;
            }
            this.mEventContext.audio_sample_interval.add(0);
        }
    }

    private void _addResultItemToPredictorSet(SpeedPredictorResult result, Integer bitrate) {
        if (result == null) {
            return;
        }
        for (SpeedPredictorResultItem it : result.getResultItems()) {
            String algoType = String.valueOf(this.mEventBase.speed_predict_type);
            String loadType = String.format("%s|%s|%s|%s", it.getLoadType(), it.getHost(), String.valueOf(bitrate), algoType);
            if (it.getTrackType() == 0) {
                this.mEventContext.video_predict_speed_set.add(Float.valueOf(it.getBandwidth()));
                this.mEventContext.video_predict_speed_load_type_set.add(loadType);
                continue;
            }
            if (it.getTrackType() != 1) continue;
            this.mEventContext.audio_predict_speed_set.add(Float.valueOf(it.getBandwidth()));
            this.mEventContext.audio_predict_speed_load_type_set.add(loadType);
        }
    }

    private void _popHead() {
        if (this.mEventContext.video_sample_count > this.mMaxWindowSize || this.mEventContext.audio_sample_count > this.mMaxWindowSize) {
            if (!this.mEventContext.play_pos_set.isEmpty()) {
                this.mEventContext.play_pos_set.remove(0);
            }
            if (!this.mEventContext.buffer_len_set.isEmpty()) {
                this.mEventContext.buffer_len_set.remove(0);
            }
            if (!this.mEventContext.play_speed_set.isEmpty()) {
                this.mEventContext.play_speed_set.remove(0);
            }
            if (!this.mEventContext.video_sample_interval.isEmpty()) {
                this.mEventContext.video_sample_interval.remove(0);
            }
            if (!this.mEventContext.video_speed_set.isEmpty()) {
                this.mEventContext.video_speed_set.remove(0);
            }
            if (!this.mEventContext.video_speed_load_type_set.isEmpty()) {
                this.mEventContext.video_speed_load_type_set.remove(0);
            }
            if (!this.mEventContext.video_predict_speed_set.isEmpty()) {
                this.mEventContext.video_predict_speed_set.remove(0);
            }
            if (!this.mEventContext.video_predict_speed_load_type_set.isEmpty()) {
                this.mEventContext.video_predict_speed_load_type_set.remove(0);
            }
            if (!this.mEventContext.video_download_bitrate_set.isEmpty()) {
                this.mEventContext.video_download_bitrate_set.remove(0);
            }
            if (!this.mEventContext.video_play_bitrate_set.isEmpty()) {
                this.mEventContext.video_play_bitrate_set.remove(0);
            }
            if (!this.mEventContext.video_download_size_set.isEmpty()) {
                this.mEventContext.video_download_size_set.remove(0);
            }
            if (!this.mEventContext.video_downLoad_cost_time_set.isEmpty()) {
                this.mEventContext.video_downLoad_cost_time_set.remove(0);
            }
            if (!this.mEventContext.video_tcpinfo_rtt_set.isEmpty()) {
                this.mEventContext.video_tcpinfo_rtt_set.remove(0);
            }
            if (!this.mEventContext.video_tcpinfo_lastRevDate.isEmpty()) {
                this.mEventContext.video_tcpinfo_lastRevDate.remove(0);
            }
            if (!this.mEventContext.video_protocol_set.isEmpty()) {
                this.mEventContext.video_protocol_set.remove(0);
            }
            --this.mEventContext.video_sample_count;
            if (!this.mEventContext.audio_sample_interval.isEmpty()) {
                this.mEventContext.audio_sample_interval.remove(0);
            }
            if (!this.mEventContext.audio_speed_set.isEmpty()) {
                this.mEventContext.audio_speed_set.remove(0);
            }
            if (!this.mEventContext.audio_speed_load_type_set.isEmpty()) {
                this.mEventContext.audio_speed_load_type_set.remove(0);
            }
            if (!this.mEventContext.audio_predict_speed_set.isEmpty()) {
                this.mEventContext.audio_predict_speed_set.remove(0);
            }
            if (!this.mEventContext.audio_predict_speed_load_type_set.isEmpty()) {
                this.mEventContext.audio_predict_speed_load_type_set.remove(0);
            }
            if (!this.mEventContext.audio_play_bitrate_set.isEmpty()) {
                this.mEventContext.audio_play_bitrate_set.remove(0);
            }
            if (!this.mEventContext.audio_download_bitrate_set.isEmpty()) {
                this.mEventContext.audio_download_bitrate_set.remove(0);
            }
            if (!this.mEventContext.audio_download_size_set.isEmpty()) {
                this.mEventContext.audio_download_size_set.remove(0);
            }
            if (!this.mEventContext.audio_downLoad_cost_time_set.isEmpty()) {
                this.mEventContext.audio_downLoad_cost_time_set.remove(0);
            }
            if (!this.mEventContext.audio_tcpinfo_rtt_set.isEmpty()) {
                this.mEventContext.audio_tcpinfo_rtt_set.remove(0);
            }
            if (!this.mEventContext.audio_tcpinfo_lastRevDate.isEmpty()) {
                this.mEventContext.audio_tcpinfo_lastRevDate.remove(0);
            }
            if (!this.mEventContext.audio_protocol_set.isEmpty()) {
                this.mEventContext.audio_protocol_set.remove(0);
            }
            --this.mEventContext.audio_sample_count;
        }
    }

    private boolean checkCurrentPlayBackVideoIsLegal() {
        boolean isLegal = true;
        Map videoInfo = this.mEventBase.getVideoInfo();
        if (videoInfo == null) {
            return false;
        }
        Map currentPlackBackFileHashMap = (Map)videoInfo.get("fileKey");
        ArrayList<String> values = new ArrayList<String>();
        for (String value : currentPlackBackFileHashMap.values()) {
            if (value.equals("") || value.equals("0")) {
                return false;
            }
            values.add(value);
        }
        for (int i = 0; i < values.size(); ++i) {
            String temp = (String)values.get(i);
            for (int j = i + 1; j < values.size(); ++j) {
                if (!temp.equals(values.get(j))) continue;
                return false;
            }
        }
        return isLegal;
    }

    private void _sendEvent(int index) {
        if (this.mEventContext.video_sample_count == 0 && this.mEventContext.audio_sample_count == 0 && !this.checkCurrentPlayBackVideoIsLegal()) {
            return;
        }
        this.mEventContext.local_time_ms = System.currentTimeMillis();
        this.mEventContext.sample_interval = this.mSampleInterval;
        if (this.mEventBase != null) {
            this.mEventContext.is_abr = this.mEventBase.is_enable_abr;
            this.mEventContext.is_multi_dimensions = this.mEventBase.is_multi_dimensions;
            this.mEventContext.is_multi_dimensions_input = this.mEventBase.is_multi_dimensionsInput;
            this.mEventContext.player_sessionid = this.mEventBase.mSessionID;
            this.mEventContext.video_id = this.mEventBase.mVid;
            this.mEventContext.url = this.mEventBase.mCurURL;
            this.mEventContext.vtype = this.mEventBase.vtype;
            Map videoInfo = this.mEventBase.getVideoInfo();
            if (videoInfo != null && videoInfo.get("bitrateMapTable") != null) {
                try {
                    JSONObject jsonObject = new JSONObject();
                    Map bitrateMapTable = (Map)videoInfo.get("bitrateMapTable");
                    for (Map.Entry it : bitrateMapTable.entrySet()) {
                        jsonObject.put(((Integer)it.getKey()).toString(), it.getValue());
                    }
                    this.mEventContext.bitrate_compress_table = jsonObject;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (videoInfo != null && videoInfo.get("video_bitrate") != null) {
                ArrayList videoBitrate = (ArrayList)videoInfo.get("video_bitrate");
                for (Integer it : videoBitrate) {
                    this.mEventContext.video_biterate_set.add(it);
                }
            }
            if (videoInfo != null && videoInfo.get("audio_bitrate") != null) {
                ArrayList audioBitrate = (ArrayList)videoInfo.get("audio_bitrate");
                for (Integer it : audioBitrate) {
                    this.mEventContext.audio_biterate_set.add(it);
                }
            }
        }
        EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mEventBase.mContext, this, this.mEventBase, this.mEventContext));
        this.mEventContext = new EventContext();
        if (index == 0) {
            this.mEventContext.index = 1;
        }
    }

    private JSONObject toJsonObject(EventContext eventContext) {
        HashMap map = new HashMap();
        LoggerUtils.putToMap(map, "local_time_ms", eventContext.local_time_ms);
        LoggerUtils.putToMap(map, "is_abr", eventContext.is_abr);
        LoggerUtils.putToMap(map, "vtype", eventContext.vtype);
        LoggerUtils.putToMap(map, "sample_interval", eventContext.sample_interval);
        LoggerUtils.putToMap(map, "video_sample_count", eventContext.video_sample_count);
        LoggerUtils.putToMap(map, "video_sample_interval", eventContext.video_sample_interval);
        LoggerUtils.putToMap(map, "video_network_speed_sampling_set", eventContext.video_speed_set);
        LoggerUtils.putToMap(map, "video_network_speed_sampling_load_types", eventContext.video_speed_load_type_set);
        LoggerUtils.putToMap(map, "video_network_speed_predict_set", eventContext.video_predict_speed_set);
        LoggerUtils.putToMap(map, "video_network_speed_predict_load_types", eventContext.video_predict_speed_load_type_set);
        LoggerUtils.putToMap(map, "video_play_bitrate_set", eventContext.video_play_bitrate_set);
        LoggerUtils.putToMap(map, "video_download_bitrate_set", eventContext.video_download_bitrate_set);
        LoggerUtils.putToMap(map, "video_download_size_set", eventContext.video_download_size_set);
        LoggerUtils.putToMap(map, "video_download_costtime_set", eventContext.video_downLoad_cost_time_set);
        LoggerUtils.putToMap(map, "video_tcpInfo_rtt_set", eventContext.video_tcpinfo_rtt_set);
        LoggerUtils.putToMap(map, "video_tcpInfo_lastRecvDate", eventContext.video_tcpinfo_lastRevDate);
        LoggerUtils.putToMap(map, "video_mdl_loader_type", eventContext.video_protocol_set);
        LoggerUtils.putToMap(map, "audio_sample_count", eventContext.audio_sample_count);
        LoggerUtils.putToMap(map, "audio_sample_interval", eventContext.audio_sample_interval);
        LoggerUtils.putToMap(map, "audio_network_speed_sampling_set", eventContext.audio_speed_set);
        LoggerUtils.putToMap(map, "audio_network_speed_sampling_load_types", eventContext.audio_speed_load_type_set);
        LoggerUtils.putToMap(map, "audio_network_speed_predict_set", eventContext.audio_predict_speed_set);
        LoggerUtils.putToMap(map, "audio_network_speed_predict_load_types", eventContext.audio_predict_speed_load_type_set);
        LoggerUtils.putToMap(map, "audio_play_bitrate_set", eventContext.audio_play_bitrate_set);
        LoggerUtils.putToMap(map, "audio_download_bitrate_set", eventContext.audio_download_bitrate_set);
        LoggerUtils.putToMap(map, "audio_download_size_set", eventContext.audio_download_size_set);
        LoggerUtils.putToMap(map, "audio_download_costtime_set", eventContext.audio_downLoad_cost_time_set);
        LoggerUtils.putToMap(map, "audio_tcpInfo_rtt_set", eventContext.audio_tcpinfo_rtt_set);
        LoggerUtils.putToMap(map, "audio_tcpInfo_lastRecvDate", eventContext.audio_tcpinfo_lastRevDate);
        LoggerUtils.putToMap(map, "audio_mdl_loader_type", eventContext.audio_protocol_set);
        LoggerUtils.putToMap(map, "buffer_len_set", eventContext.buffer_len_set);
        LoggerUtils.putToMap(map, "play_speed_set", eventContext.play_speed_set);
        LoggerUtils.putToMap(map, "play_pos_set", eventContext.play_pos_set);
        LoggerUtils.putToMap(map, "index", eventContext.index);
        LoggerUtils.putToMap(map, "player_sessionid", eventContext.player_sessionid);
        LoggerUtils.putToMap(map, "video_id", eventContext.video_id);
        LoggerUtils.putToMap(map, "video_bitrate_set", eventContext.video_biterate_set);
        LoggerUtils.putToMap(map, "audio_bitrate_set", eventContext.audio_biterate_set);
        LoggerUtils.putToMap(map, "is_multi_dimensions", eventContext.is_multi_dimensions);
        LoggerUtils.putToMap(map, "is_multi_dimensions_input", eventContext.is_multi_dimensions_input);
        JSONObject josnObj = new JSONObject(map);
        try {
            josnObj.put("bitrate_map_table", (Object)eventContext.bitrate_compress_table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return josnObj;
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private VideoEventSampleRecord rEvent;
        private Handler rHandler;
        private VideoEventBase rEventBase;
        private Context rContext;
        private EventContext rEventContext;

        public AsyncGetLogDataRunnable(Context context, VideoEventSampleRecord event, VideoEventBase base, EventContext eventContext) {
            this.rEvent = event;
            this.rEventBase = base;
            this.rContext = context;
            this.rEventContext = eventContext;
            this.rHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void run() {
            if (this.rEvent == null) {
                return;
            }
            final JSONObject jsonEvent = this.rEvent.toJsonObject(this.rEventContext);
            if (this.rHandler == null || this.rHandler.getLooper() == null) {
                VideoEventManager.instance.addEventV2(true, jsonEvent, VideoEventSampleRecord.monitorName);
                return;
            }
            this.rHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoEventManager.instance.addEventV2(true, jsonEvent, VideoEventSampleRecord.monitorName);
                }
            });
        }
    }

    private class EventContext {
        public long local_time_ms = Integer.MIN_VALUE;
        public int is_abr = -1;
        public int sample_interval = Integer.MIN_VALUE;
        public int video_sample_count = 0;
        public ArrayList<Integer> video_sample_interval = new ArrayList();
        public ArrayList<Float> video_speed_set = new ArrayList();
        public ArrayList<String> video_speed_load_type_set = new ArrayList();
        public ArrayList<Float> video_predict_speed_set = new ArrayList();
        public ArrayList<String> video_predict_speed_load_type_set = new ArrayList();
        public ArrayList<Integer> video_play_bitrate_set = new ArrayList();
        public ArrayList<Integer> video_download_bitrate_set = new ArrayList();
        public ArrayList<Float> video_download_size_set = new ArrayList();
        public ArrayList<Long> video_downLoad_cost_time_set = new ArrayList();
        public ArrayList<Long> video_tcpinfo_rtt_set = new ArrayList();
        public ArrayList<Long> video_tcpinfo_lastRevDate = new ArrayList();
        public ArrayList<String> video_protocol_set = new ArrayList();
        public int audio_sample_count = 0;
        public ArrayList<Integer> audio_sample_interval = new ArrayList();
        public ArrayList<Float> audio_speed_set = new ArrayList();
        public ArrayList<String> audio_speed_load_type_set = new ArrayList();
        public ArrayList<Float> audio_predict_speed_set = new ArrayList();
        public ArrayList<String> audio_predict_speed_load_type_set = new ArrayList();
        public ArrayList<Integer> audio_play_bitrate_set = new ArrayList();
        public ArrayList<Integer> audio_download_bitrate_set = new ArrayList();
        public ArrayList<Float> audio_download_size_set = new ArrayList();
        public ArrayList<Long> audio_downLoad_cost_time_set = new ArrayList();
        public ArrayList<Long> audio_tcpinfo_rtt_set = new ArrayList();
        public ArrayList<Long> audio_tcpinfo_lastRevDate = new ArrayList();
        public ArrayList<String> audio_protocol_set = new ArrayList();
        public ArrayList<Long> buffer_len_set = new ArrayList();
        public ArrayList<Float> play_speed_set = new ArrayList();
        public ArrayList<Integer> play_pos_set = new ArrayList();
        public int index = 0;
        public String player_sessionid = "";
        public String video_id = "";
        public String url = "";
        public ArrayList<Integer> video_biterate_set = new ArrayList();
        public ArrayList<Integer> audio_biterate_set = new ArrayList();
        public JSONObject bitrate_compress_table;
        public String vtype = "";
        public int is_multi_dimensions = -1;
        public int is_multi_dimensions_input = -1;

        private EventContext() {
        }
    }
}

