/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.selector.gracie;

import android.support.annotation.NonNull;
import com.bytedance.vcloud.abrmodule.ABRBufferInfo;
import com.bytedance.vcloud.abrmodule.IABRModuleSpeedRecord;
import com.bytedance.vcloud.abrmodule.IBufferInfo;
import com.bytedance.vcloud.abrmodule.IPlayStateSupplier;
import com.bytedance.vcloud.abrmodule.ISegmentInfo;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.model.IVideoInfo;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.MediaBitrateFitterInfo;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.strategrycenter.StrategyCenter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;

class GracieStateSupplier
implements IPlayStateSupplier {
    @NonNull
    IVideoModel mVideoModel;

    private GracieStateSupplier(@NonNull IVideoModel mVideoModel) {
        this.mVideoModel = mVideoModel;
    }

    @Override
    public float getPlaySpeed() {
        return 1.0f;
    }

    @Override
    public float getNetworkSpeed() {
        if (StrategyCenter.sNetAbrSpeedPredictor != null) {
            return StrategyCenter.sNetAbrSpeedPredictor.getPredictSpeed(0);
        }
        return -1.0f;
    }

    @Override
    public float getDownloadSpeed() {
        Map<String, String> speedPair;
        if (StrategyCenter.sNetAbrSpeedPredictor != null && (speedPair = StrategyCenter.sNetAbrSpeedPredictor.getDownloadSpeed(VideoRef.TYPE_VIDEO)) != null && speedPair.get("download_speed") != null) {
            return Float.parseFloat(speedPair.get("download_speed"));
        }
        return -1.0f;
    }

    @Override
    public float getSpeedConfidence() {
        if (StrategyCenter.sNetAbrSpeedPredictor != null) {
            return StrategyCenter.sNetAbrSpeedPredictor.getLastPredictConfidence();
        }
        return -1.0f;
    }

    @Override
    public float getAverageDownloadSpeed(int mediaType, int speed_type, boolean trigger) {
        if (StrategyCenter.sNetAbrSpeedPredictor != null) {
            return StrategyCenter.sNetAbrSpeedPredictor.getAverageDownloadSpeed(mediaType, speed_type, trigger);
        }
        return -1.0f;
    }

    @Override
    public int getNetworkState() {
        return DataLoaderHelper.getDataLoader().getIntValue(1008);
    }

    @Override
    public Map<String, IBufferInfo> getVideoBufferInfo() {
        HashMap<String, IBufferInfo> map = new HashMap<String, IBufferInfo>();
        List<VideoInfo> infoList = this.mVideoModel.getVideoInfoList();
        if (infoList == null || infoList.size() == 0) {
            return map;
        }
        for (IVideoInfo iVideoInfo : infoList) {
            if (iVideoInfo == null || iVideoInfo.getMediatype() != VideoRef.TYPE_VIDEO) continue;
            ABRBufferInfo bufferInfo = new ABRBufferInfo();
            String fileHash = iVideoInfo.getValueStr(15);
            bufferInfo.setStreamId(fileHash);
            bufferInfo.setFileAvailSize(TTVideoEngine.getCacheFileSize(fileHash));
            MediaBitrateFitterInfo fitterInfo = iVideoInfo.getBitrateFitterInfo();
            if (fitterInfo != null) {
                bufferInfo.setHeadSize(fitterInfo.getHeaderSize());
            }
            map.put("" + iVideoInfo.getValueInt(3), bufferInfo);
        }
        return map;
    }

    @Override
    public Map<String, IBufferInfo> getAudioBufferInfo() {
        HashMap<String, IBufferInfo> map = new HashMap<String, IBufferInfo>();
        List<VideoInfo> infoList = this.mVideoModel.getVideoInfoList();
        if (infoList == null || infoList.size() == 0) {
            return map;
        }
        for (IVideoInfo iVideoInfo : infoList) {
            if (iVideoInfo == null || iVideoInfo.getMediatype() != VideoRef.TYPE_AUDIO) continue;
            ABRBufferInfo bufferInfo = new ABRBufferInfo();
            String fileHash = iVideoInfo.getValueStr(15);
            bufferInfo.setStreamId(fileHash);
            bufferInfo.setFileAvailSize(TTVideoEngine.getCacheFileSize(fileHash));
            MediaBitrateFitterInfo fitterInfo = iVideoInfo.getBitrateFitterInfo();
            if (fitterInfo != null) {
                bufferInfo.setHeadSize(fitterInfo.getHeaderSize());
            }
            map.put("" + iVideoInfo.getValueInt(3), bufferInfo);
        }
        return map;
    }

    @Override
    public int getLoaderType() {
        return -1;
    }

    @Override
    public int getCurrentDownloadVideoBitrate() {
        return -1;
    }

    @Override
    public int getCurrentDownloadAudioBitrate() {
        return -1;
    }

    @Override
    public int getCurrentPlaybackTime() {
        return -1;
    }

    @Override
    public int getMaxCacheVideoTime() {
        return -1;
    }

    @Override
    public int getMaxCacheAudioTime() {
        return -1;
    }

    @Override
    public int getPlayerVideoCacheTime() {
        return 0;
    }

    @Override
    public int getPlayerAudioCacheTime() {
        return -1;
    }

    @Override
    public int getCurrentDownloadVideoSegmentIndex() {
        return -1;
    }

    @Override
    public int getCurrentDownloadAudioSegmentIndex() {
        return -1;
    }

    @Override
    public List<? extends ISegmentInfo> getSegmentInfoList(int videoWindowSize, int audioWindowSize) {
        return null;
    }

    @Override
    public Queue<IABRModuleSpeedRecord> getTimelineNetworkSpeed() {
        return null;
    }
}

