/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy.common;

import com.ss.ttvideoengine.TTVideoEngineInterface;
import com.ss.ttvideoengine.strategy.StrategySettings;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import org.json.JSONObject;

public class StrategyStatic {
    private static final String TAG = "Strategy Static";
    private static final String NETWORK_TIMEOUT = "network_timeout";
    private static final String BUFFERING_TIMEOUT = "buffering_timeout";
    private static final String NOTIFY_BUFFERING_DIRECTLY = "notify_buffering_directly";
    private static final String BUFFERING_DATA = "buffering_data";
    private static final String MAX_BUFFERING_DATA = "max_buffering_data";
    private static final String P_UPDATE_INR = "p_update_inr";
    private static final String P_UPDATE_INR_TH = "p_update_inr_th";
    public static final int INT_NULL = -100;
    private final int mScene;
    private JSONObject mStaticConfig;
    private int mNetworkTimeout = -100;
    private int mBufferingTimeout = -100;
    private int mNotifyBufferingDirectly = -100;
    private int mBufferingData = -100;
    private int mMaxBufferingData = -100;
    private int mPUpdateInr = -100;
    private int mPUpdateInrTh = -100;

    public StrategyStatic(int scene) {
        this.mScene = scene;
        this.updateConfig();
    }

    public void updateConfig() {
        this.mStaticConfig = StrategySettings.getInstance().getStatic(this.mScene);
        TTVideoEngineLog.d(TAG, "updateConfig " + this.mStaticConfig);
        if (this.mStaticConfig == null) {
            return;
        }
        this.mNetworkTimeout = this.mStaticConfig.optInt(NETWORK_TIMEOUT, -100);
        this.mBufferingTimeout = this.mStaticConfig.optInt(BUFFERING_TIMEOUT, -100);
        this.mNotifyBufferingDirectly = this.mStaticConfig.optInt(NOTIFY_BUFFERING_DIRECTLY, -100);
        this.mBufferingData = this.mStaticConfig.optInt(BUFFERING_DATA, -100);
        this.mMaxBufferingData = this.mStaticConfig.optInt(MAX_BUFFERING_DATA, -100);
        this.mPUpdateInr = this.mStaticConfig.optInt(P_UPDATE_INR, -100);
        this.mPUpdateInrTh = this.mStaticConfig.optInt(P_UPDATE_INR_TH, -100);
    }

    public void engineCreate(TTVideoEngineInterface engine) {
        if (engine == null || this.mStaticConfig == null) {
            return;
        }
        TTVideoEngineLog.d(TAG, "engineCreate " + engine);
        if (this.mNetworkTimeout != -100) {
            engine.setIntOption(12, this.mNetworkTimeout);
        }
        if (this.mBufferingTimeout != -100) {
            engine.setIntOption(11, this.mBufferingTimeout);
        }
        if (this.mNotifyBufferingDirectly != -100) {
            engine.setIntOption(322, this.mNotifyBufferingDirectly);
        }
        if (this.mBufferingData != -100) {
            engine.setIntOption(118, this.mBufferingData);
        }
        if (this.mMaxBufferingData != -100) {
            engine.setIntOption(202, this.mMaxBufferingData);
        }
    }

    public void onPrepared(TTVideoEngineInterface engine) {
        int duration;
        if (engine == null || this.mStaticConfig == null) {
            return;
        }
        TTVideoEngineLog.d(TAG, "onPrepared " + engine);
        if (this.mPUpdateInr != -100 && this.mPUpdateInrTh != -100 && (duration = engine.getDuration()) >= this.mPUpdateInrTh * 1000) {
            engine.setIntOption(602, this.mPUpdateInr);
        }
    }
}

