/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import com.ss.ttvideoengine.JniUtils;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineInternalHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class TTHelper {
    private static final String TAG = "TTHelper";
    private static String mAppPath = null;
    private static String sBoeSuffix = "";
    private static String queryStrAllowCharset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.~#[]!\\()*%";
    private static volatile long sLastGetExternalStorageStateTime = -1L;
    private static volatile String sLastExternalStorageState = null;

    public static void configBoeSuffix(String boeSuffix) {
        sBoeSuffix = boeSuffix;
    }

    public static String base64Decode(String string, String keyseed) {
        if (!TextUtils.isEmpty((CharSequence)string) && TTHelper.isBase64(string)) {
            try {
                byte[] data = Base64.decode((String)string, (int)0);
                if (TextUtils.isEmpty((CharSequence)keyseed)) {
                    return new String(data, "utf-8");
                }
                byte[] seed = Base64.decode((String)keyseed, (int)0);
                return JniUtils.getDecodedStrWithKey(data, seed);
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(TAG, e.toString());
                return "";
            }
        }
        return string;
    }

    public static String base64Decode(String string) {
        return TTHelper.base64Decode(string, null);
    }

    public static boolean isBase64(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, str);
    }

    public static byte[] base64DecodeToBytes(String string) {
        TTVideoEngineLog.d(TAG, "base64DecodeToBytes " + string);
        byte[] bytes = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                bytes = Base64.decode((String)string, (int)0);
            }
            catch (Throwable e) {
                TTVideoEngineLog.e(TAG, "base64DecodeToBytes " + e.toString());
            }
        }
        return bytes;
    }

    public static final String customBase64Encode(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String temString = string.replace("_", "$");
        temString = temString.replace("/", "@");
        temString = temString.replace(".", "#");
        return temString;
    }

    public static final String customBase64Decode(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String temString = string.replace("$", "_");
        temString = temString.replace("@", "/");
        temString = temString.replace("#", ".");
        return temString;
    }

    public static int versionStringToInt(String version) {
        if (version == null || version.isEmpty()) {
            return 0;
        }
        String[] versionArray = version.split("\\.");
        if (versionArray.length <= 0) {
            return 0;
        }
        int versionCode = 0;
        for (int i = 0; i < versionArray.length; ++i) {
            int result = 0;
            try {
                if (i == 0) {
                    versionCode = Integer.parseInt(versionArray[i]);
                    continue;
                }
                result = Integer.parseInt(versionArray[i]);
                versionCode = versionCode * 100 + result;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return versionCode;
    }

    public static final String appendQueryString(String url, String param) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)param)) {
            return url;
        }
        if (url.indexOf(param) != -1) {
            return url;
        }
        url = url.indexOf("?") == -1 ? url + "?" + param : url + "&" + param;
        return url;
    }

    public static final String getAppFilesPath(Context context) {
        if (mAppPath != null) {
            return mAppPath;
        }
        if (context == null) {
            return null;
        }
        try {
            mAppPath = context.getApplicationContext().getFilesDir().getAbsolutePath();
        }
        catch (Exception var2) {
            return null;
        }
        return mAppPath;
    }

    public static final boolean isStringHex(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return value.matches("^[A-Fa-f0-9]+$");
    }

    public static final boolean isTranscodeUrlList(String[] urls) {
        if (urls == null || urls.length <= 0) {
            return false;
        }
        for (int i = 0; i < urls.length; ++i) {
            if (!TTHelper.isTranscodeUrl(urls[i])) continue;
            return true;
        }
        return false;
    }

    public static final boolean isTranscodeUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        TTVideoEngineLog.d("isTranscodeUrl", "----start check url:" + url);
        Uri uri = Uri.parse((String)url);
        String value = uri.getQueryParameter("btag");
        if (TextUtils.isEmpty((CharSequence)value)) {
            TTVideoEngineLog.d("isTranscodeUrl", "get query value is null");
            return false;
        }
        TTVideoEngineLog.d("isTranscodeUrl", "get query value is:" + value);
        if (!TTHelper.isStringHex(value)) {
            TTVideoEngineLog.d("isTranscodeUrl", "not hex string");
            return false;
        }
        BigInteger bigValue = new BigInteger(value, 16);
        BigInteger pattern = new BigInteger("80000", 16);
        if (bigValue.and(pattern).compareTo(pattern) == 0) {
            TTVideoEngineLog.d("isTranscodeUrl", "end url is transcoded");
            return true;
        }
        TTVideoEngineLog.d("isTranscodeUrl", "****end url is not transcoded");
        return false;
    }

    public static final void recursionDeleteFile(File file) {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFile = file.listFiles();
            if (childFile == null || childFile.length == 0) {
                file.delete();
                return;
            }
            for (File f : childFile) {
                TTHelper.recursionDeleteFile(f);
            }
            file.delete();
        }
    }

    public static final void deleteBeforeDirFiles(Context context) {
        if (context == null) {
            return;
        }
        String temString = TTHelper.getAppFilesPath(context);
        if (temString == null) {
            return;
        }
        File file = new File(temString);
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            String temName;
            if (!f.isFile() || !(temName = f.getName()).matches("^[0-9]{1,15}\\.cach$")) continue;
            f.delete();
        }
    }

    public static final String encodeQuery(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        try {
            String encodeURL = Uri.encode((String)url, (String)queryStrAllowCharset);
            return encodeURL;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final HashMap<String, Resolution> defaultVideoResolutionMap() {
        HashMap<String, Resolution> temMap = new HashMap<String, Resolution>();
        temMap.put("240p", Resolution.L_Standard);
        temMap.put("360p", Resolution.Standard);
        temMap.put("480p", Resolution.High);
        temMap.put("540p", Resolution.H_High);
        temMap.put("720p", Resolution.SuperHigh);
        temMap.put("1080p", Resolution.ExtremelyHigh);
        temMap.put("2k", Resolution.TwoK);
        temMap.put("4k", Resolution.FourK);
        temMap.put("hdr", Resolution.HDR);
        temMap.put("1080p 50fps", Resolution.ExtremelyHigh_50F);
        temMap.put("2k 50fps", Resolution.TwoK_50F);
        temMap.put("4k 50fps", Resolution.FourK_50F);
        temMap.put("1080p 60fps", Resolution.ExtremelyHigh_60F);
        temMap.put("2k 60fps", Resolution.TwoK_60F);
        temMap.put("4k 60fps", Resolution.FourK_60F);
        temMap.put("1080p 120fps", Resolution.ExtremelyHigh_120F);
        temMap.put("2k 120fps", Resolution.TwoK_120F);
        temMap.put("4k 120fps", Resolution.FourK_120F);
        temMap.put("240p HDR", Resolution.L_Standard_HDR);
        temMap.put("360p HDR", Resolution.Standard_HDR);
        temMap.put("480p HDR", Resolution.High_HDR);
        temMap.put("540p HDR", Resolution.H_High_HDR);
        temMap.put("720p HDR", Resolution.SuperHigh_HDR);
        temMap.put("1080p HDR", Resolution.ExtremelyHigh_HDR);
        temMap.put("2k HDR", Resolution.TwoK_HDR);
        temMap.put("4k HDR", Resolution.FourK_HDR);
        temMap.put("8k", Resolution.EightK);
        temMap.put("1080p+", Resolution.ExtremelyHighPlus);
        return temMap;
    }

    public static final HashMap<String, Resolution> defaultAudioResolutionMap() {
        HashMap<String, Resolution> temMap = new HashMap<String, Resolution>();
        temMap.put("medium", Resolution.Standard);
        temMap.put("higher", Resolution.High);
        temMap.put("highest", Resolution.SuperHigh);
        temMap.put("original", Resolution.ExtremelyHigh);
        temMap.put("lossless", Resolution.FourK);
        return temMap;
    }

    public static final String buildBoeUrl(String url) {
        if (url == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)sBoeSuffix)) {
            return url;
        }
        boolean isBoe = url.contains(sBoeSuffix);
        boolean ipAddress = TTHelper.isIP(url);
        if (url.startsWith("https")) {
            url = url.replace("https", "http");
        }
        if (!ipAddress && url.indexOf("http") == 0 && !isBoe) {
            try {
                URL urlStr = new URL(url);
                String host = urlStr.getHost();
                StringBuilder builder = new StringBuilder();
                builder.append(host);
                builder.append(String.format(".%s", sBoeSuffix));
                url = url.replace(host, builder);
            }
            catch (Exception e) {
                TTVideoEngineLog.d(e);
            }
        }
        return url;
    }

    public static final String buildHttpsUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && !url.contains("http://127.0.0.1")) {
            return url.replaceAll("http:", "https:");
        }
        return url;
    }

    public static final String buildHttpUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && url.startsWith("https")) {
            return url.replace("https", "http");
        }
        return url;
    }

    public static final boolean isIP(String addr) {
        String str;
        if (addr == null || addr.equals("")) {
            return false;
        }
        String host = "";
        try {
            URL url = new URL(addr);
            host = url.getHost();
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(host);
        boolean ipAddress = mat.find();
        if (ipAddress) {
            return true;
        }
        int lbracket = addr.indexOf("[");
        int rbracket = addr.indexOf("]");
        return lbracket > 0 && rbracket > lbracket && (str = addr.substring(lbracket, rbracket)).indexOf(":") > 0;
    }

    public static final String computeMD5(String origin) {
        String result = "";
        try {
            result = origin;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(origin.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception exception) {
            return result;
        }
    }

    public static String replaceHostInURL(String URLToReplace, String newHost) {
        if (TextUtils.isEmpty((CharSequence)URLToReplace)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)newHost)) {
            return URLToReplace;
        }
        try {
            URI uri = new URI(URLToReplace);
            String oldHost = uri.getHost();
            if (TextUtils.isEmpty((CharSequence)oldHost)) {
                return URLToReplace;
            }
            return URLToReplace.replaceFirst(oldHost, newHost);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return URLToReplace;
        }
    }

    public static boolean isEmpty(JSONArray array) {
        return array == null || array.length() == 0;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.size() == 0;
    }

    public static boolean isEmpty(String[] strs) {
        return strs == null || strs.length == 0;
    }

    public static boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static String genTrackID(String deviceID, long time) {
        StringBuilder builder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)deviceID)) {
            builder.append(deviceID);
            builder.append("T");
        }
        builder.append(Long.toString(time));
        builder.append("T");
        String randomStr = Integer.toString((int)(Math.random() * 65535.0));
        builder.append(randomStr);
        return builder.toString();
    }

    public static final String md5(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes());
            StringBuilder result = new StringBuilder();
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result.append(temp);
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            TTVideoEngineLog.d(e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileMd5(File file) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return TTHelper.bytesToHexString(digest.digest());
    }

    private static final String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String keyFromFilePath(Context context, String filePath) {
        String appPath;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        if (context != null && !TextUtils.isEmpty((CharSequence)(appPath = TTHelper.getAppFilesPath(context)))) {
            filePath.replace(appPath, "");
        }
        String result = TTHelper.md5(filePath);
        return result;
    }

    public static float getVolume(Context context) {
        return TTVideoEngineInternalHelper.getVolume(context);
    }

    public static Looper getLooper() {
        if (Looper.myLooper() != null) {
            return Looper.myLooper();
        }
        return Looper.getMainLooper();
    }

    public static final String encodeUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        try {
            String encodeURL = URLEncoder.encode(url, "UTF-8");
            return encodeURL;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static final String decodeUrl(String url) {
        try {
            String prevURL = "";
            String decodeURL = url;
            while (!prevURL.equals(decodeURL)) {
                prevURL = decodeURL;
                decodeURL = URLDecoder.decode(decodeURL, "UTF-8");
            }
            return decodeURL;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Class<?> getClzUsingPluginLoader(int pluginType, String className) throws Exception {
        if (pluginType < 0 || TextUtils.isEmpty((CharSequence)className)) {
            throw new Exception("pluginName or/and className is empty");
        }
        ClassLoader classLoader = TTVideoEngineConfig.getClassLoader(pluginType);
        if (classLoader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Error errorWithJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        Error error = null;
        try {
            String domain = jsonObject.optString("domain");
            int code = jsonObject.optInt("code");
            int innerCode = jsonObject.optInt("innerCode");
            String des = jsonObject.optString("des");
            error = new Error(domain, code, innerCode, des);
            return error;
        }
        catch (Throwable e) {
            TTVideoEngineLog.e("TTVideoEngineTTHelper", "generate error fail. " + e.toString() + " " + jsonObject.toString());
        }
        finally {
            return error;
        }
    }

    public static final JSONObject jsonWithError(Error error) {
        if (error == null) {
            return null;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject();
            jsonObject.put("domain", (Object)error.domain);
            jsonObject.put("code", error.code);
            jsonObject.put("innerCode", error.internalCode);
            jsonObject.put("des", (Object)error.description);
        }
        catch (Throwable e) {
            TTVideoEngineLog.e("TTVideoEngineTTHelper", "error to json fail. " + e.toString() + " " + jsonObject.toString());
        }
        finally {
            return jsonObject;
        }
    }

    public static final boolean isExternalStorageWritable() {
        return "mounted".equals(TTHelper.safeGetExternalStorageState());
    }

    public static final String safeGetExternalStorageState() {
        if (!TextUtils.isEmpty((CharSequence)sLastExternalStorageState) && System.currentTimeMillis() - sLastGetExternalStorageStateTime < 5000L) {
            return sLastExternalStorageState;
        }
        try {
            sLastGetExternalStorageStateTime = System.currentTimeMillis();
            sLastExternalStorageState = Environment.getExternalStorageState();
            return sLastExternalStorageState;
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static final boolean isAndroidJB2() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static final long getDirectoryAvailableSize(String path) {
        try {
            long availableBlocks;
            long blockSize;
            StatFs stat = new StatFs(path);
            if (TTHelper.isAndroidJB2()) {
                blockSize = stat.getBlockSizeLong();
                availableBlocks = stat.getAvailableBlocksLong();
            } else {
                blockSize = stat.getBlockSize();
                availableBlocks = stat.getAvailableBlocks();
            }
            return blockSize * availableBlocks;
        }
        catch (IllegalArgumentException var6) {
            return -1L;
        }
    }

    public static final long getAvailableStorageSize(Context context) {
        if (context == null) {
            return -1L;
        }
        return Environment.getDataDirectory() != null ? TTHelper.getDirectoryAvailableSize(context.getFilesDir().getParent()) : -1L;
    }

    public static final long getFreeSize(Context context) {
        if (context == null) {
            return -1L;
        }
        if (TTHelper.isExternalStorageWritable()) {
            long availCount = 0L;
            availCount = TTHelper.getAvailableStorageSize(context);
            return availCount;
        }
        return -1L;
    }

    public static String getParam(String url, String paramKey) {
        List<String> urlSlices = TTHelper.getUrlSlices(url, paramKey);
        if (urlSlices == null || urlSlices.size() == 0) {
            return null;
        }
        for (String urlSlice : urlSlices) {
            if (!urlSlice.startsWith(paramKey + "=")) continue;
            return urlSlice.substring(paramKey.length() + 1);
        }
        return null;
    }

    public static String overrideUrlParam(String url, String paramKey, String value) {
        List<String> urlSlices = TTHelper.getUrlSlices(url, paramKey);
        if (urlSlices == null || urlSlices.size() == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder();
        for (String urlSlice : urlSlices) {
            if (urlSlice.startsWith(paramKey + "=")) {
                newUrl.append(paramKey).append("=").append(value);
                continue;
            }
            newUrl.append(urlSlice);
        }
        return newUrl.toString();
    }

    private static List<String> getUrlSlices(String url, String paramKey) {
        ArrayList<String> result = new ArrayList<String>();
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String[] urls = url.split("[?]");
        if (urls.length < 2) {
            return null;
        }
        String urlDomain = urls[0];
        String params = urls[1];
        int begin = params.indexOf(paramKey + "=");
        if (begin == -1) {
            return null;
        }
        result.add(urlDomain);
        result.add("?");
        result.add(params.substring(0, begin));
        int end = params.indexOf("&", begin);
        if (end == -1) {
            result.add(params.substring(begin));
            return result;
        }
        result.add(params.substring(begin, end));
        result.add(params.substring(end));
        return result;
    }

    public static int parseInt(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new NumberFormatException("Can't format " + o.getClass() + " to int");
    }

    public static String hmacSha1(String data) {
        byte[] signature = JniUtils.getSettingSignature(data);
        if (signature == null) {
            TTVideoEngineLog.d(TAG, "hmacSha1 signature is null");
            return null;
        }
        return TTHelper.getHexString(signature);
    }

    public static String getHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte value : bytes) {
            String hex = Integer.toHexString(value & 0xFF);
            if (hex.length() < 2) {
                result.append(0);
            }
            result.append(hex);
        }
        return result.toString();
    }

    public static StringBuilder buildUrlEncodedQuery(Map<String, Object> queryMap) {
        StringBuilder queryBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : queryMap.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            queryBuilder.append(URLEncoder.encode(entry.getKey())).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()))).append("&");
        }
        if (queryBuilder.length() > 0) {
            queryBuilder.deleteCharAt(queryBuilder.length() - 1);
        }
        return queryBuilder;
    }
}

