/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import com.ss.ttm.player.LoadControl;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class EngineLoadControl
extends LoadControl {
    private static final int CACHE_VIDEO_DURATION_MS = 30;
    private static final int CACHE_AUDIO_DURATION_MS = 40;
    private int mVideoTrackCacheDurationMs;
    private int mAudioTrackCacheDurationMs;
    private int mStartupDurationPreloadedMs = 200;
    private int mStartupDurationNonpreloadedMs = 1000;
    private int mRebufferingDurationInitMs = 1000;
    private int mRebufferingDurationMaxMs = 5000;
    private float mRebufferingIncFactor = 0.5f;
    private int mRebufferingIncType = 0;
    private int mRebufferingCount = 0;
    private TTVideoEngine mVideoEngine;

    public EngineLoadControl(int startupDurationPreloadedMs, int startupDurationNonpreloadedMs, int rebufferingDurationInitMs, int rebufferingDurationMaxMs, float rebufferingIncFactor, int rebufferingIncType, TTVideoEngine engine) {
        this.mStartupDurationPreloadedMs = startupDurationPreloadedMs;
        this.mStartupDurationNonpreloadedMs = startupDurationNonpreloadedMs;
        this.mRebufferingDurationInitMs = rebufferingDurationInitMs;
        this.mRebufferingDurationMaxMs = rebufferingDurationMaxMs;
        this.mRebufferingIncFactor = rebufferingIncFactor;
        this.mRebufferingIncType = rebufferingIncType;
        this.mVideoEngine = engine;
    }

    protected int onTrackSelected(int trackType) {
        switch (trackType) {
            case 2: {
                return this.mAudioTrackCacheDurationMs;
            }
            case 1: {
                return this.mVideoTrackCacheDurationMs;
            }
        }
        return -1;
    }

    protected boolean shouldStartPlayback(long bufferedDurationMs, float playbackSpeed, boolean rebuffering) {
        boolean bufferEnd = false;
        if (rebuffering) {
            long needBufferedMs;
            switch (this.mRebufferingIncType) {
                case 0: {
                    needBufferedMs = (long)Math.min((float)this.mRebufferingDurationInitMs + (float)this.mRebufferingCount * this.mRebufferingIncFactor * (float)this.mRebufferingDurationInitMs, (float)this.mRebufferingDurationMaxMs);
                    break;
                }
                case 1: {
                    needBufferedMs = (long)Math.min((double)this.mRebufferingDurationInitMs * (1.0 + (double)this.mRebufferingIncFactor * Math.log1p(this.mRebufferingCount)), (double)this.mRebufferingDurationMaxMs);
                    break;
                }
                default: {
                    needBufferedMs = this.mRebufferingDurationInitMs;
                }
            }
            if (bufferedDurationMs >= needBufferedMs) {
                bufferEnd = true;
                ++this.mRebufferingCount;
                TTVideoEngineLog.d("defaultlc", " parameters:  sdp " + this.mStartupDurationPreloadedMs + " sdnp " + this.mStartupDurationNonpreloadedMs + " rdi " + this.mRebufferingDurationInitMs + " rdm " + this.mRebufferingDurationMaxMs + " rif " + this.mRebufferingIncFactor + " rit " + this.mRebufferingIncType);
                TTVideoEngineLog.d("defaultlc", " buffer end:  rebuf count " + this.mRebufferingCount + ", need buf " + needBufferedMs + ", now buf " + bufferedDurationMs);
            }
        } else {
            boolean preloaded = this.mVideoEngine.getLongOption(461) > 0L;
            boolean bl = bufferEnd = bufferedDurationMs >= (long)(preloaded ? this.mStartupDurationPreloadedMs : this.mStartupDurationNonpreloadedMs);
            if (bufferEnd) {
                TTVideoEngineLog.d("defaultlc", " parameters:  sdp " + this.mStartupDurationPreloadedMs + " sdnp " + this.mStartupDurationNonpreloadedMs + " rdi " + this.mRebufferingDurationInitMs + " rdm " + this.mRebufferingDurationMaxMs + " rif " + this.mRebufferingIncFactor + " rit " + this.mRebufferingIncType);
                TTVideoEngineLog.d("defaultlc", " start up:    preloaded " + preloaded + ", need buf " + (preloaded ? this.mStartupDurationPreloadedMs : this.mStartupDurationNonpreloadedMs) + ", now buf " + bufferedDurationMs);
            }
        }
        return bufferEnd;
    }

    protected int onCodecStackSelected(int trackType) {
        switch (trackType) {
            case 2: {
                return this.mAudioTrackCacheDurationMs;
            }
            case 1: {
                return this.mVideoTrackCacheDurationMs;
            }
        }
        return -1;
    }

    protected int onFilterStackSelected(int trackType) {
        switch (trackType) {
            case 2: {
                return this.mAudioTrackCacheDurationMs;
            }
            case 1: {
                return this.mVideoTrackCacheDurationMs;
            }
        }
        return -1;
    }
}

