/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.Context;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.fetcher.mdlfethcer.MDLFetcherListener;
import com.ss.ttvideoengine.log.IVideoEventLogger;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.TTVideoEngineUtils;
import java.lang.ref.WeakReference;

public class EngineMDLFetcherListener
implements MDLFetcherListener {
    private static final String TAG = "EngineMDLFetcherListener";
    public static final int MDL_RETRY_RESULT_ERROR = 0;
    public static final int MDL_RETRY_RESULT_SUCCESS = 1;
    public static final int MDL_RETRY_RESULT_SUCCESS_CACHE = 2;
    private final WeakReference<TTVideoEngine> mVideoEngineRef;

    public EngineMDLFetcherListener(TTVideoEngine videoEngine) {
        this.mVideoEngineRef = new WeakReference<TTVideoEngine>(videoEngine);
    }

    @Override
    public String getId() {
        TTVideoEngine videoEngine = (TTVideoEngine)this.mVideoEngineRef.get();
        if (videoEngine == null) {
            return null;
        }
        return videoEngine.getHash();
    }

    @Override
    public String getFallbackApi() {
        TTVideoEngine videoEngine = (TTVideoEngine)this.mVideoEngineRef.get();
        if (videoEngine == null) {
            return null;
        }
        String apiString = videoEngine.getAPIString();
        return TTVideoEngineUtils.BuildHttpsApi(apiString);
    }

    @Override
    public Context getContext() {
        TTVideoEngine videoEngine = (TTVideoEngine)this.mVideoEngineRef.get();
        if (videoEngine == null) {
            return null;
        }
        return videoEngine.getContext();
    }

    @Override
    public void onError(Error error, String fileHash) {
        TTVideoEngineLog.i(TAG, "videoEngine mdl fetch failed " + error.toString());
        TTVideoEngine videoEngine = (TTVideoEngine)this.mVideoEngineRef.get();
        if (videoEngine == null) {
            return;
        }
        IVideoEventLogger logger = videoEngine.getLogger();
        if (logger != null) {
            logger.mdlRetryResult(0, fileHash, error);
        }
    }

    @Override
    public void onRetry(Error error) {
        TTVideoEngine videoEngine = (TTVideoEngine)this.mVideoEngineRef.get();
        if (error == null || videoEngine == null || videoEngine.getLogger() == null) {
            return;
        }
        TTVideoEngineLog.e(TAG, "fetcher should retry error " + error.toString());
        videoEngine.getLogger().needRetryToFetch(error, videoEngine.getPlayAPIVersion());
    }

    @Override
    public void onLog(String message) {
        TTVideoEngineLog.i(TAG, "fetcher cancelled");
        TTVideoEngine videoEngine = (TTVideoEngine)this.mVideoEngineRef.get();
        if (videoEngine == null || videoEngine.getLogger() == null) {
            return;
        }
        videoEngine.getLogger().logMessage(message);
    }

    @Override
    public void onCompletion(VideoModel model, boolean newModel, String fileHash) {
        TTVideoEngine videoEngine = (TTVideoEngine)this.mVideoEngineRef.get();
        if (videoEngine == null) {
            return;
        }
        TTVideoEngineLog.i(TAG, "fetch info success");
        IVideoEventLogger logger = videoEngine.getLogger();
        if (logger != null) {
            int resultCode = newModel ? 1 : 2;
            logger.mdlRetryResult(resultCode, fileHash, null);
        }
        if (logger != null && newModel) {
            logger.fetchInfoComplete(model, null);
        }
    }
}

