/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.text.TextUtils;
import com.pandora.ttlicense2.LicenseManager;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FeatureManager {
    private static final String TAG = "FeatureManager";
    public static final String BVC1 = "bvc1";
    public static final String h266 = "h266";
    public static final String VR_PANORAMA = "vr_panorama";
    public static final String ABR = "abr";
    public static final String SUPER_RESOLUTION = "super_resolution";
    public static final String SUBTITLE_MASK = "subtitle_mask";
    public static final String VOLUME_BALANCE = "volume_balance";
    public static final String PCDN = "pcdn";
    public static final String DASH = "dash";
    public static final String BASH = "bash";
    public static final String PRELOAD = "preload";
    public static final String NET_SPEED = "net_speed";
    public static final String AUDIO_ONLY = "audio_only";
    public static final String HTTP_DNS = "http_dns";
    public static final String NATIVE_MDL = "native_mdl";
    public static final String AUDIO_TRACK = "audio_track";
    public static final String STRATEGY_CENTER = "strategy_center";
    private static final List<String> VALUE_ADD_FEATURES = Arrays.asList("bvc1", "h266", "vr_panorama", "abr", "super_resolution", "subtitle_mask", "pcdn");
    private static final List<String> PREMIUM_FEATURES = Arrays.asList("dash", "bash", "preload", "net_speed", "audio_only", "http_dns", "audio_track", "volume_balance", "native_mdl", "strategy_center");

    public static String getModuleName() {
        return "vod_play";
    }

    public static boolean isLicenseExpired() {
        return LicenseManager.getInstance().checkSDKAuth("vod_play") == 2;
    }

    public static boolean hasPermission() {
        return LicenseManager.getInstance().checkSDKAuth("vod_play") == 1;
    }

    public static boolean hasPermission(String feature) {
        if (VALUE_ADD_FEATURES.contains(feature)) {
            int result = LicenseManager.getInstance().checkFeatureAuth("vod_play", feature);
            if (!TextUtils.equals((CharSequence)"premium_edition", (CharSequence)"premium_edition")) {
                TTVideoEngineLog.e(TAG, "checkAuth failed feature " + feature + ", SDK edition " + "premium_edition");
                return false;
            }
            if (result != 1) {
                TTVideoEngineLog.e(TAG, "checkAuth failed feature " + feature + ", license check result " + result);
                return false;
            }
            return true;
        }
        List<String> sdkFeatures = FeatureManager.getSDKFeatures();
        List<String> licenseFeatures = FeatureManager.getLicenseFeatures();
        if (!sdkFeatures.contains(feature)) {
            TTVideoEngineLog.e(TAG, "checkAuth failed feature " + feature + ", SDK edition " + "premium_edition");
            return false;
        }
        if (!licenseFeatures.contains(feature)) {
            TTVideoEngineLog.e(TAG, "checkAuth failed feature " + feature + ", license edition " + LicenseManager.getInstance().getSDKEdition("vod_play"));
            return false;
        }
        return true;
    }

    private static List<String> getLicenseFeatures() {
        String licenseEdition = LicenseManager.getInstance().getSDKEdition("vod_play");
        if (TextUtils.equals((CharSequence)licenseEdition, (CharSequence)"premium_edition") || TextUtils.equals((CharSequence)licenseEdition, (CharSequence)"enterprise_edition")) {
            return PREMIUM_FEATURES;
        }
        return Collections.emptyList();
    }

    private static List<String> getSDKFeatures() {
        if (TextUtils.equals((CharSequence)"premium_edition", (CharSequence)"premium_edition")) {
            return PREMIUM_FEATURES;
        }
        return Collections.emptyList();
    }
}

