/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.data;

import com.ss.ttvideoengine.data.P2PStragetyListener;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class P2PStragetyManager {
    private static final String TAG = "P2PStragetyManager";
    final int MAX_NUM = 10;
    final int INDEX_PLAY_NUM = 0;
    final int INDEX_SPEED = 1;
    final int INDEX_LEAVE_T = 2;
    final int INDEX_BUFFER_T = 3;
    final int INDEX_SWITCH_NETWORK = 4;
    final int INDEX_ERROR_T = 5;
    final int INDEX_NETWORK_LEVEL = 6;
    final int INDEX_MIN_PLAY_PRELOAD_IMTERNAL = 7;
    public int minPlayNum = 5;
    public int maxLeaveWaitTme = 600;
    public int maxBufferingTime = 500;
    public int minNetSpeed = Integer.MAX_VALUE;
    public int enableP2PStragetyConntrol = 0;
    public int expiredT = 120;
    public int minPlayPreloadInternal = Integer.MIN_VALUE;
    public int minNetworkLevel = Integer.MIN_VALUE;
    private int[] controlFlag;
    private long lastLeaveT;
    private long lastErrorT;
    private long lastBufferT;
    private P2PStragetyListener listener = null;
    private long playNum = 0L;
    private int mForbidP2P = 0;
    private int mProbeSpeed = Integer.MIN_VALUE;

    private P2PStragetyManager() {
        this.controlFlag = new int[10];
        for (int i = 0; i < 10; ++i) {
            this.controlFlag[i] = 0;
        }
    }

    public static P2PStragetyManager getInstance() {
        return Holder.instance;
    }

    public synchronized void onePlay() {
        ++this.playNum;
        TTVideoEngineLog.d(TAG, String.format("playnum:%d speedflag:%d listener:%d mProbeSpeed:%d", this.playNum, this.controlFlag[1], this.listener != null ? 1 : 0, this.mProbeSpeed));
        if (this.playNum > (long)this.minPlayNum && this.controlFlag[1] == 1 && this.listener != null && this.mProbeSpeed == Integer.MIN_VALUE) {
            this.mProbeSpeed = this.listener.getIntValue(0);
            TTVideoEngineLog.d(TAG, String.format("get probe speed:%d", this.mProbeSpeed));
        }
    }

    public synchronized void setListener(P2PStragetyListener aListener) {
        if (this.listener == null) {
            this.listener = aListener;
        }
        TTVideoEngineLog.d(TAG, String.format("set listener:%d", this.listener == null ? 0 : 1));
    }

    public synchronized void switchNetwork(int from, int to) {
        TTVideoEngineLog.d(TAG, String.format("received network change, from:%d to:%d", from, to));
        if (this.controlFlag[4] == 1) {
            TTVideoEngineLog.d(TAG, String.format("reset playnum:%d and speed:%d", this.playNum, this.mProbeSpeed));
            this.playNum = 0L;
            this.mProbeSpeed = Integer.MIN_VALUE;
        }
    }

    public synchronized void init() {
        for (int i = 0; i < 10; ++i) {
            this.controlFlag[i] = (double)(this.enableP2PStragetyConntrol & 1 << i) == Math.pow(2.0, i) ? 1 : 0;
            TTVideoEngineLog.d(TAG, String.format("control flag init, index:%d value:%d", i, this.controlFlag[i]));
        }
    }

    public synchronized int[] getP2PStragetyInfo() {
        if (this.enableP2PStragetyConntrol == 0) {
            return null;
        }
        int[] info = new int[]{this.minPlayNum, (int)this.playNum, this.minNetSpeed, this.mProbeSpeed};
        return info;
    }

    public synchronized int isAllowP2p(String rawKey) {
        if (this.enableP2PStragetyConntrol == 0) {
            TTVideoEngineLog.d(TAG, String.format("control not open, enable p2p", new Object[0]));
            return 1;
        }
        if (this.controlFlag[0] == 1 && this.minPlayNum > 0 && this.playNum < (long)this.minPlayNum) {
            TTVideoEngineLog.d(TAG, String.format("curplaynum:%d minnum:%d, not allow p2p", this.playNum, this.minPlayNum));
            return 0;
        }
        long curT = System.currentTimeMillis();
        if (this.controlFlag[2] == 1 && this.lastLeaveT > 0L && curT - this.lastLeaveT < (long)this.expiredT) {
            TTVideoEngineLog.d(TAG, String.format("curT:%d lastLeaveT:%d,internal:%d not reach expiredT:%d, not allow p2p", curT, this.lastLeaveT, curT - this.lastLeaveT, this.expiredT));
            return 0;
        }
        if (this.controlFlag[3] == 1 && this.lastBufferT > 0L && curT - this.lastBufferT < (long)this.expiredT) {
            TTVideoEngineLog.d(TAG, String.format("curT:%d lastbufferT:%d,internal:%d not reach expiredT:%d, not allow p2p", curT, this.lastBufferT, curT - this.lastBufferT, this.expiredT));
            return 0;
        }
        if (this.controlFlag[5] == 1 && this.lastErrorT > 0L && curT - this.lastErrorT < (long)this.expiredT) {
            TTVideoEngineLog.d(TAG, String.format("curT:%d lastErrorT:%d,internal:%d not reach expiredT:%d, not allow p2p", curT, this.lastErrorT, curT - this.lastErrorT, this.expiredT));
            return 0;
        }
        if (this.controlFlag[6] == 1) {
            int value = Integer.MIN_VALUE;
            if (this.listener != null) {
                value = this.listener.getIntValue(1);
            }
            TTVideoEngineLog.d(TAG, String.format("minnetworklevel:%d probelevel:%d", this.minNetworkLevel, value));
            if (value <= this.minNetworkLevel) {
                TTVideoEngineLog.d(TAG, String.format("network level not allow p2p", new Object[0]));
                return 0;
            }
        }
        this.lastLeaveT = 0L;
        this.lastErrorT = 0L;
        this.lastBufferT = 0L;
        this.mForbidP2P = 0;
        if (this.controlFlag[1] == 1) {
            TTVideoEngineLog.d(TAG, String.format("minspeed:%d probespeed:%d", this.minNetSpeed, this.mProbeSpeed));
            if (this.minNetSpeed > 0 && this.mProbeSpeed < this.minNetSpeed) {
                TTVideoEngineLog.d(TAG, "not allow p2p");
                return 0;
            }
        }
        if (this.controlFlag[7] == 1) {
            TTVideoEngineLog.d(TAG, String.format("enable min preload play internal,min value:%d", this.minPlayPreloadInternal));
            if (this.listener != null) {
                int curInternal = this.listener.getIntValue(2);
                TTVideoEngineLog.d(TAG, String.format("enable min preload play internal,min value:%d curinternal:%d", this.minPlayPreloadInternal, curInternal));
                if (curInternal >= 0 && curInternal < this.minPlayPreloadInternal) {
                    TTVideoEngineLog.d(TAG, String.format("cur internal not allow p2p", new Object[0]));
                    return 0;
                }
            }
        }
        TTVideoEngineLog.d(TAG, String.format("allow p2p", new Object[0]));
        return 1;
    }

    public synchronized void setLeaveWaitTime(long waitTime) {
        if (this.enableP2PStragetyConntrol == 0 || this.controlFlag[2] == 0) {
            return;
        }
        TTVideoEngineLog.d(TAG, String.format("leave wait time:%d ", waitTime));
        if (this.maxLeaveWaitTme > 0 && waitTime > (long)this.maxLeaveWaitTme) {
            TTVideoEngineLog.d(TAG, String.format("leave wait time:%d allow max:%d, play after this not allow p2p!", waitTime, this.maxLeaveWaitTme));
            this.lastLeaveT = System.currentTimeMillis();
            this.mForbidP2P = 1;
        }
    }

    public synchronized void setPlayErrororInterrupt(int errCode) {
        if (this.enableP2PStragetyConntrol == 0 || this.controlFlag[5] == 0) {
            return;
        }
        TTVideoEngineLog.d(TAG, String.format("occur error code:%d, play after this not allow p2p!", errCode));
        this.lastErrorT = System.currentTimeMillis();
        this.mForbidP2P = 1;
    }

    public synchronized void setBufferingTime(long bufferingTime) {
        if (this.enableP2PStragetyConntrol == 0 || this.controlFlag[3] == 0) {
            return;
        }
        TTVideoEngineLog.d(TAG, String.format("set buffering time:%d ", bufferingTime));
        if (bufferingTime > (long)this.maxBufferingTime) {
            TTVideoEngineLog.d(TAG, String.format("reach max buffering time:%d not allow p2p", this.maxBufferingTime));
            this.lastBufferT = System.currentTimeMillis();
            this.mForbidP2P = 1;
        }
    }

    private static class Holder {
        private static P2PStragetyManager instance = new P2PStragetyManager();

        private Holder() {
        }
    }
}

