/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.download;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.download.DownloadTask;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class DownloadURLTask
extends DownloadTask {
    private static final String TAG = "TTVideoEngine.DownloadURLTask";
    private ArrayList<String> urls = null;
    private String key = null;

    private DownloadURLTask() {
    }

    static DownloadURLTask taskItem() {
        DownloadURLTask task = new DownloadURLTask();
        task.setupBaseFiled();
        return task;
    }

    @Nullable
    static DownloadURLTask taskItem(String key, ArrayList<String> urls, String videoId) {
        return DownloadURLTask.taskItem(key, urls, videoId, DownloadTask.EncryptVersion.NONE);
    }

    @Nullable
    static DownloadURLTask taskItem(String key, ArrayList<String> urls, String videoId, DownloadTask.EncryptVersion encryptVersion) {
        if (TextUtils.isEmpty((CharSequence)key) || urls == null || urls.size() < 1) {
            TTVideoEngineLog.d(TAG, "[downloader] key or urls is invalid.");
            return null;
        }
        DownloadURLTask task = DownloadURLTask.taskItem();
        task.key = key;
        task.urls = urls;
        task.videoId = videoId;
        task.mediaKeys.add(key);
        task.encryptVersion = encryptVersion;
        return task;
    }

    public ArrayList<String> getUrls() {
        return this.urls;
    }

    public void updateUrls(ArrayList<String> urls) {
        this.urls = urls;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getVideoId() {
        return this.videoId;
    }

    @Override
    void setupBaseFiled() {
        super.setupBaseFiled();
        this.urls = null;
        this.key = null;
        this.taskType = "url_task";
    }

    @Override
    public void suspend() {
        TTVideoEngineLog.d(TAG, "[downloader] did call suspend, key = " + this.mediaKeys.toString());
        if (this.canceled) {
            TTVideoEngineLog.d(TAG, "[downloader] task did canceled");
            return;
        }
        if (this.getState() == 3 || this.getState() == 0 || this.getState() == 5) {
            TTVideoEngineLog.d(TAG, "[downloader] not need suspend, state = " + this.getState());
            return;
        }
        if (!this.downloader.suspended(this)) {
            TTVideoEngineLog.d(TAG, "[downloader] suspend task, task in waiting, taskIdentifier: " + this.taskIdentifier);
            return;
        }
        super.suspend();
        if (this.mediaKeys != null && this.mediaKeys.size() > 0) {
            for (int i = 0; i < this.mediaKeys.size(); ++i) {
                String key = (String)this.mediaKeys.get(i);
                DataLoaderHelper.getDataLoader().suspendedDownload(key);
            }
        }
        if (this.downloader != null) {
            this.downloader.tryNextWaitingTask(this);
        }
    }

    @Override
    public void resume() {
        TTVideoEngineLog.d(TAG, "[downloader] did call resume, key = " + this.mediaKeys.toString());
        if (this.canceled) {
            TTVideoEngineLog.d(TAG, "[downloader] task did canceled");
            return;
        }
        if (this.getState() == 2) {
            TTVideoEngineLog.d(TAG, "[downloader] state is running");
            return;
        }
        super.resume();
        if (this.downloader != null && !this.downloader.shouldResume(this)) {
            TTVideoEngineLog.i(TAG, "[downloader] not should resume task = " + this.toString());
            return;
        }
        this.usingUrls = new HashMap();
        this.usingUrls.put(this.key, this.urls);
        this.setState(2);
        String downloadUrl = DataLoaderHelper.getDataLoader().downloadUrl(this.key, this.videoId, this.urls.toArray(new String[this.urls.size()]), this.encryptVersion.getVersion(), this.customDir);
        boolean result = DataLoaderHelper.getDataLoader().startDownload(downloadUrl);
        if (!result) {
            this.receiveError(new Error("kTTVideoErrorDomainDownload", -9996, 0, "resume download fail. url = " + downloadUrl + " dataload state is " + DataLoaderHelper.getDataLoader().isRunning()));
            return;
        }
        TTVideoEngineLog.i(TAG, "[downloader] resume a task. key = " + this.key + " downloader url is " + downloadUrl);
        if (this.downloader != null) {
            this.downloader.resume(this);
        }
    }

    @Override
    void assignWithJson(JSONObject jsonObject) {
        JSONObject baseObject = jsonObject.optJSONObject("base_json");
        super.assignWithJson(baseObject);
        this.key = jsonObject.optString("key");
        JSONArray array = jsonObject.optJSONArray("urls");
        if (array != null && array.length() > 0) {
            this.urls = new ArrayList();
            for (int i = 0; i < array.length(); ++i) {
                String url = array.optString(i);
                if (TextUtils.isEmpty((CharSequence)url)) continue;
                this.urls.add(url);
            }
        }
    }

    @Override
    boolean _shouldRetry(Error error) {
        return false;
    }

    @Override
    JSONObject jsonObject() {
        HashMap map = new HashMap();
        DownloadURLTask.putToMap(map, "base_json", super.mapInfo());
        DownloadURLTask.putToMap(map, "key", this.key);
        DownloadURLTask.putToMap(map, "urls", this.urls);
        return new JSONObject(map);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (!obj.getClass().equals(DownloadURLTask.class)) {
            return false;
        }
        DownloadURLTask other = (DownloadURLTask)obj;
        return other.key.equals(this.key);
    }
}

