/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.text.TextUtils;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.log.VideoEventOnePlay;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.FileUtils;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public final class EventSaver {
    private static final String TAG = "EventSaver";
    private static final String DIR_NAME = "saved_events";
    private static volatile EventSaver sInstance;
    private static boolean checkedOnce;
    private final File mDirectory;
    private final Set<String> mEventIdList;

    private EventSaver(Context context) {
        this.mDirectory = new File(context.getCacheDir(), DIR_NAME);
        this.mEventIdList = new HashSet<String>();
    }

    public synchronized void save(VideoEventOnePlay event, VideoEventBase base) {
        if (event == null || base == null) {
            return;
        }
        String id = event.mSessionID;
        if (TextUtils.isEmpty((CharSequence)id)) {
            TTVideoEngineLog.w(TAG, "invalid sessionId");
            return;
        }
        this.mEventIdList.add(id);
        FileUtils.checkAndMkdir(this.mDirectory);
        try (FileOutputStream os = new FileOutputStream(new File(this.mDirectory, id));){
            ((OutputStream)os).write(event.toJsonObject(base).toString().getBytes());
            TTVideoEngineLog.d(TAG, "save event with name: " + id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void remove(String sessionId) {
        if (!this.mEventIdList.contains(sessionId)) {
            return;
        }
        this.mEventIdList.remove(sessionId);
        EngineThreadPool.addExecuteTask(() -> {
            try {
                new File(this.mDirectory, sessionId).delete();
                TTVideoEngineLog.i(TAG, "saved event deleted: " + sessionId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void uploadIfExits(boolean upload) {
        if (checkedOnce) {
            return;
        }
        checkedOnce = true;
        if (!this.mDirectory.exists()) {
            TTVideoEngineLog.w(TAG, "dir does not exist");
            return;
        }
        File[] files = this.mDirectory.listFiles();
        if (files == null) {
            TTVideoEngineLog.i(TAG, "no file in directory");
            return;
        }
        for (File f : files) {
            if (f == null || f.isDirectory()) continue;
            this.uploadFile(f, upload);
        }
    }

    private void uploadFile(File file, boolean upload) {
        String s = FileUtils.readString(file);
        try {
            VideoEventManager.instance.addEvent(upload, new JSONObject(s));
            TTVideoEngineLog.i(TAG, "saved event uploaded: " + file.getName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventSaver getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<EventSaver> clazz = EventSaver.class;
        synchronized (EventSaver.class) {
            if (sInstance != null) return sInstance;
            sInstance = new EventSaver(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }
}

