/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

class ViewSizeMonitor {
    private int currentWidth;
    private int currentHeight;
    private int lastValidWidth;
    private int lastValidHeight;
    private final ArrayList<String> historyList = new ArrayList();

    ViewSizeMonitor() {
    }

    public void setSize(int width, int height) {
        if (width > 0) {
            this.currentWidth = width;
            this.lastValidWidth = width;
        }
        if (height > 0) {
            this.currentHeight = height;
            this.lastValidHeight = height;
        }
        this.maybeAddToHistory(this.currentWidth, this.currentHeight);
    }

    private void maybeAddToHistory(int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("w", w);
        map.put("h", h);
        map.put("t", System.currentTimeMillis());
        try {
            this.historyList.add(new JSONObject(map).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentWidth = 0;
        this.currentHeight = 0;
    }

    public void tryAddLastSizeToHistory() {
        if (this.currentWidth <= 0 && this.currentHeight <= 0) {
            this.maybeAddToHistory(this.lastValidWidth, this.lastValidHeight);
        }
    }

    public void reset() {
        this.currentWidth = 0;
        this.currentHeight = 0;
        this.historyList.clear();
    }

    public ArrayList<String> getHistory() {
        return new ArrayList<String>(this.historyList);
    }
}

