/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.BarrageMaskInfo;
import com.ss.ttvideoengine.model.SubInfo;
import com.ss.ttvideoengine.model.VideoAdaptiveInfo;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModelPb;
import com.ss.ttvideoengine.model.VideoSeekTs;
import com.ss.ttvideoengine.model.VideoStyle;
import com.ss.ttvideoengine.model.VideoThumbInfo;
import com.ss.ttvideoengine.utils.TTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoRef {
    public static final int VALUE_VIDEO_REF_USER_ID = 1;
    public static final int VALUE_VIDEO_REF_VIDEO_ID = 2;
    public static final int VALUE_VIDEO_REF_VIDEO_DURATION = 3;
    public static final int VALUE_VIDEO_REF_STATUS = 4;
    public static final int VALUE_VIDEO_REF_VIDEO_LIST = 5;
    public static final int VALUE_VIDEO_REF_MEDIA_TYPE = 7;
    public static final int VALUE_VIDEO_REF_BASH_STRING = 8;
    public static final int VALUE_VIDEO_REF_MODEL_VERSION = 9;
    public static final int VALUE_VIDEO_REF_VIDEO_NAME = 104;
    public static final int VALUE_VIDEO_REF_VIDEO_VALIDATE = 105;
    public static final int VALUE_VIDEO_REF_VIDEO_ENABLE_SSL = 106;
    public static final int VALUE_VIDEO_REF_AUTO_DEFINITION = 107;
    public static final int VALUE_VIDEO_REF_DYNAMIC_MAIN_URL = 108;
    public static final int VALUE_VIDEO_REF_DYNAMIC_BACKUP_URL = 109;
    public static final int VALUE_VIDEO_REF_POSTER_URL = 201;
    public static final int VALUE_VIDEO_REF_CODEC_HAS_H264 = 203;
    public static final int VALUE_VIDEO_REF_CODEC_HAS_h265 = 204;
    public static final int VALUE_VIDEO_REF_FORMAT_HAS_DASH = 205;
    public static final int VALUE_VIDEO_REF_FORMAT_HAS_MP4 = 206;
    public static final int VALUE_VIDEO_REF_FORMAT_HAS_MPD = 207;
    public static final int VALUE_VIDEO_REF_FORMAT_HAS_HLS = 208;
    public static final int VALUE_VIDEO_REF_TOTAL_COUNT = 209;
    public static final int VALUE_VIDEO_REF_DYNAMIC_VIDEO_List = 210;
    public static final int VALUE_VIDEO_REF_FORMAT = 211;
    public static final int VALUE_VIDEO_REF_THUMB_INFO_LIST = 212;
    public static final int VALUE_VIDEO_REF_DYNAMIC_URLS = 213;
    public static final int VALUE_VIDEO_REF_VIDEO_SEEK_TS = 214;
    public static final int VALUE_VIDEO_REF_DYNAMIC_TYPE = 215;
    public static final int VALUE_VIDEO_REF_DNS_TIME = 216;
    public static final int VALUE_VIDEO_REF_FALLBACK_API = 217;
    public static final int VALUE_VIDEO_REF_KEY_SEED = 218;
    public static final int VALUE_VIDEO_REF_KEY_URL_ENCRYPTED = 219;
    public static final int VALUE_VIDEO_REF_URL_EXPIRE = 220;
    public static final int VALUE_VIDEO_REF_BARRAGE_MASK_URL = 221;
    public static final int VALUE_VIDEO_REF_ENABLE_ADAPTIVE = 222;
    public static final int VALUE_VIDEO_REF_DECODING_MODE = 223;
    public static final int VALUE_VIDEO_REF_LOUDNESS = 224;
    public static final int VALUE_VIDEO_REF_PEAK = 225;
    public static final int VALUE_VIDEO_REF_FULL_SCREEN_STRATEGY = 226;
    public static final int VALUE_VIDEO_REF_POPULARITY_LEVEL = 227;
    public static final int VALUE_VIDEO_REF_CODEC_HAS_h266 = 228;
    public static final int VALUE_VIDEO_REF_HAS_EMBEDED_SUBTITLE = 229;
    public static final int VALUE_VIDEO_REF_DEFAULT_AUDIO_INFO_ID = 230;
    public static final int VALUE_VIDEO_REF_DUBBED_AUDIO_INFO_LIST = 231;
    public static final int VALUE_VIDEO_REF_CATEGORY = 232;
    public static final int VALUE_VIDEO_REF_FIRST_SUB_VID = 233;
    public static final int VALUE_VIDEO_REF_ORIGINAL_AUDIO_INFO_LIST = 234;
    public static final int VALUE_VIDEO_REF_AI_BARRAGE_URL = 235;
    public static final int VALUE_VIDEO_REF_CONST_DEPTH = 236;
    public static final int VALUE_VIDEO_REF_PALLAS_VID_LABELS = 237;
    public static final int VALUE_VIDEO_REF_SUBTITLE_POSITION_X = 239;
    public static final int VALUE_VIDEO_REF_SUBTITLE_POSITION_Y = 240;
    public static final int VALUE_VIDEO_REF_MASK_FILE_HASH = 241;
    public static final int VALUE_VIDEO_REF_MASK_HEAD_LEN = 242;
    public static final int VALUE_VIDEO_REF_MASK_FILE_SIZE = 243;
    public static final int VALUE_VIDEO_REF_PALLAS_DID_LABELS = 244;
    public static int TYPE_VIDEO = 0;
    public static int TYPE_AUDIO = 1;
    private int mVersion = 1;
    private Resolution[] mAllResolutions;
    private ArrayList<Resolution> mAllResolutionsArray = new ArrayList();
    private ArrayList<String> mAllQualityArray = new ArrayList();
    private String[] mAllQualityInfos;
    private String[] mCodecArray = null;
    private String mDynamicType = "";
    private String mFormat = "mp4";
    private String mBashString = "";
    private boolean mCodecHash265 = false;
    private boolean mCodecHash266 = false;
    private boolean mCodecHasH264 = false;
    private boolean mFormatHasDASH = false;
    private boolean mFormatHasMPD = false;
    private boolean mFormatHasMP4 = false;
    private boolean mFormatHasHls = false;
    private boolean mHasEmbeddedSubtitle = false;
    public int[] mDefaultInfoId = new int[]{-1, -1};
    private static final String KEY_VER1_VIDEO_LIST = "video_list";
    private static final String KEY_VER1_VIDEO_1 = "video_1";
    private static final String KEY_VER1_VIDEO_2 = "video_2";
    private static final String KEY_VER1_VIDEO_3 = "video_3";
    private static final String KEY_VER1_VIDEO_4 = "video_4";
    private static final String KEY_VER1_VIDEO_5 = "video_5";
    private static final String KEY_VER1_VIDEO_6 = "video_6";
    private static final String KEY_VER1_VIDEO_7 = "video_7";
    private static final String KEY_VER1_VIDEO_8 = "video_8";
    private static final String KEY_VER1_USER_ID = "user_id";
    private static final String KEY_VER1_VIDEO_ID = "video_id";
    private static final String KEY_VER1_VIDEO_NAME = "video_name";
    private static final String KEY_VER1_VIDEO_DURATION = "video_duration";
    private static final String KEY_VER1_VIDEO_STATUS = "status";
    private static final String KEY_VER1_VIDEO_VALIDATE = "validate";
    private static final String KEY_VER1_VIDEO_ENABLE_SSL = "enable_ssl";
    private static final String KEY_VER1_AUTO_DEFINITION = "auto_definition";
    private static final String KEY_VER1_BIG_THUMBS = "big_thumbs";
    private static final String KEY_VER1_SEEK_TS = "seek_ts";
    private static final String KEY_VER1_BARRAGE_MASK_INFO = "barrage_mask_info";
    private static final String KEY_VER1_DYNAMIC_VIDEO = "dynamic_video";
    private static final String KEY_VER1_DYNAMIC_TYPE = "dynamic_type";
    private static final String KEY_VER1_DYNAMIC_VIDEO_LIST = "dynamic_video_list";
    private static final String KEY_VER1_DYNAMIC_AUDIO_LIST = "dynamic_audio_list";
    private static final String KEY_VER1_DYNAMIC_DUBBED_AUDIOS = "dynamic_dubbed_audios";
    private static final String KEY_VER1_MEDIA_TYPE = "media_type";
    private static final String KEY_VER1_DNS_INFO = "dns_info";
    private static final String KEY_VER1_DNS_TIME = "dns_time";
    private static final String KEY_VER1_SEED = "key_seed";
    private static final String KEY_VER1_FALLBACK_API = "fallback_api";
    private static final String KEY_VER1_VIDEOMODEL_VERSION = "version";
    private static final String KEY_VER1_URL_EXPIRE = "url_expire";
    private static final String KEY_VER1_ENABLE_ADAPTIVE = "enable_adaptive";
    private static final String KEY_VER1_DECODING_MODE = "optimal_decoding_mode";
    private static final String KEY_VER1_BARRAGE_MASK_URL = "barrage_mask_url";
    private static final String KEY_VER1_AI_BARRAGE_URL = "effect_barrage_url";
    private static final String KEY_VER1_VOLUME = "volume";
    private static final String KEY_VER1_LOUDNESS = "loudness";
    private static final String KEY_VER1_PEAK = "peak";
    private static final String KEY_VER1_FULL_SCREEN_STRATEGY = "full_screen_strategy";
    private static final String KEY_VER1_POPULARITY_LEVEL = "popularity_level";
    private static final String KEY_VER1_SUBTITLE_LANGS = "subtitle_langs";
    private static final String KEY_VER1_SUBTITLE_INFO = "subtitle_infos";
    private static final String KEY_VER1_HAS_EMBEDDED_SUBTITLE = "has_embedded_subtitle";
    private static final String KEY_VER1_VIDEO_STYLE = "video_style";
    private static final String KEY_VER1_DEPTH_ESTIMATION = "depth_estimation";
    private static final String KEY_VER1_CONST_DEPTH = "const_depth";
    private static final String KEY_VER1_SUBTITLE_POSITION = "subtitle_position";
    private static final String KEY_VER1_SUBTITLE_POSITION_X = "x";
    private static final String KEY_VER1_SUBTITLE_POSITION_Y = "y";
    private static final String KEY_VER1_PALLAS_VID_LABELS = "pallas_vid_labels";
    private static final String KEY_VER1_PALLAS_DID_LABELS = "pallas_did_labels";
    public String mUserId;
    public String mVideoId;
    public String mValidate;
    public String mAutoDefinition;
    public boolean mEnableSSL;
    public boolean mEnableAdaptive;
    public String mVideoName;
    public int mPopularityLevel;
    public List<VideoInfo> mVideoList;
    public List<VideoInfo> mDynamicVideoList;
    public List<VideoInfo> mDubbedAudioInfo;
    public List<VideoInfo> mOriginalAudioInfo;
    public String mMainURL;
    public String mBackupURL;
    public String[] mURLs;
    public int mStatus;
    public int mVideoDuration;
    public VideoSeekTs mSeekTs;
    public BarrageMaskInfo mMaskInfo;
    public List<VideoThumbInfo> mThumbInfoList;
    public List<SubInfo> mSubInfoList;
    public float mConstDepth = 0.0f;
    public float mSubtitlePositionX = 0.0f;
    public float mSubtitlePositionY = 0.0f;
    public String mMediaType;
    public String mKeyseed;
    public String mFallbackApi;
    private boolean mURLEncrypted = false;
    private HashMap<String, Resolution> mVideoResolutionMap = TTHelper.defaultVideoResolutionMap();
    private HashMap<String, Resolution> mAudioResolutionMap = TTHelper.defaultAudioResolutionMap();
    public int mMediaTypeInt = TYPE_VIDEO;
    private JSONObject mDnsInfo;
    private long mDnsTime;
    public String mDecodingMode;
    public float mLoudness = 0.0f;
    public float mPeak = 0.0f;
    public String mFullScreen;
    public int[] mSubLangs;
    private String mFirstSubVid = null;
    public VideoStyle mVideoStyle;
    private String mPallasVidLabels = "";
    private String mPallasDidLabels = "";
    private static final String KEY_VER2_PLAY_INFO_LIST = "PlayInfoList";
    private static final String KEY_VER2_VIDEO_STATUS = "Status";
    private static final String KEY_VER2_VIDEO_ID = "VideoID";
    private static final String KEY_VER2_POSTER_URL = "CoverUrl";
    private static final String KEY_VER2_VIDEO_DURATION = "Duration";
    private static final String KEY_VER2_MEDIA_TYPE = "MediaType";
    private static final String KEY_VER2_BIG_THUMBS = "BigThumbs";
    private static final String KEY_VER2_SEEK_TS = "Seekts";
    private static final String KEY_VER2_ADAPTIVE_INFO = "AdaptiveInfo";
    private static final String KEY_VER2_TOTAL_COUNT = "TotalCount";
    private static final String KEY_VER2_VIDEO_ENABLE_SSL = "EnableSSL";
    private static final String KEY_VER2_ENABLE_ADAPTIVE = "EnableAdaptive";
    private String mVideoIdVer2;
    private List<VideoInfo> mVideoListVer2 = null;
    private int mStatusVer2;
    private int mVideoDurationVer2;
    private String mPosterUrlVer2;
    private String mMediaTypeVer2;
    private int mMediaTypeIntVer2 = TYPE_VIDEO;
    private VideoSeekTs mSeekTsVer2;
    private VideoAdaptiveInfo mAdaptiveInfoVer2;
    private List<VideoThumbInfo> mThumbInfoListVer2;
    private int mTotalCountVer2;
    private String mBarrageMaskUrl;
    private String mAIBarrageUrl;
    private long mUrlExpire = 0L;
    private String mMaskFileHash;
    private int mMaskHeadLen;
    private long mMaskFileSize = 0L;
    private Map<String, VideoModelPb.DNS> mDnsInfoVer3;
    private static final String KEY_VER4_VIDEOMODEL_VERSION = "Version";
    private static final String KEY_VER4_PLAY_INFO_LIST = "PlayInfoList";
    private static final String KEY_VER4_VIDEO_STATUS = "Status";
    private static final String KEY_VER4_VIDEO_ID = "Vid";
    private static final String KEY_VER4_POSTER_URL = "PosterUrl";
    private static final String KEY_VER4_VIDEO_DURATION = "Duration";
    private static final String KEY_VER4_FILE_TYPE = "FileType";
    private static final String KEY_VER4_ADAPTIVE_INFO = "AdaptiveInfo";
    private static final String KEY_VER4_TOTAL_COUNT = "TotalCount";
    private static final String KEY_VER4_VIDEO_ENABLE_SSL = "EnableSSL";
    private static final String KEY_VER4_ENABLE_ADAPTIVE = "EnableAdaptive";
    private static final String KEY_VER4_THUMB_INFO_LIST = "ThumbInfoList";
    private static final String KEY_VER4_BARRAGE_MASK_URL = "BarrageMaskUrl";
    private static final String KEY_VER4_SUBTITLE_INFO = "SubtitleInfoList";
    private String mPosterUrl;
    private int mTotalCount;
    private VideoAdaptiveInfo mAdaptiveInfo;

    public void parseFromPb(VideoModelPb.VideoInfo pb) {
    }

    public void extractFields(JSONObject obj) throws JSONException {
        VideoThumbInfo thumbInfo3;
        SubInfo subInfo;
        if (obj == null) {
            return;
        }
        JSONArray videoList = obj.optJSONArray("PlayInfoList");
        if (videoList != null && videoList.length() > 0 || !TextUtils.isEmpty((CharSequence)obj.optString(KEY_VER2_VIDEO_ID)) || !TextUtils.isEmpty((CharSequence)obj.optString(KEY_VER4_VIDEO_ID))) {
            this.mVersion = obj.optInt(KEY_VER4_VIDEOMODEL_VERSION) == 4 ? 4 : 2;
        } else if (!TextUtils.isEmpty((CharSequence)obj.optString(KEY_VER1_VIDEO_ID))) {
            this.mVersion = obj.optInt(KEY_VER1_VIDEOMODEL_VERSION) == 3 ? 3 : 1;
        }
        if (this.mVersion == 1 || this.mVersion == 3) {
            JSONObject volume;
            JSONArray thumbArray;
            VideoInfo info;
            JSONObject videoListObj;
            JSONObject subtitle_position;
            JSONArray subInfoArray;
            JSONArray subLangsArray;
            if (this.mVersion == 1) {
                this.mFallbackApi = obj.optString(KEY_VER1_FALLBACK_API);
                String keySeed = obj.optString(KEY_VER1_SEED);
                if (!TextUtils.isEmpty((CharSequence)keySeed)) {
                    this.mKeyseed = keySeed;
                }
            } else {
                JSONObject fallback_api = obj.optJSONObject(KEY_VER1_FALLBACK_API);
                if (fallback_api != null) {
                    this.mFallbackApi = fallback_api.optString(KEY_VER1_FALLBACK_API);
                    String keySeed = fallback_api.optString(KEY_VER1_SEED);
                    if (!TextUtils.isEmpty((CharSequence)keySeed)) {
                        this.mKeyseed = keySeed;
                    }
                }
            }
            this.mVideoDuration = obj.optInt(KEY_VER1_VIDEO_DURATION);
            this.mStatus = obj.optInt(KEY_VER1_VIDEO_STATUS);
            this.mEnableSSL = obj.optBoolean(KEY_VER1_VIDEO_ENABLE_SSL);
            this.mEnableAdaptive = obj.optBoolean(KEY_VER1_ENABLE_ADAPTIVE);
            this.mVideoId = obj.optString(KEY_VER1_VIDEO_ID);
            this.mPopularityLevel = obj.optInt(KEY_VER1_POPULARITY_LEVEL);
            this.mMediaType = obj.optString(KEY_VER1_MEDIA_TYPE);
            this.mDecodingMode = obj.optString(KEY_VER1_DECODING_MODE);
            this.mUrlExpire = obj.optLong(KEY_VER1_URL_EXPIRE);
            this.mValidate = obj.optString(KEY_VER1_VIDEO_VALIDATE);
            this.mAutoDefinition = obj.optString(KEY_VER1_AUTO_DEFINITION);
            this.mVideoName = obj.optString(KEY_VER1_VIDEO_NAME);
            this.mUserId = obj.optString(KEY_VER1_USER_ID);
            if (this.mVersion == 1) {
                String aiBarrageUrl;
                String barrageMaskUrl = obj.optString(KEY_VER1_BARRAGE_MASK_URL);
                if (!TextUtils.isEmpty((CharSequence)barrageMaskUrl)) {
                    this.mBarrageMaskUrl = TTHelper.base64Decode(barrageMaskUrl, this.mURLEncrypted ? this.mKeyseed : null);
                }
                if (!TextUtils.isEmpty((CharSequence)(aiBarrageUrl = obj.optString(KEY_VER1_AI_BARRAGE_URL)))) {
                    this.mAIBarrageUrl = TTHelper.base64Decode(aiBarrageUrl, this.mURLEncrypted ? this.mKeyseed : null);
                }
            } else {
                this.mBarrageMaskUrl = obj.optString(KEY_VER1_BARRAGE_MASK_URL);
                this.mAIBarrageUrl = obj.optString(KEY_VER1_AI_BARRAGE_URL);
            }
            if (this.mMediaType.equals("video")) {
                this.mMediaTypeInt = TYPE_VIDEO;
            } else if (this.mMediaType.equals("audio")) {
                this.mMediaTypeInt = TYPE_AUDIO;
            }
            if (obj.has(KEY_VER1_SUBTITLE_LANGS) && (subLangsArray = obj.optJSONArray(KEY_VER1_SUBTITLE_LANGS)) != null && subLangsArray.length() > 0) {
                this.mSubLangs = new int[subLangsArray.length()];
                for (int i = 0; i < subLangsArray.length(); ++i) {
                    this.mSubLangs[i] = subLangsArray.optInt(i);
                }
            }
            if (obj.has(KEY_VER1_SUBTITLE_INFO) && (subInfoArray = obj.optJSONArray(KEY_VER1_SUBTITLE_INFO)) != null && subInfoArray.length() > 0) {
                this.mSubInfoList = new ArrayList<SubInfo>();
                for (int i = 0; i < subInfoArray.length(); ++i) {
                    subInfo = new SubInfo();
                    subInfo.extractFields(subInfoArray.getJSONObject(i));
                    this.mSubInfoList.add(subInfo);
                }
            }
            this.mHasEmbeddedSubtitle = obj.optBoolean(KEY_VER1_HAS_EMBEDDED_SUBTITLE);
            JSONObject depth_estimation = obj.optJSONObject(KEY_VER1_DEPTH_ESTIMATION);
            if (depth_estimation != null) {
                this.mConstDepth = (float)depth_estimation.optDouble(KEY_VER1_CONST_DEPTH);
            }
            if ((subtitle_position = obj.optJSONObject(KEY_VER1_SUBTITLE_POSITION)) != null) {
                this.mSubtitlePositionX = (float)subtitle_position.optDouble(KEY_VER1_SUBTITLE_POSITION_X);
                this.mSubtitlePositionY = (float)subtitle_position.optDouble(KEY_VER1_SUBTITLE_POSITION_Y);
            }
            if (this.mVersion == 1) {
                videoListObj = obj.optJSONObject(KEY_VER1_VIDEO_LIST);
                if (videoListObj != null) {
                    String[] videoListKeys;
                    this.mVideoList = new ArrayList<VideoInfo>();
                    for (String key : videoListKeys = new String[]{KEY_VER1_VIDEO_1, KEY_VER1_VIDEO_2, KEY_VER1_VIDEO_3, KEY_VER1_VIDEO_4, KEY_VER1_VIDEO_5, KEY_VER1_VIDEO_6, KEY_VER1_VIDEO_7, KEY_VER1_VIDEO_8}) {
                        if (!videoListObj.has(key)) continue;
                        info = this._generateVideoInfo(videoListObj.getJSONObject(key), this.mMediaTypeInt, this.mURLEncrypted ? this.mKeyseed : null);
                        info.mVideoDuration = this.mVideoDuration;
                        this.mVideoList.add(info);
                    }
                }
            } else {
                this.mVideoList = new ArrayList<VideoInfo>();
                videoListObj = obj.optJSONArray(KEY_VER1_VIDEO_LIST);
                if (videoListObj != null && videoListObj.length() > 0) {
                    for (int i = 0; i < videoListObj.length(); ++i) {
                        VideoInfo info2 = this._generateVideoInfo(videoListObj.getJSONObject(i), this.mMediaTypeInt, this.mURLEncrypted ? this.mKeyseed : null);
                        this.mVideoList.add(info2);
                    }
                }
            }
            this.mDnsInfo = obj.optJSONObject(KEY_VER1_DNS_INFO);
            this.mDnsTime = obj.optLong(KEY_VER1_DNS_TIME);
            JSONObject dynamicVideo = obj.optJSONObject(KEY_VER1_DYNAMIC_VIDEO);
            if (dynamicVideo != null) {
                int infoId = 0;
                if (this.mVersion == 1) {
                    String backupURL;
                    String mainURL = dynamicVideo.optString("main_url");
                    if (!TextUtils.isEmpty((CharSequence)mainURL)) {
                        this.mMainURL = TTHelper.base64Decode(mainURL, this.mURLEncrypted ? this.mKeyseed : null);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(backupURL = dynamicVideo.optString("backup_url_1")))) {
                        this.mBackupURL = TTHelper.base64Decode(backupURL, this.mURLEncrypted ? this.mKeyseed : null);
                    }
                } else {
                    this.mMainURL = dynamicVideo.optString("main_url");
                    this.mBackupURL = dynamicVideo.optString("backup_url");
                }
                this.mDynamicType = dynamicVideo.optString(KEY_VER1_DYNAMIC_TYPE);
                this.mDynamicVideoList = new ArrayList<VideoInfo>();
                JSONArray dynamicVideoList = dynamicVideo.optJSONArray(KEY_VER1_DYNAMIC_VIDEO_LIST);
                if (dynamicVideoList != null && dynamicVideoList.length() > 0) {
                    for (int i = 0; i < dynamicVideoList.length(); ++i) {
                        VideoInfo info3 = this._generateVideoInfo(dynamicVideoList.getJSONObject(i), TYPE_VIDEO, this.mURLEncrypted ? this.mKeyseed : null);
                        info3.mInfoId = infoId++;
                        this.mDynamicVideoList.add(info3);
                    }
                }
                boolean hasDubbedAudios = false;
                JSONArray dynamicDubbedAudios = dynamicVideo.optJSONArray(KEY_VER1_DYNAMIC_DUBBED_AUDIOS);
                if (dynamicDubbedAudios != null && dynamicDubbedAudios.length() > 0) {
                    this.mDubbedAudioInfo = new ArrayList<VideoInfo>();
                    for (int i = 0; i < dynamicDubbedAudios.length(); ++i) {
                        info = this._generateVideoInfo(dynamicDubbedAudios.getJSONObject(i), TYPE_AUDIO, this.mURLEncrypted ? this.mKeyseed : null);
                        info.mInfoId = infoId++;
                        this.mDynamicVideoList.add(info);
                        this.mDubbedAudioInfo.add(info);
                        hasDubbedAudios = true;
                    }
                }
                JSONArray dynamicAudioList = dynamicVideo.optJSONArray(KEY_VER1_DYNAMIC_AUDIO_LIST);
                int bitrate = Integer.MAX_VALUE;
                if (dynamicAudioList != null && dynamicAudioList.length() > 0) {
                    this.mOriginalAudioInfo = new ArrayList<VideoInfo>();
                    for (int i = 0; i < dynamicAudioList.length(); ++i) {
                        VideoInfo info4 = this._generateVideoInfo(dynamicAudioList.getJSONObject(i), TYPE_AUDIO, this.mURLEncrypted ? this.mKeyseed : null);
                        info4.mInfoId = infoId++;
                        if (hasDubbedAudios && bitrate > info4.mBitrate) {
                            this.mDefaultInfoId[VideoRef.TYPE_AUDIO] = info4.mInfoId;
                            bitrate = info4.mBitrate;
                        }
                        this.mDynamicVideoList.add(info4);
                        this.mOriginalAudioInfo.add(info4);
                    }
                }
                if (this.mDynamicVideoList.size() > 0) {
                    ArrayList<String> urls = new ArrayList<String>();
                    if (!TextUtils.isEmpty((CharSequence)this.mMainURL)) {
                        urls.add(this.mMainURL);
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.mBackupURL)) {
                        urls.add(this.mBackupURL);
                    }
                    this.mURLs = new String[urls.size()];
                    urls.toArray(this.mURLs);
                }
            }
            if (obj.has(KEY_VER1_BARRAGE_MASK_INFO)) {
                this.mMaskInfo = new BarrageMaskInfo();
                this.mMaskInfo.extractFields(obj.getJSONObject(KEY_VER1_BARRAGE_MASK_INFO));
                if (this.mVersion == 1) {
                    String barrageMaskUrl = this.mMaskInfo.getValueStr(1);
                    if (!TextUtils.isEmpty((CharSequence)barrageMaskUrl)) {
                        this.mBarrageMaskUrl = TTHelper.base64Decode(barrageMaskUrl, this.mURLEncrypted ? this.mKeyseed : null);
                    }
                } else {
                    this.mBarrageMaskUrl = this.mMaskInfo.getValueStr(1);
                }
                this.mMaskHeadLen = this.mMaskInfo.getValueInt(7);
                this.mMaskFileHash = this.mMaskInfo.getValueStr(3);
                this.mMaskFileSize = this.mMaskInfo.getValueLong(4);
            }
            if (obj.has(KEY_VER1_SEEK_TS)) {
                this.mSeekTs = new VideoSeekTs();
                this.mSeekTs.extractFields(obj.getJSONObject(KEY_VER1_SEEK_TS));
            }
            if (obj.has(KEY_VER1_BIG_THUMBS) && (thumbArray = obj.optJSONArray(KEY_VER1_BIG_THUMBS)) != null && thumbArray.length() > 0) {
                this.mThumbInfoList = new ArrayList<VideoThumbInfo>();
                for (int i = 0; i < thumbArray.length(); ++i) {
                    VideoThumbInfo thumbInfo2 = new VideoThumbInfo();
                    thumbInfo2.setVersion(this.mVersion);
                    thumbInfo2.extractFields(thumbArray.getJSONObject(i));
                    this.mThumbInfoList.add(thumbInfo2);
                }
            }
            if (obj.has(KEY_VER1_VOLUME) && (volume = obj.optJSONObject(KEY_VER1_VOLUME)) != null && (volume.has(KEY_VER1_LOUDNESS) || volume.has(KEY_VER1_PEAK))) {
                this.mLoudness = (float)volume.optDouble(KEY_VER1_LOUDNESS);
                this.mPeak = (float)volume.optDouble(KEY_VER1_PEAK);
            }
            this.mFullScreen = obj.optString(KEY_VER1_FULL_SCREEN_STRATEGY);
            if (obj.has(KEY_VER1_VIDEO_STYLE)) {
                this.mVideoStyle = new VideoStyle();
                this.mVideoStyle.extractFields(obj.getJSONObject(KEY_VER1_VIDEO_STYLE));
            }
            if (obj.has(KEY_VER1_PALLAS_VID_LABELS)) {
                this.mPallasVidLabels = obj.optString(KEY_VER1_PALLAS_VID_LABELS);
            }
            if (obj.has(KEY_VER1_PALLAS_DID_LABELS)) {
                this.mPallasDidLabels = obj.optString(KEY_VER1_PALLAS_DID_LABELS);
            }
        } else if (this.mVersion == 2) {
            JSONObject adaptiveInfo;
            JSONArray thumbArray;
            this.mStatusVer2 = obj.optInt("Status");
            this.mVideoIdVer2 = obj.optString(KEY_VER2_VIDEO_ID);
            this.mPosterUrlVer2 = obj.optString(KEY_VER2_POSTER_URL);
            this.mVideoDurationVer2 = obj.optInt("Duration");
            this.mMediaTypeVer2 = obj.optString(KEY_VER2_MEDIA_TYPE);
            this.mTotalCountVer2 = obj.optInt("TotalCount");
            this.mEnableSSL = obj.optBoolean("EnableSSL");
            this.mEnableAdaptive = obj.optBoolean("EnableAdaptive");
            if (this.mMediaTypeVer2.equals("video")) {
                this.mMediaTypeIntVer2 = TYPE_VIDEO;
            } else if (this.mMediaTypeVer2.equals("audio")) {
                this.mMediaTypeIntVer2 = TYPE_AUDIO;
            }
            if (obj.has(KEY_VER2_SEEK_TS)) {
                this.mSeekTsVer2 = new VideoSeekTs();
                this.mSeekTsVer2.extractFields(obj.getJSONObject(KEY_VER2_SEEK_TS));
            }
            if (obj.has(KEY_VER2_BIG_THUMBS) && (thumbArray = obj.optJSONArray(KEY_VER2_BIG_THUMBS)) != null && thumbArray.length() > 0) {
                this.mThumbInfoListVer2 = new ArrayList<VideoThumbInfo>();
                for (int i = 0; i < thumbArray.length(); ++i) {
                    try {
                        thumbInfo3 = new VideoThumbInfo();
                        thumbInfo3.setVersion(this.mVersion);
                        thumbInfo3.extractFields(thumbArray.getJSONObject(i));
                        this.mThumbInfoListVer2.add(thumbInfo3);
                        continue;
                    }
                    catch (JSONException thumbInfo3) {
                        // empty catch block
                    }
                }
            }
            if (videoList != null && videoList.length() > 0) {
                this.mVideoListVer2 = new ArrayList<VideoInfo>();
                for (int i = 0; i < videoList.length(); ++i) {
                    VideoInfo info = this._generateVideoInfo(videoList.getJSONObject(i), this.mMediaTypeIntVer2, this.mURLEncrypted ? this.mKeyseed : null);
                    this.mVideoListVer2.add(info);
                }
            }
            if (obj.has("AdaptiveInfo") && (adaptiveInfo = obj.optJSONObject("AdaptiveInfo")) != null) {
                this.mAdaptiveInfoVer2 = new VideoAdaptiveInfo();
                this.mAdaptiveInfoVer2.extractFields(adaptiveInfo);
                this.mDynamicType = this.mAdaptiveInfoVer2.getValueStr(215);
                this.mMainURL = this.mAdaptiveInfoVer2.getValueStr(108);
                this.mBackupURL = this.mAdaptiveInfoVer2.getValueStr(109);
                ArrayList<String> urls = new ArrayList<String>();
                if (!TextUtils.isEmpty((CharSequence)this.mMainURL)) {
                    urls.add(this.mMainURL);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mBackupURL)) {
                    urls.add(this.mBackupURL);
                }
                this.mURLs = new String[urls.size()];
                urls.toArray(this.mURLs);
            }
        } else if (this.mVersion == 4) {
            JSONArray thumbArray;
            JSONArray subInfoArray;
            JSONObject adaptiveInfo;
            this.mStatus = obj.optInt("Status");
            this.mVideoId = obj.optString(KEY_VER4_VIDEO_ID);
            this.mPosterUrl = obj.optString(KEY_VER4_POSTER_URL);
            this.mVideoDuration = obj.optInt("Duration");
            this.mMediaType = obj.optString(KEY_VER4_FILE_TYPE);
            this.mTotalCount = obj.optInt("TotalCount");
            this.mEnableSSL = obj.optBoolean("EnableSSL");
            this.mEnableAdaptive = obj.optBoolean("EnableAdaptive");
            this.mBarrageMaskUrl = obj.optString(KEY_VER4_BARRAGE_MASK_URL);
            if (this.mMediaType.equals("video")) {
                this.mMediaTypeInt = TYPE_VIDEO;
            } else if (this.mMediaType.equals("audio")) {
                this.mMediaTypeInt = TYPE_AUDIO;
            }
            if (videoList != null && videoList.length() > 0) {
                this.mVideoList = new ArrayList<VideoInfo>();
                for (int i = 0; i < videoList.length(); ++i) {
                    VideoInfo info = this._generateVideoInfo(videoList.getJSONObject(i), this.mMediaTypeInt, this.mURLEncrypted ? this.mKeyseed : null);
                    this.mVideoList.add(info);
                }
                this.mLoudness = this.mVideoList.get((int)0).mLoudness;
                this.mPeak = this.mVideoList.get((int)0).mPeak;
            }
            if (obj.has("AdaptiveInfo") && (adaptiveInfo = obj.optJSONObject("AdaptiveInfo")) != null) {
                this.mAdaptiveInfo = new VideoAdaptiveInfo();
                this.mAdaptiveInfo.extractFields(adaptiveInfo);
                this.mDynamicType = this.mAdaptiveInfo.getValueStr(215);
                this.mMainURL = this.mAdaptiveInfo.getValueStr(108);
                this.mBackupURL = this.mAdaptiveInfo.getValueStr(109);
                ArrayList<String> urls = new ArrayList<String>();
                if (!TextUtils.isEmpty((CharSequence)this.mMainURL)) {
                    urls.add(this.mMainURL);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mBackupURL)) {
                    urls.add(this.mBackupURL);
                }
                this.mURLs = new String[urls.size()];
                urls.toArray(this.mURLs);
            }
            if (obj.has(KEY_VER4_SUBTITLE_INFO) && (subInfoArray = obj.optJSONArray(KEY_VER4_SUBTITLE_INFO)) != null && subInfoArray.length() > 0) {
                this.mSubInfoList = new ArrayList<SubInfo>();
                for (int i = 0; i < subInfoArray.length(); ++i) {
                    subInfo = new SubInfo();
                    subInfo.extractFields(subInfoArray.getJSONObject(i));
                    this.mSubInfoList.add(subInfo);
                }
            }
            if (obj.has(KEY_VER4_THUMB_INFO_LIST) && (thumbArray = obj.optJSONArray(KEY_VER4_THUMB_INFO_LIST)) != null && thumbArray.length() > 0) {
                this.mThumbInfoList = new ArrayList<VideoThumbInfo>();
                for (int i = 0; i < thumbArray.length(); ++i) {
                    thumbInfo3 = new VideoThumbInfo();
                    thumbInfo3.setVersion(this.mVersion);
                    thumbInfo3.extractFields(thumbArray.getJSONObject(i));
                    this.mThumbInfoList.add(thumbInfo3);
                }
            }
        }
        List<VideoInfo> infoList = this.getVideoInfoList();
        if (infoList != null && infoList.size() > 0) {
            for (VideoInfo info : infoList) {
                if (info.getMediatype() == TYPE_VIDEO) {
                    this.mMediaTypeInt = this.mMediaTypeIntVer2 = TYPE_VIDEO;
                    break;
                }
                if (info.getMediatype() != TYPE_AUDIO) continue;
                this.mMediaTypeInt = this.mMediaTypeIntVer2 = TYPE_AUDIO;
            }
        }
        this.mBashString = this.toBashString();
        this.mAllResolutions = new Resolution[this.mAllResolutionsArray.size()];
        this.mAllResolutionsArray.toArray(this.mAllResolutions);
        this.mAllQualityInfos = new String[this.mAllQualityArray.size()];
        this.mAllQualityArray.toArray(this.mAllQualityInfos);
    }

    private VideoInfo _generateVideoInfo(JSONObject jsonObject, int mediaType, String keyseed) {
        VideoInfo info = new VideoInfo(keyseed);
        info.setVersion(this.mVersion);
        info.setMediaType(mediaType);
        info.setValue(39, this.mLoudness);
        info.setValue(40, this.mPeak);
        info.extractFields(jsonObject);
        Resolution resolution = Resolution.Standard;
        String resolutionStr = null;
        mediaType = info.getMediatype();
        if (mediaType == TYPE_AUDIO) {
            resolutionStr = info.getValueStr(18);
        } else if (mediaType == TYPE_VIDEO) {
            resolutionStr = info.getValueStr(7);
        }
        if (!TextUtils.isEmpty((CharSequence)resolutionStr)) {
            if (resolutionStr.equals(Resolution.L_Standard.toString(mediaType))) {
                resolution = Resolution.L_Standard;
            } else if (resolutionStr.equals(Resolution.Standard.toString(mediaType))) {
                resolution = Resolution.Standard;
            } else if (resolutionStr.equals(Resolution.High.toString(mediaType))) {
                resolution = Resolution.High;
            } else if (resolutionStr.equals(Resolution.H_High.toString(mediaType))) {
                resolution = Resolution.H_High;
            } else if (resolutionStr.equals(Resolution.SuperHigh.toString(mediaType))) {
                resolution = Resolution.SuperHigh;
            } else if (resolutionStr.equals(Resolution.ExtremelyHigh.toString(mediaType))) {
                resolution = Resolution.ExtremelyHigh;
            } else if (resolutionStr.equals(Resolution.TwoK.toString(mediaType))) {
                resolution = Resolution.TwoK;
            } else if (resolutionStr.equals(Resolution.FourK.toString(mediaType))) {
                resolution = Resolution.FourK;
            } else if (resolutionStr.equals(Resolution.HDR.toString(mediaType))) {
                resolution = Resolution.HDR;
            } else if (resolutionStr.equals(Resolution.ExtremelyHigh_50F.toString(mediaType))) {
                resolution = Resolution.ExtremelyHigh_50F;
            } else if (resolutionStr.equals(Resolution.TwoK_50F.toString(mediaType))) {
                resolution = Resolution.TwoK_50F;
            } else if (resolutionStr.equals(Resolution.FourK_50F.toString(mediaType))) {
                resolution = Resolution.FourK_50F;
            } else if (resolutionStr.equals(Resolution.ExtremelyHigh_60F.toString(mediaType))) {
                resolution = Resolution.ExtremelyHigh_60F;
            } else if (resolutionStr.equals(Resolution.TwoK_60F.toString(mediaType))) {
                resolution = Resolution.TwoK_60F;
            } else if (resolutionStr.equals(Resolution.FourK_60F.toString(mediaType))) {
                resolution = Resolution.FourK_60F;
            } else if (resolutionStr.equals(Resolution.ExtremelyHigh_120F.toString(mediaType))) {
                resolution = Resolution.ExtremelyHigh_120F;
            } else if (resolutionStr.equals(Resolution.TwoK_120F.toString(mediaType))) {
                resolution = Resolution.TwoK_120F;
            } else if (resolutionStr.equals(Resolution.FourK_120F.toString(mediaType))) {
                resolution = Resolution.FourK_120F;
            } else if (resolutionStr.equals(Resolution.L_Standard_HDR.toString(mediaType))) {
                resolution = Resolution.L_Standard_HDR;
            } else if (resolutionStr.equals(Resolution.Standard_HDR.toString(mediaType))) {
                resolution = Resolution.Standard_HDR;
            } else if (resolutionStr.equals(Resolution.High_HDR.toString(mediaType))) {
                resolution = Resolution.High_HDR;
            } else if (resolutionStr.equals(Resolution.H_High_HDR.toString(mediaType))) {
                resolution = Resolution.H_High_HDR;
            } else if (resolutionStr.equals(Resolution.SuperHigh_HDR.toString(mediaType))) {
                resolution = Resolution.SuperHigh_HDR;
            } else if (resolutionStr.equals(Resolution.ExtremelyHigh_HDR.toString(mediaType))) {
                resolution = Resolution.ExtremelyHigh_HDR;
            } else if (resolutionStr.equals(Resolution.TwoK_HDR.toString(mediaType))) {
                resolution = Resolution.TwoK_HDR;
            } else if (resolutionStr.equals(Resolution.FourK_HDR.toString(mediaType))) {
                resolution = Resolution.FourK_HDR;
            } else if (resolutionStr.equals(Resolution.EightK.toString(mediaType))) {
                resolution = Resolution.EightK;
            } else if (resolutionStr.equals(Resolution.ExtremelyHighPlus.toString(mediaType))) {
                resolution = Resolution.ExtremelyHighPlus;
            }
        }
        info.setResolution(resolution);
        info.setValue(26, resolutionStr);
        String format = info.getValueStr(6);
        if (!TextUtils.isEmpty((CharSequence)format)) {
            this.mFormat = format;
        }
        if (!this.mFormatHasMPD && this.mFormat.equals("mpd")) {
            this.mFormatHasMPD = true;
        } else if (!this.mFormatHasDASH && this.mFormat.equals("dash")) {
            this.mFormatHasDASH = true;
        } else if (!this.mFormatHasMP4 && this.mFormat.equals("mp4")) {
            this.mFormatHasMP4 = true;
        } else if (!this.mFormatHasHls && this.mFormat.equals("hls")) {
            this.mFormatHasHls = true;
        }
        String codec = info.getValueStr(8);
        if (!this.mCodecHasH264 && codec.equals("h264")) {
            this.mCodecHasH264 = true;
        } else if (!this.mCodecHash265 && codec.equals("h265")) {
            this.mCodecHash265 = true;
        } else if (!this.mCodecHash266 && codec.equals("h266")) {
            this.mCodecHash266 = true;
        }
        return info;
    }

    public void setVersion(int version) {
        this.mVersion = version;
    }

    public int getVersion() {
        return this.mVersion;
    }

    @Deprecated
    @Nullable
    public VideoInfo getVideoInfoWithClarity(String clarityDefinitin) {
        if (TextUtils.isEmpty((CharSequence)clarityDefinitin)) {
            return null;
        }
        List<VideoInfo> videoInfoList = this.getVideoInfoList();
        if (videoInfoList == null || videoInfoList.size() == 0) {
            return null;
        }
        for (int i = 0; i < videoInfoList.size(); ++i) {
            if (videoInfoList.get(i) == null || !this.getResolutionStr(videoInfoList.get(i)).equals(clarityDefinitin)) continue;
            return videoInfoList.get(i);
        }
        return videoInfoList.get(0);
    }

    @Nullable
    public VideoInfo getVideoInfo(Resolution resolution, Map<Integer, String> otherDimensionalityMap) {
        return this.getVideoInfo(resolution, this.getValueInt(7), otherDimensionalityMap);
    }

    @Nullable
    public VideoInfo getVideoInfo(Map<Integer, String> otherDimensionalityMap) {
        List<VideoInfo> videoInfoList = this.getVideoInfoList();
        if (videoInfoList == null || videoInfoList.size() == 0) {
            return null;
        }
        for (VideoInfo tmpInfo : videoInfoList) {
            if (tmpInfo == null) continue;
            if (otherDimensionalityMap == null || otherDimensionalityMap.size() == 0) {
                return tmpInfo;
            }
            boolean isFound = true;
            for (Map.Entry<Integer, String> entry : otherDimensionalityMap.entrySet()) {
                int key = entry.getKey();
                String value = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)value) || value.equals(tmpInfo.getValueStr(key))) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            return tmpInfo;
        }
        return null;
    }

    @Nullable
    public VideoInfo getVideoInfo(Resolution resolution, int type, Map<Integer, String> otherDimensionalityMap) {
        List<VideoInfo> videoInfoList = this.getVideoInfoList();
        if (videoInfoList == null || videoInfoList.size() == 0) {
            return null;
        }
        for (VideoInfo tmpInfo : videoInfoList) {
            if (tmpInfo == null || type != tmpInfo.getMediatype()) continue;
            if (otherDimensionalityMap != null && otherDimensionalityMap.containsKey(32)) {
                String value = otherDimensionalityMap.get(32);
                if (!TextUtils.isEmpty((CharSequence)tmpInfo.getValueStr(32)) && tmpInfo.getValueStr(32).equals(value)) {
                    return tmpInfo;
                }
            }
            if (resolution != tmpInfo.getResolution()) continue;
            if (otherDimensionalityMap == null || otherDimensionalityMap.size() == 0) {
                return tmpInfo;
            }
            boolean isFound = true;
            for (Map.Entry<Integer, String> entry : otherDimensionalityMap.entrySet()) {
                int key = entry.getKey();
                String value = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)value) || value.equals(tmpInfo.getValueStr(key))) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            return tmpInfo;
        }
        return null;
    }

    public String getResolutionStr(VideoInfo videoinfo) {
        if (videoinfo == null) {
            return this.resolutionToString(Resolution.Standard);
        }
        int mediaType = videoinfo.getMediatype();
        if (mediaType == TYPE_AUDIO) {
            String quality = videoinfo.getValueStr(18);
            return quality != null ? quality : this.resolutionToString(Resolution.Standard, mediaType);
        }
        if (mediaType == TYPE_VIDEO) {
            String definition = videoinfo.getValueStr(7);
            return definition != null ? definition : this.resolutionToString(Resolution.Standard, mediaType);
        }
        return this.resolutionToString(Resolution.Standard);
    }

    public Resolution[] getSupportResolutions() {
        return this.mAllResolutions;
    }

    public String[] getSupportQualityInfos() {
        return this.mAllQualityInfos;
    }

    @Deprecated
    public int[] getSupportSubtitleLangs() {
        return this.mSubLangs;
    }

    public JSONObject getDnsInfo() {
        return this.mDnsInfo;
    }

    public String[] allVideoURLs(Resolution resolution, Map<Integer, String> otherDimensionalityMap) {
        if (this.mURLs != null && this.mURLs.length > 0) {
            return this.mURLs;
        }
        VideoInfo info = this.getVideoInfo(resolution, otherDimensionalityMap);
        if (info == null) {
            return new String[0];
        }
        return info.getValueStrArr(16);
    }

    public List<VideoInfo> getVideoInfoList() {
        if (this.mVersion == 2) {
            return this.mVideoListVer2;
        }
        List<VideoInfo> videoInfoList = null;
        if (this.mVideoList != null && this.mVideoList.size() > 0) {
            videoInfoList = this.mVideoList;
        }
        if (this.mDynamicVideoList != null && this.mDynamicVideoList.size() > 0) {
            videoInfoList = this.mDynamicVideoList;
        }
        return videoInfoList;
    }

    public VideoSeekTs getSeekTs() {
        if (this.mVersion == 2) {
            return this.mSeekTsVer2;
        }
        return this.mSeekTs;
    }

    public List<VideoThumbInfo> getThumbInfoList() {
        if (this.mVersion == 2) {
            return this.mThumbInfoListVer2;
        }
        return this.mThumbInfoList;
    }

    public List<SubInfo> getSubInfoList() {
        return this.mSubInfoList;
    }

    public String[] getCodecs() {
        if (this.mCodecArray == null) {
            List<VideoInfo> infoList = this.getVideoInfoList();
            ArrayList<String> codecList = new ArrayList<String>();
            if (infoList != null && infoList.size() > 0) {
                for (VideoInfo info : infoList) {
                    String infoCodecType;
                    if (info == null || TextUtils.isEmpty((CharSequence)(infoCodecType = info.getValueStr(8))) || codecList.contains(infoCodecType)) continue;
                    codecList.add(infoCodecType);
                }
            }
            this.mCodecArray = new String[codecList.size()];
            codecList.toArray(this.mCodecArray);
        }
        return this.mCodecArray;
    }

    public int getValueInt(int key) {
        if (this.mVersion == 2) {
            switch (key) {
                case 4: {
                    return this.mStatusVer2;
                }
                case 3: {
                    return this.mVideoDurationVer2;
                }
                case 7: {
                    return this.mMediaTypeIntVer2;
                }
                case 209: {
                    return this.mTotalCountVer2;
                }
                case 230: {
                    return this.mDefaultInfoId[TYPE_AUDIO];
                }
                case 232: {
                    return 0;
                }
                case 242: {
                    return this.mMaskHeadLen;
                }
            }
            return 0;
        }
        switch (key) {
            case 4: {
                return this.mStatus;
            }
            case 3: {
                return this.mVideoDuration;
            }
            case 7: {
                return this.mMediaTypeInt;
            }
            case 9: {
                return this.mVersion;
            }
            case 227: {
                return this.mPopularityLevel;
            }
            case 209: {
                return this.mTotalCount;
            }
            case 230: {
                return this.mDefaultInfoId[TYPE_AUDIO];
            }
            case 232: {
                return 0;
            }
        }
        return 0;
    }

    public long getValueLong(int key) {
        switch (key) {
            case 216: {
                return this.mDnsTime;
            }
            case 220: {
                return this.mUrlExpire;
            }
            case 243: {
                return this.mMaskFileSize;
            }
        }
        return 0L;
    }

    public float getValueFloat(int key) {
        switch (key) {
            case 224: {
                return this.mLoudness;
            }
            case 225: {
                return this.mPeak;
            }
            case 236: {
                return this.mConstDepth;
            }
            case 239: {
                return this.mSubtitlePositionX;
            }
            case 240: {
                return this.mSubtitlePositionY;
            }
        }
        return 0.0f;
    }

    public void setValueStr(int key, String str) {
        if (key == 218) {
            this.mKeyseed = str;
            if (this.mKeyseed != null) {
                // empty if block
            }
        }
    }

    public String getValueStr(int key) {
        if (key == 211) {
            return this.mFormat;
        }
        if (key == 215) {
            return this.mDynamicType;
        }
        if (key == 8) {
            return this.mBashString;
        }
        if (key == 233) {
            return this.mFirstSubVid;
        }
        if (key == 237) {
            return this.mPallasVidLabels;
        }
        if (key == 244) {
            return this.mPallasDidLabels;
        }
        if (this.mVersion == 2) {
            switch (key) {
                case 2: {
                    return this.mVideoIdVer2;
                }
                case 201: {
                    return this.mPosterUrlVer2;
                }
                case 7: {
                    return this.mMediaTypeVer2;
                }
            }
            return "";
        }
        switch (key) {
            case 1: {
                return this.mUserId;
            }
            case 2: {
                return this.mVideoId;
            }
            case 105: {
                return this.mValidate;
            }
            case 107: {
                return this.mAutoDefinition;
            }
            case 104: {
                return this.mVideoName;
            }
            case 108: {
                return this.mMainURL;
            }
            case 109: {
                return this.mBackupURL;
            }
            case 7: {
                return this.mMediaType;
            }
            case 217: {
                return this.mFallbackApi;
            }
            case 218: {
                return this.mKeyseed;
            }
            case 221: {
                return this.mBarrageMaskUrl;
            }
            case 235: {
                return this.mAIBarrageUrl;
            }
            case 241: {
                return this.mMaskFileHash;
            }
            case 223: {
                return this.mDecodingMode;
            }
            case 226: {
                return this.mFullScreen;
            }
            case 201: {
                return this.mPosterUrl;
            }
        }
        return "";
    }

    public List<VideoInfo> getValueList(int key) {
        if (this.mVersion == 2) {
            switch (key) {
                case 5: {
                    return this.mVideoListVer2;
                }
            }
            return null;
        }
        switch (key) {
            case 5: {
                return this.mVideoList;
            }
            case 210: {
                return this.mDynamicVideoList;
            }
            case 231: {
                return this.mDubbedAudioInfo;
            }
            case 234: {
                return this.mOriginalAudioInfo;
            }
        }
        return null;
    }

    public Boolean getValueBool(int key) {
        switch (key) {
            case 106: {
                return this.mEnableSSL;
            }
            case 222: {
                return this.mEnableAdaptive;
            }
            case 203: {
                return this.mCodecHasH264;
            }
            case 204: {
                return this.mCodecHash265;
            }
            case 228: {
                return this.mCodecHash266;
            }
            case 205: {
                return this.mFormatHasDASH;
            }
            case 206: {
                return this.mFormatHasMP4;
            }
            case 207: {
                return this.mFormatHasMPD;
            }
            case 208: {
                return this.mFormatHasHls;
            }
            case 229: {
                return this.mHasEmbeddedSubtitle;
            }
        }
        return false;
    }

    public void setValue(int key, String value) {
        switch (key) {
            case 2: {
                this.mVideoId = value;
                this.mVideoIdVer2 = value;
                return;
            }
            case 201: {
                this.mPosterUrlVer2 = value;
                return;
            }
            case 7: {
                this.mMediaTypeVer2 = value;
                this.mMediaType = value;
                return;
            }
            case 1: {
                this.mUserId = value;
                return;
            }
            case 105: {
                this.mValidate = value;
                return;
            }
            case 107: {
                this.mAutoDefinition = value;
                return;
            }
            case 104: {
                this.mVideoName = value;
                return;
            }
            case 108: {
                this.mMainURL = value;
                return;
            }
            case 109: {
                this.mBackupURL = value;
                return;
            }
            case 233: {
                this.mFirstSubVid = value;
                return;
            }
        }
    }

    public void setValue(int key, boolean value) {
        switch (key) {
            case 106: {
                this.mEnableSSL = value;
                return;
            }
            case 219: {
                this.mURLEncrypted = value;
                return;
            }
        }
    }

    public void setValue(int key, int value) {
        switch (key) {
            case 4: {
                this.mStatus = value;
                return;
            }
            case 3: {
                this.mVideoDuration = value;
                this.mVideoDurationVer2 = value;
                return;
            }
            case 7: {
                this.mMediaTypeInt = value;
                this.mMediaTypeIntVer2 = value;
                return;
            }
            case 209: {
                this.mTotalCountVer2 = value;
                return;
            }
        }
    }

    public void setValue(int key, String[] value) {
        switch (key) {
            case 213: {
                this.mURLs = value;
                return;
            }
        }
    }

    public void setValue(int key, List value) {
        switch (key) {
            case 212: {
                this.mThumbInfoListVer2 = value;
                this.mThumbInfoList = value;
                return;
            }
            case 5: {
                this.mVideoList = value;
                this.mVideoListVer2 = value;
                return;
            }
            case 210: {
                this.mDynamicVideoList = value;
                return;
            }
        }
    }

    public void setValue(int key, VideoSeekTs value) {
        switch (key) {
            case 214: {
                this.mSeekTs = value;
                this.mSeekTsVer2 = value;
                return;
            }
        }
    }

    public void setUpResolution(HashMap<String, Resolution> resolutionMap) {
        int mediaType = this.getValueInt(7);
        HashMap<String, Resolution> temMap = null;
        if (resolutionMap == null || resolutionMap.size() <= 0) {
            temMap = mediaType == TYPE_AUDIO ? this.mAudioResolutionMap : this.mVideoResolutionMap;
        } else {
            temMap = resolutionMap;
            if (mediaType == TYPE_AUDIO) {
                this.mAudioResolutionMap = resolutionMap;
            } else {
                this.mVideoResolutionMap = resolutionMap;
            }
        }
        Resolution resolution = Resolution.Standard;
        String qualityDesc = "";
        List<VideoInfo> videoList = this.getVideoInfoList();
        if (videoList != null) {
            for (int i = 0; i < videoList.size(); ++i) {
                VideoInfo info = videoList.get(i);
                if (info == null || info.getMediatype() != mediaType) continue;
                info.setResolutionBaseMap(temMap);
                resolution = info.getResolution();
                qualityDesc = info.getValueStr(32);
                if (!this.mAllQualityArray.contains(qualityDesc)) {
                    this.mAllQualityArray.add(qualityDesc);
                }
                if (this.mAllResolutionsArray.contains((Object)resolution)) continue;
                this.mAllResolutionsArray.add(resolution);
            }
        }
        this.mAllResolutions = new Resolution[this.mAllResolutionsArray.size()];
        this.mAllResolutionsArray.toArray(this.mAllResolutions);
        this.mAllQualityInfos = new String[this.mAllQualityArray.size()];
        this.mAllQualityArray.toArray(this.mAllQualityInfos);
    }

    public String resolutionToString(Resolution resolution) {
        return this.resolutionToString(resolution, this.getValueInt(7));
    }

    public String resolutionToString(Resolution resolution, int mediaType) {
        HashMap<String, Resolution> temMap = null;
        temMap = mediaType == TYPE_AUDIO ? this.mAudioResolutionMap : this.mVideoResolutionMap;
        String result = null;
        for (Map.Entry<String, Resolution> entry : temMap.entrySet()) {
            Resolution value = entry.getValue();
            if (value.getIndex() != resolution.getIndex()) continue;
            result = entry.getKey();
            break;
        }
        if (TextUtils.isEmpty(result)) {
            result = resolution.toString(mediaType);
        }
        return result;
    }

    public String toBashString() {
        JSONObject jsonObject = this.toBashJsonObject();
        return jsonObject != null ? jsonObject.toString() : "";
    }

    public JSONObject toBashJsonObject() {
        try {
            List<VideoInfo> infoList = this.getVideoInfoList();
            if (infoList == null || infoList.size() <= 0) {
                return null;
            }
            JSONArray videoJsonArray = new JSONArray();
            JSONArray audioJsonArray = new JSONArray();
            for (VideoInfo info : infoList) {
                JSONObject infoJsonObject = null;
                if (info == null || (infoJsonObject = info.toBashJsonObject()) == null) continue;
                if (info.getMediatype() == TYPE_VIDEO) {
                    videoJsonArray.put((Object)infoJsonObject);
                    continue;
                }
                if (info.getMediatype() != TYPE_AUDIO) continue;
                audioJsonArray.put((Object)infoJsonObject);
            }
            if (videoJsonArray.length() > 0 || audioJsonArray.length() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(KEY_VER1_DYNAMIC_VIDEO_LIST, (Object)videoJsonArray);
                jsonObject.put(KEY_VER1_DYNAMIC_AUDIO_LIST, (Object)audioJsonArray);
                return jsonObject;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

