/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.text.TextUtils;
import com.ss.ttvideoengine.net.BaseDNS;
import com.ss.ttvideoengine.net.LocalDNS;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.reflect.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HTTPDNS
extends BaseDNS {
    private static final String TAG = "HTTPDNS";
    private static String mTTDNSServerHost = "";
    private int mHttpDNSType = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTTDNSServerHost(String host) {
        Class<LocalDNS> clazz = LocalDNS.class;
        synchronized (LocalDNS.class) {
            if (!TextUtils.isEmpty((CharSequence)host)) {
                mTTDNSServerHost = host;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTTDNSServerHost() {
        Class<LocalDNS> clazz = LocalDNS.class;
        synchronized (LocalDNS.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return mTTDNSServerHost;
        }
    }

    public HTTPDNS(String hostname, TTVNetClient client, int http_dns_type) {
        super(hostname, client);
        this.mHttpDNSType = http_dns_type;
        TTVideoEngineLog.i(TAG, "DNS use HTTPDNS" + (http_dns_type == 2 ? "_TT" : "_ALI"));
    }

    @Override
    public void start() {
        Method[] methods;
        String url = this._getURL();
        boolean newStartTaskExit = false;
        for (Method meth : methods = this.mNetClient.getClass().getDeclaredMethods()) {
            if (!meth.getName().equals("startTask") || meth.getParameterTypes().length != 5) continue;
            newStartTaskExit = true;
            break;
        }
        if (newStartTaskExit) {
            this.mNetClient.startTask(url, null, null, 0, new TTVNetClient.CompletionListener(){

                @Override
                public void onCompletion(JSONObject jsonObject, Error error) {
                    HTTPDNS.this._handleResponse(jsonObject, error);
                }
            });
        } else {
            this.mNetClient.startTask(url, null, new TTVNetClient.CompletionListener(){

                @Override
                public void onCompletion(JSONObject jsonObject, Error error) {
                    HTTPDNS.this._handleResponse(jsonObject, error);
                }
            });
        }
    }

    @Override
    public void cancel() {
        if (this.mCancelled) {
            return;
        }
        this.mCancelled = true;
        this.mNetClient.cancel();
    }

    private String _getURL() {
        StringBuilder builder = new StringBuilder();
        String dnsServerHost = HTTPDNS.getTTDNSServerHost();
        builder.append("https://" + mTTDNSServerHost + "/q?host=");
        builder.append(this.mHostname);
        String result = builder.toString();
        TTVideoEngineLog.d(TAG, "http dns parse url is" + result);
        return result;
    }

    private void _handleResponse(JSONObject jsonObject, Error error) {
        if (error != null) {
            error.domain = "kTTVideoErrorDomainHTTPDNS";
        } else if (jsonObject == null || jsonObject.length() == 0) {
            error = new Error("kTTVideoErrorDomainHTTPDNS", -9997, (this.mHttpDNSType == 2 ? "TT_" : "ALI_") + "HTTP dns empty");
        } else {
            JSONArray ips = jsonObject.optJSONArray("ips");
            if (ips == null || ips.length() == 0) {
                error = new Error("kTTVideoErrorDomainHTTPDNS", -9997, (this.mHttpDNSType == 2 ? "TT_" : "ALI_") + "HTTP dns empty");
            } else {
                try {
                    jsonObject.put("time", System.currentTimeMillis());
                    jsonObject.put("dns_type", (Object)"httpDNS");
                }
                catch (JSONException e) {
                    TTVideoEngineLog.d(e);
                }
                this.notifySuccess(jsonObject);
                return;
            }
        }
        this.notifyError(error);
    }
}

