/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import com.ss.ttvideoengine.net.BaseDNS;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalDNS
extends BaseDNS {
    private static final String TAG = "LocalDNS";
    private static final int TIME_OUT = 10000;
    private InetAddress mAddress;
    private boolean mRet = false;
    private Future mFuture;

    public LocalDNS(String hostname) {
        super(hostname);
        TTVideoEngineLog.i(TAG, "DNS use LocalDNS");
    }

    @Override
    public void start() {
        try {
            this.mFuture = EngineThreadPool.addExecuteTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LocalDNS.this.mAddress = InetAddress.getByName(LocalDNS.this.mHostname);
                    }
                    catch (Throwable e) {
                        TTVideoEngineLog.d(e);
                        Class<LocalDNS> clazz = LocalDNS.class;
                        synchronized (LocalDNS.class) {
                            if (!LocalDNS.this.mRet) {
                                LocalDNS.this.mRet = true;
                                LocalDNS.this.notifyError(new Error("kTTVideoErrorDomainLocalDNS", -9968, e.getMessage()));
                            }
                            // ** MonitorExit[var2_4] (shouldn't be in output)
                            return;
                        }
                    }
                    if (LocalDNS.this.mAddress == null) {
                        Class<LocalDNS> e = LocalDNS.class;
                        synchronized (LocalDNS.class) {
                            if (!LocalDNS.this.mRet) {
                                LocalDNS.this.mRet = true;
                                LocalDNS.this.notifyError(new Error("kTTVideoErrorDomainLocalDNS", -9998));
                            }
                            // ** MonitorExit[e] (shouldn't be in output)
                            return;
                        }
                    }
                    String ip = LocalDNS.this.mAddress.getHostAddress();
                    if (LocalDNS.this.mAddress instanceof Inet6Address) {
                        ip = String.format("[%s]", ip);
                    }
                    Class<LocalDNS> clazz = LocalDNS.class;
                    synchronized (LocalDNS.class) {
                        if (LocalDNS.this.mRet) {
                            // ** MonitorExit[var2_5] (shouldn't be in output)
                            return;
                        }
                        LocalDNS.this.mRet = true;
                        // ** MonitorExit[var2_5] (shouldn't be in output)
                        if (ip == null) {
                            LocalDNS.this.notifyError(new Error("kTTVideoErrorDomainLocalDNS", -9997));
                            return;
                        }
                        JSONObject ip_return = new JSONObject();
                        JSONArray ip_array = new JSONArray();
                        ip_array.put((Object)ip);
                        try {
                            ip_return.put("ips", (Object)ip_array);
                            ip_return.put("time", System.currentTimeMillis());
                            ip_return.put("dns_type", (Object)"localDNS");
                        }
                        catch (JSONException e) {
                            TTVideoEngineLog.d(e);
                        }
                        LocalDNS.this.notifySuccess(ip_return);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            this.notifyError(new Error("kTTVideoErrorDomainLocalDNS", -9968, e.getMessage()));
        }
        this.mHandler.postDelayed((Runnable)new MyRunnable(this), 10000L);
    }

    @Override
    public void cancel() {
        if (this.mCancelled) {
            return;
        }
        this.mCancelled = true;
        if (this.mFuture != null) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    @Override
    public void close() {
        super.close();
        this.mCancelled = true;
        if (this.mFuture != null) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    private static class MyRunnable
    implements Runnable {
        private final WeakReference<LocalDNS> mLocalDNSRef;

        public MyRunnable(LocalDNS dns) {
            this.mLocalDNSRef = new WeakReference<LocalDNS>(dns);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LocalDNS dns = (LocalDNS)this.mLocalDNSRef.get();
            if (dns == null) {
                return;
            }
            Class<LocalDNS> clazz = LocalDNS.class;
            synchronized (LocalDNS.class) {
                if (!dns.mRet) {
                    dns.mRet = true;
                    dns.notifyError(new Error("kTTVideoErrorDomainLocalDNS", -10000));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

