/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.preload;

import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.preload.PreloadScene;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class PreloadConfig {
    private static final String TAG = "PreloadConfig";
    public int mMaxSceneCount = 10;
    public String mCurrentSceneId = null;

    public static PreloadConfig share() {
        return SingleBuilder.single;
    }

    public void createScene(PreloadScene scene) {
        TTVideoEngineLog.i(TAG, "create scene " + scene.mSceneId);
        if (scene == null || TextUtils.isEmpty((CharSequence)scene.mSceneId)) {
            return;
        }
        DataLoaderHelper.getDataLoader().createScene(scene);
    }

    public void destroyScene(String sceneId) {
        if (TextUtils.isEmpty((CharSequence)sceneId)) {
            return;
        }
        TTVideoEngineLog.i(TAG, "destroy scene " + sceneId);
        DataLoaderHelper.getDataLoader().destroyScene(sceneId);
        if (this.mCurrentSceneId != null && this.mCurrentSceneId.equals(sceneId)) {
            this.mCurrentSceneId = null;
        }
    }

    public String getCurrentSceneId() {
        return this.mCurrentSceneId;
    }

    public boolean moveToScene(String sceneId) {
        if (TextUtils.isEmpty((CharSequence)sceneId)) {
            return false;
        }
        TTVideoEngineLog.i(TAG, "move to scene " + sceneId);
        if (this.mCurrentSceneId != null && this.mCurrentSceneId.equals(sceneId)) {
            return true;
        }
        this.mCurrentSceneId = sceneId;
        DataLoaderHelper.getDataLoader().moveToScene(sceneId);
        return true;
    }

    private static class SingleBuilder {
        private static PreloadConfig single = new PreloadConfig();

        private SingleBuilder() {
        }
    }
}

