/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy.utils;

import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.strategy.utils.BufferCheckListener;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BufferCheckUtil {
    private static final String TAG = "Strategy CheckUtil";
    private BufferCheckListener mListener;
    private int mInternal = 300;
    private WeakReference<TTVideoEngine> mEngine;
    private ScheduledExecutorService mExecutor;

    public static BufferCheckUtil instance() {
        return Holder.instance;
    }

    private BufferCheckUtil() {
    }

    public void setInternal(int internal) {
        this.mInternal = internal;
    }

    public void start(TTVideoEngine engine, BufferCheckListener listener) {
        if (engine == null) {
            return;
        }
        this.stop();
        TTVideoEngineLog.d(TAG, "start");
        this.mEngine = new WeakReference<TTVideoEngine>(engine);
        this.mListener = listener;
        this.mExecutor = new ScheduledThreadPoolExecutor(1);
        this.mExecutor.scheduleWithFixedDelay(this::checkBuffer, 0L, this.mInternal, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.mExecutor != null) {
            TTVideoEngineLog.d(TAG, "stop");
            this.mExecutor.shutdownNow();
            this.mExecutor = null;
        }
        this.mEngine = null;
    }

    private void checkBuffer() {
        TTVideoEngine playEngine = this.getEngine();
        if (playEngine == null || playEngine.isReleased()) {
            this.stop();
            return;
        }
        long videoCache = playEngine.getLongOption(62);
        long audioCache = playEngine.getLongOption(61);
        long cacheSizeInMS = Math.min(videoCache, audioCache);
        boolean cacheEnd = this.isCacheEnd(playEngine, cacheSizeInMS);
        String videoID = playEngine.getVideoID();
        if (cacheEnd) {
            TTVideoEngineLog.d(TAG, "cacheEnd " + videoID);
            if (this.mListener != null) {
                this.mListener.onCacheEnd(playEngine);
            }
            return;
        }
        TTVideoEngineLog.d(TAG, "cache:" + cacheSizeInMS + ", videoID:" + videoID);
        if (this.mListener != null) {
            this.mListener.onCacheSize(playEngine, cacheSizeInMS);
        }
    }

    private boolean isCacheEnd(TTVideoEngine playEngine, long cache) {
        if (this.isMdlCacheEnd(playEngine)) {
            TTVideoEngineLog.d(TAG, "mdl cache end");
            return true;
        }
        int duration = playEngine.getDuration();
        int currentPlayPosition = playEngine.getCurrentPlaybackTime();
        return duration > 0 && cache + (long)currentPlayPosition + 1000L >= (long)duration;
    }

    private boolean isMdlCacheEnd(TTVideoEngine playEngine) {
        if (playEngine == null) {
            return false;
        }
        List<String> cacheKeys = playEngine.getCacheKeys();
        if (cacheKeys == null || cacheKeys.size() <= 0) {
            return false;
        }
        boolean isCacheEnd = true;
        for (String cacheKey : cacheKeys) {
            DataLoaderHelper.DataLoaderCacheInfo cacheInfo = TTVideoEngine.getCacheInfo(cacheKey);
            if (cacheInfo != null && cacheInfo.mMediaSize <= cacheInfo.mCacheSizeFromZero) continue;
            isCacheEnd = false;
        }
        return isCacheEnd;
    }

    private TTVideoEngine getEngine() {
        if (this.mEngine == null) {
            return null;
        }
        return (TTVideoEngine)this.mEngine.get();
    }

    private static class Holder {
        private static final BufferCheckUtil instance = new BufferCheckUtil();

        private Holder() {
        }
    }
}

