/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.text.TextUtils;
import java.net.URL;
import org.json.JSONObject;

public class DataLoaderCDNLog {
    public String url;
    public String fileKey;
    public String host;
    public String serverIp;
    public String xCache;
    public String xMCache;
    public long contentLength;
    public long reqStartT;
    public long reqEndT;

    public DataLoaderCDNLog(JSONObject log) throws Exception {
        if (log == null) {
            throw new Exception("log null");
        }
        this.url = log.optString("url");
        URL u = new URL(this.url);
        this.host = u.getHost();
        this.serverIp = log.optString("server_ip");
        this.xCache = log.optString("x_cache");
        this.xMCache = log.optString("x_m_cache");
        this.fileKey = log.optString("f_key");
        this.contentLength = log.optLong("contentLength", -1L);
        this.reqStartT = log.optLong("req_start_t", -1L);
        this.reqEndT = log.optLong("req_end_t", -1L);
    }

    public static JSONObject process(JSONObject log) {
        if (log == null) {
            return null;
        }
        try {
            URL u;
            String url = null;
            String host = null;
            url = log.optString("url");
            if (!TextUtils.isEmpty((CharSequence)url) && !TextUtils.isEmpty((CharSequence)(host = (u = new URL(url)).getHost()))) {
                log.put("host", (Object)host);
            }
        }
        catch (Exception e) {
            return null;
        }
        return log;
    }
}

