/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.bytedance.vcloud.cacheModule.CacheFileManager;
import com.bytedance.vcloud.cacheModule.CacheModuleLoader;
import com.bytedance.vcloud.cacheModule.PlaylistDownloaderItem;
import com.bytedance.vcloud.cacheModule.utils.CmLog;
import com.bytedance.vcloud.cacheModule.utils.UriUtils;
import com.ss.mediakit.medialoader.AVMDLDataLoader;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PlaylistDownloader {
    private static final String TAG;
    public static final long HLS_PROGRESS_SCALE = 100L;
    private static final float HLS_STEP_PERCENT = 0.5f;
    private String mMdlProxyUrl = null;
    private String mPlaylistFileKey = null;
    private DownloadStatus mDownloadStatus = DownloadStatus.Unknown;
    private PlaylistDownloaderItem mM3u8FileDownloader = null;
    private List<DownloadUrlInfo> mSubMdlProxyUrls = null;
    private float mSubUrlStepPercent = 0.0f;
    private float mTotalPercent = 0.0f;
    private HandlerThread mDownloadThread = null;
    private Handler mDownloadCmdHandler = null;
    private Handler mStatusListenerHandler = null;
    private volatile boolean mCanceled = false;
    private String mCurrentFileKey = null;
    public static final int WHAT_DOWNLOAD_CMD_START = 10000;
    public static final int WHAT_DOWNLOAD_STATUS_START = 11000;
    public static final int WHAT_DOWNLOAD_STATUS_CANCEL = 11001;
    public static final int WHAT_DOWNLOAD_STATUS_COMPLETED = 11002;
    public static final int WHAT_DOWNLOAD_STATUS_ERROR = 11003;
    public static final int WHAT_DOWNLOAD_STATUS_PROGRESS = 11004;
    public static final int WHAT_DOWNLOAD_STATUS_CHANGED = 12000;
    private static final int ErrorCodeIsCreateTask = -1000;
    private static final int ErrorCodeIsTheSameKeyTask = -1001;
    private static final int ErrorCodeIsTooManyTask = -1002;
    private static final int ErrorCodeIsAllURLInvalid = -1003;
    private static final int ErrorCodeIsInvalidContentLenth = -2000;
    private static final int ErrorCodeIsStatusCodeMoreThan400 = -3000;
    private static final int ErrorCodeIsStatusCodeMoreThan500 = -3001;
    private static final int ErrorCodeIsInvalidRequestInfo = -4000;
    private static final int ErrorCodeIsInvalidFileWrite = -5000;
    private static final int HTTP_ERROR_HTTP_BAD_REQUEST;
    private static final int HTTP_ERROR_HTTP_UNAUTHORIZED;
    private static final int HTTP_ERROR_HTTP_FORBIDDEN;
    private static final int HTTP_ERROR_HTTP_NOT_FOUND;
    private static final int HTTP_ERROR_HTTP_TIMEOUT;
    private static final int HTTP_ERROR_HTTP_OTHER_4XX;
    private static final int HTTP_ERROR_HTTP_SERVER_ERROR;
    private static final int FILE_ERROR;
    private static final String LogInfoFormat = "%d,%d,%s,%s";
    private IDownloadListener mListener = null;
    private float baseDownloadPercent = 0.0f;
    private float lastDownloadPercent = 0.0f;

    public PlaylistDownloader(String mdlProxyUrl) {
        CmLog.d(TAG, "<" + this + ">");
        this.mTotalPercent = 100.0f;
        this.mMdlProxyUrl = mdlProxyUrl;
        Map<String, String> params = UriUtils.parseURLParam(this.mMdlProxyUrl);
        if (params.containsKey("k")) {
            this.mPlaylistFileKey = params.get("k");
        }
        this.initStatusListenerHandler();
        this.initDownloadCmdHandler();
    }

    private void initStatusListenerHandler() {
        this.mStatusListenerHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                CmLog.d(TAG, "<" + (Object)((Object)this) + ">msg.what = " + msg.what);
                if (PlaylistDownloader.this.mListener != null) {
                    int what = msg.what;
                    switch (what) {
                        case 11000: {
                            PlaylistDownloader.this.callStartListener(PlaylistDownloader.this.mMdlProxyUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                            break;
                        }
                        case 11001: {
                            PlaylistDownloader.this.callCancelListener(PlaylistDownloader.this.mPlaylistFileKey, PlaylistDownloader.this.mMdlProxyUrl);
                            break;
                        }
                        case 11002: {
                            PlaylistDownloader.this.callCompleteListener(PlaylistDownloader.this.mMdlProxyUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                            break;
                        }
                        case 11003: {
                            PlaylistDownloader.this.callErrorListener(PlaylistDownloader.this.mMdlProxyUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                            break;
                        }
                        case 11004: {
                            PlaylistDownloader.this.callProgressListener(PlaylistDownloader.this.mMdlProxyUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                        }
                    }
                }
                super.handleMessage(msg);
            }
        };
    }

    private void changeStatusToError(long errorCode, AVMDLDataLoaderNotifyInfo errorInfo) {
        this.mDownloadStatus = DownloadStatus.Error;
        if (errorInfo == null) {
            errorInfo = new AVMDLDataLoaderNotifyInfo();
            errorInfo.what = 8;
            errorInfo.code = errorCode;
        }
        errorInfo.parameter = 3L;
        errorInfo.logInfo = TextUtils.isEmpty((CharSequence)this.mPlaylistFileKey) ? this.mMdlProxyUrl : this.mPlaylistFileKey;
        Message message = this.mStatusListenerHandler.obtainMessage(11003);
        message.obj = errorInfo;
        this.mStatusListenerHandler.sendMessage(message);
    }

    private void callErrorListener(String mdlProxyUrl, AVMDLDataLoaderNotifyInfo errorInfo) {
        this.mListener.onError(mdlProxyUrl, errorInfo);
    }

    @SuppressLint(value={"DefaultLocale"})
    private void changeStatusToCompleted() {
        this.mDownloadStatus = DownloadStatus.Completed;
        AVMDLDataLoaderNotifyInfo completedInfo = new AVMDLDataLoaderNotifyInfo();
        completedInfo.what = 21;
        completedInfo.parameter = 3L;
        completedInfo.logInfo = String.format(LogInfoFormat, 10000L, 10000L, this.mPlaylistFileKey, this.mM3u8FileDownloader.getDownloadFilePath());
        Message message = this.mStatusListenerHandler.obtainMessage(11002);
        message.obj = completedInfo;
        this.mStatusListenerHandler.sendMessage(message);
    }

    private void callCompleteListener(String mdlProxyUrl, AVMDLDataLoaderNotifyInfo completedInfo) {
        this.mListener.onCompleted(mdlProxyUrl, completedInfo);
    }

    private void changeStatusToCancel() {
        this.mDownloadStatus = DownloadStatus.Cancel;
        Message message = this.mStatusListenerHandler.obtainMessage(11001);
        this.mStatusListenerHandler.sendMessage(message);
    }

    private void callCancelListener(String urlFileKey, String mdlProxyUrl) {
        this.mListener.onCancel(urlFileKey, mdlProxyUrl);
    }

    private void changeStatusToStart() {
        this.mDownloadStatus = DownloadStatus.Start;
        Object startInfo = null;
        Message message = this.mStatusListenerHandler.obtainMessage(11000);
        message.obj = startInfo;
        this.mStatusListenerHandler.sendMessage(message);
    }

    private void callStartListener(String proxyUrl, AVMDLDataLoaderNotifyInfo obj) {
        this.mListener.onStart(proxyUrl, obj);
    }

    private static int mkTag(int a, int b, int c, int d) {
        return -(a | b << 8 | c << 16 | d << 24);
    }

    public int download() {
        if (this.mCanceled) {
            CmLog.w(TAG, "<" + this + ">download has been cancled");
            return 0;
        }
        Message msg = this.mDownloadCmdHandler.obtainMessage(10000);
        this.mDownloadCmdHandler.sendMessage(msg);
        return 0;
    }

    private void initDownloadCmdHandler() {
        this.mDownloadThread = new HandlerThread("playlistDownloader");
        this.mDownloadThread.start();
        this.mDownloadCmdHandler = new Handler(this.mDownloadThread.getLooper()){

            public void handleMessage(Message msg) {
                if (msg.what == 10000) {
                    PlaylistDownloader.this.downloadM3u8File(PlaylistDownloader.this.mMdlProxyUrl);
                } else if (msg.what == 12000) {
                    Bundle data = msg.getData();
                    String fileKey = data.getString("fileKey", null);
                    int statusCode = data.getInt("status", 0);
                    DownloadStatus status = DownloadStatus.covertCode(statusCode);
                    AVMDLDataLoaderNotifyInfo info = (AVMDLDataLoaderNotifyInfo)msg.obj;
                    PlaylistDownloader.this.processStatusChangeInner(fileKey, status, info);
                }
                super.handleMessage(msg);
            }
        };
    }

    private void downloadM3u8File(String url) {
        CmLog.d(TAG, "<" + this + "> downloadM3u8File : " + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            CmLog.e(TAG, "<" + this + "> main url is empty. ");
            this.changeStatusToError(-4000L, null);
            return;
        }
        this.mM3u8FileDownloader = new PlaylistDownloaderItem(url);
        int downloadRet = this.mM3u8FileDownloader.download();
        if (downloadRet < 0 && !this.mCanceled) {
            CmLog.e(TAG, "<" + this + ">open main m3u8 url fail : " + downloadRet);
            this.changeStatusToError(PlaylistDownloader.getErrorCode(downloadRet), null);
            return;
        }
        this.updateDownloadProgress(null);
        CacheFileManager.HlsCacheNodeInfo hlsCacheNodeInfo = new CacheFileManager.HlsCacheNodeInfo();
        hlsCacheNodeInfo.version = 1;
        hlsCacheNodeInfo.fileKey = this.mPlaylistFileKey;
        this.mM3u8FileDownloader.writeHlsNodeInfo(hlsCacheNodeInfo);
        List<String> subUrls = this.mM3u8FileDownloader.getSubUrls();
        this.mSubMdlProxyUrls = new LinkedList<DownloadUrlInfo>();
        for (String subUrl : subUrls) {
            DownloadUrlInfo info = new DownloadUrlInfo();
            info.mUrl = subUrl;
            this.mSubMdlProxyUrls.add(info);
        }
        this.mSubUrlStepPercent = (this.mTotalPercent - 0.5f) / (float)this.mSubMdlProxyUrls.size();
        this.downloadNextUrl();
    }

    private static int getErrorCode(int preloadRet) {
        if (preloadRet == HTTP_ERROR_HTTP_BAD_REQUEST || preloadRet == HTTP_ERROR_HTTP_UNAUTHORIZED || preloadRet == HTTP_ERROR_HTTP_FORBIDDEN || preloadRet == HTTP_ERROR_HTTP_NOT_FOUND || preloadRet == HTTP_ERROR_HTTP_TIMEOUT || preloadRet == HTTP_ERROR_HTTP_OTHER_4XX) {
            return -3000;
        }
        if (preloadRet == HTTP_ERROR_HTTP_SERVER_ERROR) {
            return -3001;
        }
        if (preloadRet == FILE_ERROR) {
            return -5000;
        }
        return preloadRet;
    }

    private void downloadNextUrl() {
        if (this.mCanceled) {
            CmLog.w(TAG, "<" + this + ">downloadNextUrl...but canceled");
            return;
        }
        if (this.mDownloadStatus == DownloadStatus.Error) {
            CmLog.w(TAG, "<" + this + ">downloadNextUrl...but error before");
            return;
        }
        this.mCurrentFileKey = null;
        boolean proxyUrlsEmpty = this.mSubMdlProxyUrls.isEmpty();
        if (proxyUrlsEmpty) {
            CmLog.i(TAG, "<" + this + ">downloadNextUrl() completed. proxyUrlsEmpty");
            this.mM3u8FileDownloader.allDownloadCompleted();
            this.lastDownloadPercent = this.mTotalPercent;
            AVMDLDataLoaderNotifyInfo info = new AVMDLDataLoaderNotifyInfo();
            info.what = 3;
            info.parameter = 3L;
            String downloadM3u8FilePath = this.mM3u8FileDownloader.getDownloadFilePath();
            info.logInfo = this.formatProgressLogInfo(this.mTotalPercent, this.mTotalPercent, this.mPlaylistFileKey, downloadM3u8FilePath);
            Message message = this.mStatusListenerHandler.obtainMessage(11004);
            message.obj = info;
            this.mStatusListenerHandler.sendMessage(message);
            this.mCurrentFileKey = null;
            this.changeStatusToCompleted();
            return;
        }
        DownloadUrlInfo downloadUrlInfo = this.mSubMdlProxyUrls.remove(0);
        String mdlProxyUrl = downloadUrlInfo.mUrl;
        CmLog.d(TAG, "<" + this + "> downloadNextUrl = " + mdlProxyUrl);
        if (TextUtils.isEmpty((CharSequence)mdlProxyUrl)) {
            this.changeStatusToError(-4000L, null);
            return;
        }
        Map<String, String> params = UriUtils.parseURLParam(mdlProxyUrl);
        if (params.containsKey("k")) {
            this.mCurrentFileKey = params.get("k");
        }
        CacheFileManager.TsCacheNodeInfo tsCacheNodeInfo = new CacheFileManager.TsCacheNodeInfo();
        tsCacheNodeInfo.version = 1;
        tsCacheNodeInfo.fileKey = this.mCurrentFileKey;
        this.mM3u8FileDownloader.writeTsNodeInfo(tsCacheNodeInfo);
        CmLog.i(TAG, "<" + this + ">MDL downloadResource filekey = " + this.mCurrentFileKey + " proxyUrl = " + mdlProxyUrl);
        AVMDLDataLoader.getInstance().downloadResource(mdlProxyUrl);
    }

    public boolean isMyKey(String fileKey) {
        return this.isPlaylistFileKey(fileKey) || this.isTsFileKey(fileKey);
    }

    public boolean processStatusChange(String fileKey, DownloadStatus status, AVMDLDataLoaderNotifyInfo info) {
        boolean willIntercept = this.checkIfIntercept(fileKey, status);
        CmLog.e(TAG, "processStatusChange checkIfIntercept: " + willIntercept);
        Message message = this.mDownloadCmdHandler.obtainMessage(12000);
        Bundle data = new Bundle();
        data.putInt("status", status.ordinal());
        data.putString("fileKey", fileKey);
        message.setData(data);
        message.obj = info;
        this.mDownloadCmdHandler.sendMessage(message);
        return willIntercept;
    }

    void processStatusChangeInner(String fileKey, DownloadStatus status, AVMDLDataLoaderNotifyInfo info) {
        if (this.isPlaylistFileKey(fileKey)) {
            this.processM3u8PreloadStatus(fileKey, status, info);
        } else if (this.isTsFileKey(fileKey)) {
            this.processTsPreloadStatus(fileKey, status, info);
        }
    }

    private boolean isPlaylistFileKey(String fileKey) {
        return this.mPlaylistFileKey != null && this.mPlaylistFileKey.equals(fileKey);
    }

    public boolean isTsFileKey(String fileKey) {
        return this.mCurrentFileKey != null && this.mCurrentFileKey.equals(fileKey);
    }

    boolean checkIfIntercept(String fileKey, DownloadStatus status) {
        if (this.isPlaylistFileKey(fileKey)) {
            if (status == DownloadStatus.Progress) {
                return false;
            }
            if (status == this.mDownloadStatus) {
                return true;
            }
            return status != DownloadStatus.Error;
        }
        return this.isTsFileKey(fileKey);
    }

    private void processM3u8PreloadStatus(String fileKey, DownloadStatus status, AVMDLDataLoaderNotifyInfo info) {
        CmLog.i(TAG, "do nothing ... processM3u8PreloadStatus = " + fileKey + ", mCurrentFileKey = " + this.mCurrentFileKey + ", mUrlFileKey = " + this.mPlaylistFileKey + ", status = " + status.name());
    }

    private void processTsPreloadStatus(String fileKey, DownloadStatus status, AVMDLDataLoaderNotifyInfo info) {
        CmLog.i(TAG, "processTsPreloadStatus = " + fileKey + ", status = " + status.name() + ", info.loginfo = " + info.logInfo);
        if (status == DownloadStatus.Completed) {
            CmLog.i(TAG, "<" + this + ">sub download completed  , key = " + this.mCurrentFileKey);
            if (fileKey.equals(this.mCurrentFileKey)) {
                this.downloadNextUrl();
            }
        } else if (status == DownloadStatus.Cancel) {
            CmLog.d(TAG, "<" + this + ">mdl canceled... " + this.mCurrentFileKey);
        } else if (status == DownloadStatus.Error) {
            CmLog.d(TAG, "<" + this + ">mdl Error ... " + this.mCurrentFileKey + " , info :" + info.logInfo);
            this.changeStatusToError(info.code, info);
        } else if (status == DownloadStatus.Progress) {
            CmLog.d(TAG, "<" + this + ">mdl progress ... " + this.mCurrentFileKey + " , info :" + info.logInfo);
            this.updateDownloadProgress(info);
        }
    }

    private void updateDownloadProgress(AVMDLDataLoaderNotifyInfo info) {
        ProgressInfo progressInfo;
        float deltaDownloadPercent = 0.0f;
        DownloadLogInfo downloadLogInfo = null;
        if (info == null) {
            progressInfo = new ProgressInfo();
            progressInfo.isHls = true;
            deltaDownloadPercent = this.computeDeltaProgress(progressInfo);
        } else {
            downloadLogInfo = PlaylistDownloader.parseDownloadLogInfo(info.logInfo);
            if (downloadLogInfo == null) {
                return;
            }
            progressInfo = new ProgressInfo();
            progressInfo.isHls = false;
            progressInfo.mediaSize = downloadLogInfo.mediaSize;
            progressInfo.downloadedSize = downloadLogInfo.downloadedSize;
            deltaDownloadPercent = this.computeDeltaProgress(progressInfo);
        }
        if (info == null) {
            info = new AVMDLDataLoaderNotifyInfo();
            info.what = 3;
            info.parameter = 3L;
        }
        String downloadM3u8FilePath = this.mM3u8FileDownloader.getDownloadFilePath();
        info.logInfo = this.formatProgressLogInfo(deltaDownloadPercent, this.mTotalPercent, this.mPlaylistFileKey, downloadM3u8FilePath);
        Message message = this.mStatusListenerHandler.obtainMessage(11004);
        message.obj = info;
        this.mStatusListenerHandler.sendMessage(message);
    }

    private String formatProgressLogInfo(float deltaDownloadPercent, float mTotalPercent, String playlistFileKey, String downloadM3u8FilePath) {
        long deltaProgress = (long)(deltaDownloadPercent * 100.0f);
        long totalProgress = (long)(mTotalPercent * 100.0f);
        return this.formatProgressLogInfo(deltaProgress, totalProgress, playlistFileKey, downloadM3u8FilePath);
    }

    @SuppressLint(value={"DefaultLocale"})
    private String formatProgressLogInfo(long deltaProgress, long totalProgress, String playlistFileKey, String downloadM3u8FilePath) {
        return String.format(LogInfoFormat, deltaProgress, totalProgress, playlistFileKey, downloadM3u8FilePath);
    }

    private void callProgressListener(String mdlProxyUrl, AVMDLDataLoaderNotifyInfo info) {
        CmLog.d(TAG, "callProgressListener delta info:" + info.logInfo);
        DownloadLogInfo downloadLogInfo = PlaylistDownloader.parseDownloadLogInfo(info.logInfo);
        if (downloadLogInfo != null) {
            info.logInfo = this.formatProgressLogInfo(this.lastDownloadPercent, this.mTotalPercent, this.mPlaylistFileKey, this.mM3u8FileDownloader.getDownloadFilePath());
            CmLog.d(TAG, "callProgressListener out info:" + info.logInfo);
            this.mListener.onProgress(mdlProxyUrl, info);
        }
    }

    public static DownloadLogInfo parseDownloadLogInfo(String logInfo) {
        if (TextUtils.isEmpty((CharSequence)logInfo)) {
            return null;
        }
        String[] temArray = logInfo.split(",");
        if (temArray.length < 4) {
            return null;
        }
        DownloadLogInfo dstInfo = new DownloadLogInfo();
        dstInfo.downloadedSize = Long.parseLong(temArray[0]);
        dstInfo.mediaSize = Long.parseLong(temArray[1]);
        dstInfo.key = temArray[2];
        dstInfo.localFilePath = temArray[3];
        return dstInfo;
    }

    public void cancel() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        if (this.mM3u8FileDownloader != null) {
            this.mM3u8FileDownloader.cancel();
        }
        if (this.mCurrentFileKey != null) {
            CmLog.d(TAG, "<" + this + ">cancel ts.. mCurrentFileKey:" + this.mCurrentFileKey);
            AVMDLDataLoader.getInstance().suspendDownload(this.mCurrentFileKey);
        }
        this.changeStatusToCancel();
    }

    public void release() {
        if (this.mM3u8FileDownloader != null) {
            this.mM3u8FileDownloader.release();
        }
        if (this.mDownloadThread != null) {
            this.mDownloadThread.quit();
        }
    }

    public void setLoaderListener(IDownloadListener listener) {
        this.mListener = listener;
    }

    private float computeDeltaProgress(ProgressInfo progressInfo) {
        if (progressInfo.isHls) {
            float deltaDownloadPercent = 0.5f;
            this.baseDownloadPercent += deltaDownloadPercent;
            this.lastDownloadPercent = this.baseDownloadPercent;
            return deltaDownloadPercent;
        }
        if (progressInfo.mediaSize <= 0L) {
            return 0.0f;
        }
        if (progressInfo.downloadedSize == progressInfo.mediaSize) {
            float deltaDownloadPercent = this.baseDownloadPercent + this.mSubUrlStepPercent - this.lastDownloadPercent;
            this.baseDownloadPercent += this.mSubUrlStepPercent;
            this.lastDownloadPercent = this.baseDownloadPercent;
            return deltaDownloadPercent;
        }
        float tsDownloadPercent = this.mSubUrlStepPercent * (float)progressInfo.downloadedSize / (float)progressInfo.mediaSize;
        float deltaDownloadPercent = this.baseDownloadPercent + tsDownloadPercent - this.lastDownloadPercent;
        this.lastDownloadPercent += tsDownloadPercent;
        return deltaDownloadPercent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    static {
        CacheModuleLoader.loadLibrary();
        TAG = PlaylistDownloader.class.getSimpleName();
        HTTP_ERROR_HTTP_BAD_REQUEST = PlaylistDownloader.mkTag(248, 52, 48, 48);
        HTTP_ERROR_HTTP_UNAUTHORIZED = PlaylistDownloader.mkTag(248, 52, 48, 49);
        HTTP_ERROR_HTTP_FORBIDDEN = PlaylistDownloader.mkTag(248, 52, 48, 51);
        HTTP_ERROR_HTTP_NOT_FOUND = PlaylistDownloader.mkTag(248, 52, 48, 52);
        HTTP_ERROR_HTTP_TIMEOUT = PlaylistDownloader.mkTag(248, 52, 48, 56);
        HTTP_ERROR_HTTP_OTHER_4XX = PlaylistDownloader.mkTag(248, 52, 88, 88);
        HTTP_ERROR_HTTP_SERVER_ERROR = PlaylistDownloader.mkTag(248, 53, 88, 88);
        FILE_ERROR = PlaylistDownloader.mkTag(73, 78, 70, 87);
    }

    private static class ProgressInfo {
        public boolean isHls;
        public long downloadedSize;
        public long mediaSize;

        private ProgressInfo() {
        }
    }

    public static class DownloadUrlInfo {
        public String mUrl = null;
    }

    public static interface IDownloadListener {
        public void onStart(String var1, AVMDLDataLoaderNotifyInfo var2);

        public void onCancel(String var1, String var2);

        public void onCompleted(String var1, AVMDLDataLoaderNotifyInfo var2);

        public void onError(String var1, AVMDLDataLoaderNotifyInfo var2);

        public void onProgress(String var1, AVMDLDataLoaderNotifyInfo var2);
    }

    public static class DownloadLogInfo {
        public long downloadedSize = 0L;
        public long mediaSize = 0L;
        public String key = null;
        public String localFilePath = null;
    }

    public static enum DownloadStatus {
        Unknown,
        Start,
        Cancel,
        Completed,
        Error,
        Progress;


        public static DownloadStatus covertCode(int statusCode) {
            if (statusCode == Start.ordinal()) {
                return Start;
            }
            if (statusCode == Cancel.ordinal()) {
                return Cancel;
            }
            if (statusCode == Completed.ordinal()) {
                return Completed;
            }
            if (statusCode == Error.ordinal()) {
                return Error;
            }
            if (statusCode == Progress.ordinal()) {
                return Progress;
            }
            return Unknown;
        }
    }
}

